/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack.game;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class Bet {
    public int maj = 0;
    public int min = 0;
    public int flag = 0;
    private String _str = "";

    public Bet(int major, int minor) {
        this.set(this.maj, this.min);
    }

    public Bet(int major) {
        this.set(major, 0);
    }

    public Bet(Bet b2) {
        this.set(b2.maj, b2.min);
    }

    public Bet(byte[] data) {
        this.fromByteArray(data);
    }

    public void set(int major) {
        this.set(major, 0);
    }

    public void set(Bet b2) {
        this.set(b2.maj, b2.min);
    }

    public void set(int major, int minor) {
        this.maj = major;
        this.min = minor;
        this._recalc();
    }

    public void add(int major, int minor) {
        this.maj += major;
        this.min += minor;
        this._recalc();
    }

    public void add(Bet bet2) {
        this.add(bet2.maj, bet2.min);
    }

    public void subtract(int major, int minor) {
        this.maj -= major;
        this.min -= minor;
        if (this.min < 0) {
            int minpos = Math.abs(this.min);
            while (minpos >= 100) {
                minpos -= 100;
                --this.maj;
            }
            if (minpos > 0) {
                --this.maj;
                this.min = 100 - minpos;
            }
        }
        if (this.maj < 0) {
            this.min = 0;
            this.maj = 0;
        }
        this._recalc();
    }

    public static Bet difference(Bet bet1, Bet bet2) {
        if (bet1.isGreaterThan(bet2)) {
            Bet diff = new Bet(bet1);
            diff.subtract(bet2);
            return diff;
        }
        if (bet1.isLessThan(bet2)) {
            Bet diff = new Bet(bet2);
            diff.subtract(bet1);
            return diff;
        }
        Bet diff = new Bet(0);
        return diff;
    }

    public void subtract(Bet bet2) {
        this.subtract(bet2.maj, bet2.min);
    }

    public void divideByTwo() {
        if ((this.maj & 1) == 1) {
            this.maj = this.maj - 1 >> 1;
            this.min += 100;
            if (this.min > 100) {
                this.min -= 100;
                ++this.maj;
            }
        } else {
            this.maj >>= 1;
        }
        this.min = (this.min & 1) == 1 ? this.min - 1 >> 1 : (this.min >>= 1);
        this._recalc();
    }

    public void multiplyByTwo() {
        this.maj *= 2;
        this.min *= 2;
        this._recalc();
    }

    public boolean isGreaterThanZero() {
        return this.maj > 0 || this.min > 0;
    }

    public boolean isZero() {
        return this.maj == 0 && this.min == 0;
    }

    public boolean isEqualTo(Bet bet2) {
        return bet2.maj == this.maj && bet2.min == this.min;
    }

    public boolean isGreaterThan(Bet bet2) {
        return this.isGreaterThan(bet2.maj, bet2.min);
    }

    public boolean isGreaterThanOrEqualTo(Bet bet2) {
        return this.isGreaterThanOrEqualTo(bet2.maj, bet2.min);
    }

    public boolean isLessThan(Bet bet2) {
        return this.isLessThan(bet2.maj, bet2.min);
    }

    public boolean isLessThanOrEqualTo(Bet bet2) {
        return this.isLessThanOrEqualTo(bet2.maj, bet2.min);
    }

    public boolean isEqualTo(int major, int minor) {
        return this.maj == major && this.min == minor;
    }

    public boolean isGreaterThan(int major, int minor) {
        if (this.maj == major && this.min == minor) {
            return false;
        }
        if (this.maj > major) {
            return true;
        }
        return this.maj == major && this.min > minor;
    }

    public boolean isGreaterThanOrEqualTo(int major, int minor) {
        if (this.maj == major && this.min == minor) {
            return true;
        }
        return this.isGreaterThan(major, minor);
    }

    public boolean isLessThan(int major, int minor) {
        return !this.isEqualTo(major, minor) && !this.isGreaterThan(major, minor);
    }

    public boolean isLessThanOrEqualTo(int major, int minor) {
        if (this.maj == major && this.min == minor) {
            return true;
        }
        return this.isLessThan(major, minor);
    }

    public String toString() {
        return this._str;
    }

    private void _recalc() {
        while (this.min >= 100) {
            this.min -= 100;
            ++this.maj;
        }
        this._str = Integer.toString(this.maj);
        if (this.min >= 10) {
            this._str = this._str + "." + Integer.toString(this.min);
        } else if (this.min > 0 && this.min <= 10) {
            this._str = this._str + ".0" + this.min;
        }
    }

    public void setFlag(int f) {
        this.flag = f;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(this.maj);
            os.writeInt(this.min);
            os.writeInt(this.flag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            this.maj = is.readInt();
            this.min = is.readInt();
            this.flag = is.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._recalc();
    }
}

