/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.blackjack.Blackjack;
import net.handyx.casinopack.blackjack.Common;
import net.handyx.casinopack.blackjack.Strings;
import net.handyx.casinopack.common.FrameRenderer;
import net.handyx.casinopack.common.GMG;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.common.RunnableCanvas;

public class MenuCanvas
extends RunnableCanvas {
    private Blackjack parent;
    private Image scrollerImage;
    private Image upArrowImage;
    private Image downArrowImage;
    private Image[] alphaMesh = new Image[5];
    private int MAIN_MENU = 0;
    private int OPTIONS_MENU = 1;
    private int HELP_MENU = 2;
    private int displayMode = this.MAIN_MENU;
    private int[] optionsSettings = new int[Strings.OPTIONS_MENU_ITEM_DEFAULT.length];
    private int maxLines = 13;
    private int lineOffset = 0;
    private int scrolling = 0;
    private String[] helpLines = null;
    public int selectedIndex = 0;
    public int optionsSelectedIndex = 0;
    public int helpSelectedIndex = 0;
    private int POPUP_REVEAL = 1;
    private int POPUP_HIDE = 2;
    private int displayPopup = 0;
    private int POPUP_ABOUT = 0;
    private int POPUP_NEW_GAME = 1;
    private int POPUP_HELP = 2;
    private int POPUP_GMG_CONNECTION = 4;
    private int popupType = this.POPUP_ABOUT;
    private int boxW = 0;
    private int boxH = 0;
    private int boxNumFrames = 0;
    private int boxFrame = 0;
    private int alphaIndex = -1;
    private int popupSelectedIndex = 0;
    public static final String[] OPTIONS_MENU_ITEMS = new String[]{"Sound", "In-Game Hints", "Perfect Play Warning", "Currency", "Starting Cash", "Rules Preset", "No. of Decks", "Double Down Rule", "Dealer Insurance", "Double on Split", "Dealer Hits Soft 17", "Dealer Peeks Hole Card", "Split Aces", "Hit on Split Aces", "Re-Split Aces", "Max Split Hands", "Surrender", "Deck Shuffling"};

    public MenuCanvas(Blackjack p) {
        this.parent = p;
        for (int i = 0; i < this.optionsSettings.length; ++i) {
            this.optionsSettings[i] = Strings.OPTIONS_MENU_ITEM_DEFAULT[i];
        }
    }

    public void loadResources() {
        this.scrollerImage = Common.loadImage("/scroller.png");
        this.upArrowImage = Common.loadImage("/up_arrow.png");
        this.downArrowImage = Common.loadImage("/down_arrow.png");
        for (int i = 0; i < 5; ++i) {
            this.alphaMesh[i] = Common.loadCommonImage("/mesh_alpha" + i + ".png");
        }
    }

    public void purgeResources() {
        this.downArrowImage = null;
        this.upArrowImage = null;
        this.scrollerImage = null;
        for (int i = 0; i < 5; ++i) {
            this.alphaMesh[i] = null;
        }
        System.gc();
    }

    public void processFrame(int fn) {
        Common.processToasts();
        if (this.boxFrame < this.boxNumFrames) {
            ++this.boxFrame;
            if (this.displayPopup == this.POPUP_HIDE) {
                if (this.alphaIndex > -1) {
                    --this.alphaIndex;
                }
            } else if (this.alphaIndex < 4) {
                ++this.alphaIndex;
            }
            if (this.boxFrame == this.boxNumFrames && this.displayPopup == this.POPUP_HIDE) {
                this.displayPopup = 0;
                this.alphaIndex = -1;
            }
        }
        if (this.scrolling == 1) {
            if (this.lineOffset + this.maxLines < this.helpLines.length) {
                ++this.lineOffset;
            }
        } else if (this.scrolling == -1 && this.lineOffset > 0) {
            --this.lineOffset;
        }
    }

    public void paintCanvas(Graphics gfx, int sw, int sh) {
        int i;
        int spacing;
        int padding;
        int y;
        int x;
        if (Common.bgImage == null) {
            return;
        }
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        sw = g.getWidth();
        sh = g.getHeight();
        g.drawImage(Common.bgImage, 0, 0, 20);
        boolean renderMenuItems = true;
        if ((this.displayPopup == this.POPUP_REVEAL || this.displayPopup == this.POPUP_HIDE) && this.boxFrame >= this.boxNumFrames) {
            renderMenuItems = false;
        }
        if (this.displayMode == this.MAIN_MENU && renderMenuItems) {
            x = 0;
            y = 110;
            padding = 5;
            spacing = 5;
            if (sh <= 260) {
                y -= 6;
                spacing = 3;
                padding = 10;
            }
            int lineY = y + padding + Strings.MENU_ITEMS.length * (Common.settingsFont.getHeight() + spacing) + padding;
            if (!GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                lineY -= Common.settingsFont.getHeight() + spacing;
            }
            if (!this.parent.gameCanvas.canResume()) {
                lineY -= Common.settingsFont.getHeight() + spacing;
            }
            y += padding;
            String s = "";
            for (i = 0; i < Strings.MENU_ITEMS.length; ++i) {
                String string = s = i == 4 ? GMG.GET_MORE_GAMES_LABEL : Strings.MENU_ITEMS[i];
                if (i == 4 && !GMG.DISPLAY_GET_MORE_GAMES_LINK || i == 1 && !this.parent.gameCanvas.canResume()) continue;
                x = sw - Common.largeFont.stringWidth(s) >> 1;
                if (i == this.selectedIndex) {
                    Common.largeFont.drawString(g, s, x + 1, y + 1);
                    Common.largeFont.drawString(g, s, x, y);
                } else {
                    Common.largeFontDisabled.drawString(g, s, x, y);
                }
                y += Common.largeFont.getHeight() + spacing;
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, Strings.CMD_SELECT, Common.settingsFont);
            }
        } else if (this.displayMode == this.HELP_MENU && renderMenuItems) {
            x = 0;
            y = 110;
            padding = 5;
            spacing = 5;
            if (sh <= 260) {
                y -= 6;
                spacing = 3;
                padding = 10;
            }
            int headerX = (sw - Common.largeFont.stringWidth("Help")) / 2;
            Common.largeFont.drawString(g, "Help", headerX + 1, y + 1);
            Common.largeFont.drawString(g, "Help", headerX, y);
            int lineY = (y += Common.largeFont.getHeight() + 6) + padding + Strings.HELP_MENU_ITEMS.length * (Common.settingsFont.getHeight() + spacing) + padding;
            y += padding;
            for (i = 0; i < Strings.HELP_MENU_ITEMS.length; ++i) {
                x = sw - Common.settingsFont.stringWidth(Strings.HELP_MENU_ITEMS[i]) >> 1;
                if (i == this.helpSelectedIndex) {
                    Common.settingsFont.drawString(g, Strings.HELP_MENU_ITEMS[i], x + 1, y + 1);
                    Common.settingsFont.drawString(g, Strings.HELP_MENU_ITEMS[i], x, y);
                } else {
                    Common.settingsFontDisabled.drawString(g, Strings.HELP_MENU_ITEMS[i], x, y);
                }
                y += Common.settingsFont.getHeight() + spacing;
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, Strings.CMD_SELECT, Common.settingsFont);
                MenuCanvas.drawRightCommand(g, Strings.CMD_BACK, Common.settingsFont);
            }
        } else if (this.displayMode == this.OPTIONS_MENU && renderMenuItems) {
            x = 0;
            y = 110;
            int maxItems = 7;
            int padding2 = 5;
            int spacing2 = 5;
            if (sh <= 260) {
                y -= 6;
                spacing2 = 3;
                padding2 = 10;
            }
            int headerX = (sw - Common.largeFont.stringWidth("Settings")) / 2;
            Common.largeFont.drawString(g, "Settings", headerX + 1, y + 1);
            Common.largeFont.drawString(g, "Settings", headerX, y);
            g.setColor(0xFFFFFF);
            g.drawLine(15, y += Common.largeFont.getHeight() + 6, 225, y);
            g.setColor(0);
            g.drawLine(15, y + 1, 225, y + 1);
            g.drawImage(this.upArrowImage, 223 - g.unscale(this.upArrowImage.getWidth()), y - 2 - g.unscale(this.upArrowImage.getHeight()), 20);
            int lineY = y + padding2 + maxItems * (Common.settingsFont.getHeight() + spacing2) + padding2;
            g.setColor(0xFFFFFF);
            g.drawLine(15, lineY, 225, lineY);
            g.setColor(0);
            g.drawLine(15, lineY + 1, 225, lineY + 1);
            g.drawImage(this.downArrowImage, 223 - g.unscale(this.downArrowImage.getWidth()), lineY + 3, 20);
            y += padding2;
            int currentItem = this.optionsSelectedIndex - (maxItems - 1) / 2;
            for (int i2 = 0; i2 < maxItems; ++i2) {
                int displayItem = currentItem;
                if (displayItem < 0) {
                    displayItem += Strings.OPTIONS_MENU_ITEM_SETTINGS.length;
                }
                String setting = Strings.OPTIONS_MENU_ITEMS[displayItem] + ": " + Strings.OPTIONS_MENU_ITEM_SETTINGS[displayItem][this.optionsSettings[displayItem]];
                if (displayItem == 4) {
                    setting = Strings.OPTIONS_MENU_ITEMS[displayItem] + ": ";
                    setting = this.optionsSettings[3] == 0 ? setting + "$" : (this.optionsSettings[3] == 1 ? setting + "\u00a3" : setting + "#");
                    setting = setting + Strings.OPTIONS_MENU_ITEM_SETTINGS[displayItem][this.optionsSettings[displayItem]];
                }
                x = sw - Common.settingsFont.stringWidth(setting) >> 1;
                if (displayItem == this.optionsSelectedIndex) {
                    Common.settingsFont.drawString(g, setting, x + 1, y + 1);
                    Common.settingsFont.drawString(g, setting, x, y);
                } else {
                    Common.settingsFontDisabled.drawString(g, setting, x, y);
                }
                y += Common.settingsFont.getHeight() + spacing2;
                if (++currentItem < Strings.OPTIONS_MENU_ITEM_SETTINGS.length) continue;
                currentItem -= Strings.OPTIONS_MENU_ITEM_SETTINGS.length;
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, Strings.CMD_CHANGE, Common.settingsFont);
                MenuCanvas.drawRightCommand(g, Strings.CMD_BACK, Common.settingsFont);
            }
        }
        if (this.displayPopup > 0) {
            if (this.popupType != this.POPUP_HELP && this.alphaIndex >= 0) {
                for (int meshX = 0; meshX < sw; meshX += 48) {
                    for (int meshY = 0; meshY < sh; meshY += 64) {
                        g.drawImage(this.alphaMesh[this.alphaIndex], meshX, meshY, 20);
                    }
                }
            }
            if (this.boxFrame < this.boxNumFrames) {
                int tmpH;
                int tmpW;
                if (this.displayPopup == this.POPUP_REVEAL) {
                    tmpW = this.boxFrame * (this.boxW / this.boxNumFrames);
                    tmpH = this.boxFrame * (this.boxH / this.boxNumFrames);
                    FrameRenderer.renderFrame(g, sw >> 1, sh >> 1, tmpW, tmpH, 3, null);
                } else if (this.displayPopup == this.POPUP_HIDE) {
                    tmpW = (this.boxNumFrames - this.boxFrame) * (this.boxW / this.boxNumFrames);
                    tmpH = (this.boxNumFrames - this.boxFrame) * (this.boxH / this.boxNumFrames);
                    FrameRenderer.renderFrame(g, sw >> 1, sh >> 1, tmpW, tmpH, 3, null);
                }
            } else {
                int i3;
                int y2;
                int boxX = sw - this.boxW >> 1;
                int boxY = sh - this.boxH >> 1;
                FrameRenderer.renderFrame(g, boxX, boxY, this.boxW, this.boxH, 20, null);
                String[] lines = null;
                if (this.popupType == this.POPUP_ABOUT) {
                    lines = Common.normalBlackFont.wrap(Strings.ABOUT_TEXT, this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, Strings.CMD_OK, Common.settingsFont);
                } else if (this.popupType == this.POPUP_GMG_CONNECTION) {
                    lines = Common.normalBlackFont.wrap(GMG.GMG_CONNECTION_TEXT, this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, Strings.CMD_OK, Common.settingsFont);
                } else if (this.popupType == this.POPUP_NEW_GAME) {
                    lines = Common.normalBlackFont.wrap("Are you sure you want to start a new game?\n\nYour current game progress will be lost.", this.boxW - 16);
                    y2 = sh - lines.length * Common.normalBlackFont.getHeight() >> 1;
                    y2 -= 20;
                    for (i3 = 0; i3 < lines.length; ++i3) {
                        int x2 = sw - Common.normalBlackFont.stringWidth(lines[i3]) >> 1;
                        Common.normalBlackFont.drawString(g, lines[i3], x2, y2);
                        y2 += Common.normalBlackFont.getHeight();
                    }
                    int buttonX = (g.getWidth() - 2 * g.unscale(Common.yesOffImage.getWidth()) - 10) / 2;
                    g.drawImage(this.popupSelectedIndex == 0 ? Common.yesOnImage : Common.yesOffImage, buttonX, y2 += 20, 20);
                    g.drawImage(this.popupSelectedIndex == 1 ? Common.noOnImage : Common.noOffImage, buttonX + g.unscale(Common.yesOffImage.getWidth()) + 10, y2, 20);
                    MenuCanvas.drawRightCommand(g, Strings.CMD_NO, Common.settingsFont);
                    MenuCanvas.drawLeftCommand(g, Strings.CMD_YES, Common.settingsFont);
                } else if (this.popupType == this.POPUP_HELP) {
                    MenuCanvas.drawRightCommand(g, Strings.CMD_BACK, Common.settingsFont);
                }
                if (this.popupType != this.POPUP_HELP && this.popupType != this.POPUP_NEW_GAME) {
                    y2 = sh - lines.length * Common.normalBlackFont.getHeight() >> 1;
                    for (i3 = 0; i3 < lines.length; ++i3) {
                        int x3 = sw - Common.normalBlackFont.stringWidth(lines[i3]) >> 1;
                        Common.normalBlackFont.drawString(g, lines[i3], x3, y2);
                        y2 += Common.normalBlackFont.getHeight();
                    }
                } else if (this.popupType == this.POPUP_HELP) {
                    y2 = boxY + 10;
                    int x4 = boxX + 10;
                    Common.largeFont.drawString(g, Strings.HELP_MENU_ITEMS[this.helpSelectedIndex], (g.getWidth() - Common.largeFont.stringWidth(Strings.HELP_MENU_ITEMS[this.helpSelectedIndex])) / 2, y2);
                    y2 += Common.largeFont.getHeight() + 7;
                    if (this.helpLines != null) {
                        for (int l = 0; l < this.maxLines && l + this.lineOffset < this.helpLines.length; ++l) {
                            Common.normalBlackFont.drawString(g, this.helpLines[l + this.lineOffset], x4, y2);
                            y2 += Common.normalBlackFont.getHeight();
                        }
                    }
                    if (this.helpLines.length > this.maxLines) {
                        int scrollBarHeight = Common.normalBlackFont.getHeight() * this.maxLines;
                        g.setColor(0);
                        g.fillRect(boxX + this.boxW - 12, boxY + 17 + Common.largeFont.getHeight(), 3, scrollBarHeight);
                        int maxBarPos = scrollBarHeight - 3 - this.scrollerImage.getHeight();
                        int offset = maxBarPos * 10000 / (this.helpLines.length - this.maxLines) * this.lineOffset / 10000;
                        if (this.helpLines.length - this.lineOffset <= this.maxLines) {
                            offset = maxBarPos;
                        }
                        g.drawImage(this.scrollerImage, boxX + this.boxW - 14, boxY + 19 + Common.largeFont.getHeight() + offset, 20);
                    }
                }
            }
        }
        Common.renderToasts(g);
    }

    public void keyPressedEvent(int keyCode, int ga, int sk) {
        if (this.displayPopup == this.POPUP_REVEAL) {
            if (sk == 3 || sk == 2) {
                this.displayPopup = this.POPUP_HIDE;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
                return;
            }
            if (ga == 2 || ga == 5) {
                this.popupSelectedIndex = this.popupSelectedIndex == 0 ? 1 : 0;
            } else if (ga == 8 || sk == 1) {
                if (this.popupType == this.POPUP_NEW_GAME) {
                    if (this.popupSelectedIndex == 0) {
                        this.displayPopup = 0;
                        this.alphaIndex = 4;
                        this.parent.startNewGame();
                    } else {
                        this.displayPopup = this.POPUP_HIDE;
                        this.boxFrame = 0;
                        this.boxNumFrames = 5;
                    }
                }
                return;
            }
            if (this.popupType == this.POPUP_HELP) {
                if (ga == 1) {
                    if (this.lineOffset > 0) {
                        --this.lineOffset;
                    }
                    this.scrolling = -1;
                } else if (ga == 6) {
                    if (this.lineOffset + this.maxLines < this.helpLines.length) {
                        ++this.lineOffset;
                    }
                    this.scrolling = 1;
                }
            }
        } else if (this.displayMode == this.MAIN_MENU) {
            if (sk == 1) {
                this.performMenuSelect();
                return;
            }
            if (sk == 2) {
                return;
            }
            if (ga == 1) {
                if (this.selectedIndex == 2 && !this.parent.gameCanvas.canResume()) {
                    this.selectedIndex = 0;
                } else {
                    int n = this.selectedIndex = this.selectedIndex == 0 ? Strings.MENU_ITEMS.length - 1 : this.selectedIndex - 1;
                    if (!GMG.DISPLAY_GET_MORE_GAMES_LINK && this.selectedIndex == 4) {
                        --this.selectedIndex;
                    }
                }
            } else if (ga == 6) {
                if (this.selectedIndex == 0 && !this.parent.gameCanvas.canResume()) {
                    this.selectedIndex = 2;
                } else {
                    int n = this.selectedIndex = this.selectedIndex == Strings.MENU_ITEMS.length - 1 ? 0 : this.selectedIndex + 1;
                    if (!GMG.DISPLAY_GET_MORE_GAMES_LINK && this.selectedIndex == 4) {
                        ++this.selectedIndex;
                    }
                }
            } else if (ga == 8) {
                this.performMenuSelect();
            }
        } else if (this.displayMode == this.HELP_MENU) {
            if (sk == 1) {
                this.performMenuSelect();
                return;
            }
            if (sk == 2 || sk == 3) {
                this.displayMode = this.MAIN_MENU;
                return;
            }
            if (ga == 1) {
                this.helpSelectedIndex = this.helpSelectedIndex == 0 ? Strings.HELP_MENU_ITEMS.length - 1 : this.helpSelectedIndex - 1;
            } else if (ga == 6) {
                this.helpSelectedIndex = this.helpSelectedIndex == Strings.HELP_MENU_ITEMS.length - 1 ? 0 : this.helpSelectedIndex + 1;
            } else if (ga == 8) {
                this.performMenuSelect();
            }
        } else if (this.displayMode == this.OPTIONS_MENU) {
            if (sk == 1) {
                this.changeSetting(this.optionsSelectedIndex, true);
                return;
            }
            if (sk == 2 || sk == 3) {
                this.displayMode = this.MAIN_MENU;
                this.applySettings();
                this.saveSettings();
                Common.displayToast("Rules changes will take effect when a new game is started.");
                return;
            }
            if (ga == 1) {
                int n = this.optionsSelectedIndex = this.optionsSelectedIndex == 0 ? Strings.OPTIONS_MENU_ITEMS.length - 1 : this.optionsSelectedIndex - 1;
                if (this.optionsSelectedIndex == 0 && !Common.supportsSound()) {
                    this.optionsSelectedIndex = Strings.OPTIONS_MENU_ITEMS.length - 1;
                }
            } else if (ga == 6) {
                int n = this.optionsSelectedIndex = this.optionsSelectedIndex == Strings.OPTIONS_MENU_ITEMS.length - 1 ? 0 : this.optionsSelectedIndex + 1;
                if (this.optionsSelectedIndex == 0 && !Common.supportsSound()) {
                    this.optionsSelectedIndex = 1;
                }
            } else if (ga == 2) {
                this.changeSetting(this.optionsSelectedIndex, false);
            } else if (ga == 5) {
                this.changeSetting(this.optionsSelectedIndex, true);
            } else if (ga == 8) {
                this.changeSetting(this.optionsSelectedIndex, true);
            }
        }
    }

    public void keyReleasedEvent(int keyCode, int ga, int sk) {
        this.scrolling = 0;
        if (this.displayPopup == this.POPUP_REVEAL && this.popupType == this.POPUP_HELP) {
            if (ga == 1) {
                if (this.lineOffset > 0) {
                    --this.lineOffset;
                }
            } else if (ga == 6 && this.lineOffset + this.maxLines < this.helpLines.length) {
                ++this.lineOffset;
            }
        }
    }

    public void performMenuSelect() {
        if (this.displayMode == this.MAIN_MENU) {
            int si = this.selectedIndex;
            switch (si) {
                case 0: {
                    if (this.parent.gameCanvas.canResume()) {
                        this.displayPopup = this.POPUP_REVEAL;
                        this.popupType = this.POPUP_NEW_GAME;
                        this.boxFrame = 0;
                        this.boxNumFrames = 5;
                        this.popupSelectedIndex = 0;
                        this.boxW = 200;
                        this.boxH = 170;
                        break;
                    }
                    this.parent.startNewGame();
                    break;
                }
                case 1: {
                    this.parent.resumeGame();
                    break;
                }
                case 2: {
                    this.optionsSelectedIndex = 0;
                    if (!Common.supportsSound()) {
                        this.optionsSelectedIndex = 1;
                    }
                    this.displayMode = this.OPTIONS_MENU;
                    break;
                }
                case 3: {
                    this.helpSelectedIndex = 0;
                    this.displayMode = this.HELP_MENU;
                    break;
                }
                case 4: {
                    try {
                        if (this.parent.parent.platformRequest(GMG.GET_MORE_GAMES_URL) && !GMG.IGNORE_PLATFORM_REQUEST_EXIT) {
                            this.parent.exitApplication();
                        }
                    }
                    catch (Exception e) {
                        this.displayPopup = this.POPUP_REVEAL;
                        this.popupType = this.POPUP_GMG_CONNECTION;
                        this.boxFrame = 0;
                        this.boxNumFrames = 5;
                        this.boxW = 200;
                        this.boxH = 140;
                    }
                    break;
                }
                case 5: {
                    this.displayPopup = this.POPUP_REVEAL;
                    this.popupType = this.POPUP_ABOUT;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                    this.boxW = 200;
                    this.boxH = 140;
                    break;
                }
                case 6: {
                    this.parent.exitApplication();
                }
            }
        } else if (this.displayMode == this.HELP_MENU) {
            this.boxW = 230;
            this.boxH = 280;
            this.maxLines = (this.boxH - 20 - Common.largeFont.getHeight() - 7) / Common.normalBlackFont.getHeight();
            String helpSectionData = this.loadTextResource("/help/help" + this.helpSelectedIndex + ".txt");
            this.helpLines = Common.normalBlackFont.wrap(helpSectionData + "\n", this.boxW - 30);
            this.lineOffset = 0;
            this.scrolling = 0;
            this.displayPopup = this.POPUP_REVEAL;
            this.popupType = this.POPUP_HELP;
            this.boxFrame = 0;
            this.boxNumFrames = 5;
        }
    }

    public void changeSetting(int idx, boolean changeRight) {
        if (changeRight) {
            if (this.optionsSettings[idx] == Strings.OPTIONS_MENU_ITEM_SETTINGS[idx].length - 1) {
                this.optionsSettings[idx] = 0;
            } else {
                int n = idx;
                this.optionsSettings[n] = this.optionsSettings[n] + 1;
            }
        } else if (this.optionsSettings[idx] == 0) {
            this.optionsSettings[idx] = Strings.OPTIONS_MENU_ITEM_SETTINGS[idx].length - 1;
        } else {
            int n = idx;
            this.optionsSettings[n] = this.optionsSettings[n] - 1;
        }
        if (idx == 5) {
            int presetNum = this.optionsSettings[5];
            for (int i = 6; i < 18; ++i) {
                this.optionsSettings[i] = Strings.PRESETS_VALUES[presetNum][i - 6];
            }
        }
    }

    public void applySettings() {
        Common.setting_sound = this.optionsSettings[0] != 0;
        Common.setting_sound_volume = Strings.OPTIONS_MENU_ITEM_VALUES[0][this.optionsSettings[0]];
        Common.setting_hints = this.optionsSettings[1] != 0;
        Common.setting_perfect_play = this.optionsSettings[2] != 0;
        Common.setting_currency = Strings.OPTIONS_MENU_ITEM_VALUES[3][this.optionsSettings[3]];
        Common.setting_starting_cash = Strings.OPTIONS_MENU_ITEM_VALUES[4][this.optionsSettings[4]];
        Common.setting_preset = Strings.OPTIONS_MENU_ITEM_VALUES[5][this.optionsSettings[5]];
        Common.setting_num_decks = Strings.OPTIONS_MENU_ITEM_VALUES[6][this.optionsSettings[6]];
        Common.setting_double_rule = Strings.OPTIONS_MENU_ITEM_VALUES[7][this.optionsSettings[7]];
        Common.setting_insurance = Strings.OPTIONS_MENU_ITEM_VALUES[8][this.optionsSettings[8]];
        Common.setting_double_on_split = this.optionsSettings[9] != 0;
        Common.setting_dealer_hits_soft_17 = this.optionsSettings[10] != 0;
        Common.setting_dealer_peeks = this.optionsSettings[11] != 0;
        Common.setting_split_aces = this.optionsSettings[12] != 0;
        Common.setting_hit_split_aces = this.optionsSettings[13] != 0;
        Common.setting_resplit_aces = this.optionsSettings[14] != 0;
        Common.setting_max_split_hands = Strings.OPTIONS_MENU_ITEM_VALUES[15][this.optionsSettings[15]];
        Common.setting_surrender_rule = Strings.OPTIONS_MENU_ITEM_VALUES[16][this.optionsSettings[16]];
        Common.setting_shuffling = Strings.OPTIONS_MENU_ITEM_VALUES[17][this.optionsSettings[17]];
        Common.soundEnabled = Common.setting_sound;
        if (!Common.supportsSound()) {
            Common.soundEnabled = false;
        }
    }

    public void loadSettings() {
        try {
            if (RecordManager.exists("bj_set")) {
                DataInputStream is = new DataInputStream(new ByteArrayInputStream(RecordManager.load("bj_set")));
                for (int i = 0; i < this.optionsSettings.length; ++i) {
                    this.optionsSettings[i] = is.readInt();
                }
            }
            this.applySettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveSettings() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            for (int i = 0; i < this.optionsSettings.length; ++i) {
                os.writeInt(this.optionsSettings[i]);
            }
            RecordManager.save(baos.toByteArray(), "bj_set");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String loadTextResource(String res) {
        if (res == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/blackjack" + res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return sb.toString();
    }
}

