/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import net.handyx.casinopack.blackjack.AnimatedObject;
import net.handyx.casinopack.blackjack.Blackjack;
import net.handyx.casinopack.blackjack.Common;
import net.handyx.casinopack.blackjack.GameRenderer;
import net.handyx.casinopack.blackjack.GameRes;
import net.handyx.casinopack.blackjack.Strings;
import net.handyx.casinopack.blackjack.game.Bet;
import net.handyx.casinopack.blackjack.game.Game;
import net.handyx.casinopack.blackjack.game.GameStats;
import net.handyx.casinopack.blackjack.game.Hand;
import net.handyx.casinopack.blackjack.game.StrategyAdvisor;
import net.handyx.casinopack.common.FrameRenderer;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.common.RunnableCanvas;

public class GameCanvas
extends RunnableCanvas {
    public boolean mSoundEnabled = false;
    public boolean mVibrationEnabled = false;
    public boolean mLandscape = false;
    public boolean mDisplayHintStar = false;
    public boolean mDisplayPerfectPlayWarning = false;
    public boolean mCanResume = false;
    public int mStartingCash = 100;
    public int mCurrency = 0;
    public String mCurrencyStr = "$";
    public Blackjack mParent = null;
    public GameStats mGameStats = null;
    public Game mGame;
    public GameRenderer mGameRenderer;
    public int mTurn = 0;
    public Bet mBet = new Bet(0);
    public Bet _mBet = new Bet(0);
    public Bet mCash = new Bet(this.mStartingCash);
    public Bet _mCash = new Bet(this.mStartingCash);
    public Vector mWinnings;
    public Vector _mWinnings;
    public int mDealerCardsDealt = 0;
    public Vector mPlayerCardsDealt;
    public Vector mPlayerOfferedInsurance;
    public Vector mPlayerOfferedSurrender;
    public int mPlayerHand = 0;
    public int mPlayerHandsDealt = 0;
    public Vector mPlayerTotalString;
    public String mDealerTotalString = "";
    public Vector mAnimationQueue;
    public int mTurnCardFrame = 0;
    public boolean mChipSelectorVisible = false;
    public int mLastBetChipShown = 0;
    public boolean mPlaceBetsLabelShown = false;
    public boolean mInsuranceOfferVisible = false;
    public boolean mEvenMoneyOfferVisible = false;
    public boolean mDealerHasPeekedHoleCard = false;
    public boolean mSurrenderOfferVisible = false;
    public boolean displayStrategyTable = false;
    public boolean mPerfectPlayVisible = false;
    public static final int PLACE_BETS = 0;
    public static final int DEALING = 1;
    public static final int DEALER = 2;
    public static final int PLAYER = 3;
    public static final int SPLITTING = 4;
    public static final int FINISHED = 5;
    public static final int CLEAR_TABLE = 6;
    public static final int MOVING_HANDS = 7;
    public static final int MOVING_HANDS_FINSIHED = 8;
    public static final int PAUSE_SPLIT = 9;
    public static final int NO_BUTTON = -1;
    public static final int HIT_BUTTON = 0;
    public static final int STAND_BUTTON = 1;
    public static final int DOUBLE_BUTTON = 2;
    public static final int SPLIT_BUTTON = 3;
    public static final int NEXTGAME_BUTTON = 4;
    public static final int DEAL_BUTTON = 5;
    public static final int CLEARBETS_BUTTON = 6;
    public static final int INSURANCE_YES_BUTTON = 7;
    public static final int INSURANCE_NO_BUTTON = 8;
    public static final int BET_1_BUTTON = 9;
    public static final int BET_5_BUTTON = 10;
    public static final int BET_10_BUTTON = 11;
    public static final int BET_25_BUTTON = 12;
    public static final int BET_50_BUTTON = 13;
    public static final int SURRENDER_YES_BUTTON = 14;
    public static final int SURRENDER_NO_BUTTON = 15;
    public static final int LEFT_SPLIT_BUTTON = 16;
    public static final int RIGHT_SPLIT_BUTTON = 17;
    public static final int EVEN_MONEY_YES_BUTTON = 18;
    public static final int EVEN_MONEY_NO_BUTTON = 19;
    public int mButtonDown = -1;
    public int mSelectedButton = -1;
    public int mChosenAction = -1;
    public String mBetStr = "";
    public String mInsuranceStr = "";
    public Vector popupMenuItems = null;
    public int popupMenuSelectedIndex = 0;
    public boolean displayPopupMenu = false;
    private String popupWindowTitle;
    private String[] popupWindowText;
    private int popupWindowOffset = 0;
    private int popupWindowMaxLines = 0;
    private int popupWindowScroll = 0;
    private boolean displayPopupWindow = false;
    private int perfectPlaySelectedIndex = 0;
    private int strategyTableOffset = 0;
    private int strategyTableScroll = 0;
    private int strategyTableHeight = 0;
    private int perfectPlayStrategyYesX = 0;
    private int perfectPlayStrategyYesY = 0;
    private int perfectPlayStrategyNoX = 0;
    private int perfectPlayStrategyNoY = 0;
    public static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public GameCanvas(Blackjack p) {
        this.mParent = p;
        this.mGameRenderer = new GameRenderer(this);
        this.mGame = new Game();
        this.mAnimationQueue = new Vector();
        this.mPlayerCardsDealt = new Vector();
        this.mPlayerOfferedInsurance = new Vector();
        this.mPlayerOfferedSurrender = new Vector();
        this.mWinnings = new Vector();
        this._mWinnings = new Vector();
        this.mPlayerTotalString = new Vector();
    }

    public void loadResources() {
    }

    public void purgeResources() {
    }

    public void newGame() {
        this.mGameStats.resetGameStats();
        this.mPlayerCardsDealt.removeAllElements();
        this.mPlayerCardsDealt.addElement(new Integer(0));
        this.mWinnings.removeAllElements();
        this.mWinnings.addElement(new Bet(0));
        this._mWinnings.removeAllElements();
        this._mWinnings.addElement(new Bet(0));
        this.mPlayerOfferedInsurance.removeAllElements();
        this.mPlayerOfferedInsurance.addElement(new Boolean(false));
        this.mPlayerOfferedSurrender.removeAllElements();
        this.mPlayerOfferedSurrender.addElement(new Boolean(false));
        this.mPlayerHand = 0;
        this.mPlayerHandsDealt = 1;
        this.mDealerCardsDealt = 0;
        this.mGame.resetGame();
        this.mCash.set(this.mStartingCash);
        this._mCash.set(this.mStartingCash);
        this.mBet.set(0);
        this._mBet.set(0);
        this.mSurrenderOfferVisible = false;
        this.mEvenMoneyOfferVisible = false;
        this.mInsuranceOfferVisible = false;
        this.mChipSelectorVisible = false;
        this.mTurn = 0;
        this.mLastBetChipShown = 0;
        for (int i = 0; i < 5; ++i) {
            this.mAnimationQueue.addElement(new AnimatedObject(8, i, GameRenderer.BUTTONS_BET_X + i * GameRenderer.BET_BUTTONS_X_SPACING, 355, GameRenderer.BUTTONS_BET_X + i * GameRenderer.BET_BUTTONS_X_SPACING, GameRenderer.BUTTONS_BET_Y, 6, i * 60));
        }
        this.mPlaceBetsLabelShown = false;
        this.mAnimationQueue.addElement(new AnimatedObject(17, 0, -110, GameRenderer.PLACE_BETS_Y, GameRenderer.PLACE_BETS_X, GameRenderer.PLACE_BETS_Y, 15, 0L));
        this.mSelectedButton = 9;
        this.mCanResume = true;
    }

    public void nextGame() {
        this.mPlayerCardsDealt.removeAllElements();
        this.mPlayerCardsDealt.addElement(new Integer(0));
        this.mPlayerTotalString.removeAllElements();
        this.mPlayerTotalString.addElement(new String(""));
        this.mWinnings.removeAllElements();
        this.mWinnings.addElement(new Bet(0));
        this._mWinnings.removeAllElements();
        this._mWinnings.addElement(new Bet(0));
        this.mPlayerOfferedInsurance.removeAllElements();
        this.mPlayerOfferedInsurance.addElement(new Boolean(false));
        this.mPlayerOfferedSurrender.removeAllElements();
        this.mPlayerOfferedSurrender.addElement(new Boolean(false));
        this.mPlayerHand = 0;
        this.mPlayerHandsDealt = 1;
        this.mDealerCardsDealt = 0;
        this.mChipSelectorVisible = false;
        this.mTurn = 0;
        this.mSurrenderOfferVisible = false;
        this.mEvenMoneyOfferVisible = false;
        this.mInsuranceOfferVisible = false;
        this.mLastBetChipShown = 0;
        for (int i = 0; i < 5; ++i) {
            this.mAnimationQueue.addElement(new AnimatedObject(8, i, GameRenderer.BUTTONS_BET_X + i * GameRenderer.BET_BUTTONS_X_SPACING, 355, GameRenderer.BUTTONS_BET_X + i * GameRenderer.BET_BUTTONS_X_SPACING, GameRenderer.BUTTONS_BET_Y, 6, i * 60));
        }
        this.mPlaceBetsLabelShown = false;
        this.mAnimationQueue.addElement(new AnimatedObject(17, 0, -110, GameRenderer.PLACE_BETS_Y, GameRenderer.PLACE_BETS_X, GameRenderer.PLACE_BETS_Y, 15, 0L));
        if (this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
            this.mCash.subtract(this.mBet);
        } else {
            this.mBet = new Bet(this.mCash);
            this.mCash = new Bet(0);
        }
        this.mGame.newGame();
    }

    public void applySettings() {
        this.setCurrency(Common.setting_currency);
        this.setStartingCash(Common.setting_starting_cash);
        this.setHint(Common.setting_hints);
        this.setPerfectPlayWarning(Common.setting_perfect_play);
        this.setSound(Common.setting_sound);
    }

    public void applyGameSettings() {
        this.mGame.applySettings(Common.setting_num_decks, Common.setting_dealer_hits_soft_17, Common.setting_double_rule, Common.setting_insurance, Common.setting_dealer_peeks, false, false, Common.setting_hit_split_aces, Common.setting_resplit_aces, Common.setting_double_on_split, Common.setting_max_split_hands, Common.setting_split_aces, Common.setting_surrender_rule, Common.setting_shuffling);
    }

    public void deal() {
        this._mBet.set(this.mBet);
        this._mCash.set(this.mCash);
        this.mPlayerCardsDealt.removeAllElements();
        this.mPlayerCardsDealt.addElement(new Integer(0));
        this.mPlayerTotalString.removeAllElements();
        this.mPlayerTotalString.addElement(new String(""));
        this.mWinnings.removeAllElements();
        this.mWinnings.addElement(new Bet(0));
        this._mWinnings.removeAllElements();
        this._mWinnings.addElement(new Bet(0));
        this.mPlayerOfferedInsurance.removeAllElements();
        this.mPlayerOfferedInsurance.addElement(new Boolean(false));
        this.mPlayerOfferedSurrender.removeAllElements();
        this.mPlayerOfferedSurrender.addElement(new Boolean(false));
        this.mGame.deal(this.mBet, this.mCash);
        this.mPlayerHand = 0;
        this.mPlayerHandsDealt = 1;
        this.mDealerCardsDealt = 0;
        this.mDealerHasPeekedHoleCard = false;
        this.mSurrenderOfferVisible = false;
        this.mTurn = 1;
        this.mAnimationQueue.removeAllElements();
        this.mAnimationQueue.addElement(new AnimatedObject(0, 0, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.PLAYER_CARD_1_X, GameRenderer.PLAYER_CARD_1_Y, 20, 0L));
        this.mAnimationQueue.addElement(new AnimatedObject(2, 0, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.DEALER_CARD_1_X, GameRenderer.DEALER_CARD_1_Y, 15, 400L));
        this.mAnimationQueue.addElement(new AnimatedObject(1, 1, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.PLAYER_CARD_2_X, GameRenderer.PLAYER_CARD_2_Y, 20, 800L));
        this.mAnimationQueue.addElement(new AnimatedObject(3, 1, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.DEALER_CARD_2_X, GameRenderer.DEALER_CARD_2_Y, 15, 1200L));
        Common.doSound("card_deal_2x2");
    }

    public void dealSingleCard(int destination) {
        if (destination == 2) {
            this.mGame.hitDealer();
            this.mAnimationQueue.addElement(new AnimatedObject(5, this.mGame.getDealerHand().getLastCardIndex(), GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.DEALER_CARD_2_X + (this.mDealerCardsDealt - 1) * GameRenderer.DEALER_CARD_X_INCREMENT, GameRenderer.DEALER_CARD_2_Y, 15, 0L));
            Common.doSound("card_deal_1");
        } else if (destination == 3) {
            this.mGame.hit(this.mCash);
            this.mAnimationQueue.addElement(new AnimatedObject(4, this.mGame.getPlayerHand().getLastCardIndex(), GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.PLAYER_CARD_2_X + ((Integer)this.mPlayerCardsDealt.elementAt(this.mPlayerHand) - 1) * GameRenderer.PLAYER_CARD_X_INCREMENT, GameRenderer.PLAYER_CARD_2_Y, 20, 0L));
            Common.doSound("card_deal_1");
        }
    }

    public void turnDealerCard() {
        this.mDealerTotalString = "";
        this.mAnimationQueue.addElement(new AnimatedObject(6, 15, 0L));
        this.mTurnCardFrame = 15;
        Common.doSound("card_deal_1");
    }

    public void stand() {
        if (this.mPlayerHand > 0) {
            this.mTurn = 9;
            this.mAnimationQueue.addElement(new AnimatedObject(16, 30, 0L));
        } else {
            this.mTurn = 2;
            this.turnDealerCard();
            if (this.mSelectedButton != -1) {
                this.mSelectedButton = 4;
            }
        }
    }

    public void split() {
        this.mCash.subtract(this.mBet);
        this.mTurn = 4;
        if (this.mSelectedButton == 3) {
            this.mSelectedButton = 0;
        }
        this.mPlayerCardsDealt.setElementAt(new Integer(1), this.mPlayerHand);
        ++this.mPlayerHand;
        ++this.mPlayerHandsDealt;
        this.mPlayerCardsDealt.insertElementAt(new Integer(1), this.mPlayerHand);
        this.mWinnings.insertElementAt(new Bet(0), this.mPlayerHand);
        this._mWinnings.insertElementAt(new Bet(0), this.mPlayerHand);
        this.mPlayerTotalString.insertElementAt("", this.mPlayerHand);
        this.mPlayerOfferedInsurance.insertElementAt(new Boolean(false), this.mPlayerHand);
        this.mGame.split(this.mBet, this.mCash);
        this.calculateHandTotalStrings();
        this.mAnimationQueue.addElement(new AnimatedObject(13, 0, GameRenderer.PLAYER_CARD_1_X, GameRenderer.PLAYER_CARD_1_Y, GameRenderer.PLAYER_CARD_1_X - GameRenderer.PLAYER_HAND_X_OFFSET, GameRenderer.PLAYER_CARD_1_Y, 20, 0L));
        this.mAnimationQueue.addElement(new AnimatedObject(13, 1, GameRenderer.PLAYER_CARD_2_X, GameRenderer.PLAYER_CARD_2_Y, GameRenderer.PLAYER_CARD_1_X, GameRenderer.PLAYER_CARD_1_Y, 20, 0L));
    }

    public void moveHands(int direction) {
        if (direction == 2 ? this.mPlayerHand == 0 : direction == 5 && this.mPlayerHand == this.mPlayerHandsDealt - 1) {
            return;
        }
        if (this.mSelectedButton == 17) {
            if (this.mPlayerHand == this.mPlayerHandsDealt - 2) {
                this.mSelectedButton = 4;
            }
        } else if (this.mSelectedButton == 16) {
            if (this.mPlayerHand == 1) {
                this.mSelectedButton = 4;
            }
        } else if (this.mSelectedButton != -1) {
            this.mSelectedButton = 1;
        }
        this.mTurn = this.mTurn == 5 ? 8 : 7;
        int xo = -(this.mPlayerHand * GameRenderer.PLAYER_HAND_X_OFFSET);
        for (int hand = 0; hand < this.mPlayerHandsDealt; ++hand) {
            int nCards = (Integer)this.mPlayerCardsDealt.elementAt(hand);
            for (int card = 0; card < nCards; ++card) {
                int y1;
                int x1;
                if (card == 0) {
                    x1 = GameRenderer.PLAYER_CARD_1_X + xo;
                    y1 = GameRenderer.PLAYER_CARD_1_Y;
                } else if (card == 1) {
                    x1 = GameRenderer.PLAYER_CARD_2_X + xo;
                    y1 = GameRenderer.PLAYER_CARD_2_Y;
                } else {
                    x1 = xo + GameRenderer.PLAYER_CARD_2_X + GameRenderer.PLAYER_CARD_X_INCREMENT * (card - 1);
                    y1 = GameRenderer.PLAYER_CARD_2_Y + GameRenderer.PLAYER_CARD_Y_INCREMENT * (card - 1);
                }
                int x2 = direction == 2 ? x1 + GameRenderer.PLAYER_HAND_X_OFFSET : x1 - GameRenderer.PLAYER_HAND_X_OFFSET;
                int y2 = y1;
                this.mAnimationQueue.addElement(new AnimatedObject(15, hand, card, x1, y2, x2, y2, 25, 0L));
            }
            xo += GameRenderer.PLAYER_HAND_X_OFFSET;
        }
        this.mPlayerHand = direction == 2 ? --this.mPlayerHand : ++this.mPlayerHand;
        this.mGame.selectHand(this.mPlayerHand, this.mCash);
    }

    public void paintCanvas(Graphics gfx, int sw, int sh) {
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        sw = g.getWidth();
        sh = g.getHeight();
        this.mGameRenderer.paintCanvas(g, sw, sh);
        if (this.displayPopupMenu) {
            this.renderPopupMenu(g);
            GameCanvas.drawLeftCommand(g, Strings.CMD_SELECT, Common.settingsFont);
            GameCanvas.drawRightCommand(g, Strings.CMD_CANCEL, Common.settingsFont);
        } else if (this.displayPopupWindow) {
            this.renderPopupWindow(g);
            GameCanvas.drawRightCommand(g, Strings.CMD_OK, Common.settingsFont);
        } else if (this.mPerfectPlayVisible) {
            this.renderPerfectPlayWindow(g);
            GameCanvas.drawLeftCommand(g, Strings.CMD_YES, Common.settingsFont);
            GameCanvas.drawRightCommand(g, Strings.CMD_NO, Common.settingsFont);
        } else if (this.displayStrategyTable) {
            this.renderStrategyTable(g);
            GameCanvas.drawRightCommand(g, Strings.CMD_OK, Common.settingsFont);
        } else {
            GameCanvas.drawLeftCommand(g, Strings.CMD_OPTIONS, Common.settingsFont);
            GameCanvas.drawRightCommand(g, Strings.CMD_MENU, Common.settingsFont);
        }
    }

    public void displayPopupMenu() {
        if (this.popupMenuItems == null) {
            this.popupMenuItems = new Vector();
        }
        this.popupMenuItems.removeAllElements();
        if (this.canSurrender()) {
            this.popupMenuItems.addElement("Surrender");
        }
        this.popupMenuItems.addElement("Strategy Table");
        if (this.canDisplayHint()) {
            this.popupMenuItems.addElement("Hint");
        }
        this.popupMenuItems.addElement("Game Stats");
        this.popupMenuItems.addElement("Return to Main Menu");
        this.popupMenuSelectedIndex = 0;
        this.displayPopupMenu = true;
    }

    public void renderPopupMenu(GraphicsScaler g) {
        int menuW = 200;
        int menuItemH = Common.normalBlackFont.getHeight() + 16;
        int menuH = menuItemH * this.popupMenuItems.size() + 6;
        int menuX = (g.getWidth() - menuW) / 2;
        int menuY = (g.getHeight() - menuH) / 2;
        for (int meshX = 0; meshX < this.getWidth(); meshX += 48) {
            for (int meshY = 0; meshY < this.getHeight(); meshY += 64) {
                g.drawImage(Common.meshImage, meshX, meshY, 20);
            }
        }
        g.setColor(0x666666);
        g.fillRect(menuX, menuY, menuW, menuH);
        g.setColor(0x333333);
        int y = menuY + 3;
        for (int i = 0; i < this.popupMenuItems.size(); ++i) {
            String label = (String)this.popupMenuItems.elementAt(i);
            if (i == this.popupMenuSelectedIndex) {
                g.fillRect(menuX + 3, y, menuW - 6, menuItemH);
                Common.normalBlackFont.drawString(g, label, 1 + (g.getWidth() - Common.normalBlackFont.stringWidth(label)) / 2, y + 7 + 1);
                Common.normalWhiteFont.drawString(g, label, (g.getWidth() - Common.normalWhiteFont.stringWidth(label)) / 2, y + 7);
            } else {
                Common.normalBlackFont.drawString(g, label, (g.getWidth() - Common.normalBlackFont.stringWidth(label)) / 2, y + 7);
            }
            y += menuItemH;
        }
    }

    public void activatePopupMenu() {
        this.displayPopupMenu = false;
        String s = (String)this.popupMenuItems.elementAt(this.popupMenuSelectedIndex);
        if (s.equals("Surrender")) {
            this.surrender();
        } else if (s.equals("Strategy Table")) {
            this.displayStrategyTable();
        } else if (s.equals("Hint")) {
            String msg = "";
            if (this.isOfferingEarlySurrender()) {
                if (this.getRecommendedAction() == 9) {
                    msg = "The recommended action is to Surrender\n\n";
                    msg = msg + "You have been offered early surrender, this is a highly beneficial rule for the player although rarely seen in real casinos.";
                } else {
                    msg = "The recommended action is to not surrender\n\n";
                    msg = msg + "You have been offered early surrender, this is a highly beneficial rule for the player although rarely seen in real casinos.";
                }
            } else if (this.isOfferingInsurance() || this.isOfferingEvenMoney()) {
                msg = "The recommended action is to not take insurance or even money\n\n";
                msg = msg + "In almost all circumstances it is a better not to take insurance (or even money). It only increases the house edge!";
            } else {
                msg = "The recommended action is to " + this.getRecommendedActionString();
                if (this.getRecommendedAction() == 4) {
                    if (this.isFirstCardAceOrEight()) {
                        msg = msg + "\n\nRemember, always split aces and eights!";
                    }
                } else if (!this.hasSoftHand()) {
                    if (this.getTotal() >= 17) {
                        msg = msg + "\n\nRemember, always stand on a hand with a hard total of 17 or more!";
                    } else if (this.getTotal() >= 4 && this.getTotal() <= 7 && Game.ruleNumDecks == 1) {
                        msg = msg + "\n\nRemember, in a single deck game, always hit on a hand with a hard total of 4 to 7!";
                    } else if (this.getTotal() >= 4 && this.getTotal() <= 8 && Game.ruleNumDecks > 1) {
                        msg = msg + "\n\nRemember, always hit on a hand with a hard total of 4 to 8!";
                    }
                }
            }
            msg = msg + "\n\nYour strategy will change depending on the rules in play. Check out the strategy table for a detailed view of the best strategy for the current game.";
            this.displayPopupWindow(s, msg);
        } else if (s.equals("Game Stats")) {
            this.displayPopupWindow(s, this.mGameStats.toString());
        } else if (s.equals("Return to Main Menu")) {
            this.mParent.displayMainMenu();
        }
    }

    public void displayPopupWindow(String title, String text) {
        this.popupWindowTitle = title;
        this.popupWindowText = Common.normalWhiteFont.wrap(text, 190);
        this.popupWindowOffset = 0;
        this.displayPopupWindow = true;
        int windowHeight = 280;
        int menuItemH = Common.normalBlackFont.getHeight() + 16;
        this.popupWindowMaxLines = (windowHeight - 3 - menuItemH - 15 - 10) / Common.normalWhiteFont.getHeight();
    }

    public void renderPopupWindow(GraphicsScaler g) {
        int windowWidth = 220;
        int windowHeight = 280;
        int windowX = (240 - windowWidth) / 2;
        int windowY = (320 - windowHeight) / 2;
        int menuItemH = Common.normalBlackFont.getHeight() + 16;
        for (int meshX = 0; meshX < 240; meshX += 48) {
            for (int meshY = 0; meshY < 320; meshY += 64) {
                g.drawImage(Common.meshImage, meshX, meshY, 20);
            }
        }
        g.setColor(0x666666);
        g.fillRect(windowX, windowY, windowWidth, windowHeight);
        g.setColor(0x333333);
        g.fillRect(windowX + 3, windowY + 3, windowWidth - 6, menuItemH);
        g.fillRect(windowX + 3, windowY + 3 + menuItemH + 3, windowWidth - 6, windowHeight - 9 - menuItemH);
        Common.normalBlackFont.drawString(g, this.popupWindowTitle, 1 + (g.getWidth() - Common.normalBlackFont.stringWidth(this.popupWindowTitle)) / 2, windowY + 10 + 1);
        Common.normalWhiteFont.drawString(g, this.popupWindowTitle, (g.getWidth() - Common.normalWhiteFont.stringWidth(this.popupWindowTitle)) / 2, windowY + 10);
        int y = windowY + 3 + menuItemH + 15;
        for (int i = 0; i < this.popupWindowMaxLines; ++i) {
            if (this.popupWindowOffset + i < this.popupWindowText.length) {
                String line = this.popupWindowText[this.popupWindowOffset + i];
                Common.normalWhiteFont.drawString(g, line, windowX + 15, y);
            }
            y += Common.normalWhiteFont.getHeight();
        }
    }

    public void renderPerfectPlayWindow(GraphicsScaler g) {
        int buttonX;
        for (int meshX = 0; meshX < 240; meshX += 48) {
            for (int meshY = 0; meshY < 320; meshY += 64) {
                g.drawImage(Common.meshImage, meshX, meshY, 20);
            }
        }
        int windowWidth = 200;
        int windowHeight = 180;
        int windowX = (240 - windowWidth) / 2;
        int windowY = (320 - windowHeight) / 2;
        FrameRenderer.renderFrame(g, windowX, windowY, windowWidth, windowHeight, 20, null);
        Common.largeFont.drawString(g, "Perfect Play", (240 - Common.largeFont.stringWidth("Perfect Play")) / 2, windowY + 15);
        String[] lines = Common.normalBlackFont.wrap("The action you have chosen is not the best play for this hand.\n\nAre you sure you want to continue and take this action?", windowWidth - 30);
        int y = windowY + 50;
        for (int i = 0; i < lines.length; ++i) {
            Common.normalBlackFont.drawString(g, lines[i], (240 - Common.normalBlackFont.stringWidth(lines[i])) / 2, y);
            y += Common.normalWhiteFont.getHeight();
        }
        this.perfectPlayStrategyYesX = buttonX = (240 - 2 * g.unscale(Common.yesOffImage.getWidth()) - 10) / 2;
        this.perfectPlayStrategyYesY = y += 10;
        this.perfectPlayStrategyNoX = buttonX + g.unscale(Common.yesOffImage.getWidth()) + 10;
        this.perfectPlayStrategyNoY = y;
        g.drawImage(this.perfectPlaySelectedIndex == 0 ? Common.yesOnImage : Common.yesOffImage, buttonX, y, 20);
        g.drawImage(this.perfectPlaySelectedIndex == 1 ? Common.noOnImage : Common.noOffImage, buttonX + g.unscale(Common.yesOffImage.getWidth()) + 10, y, 20);
    }

    private void renderStrategyTable(GraphicsScaler g) {
        for (int meshX = 0; meshX < 240; meshX += 48) {
            for (int meshY = 0; meshY < 320; meshY += 64) {
                g.drawImage(Common.meshImage, meshX, meshY, 20);
            }
        }
        if (StrategyAdvisor.mTableBitmap != null) {
            int x = (240 - g.unscale(StrategyAdvisor.mTableBitmap.getWidth())) / 2;
            int y = this.strategyTableOffset;
            FrameRenderer.renderFrame(g, 0, y, 240, g.unscale(StrategyAdvisor.mTableBitmap.getHeight()) + 40);
            Common.normalBlackFont.drawCenteredString(g, "Strategy Table", g.getWidth(), y + 8);
            g.drawImage(StrategyAdvisor.mTableBitmap, x, y + 30, 20);
            if (this.mGame.mStrategyAction != -1 && this.mGame.mStrategyActionPosition[0] >= 0 && this.mGame.mStrategyActionPosition[1] >= 0) {
                int actionX = x + 32 + this.mGame.mStrategyActionPosition[1] * 16;
                int actionY = y + 30 + 25 + this.mGame.mStrategyActionPosition[0] * 8;
                g.drawImage(GameRes.mStatTableHighlight, actionX + -3, actionY + -4, 20);
            }
            g.drawImage(Common.scrollImage, (240 - g.unscale(Common.scrollImage.getWidth())) / 2, 320 - g.unscale(Common.scrollImage.getHeight()) - 3, 20);
        }
    }

    public void stopNotify() {
        Common.stopSounds();
    }

    public void processFrame(int fn) {
        Bet diff;
        Common.processToasts();
        if (this.displayPopupWindow) {
            if (this.popupWindowScroll > 0) {
                if (this.popupWindowOffset < this.popupWindowText.length - this.popupWindowMaxLines) {
                    ++this.popupWindowOffset;
                }
            } else if (this.popupWindowScroll < 0 && this.popupWindowOffset > 0) {
                --this.popupWindowOffset;
            }
        }
        if (this.displayStrategyTable) {
            if (this.strategyTableScroll > 0) {
                this.strategyTableOffset -= 10;
                if (this.strategyTableOffset < -(this.strategyTableHeight - 320 + 10)) {
                    this.strategyTableOffset = -(this.strategyTableHeight - 320 + 10);
                }
            } else if (this.strategyTableScroll < 0) {
                this.strategyTableOffset += 10;
                if (this.strategyTableOffset > 10) {
                    this.strategyTableOffset = 5;
                }
            }
        }
        if (!this._mBet.isEqualTo(this.mBet)) {
            if (this.mBet.isGreaterThan(this._mBet)) {
                diff = Bet.difference(this.mBet, this._mBet);
                if (diff.maj > 100) {
                    this._mBet.add(100, 0);
                } else if (diff.maj > 10) {
                    this._mBet.add(10, 0);
                } else if (diff.maj > 0) {
                    this._mBet.add(1, 0);
                } else {
                    this._mBet.add(0, diff.min);
                }
            } else {
                diff = Bet.difference(this.mBet, this._mBet);
                if (diff.maj > 100) {
                    this._mBet.subtract(100, 0);
                } else if (diff.maj > 10) {
                    this._mBet.subtract(10, 0);
                } else if (diff.maj > 0) {
                    this._mBet.subtract(1, 0);
                } else {
                    this._mBet.subtract(0, diff.min);
                }
            }
        }
        if (!this._mCash.isEqualTo(this.mCash)) {
            if (this.mCash.isGreaterThan(this._mCash)) {
                diff = Bet.difference(this.mCash, this._mCash);
                if (diff.maj > 100) {
                    this._mCash.add(100, 0);
                } else if (diff.maj > 10) {
                    this._mCash.add(10, 0);
                } else if (diff.maj > 0) {
                    this._mCash.add(1, 0);
                } else {
                    this._mCash.add(0, diff.min);
                }
            } else {
                diff = Bet.difference(this.mCash, this._mCash);
                if (diff.maj > 100) {
                    this._mCash.subtract(100, 0);
                } else if (diff.maj > 10) {
                    this._mCash.subtract(10, 0);
                } else if (diff.maj > 0) {
                    this._mCash.subtract(1, 0);
                } else {
                    this._mCash.subtract(0, diff.min);
                }
            }
        }
        for (int i = 0; i < this.mWinnings.size(); ++i) {
            Bet diff2;
            Bet winnings;
            Bet _winnings = (Bet)this._mWinnings.elementAt(i);
            if (_winnings.isEqualTo(winnings = (Bet)this.mWinnings.elementAt(i))) continue;
            if (winnings.isGreaterThan(_winnings)) {
                diff2 = Bet.difference(winnings, _winnings);
                if (diff2.maj > 100) {
                    _winnings.add(100, 0);
                    continue;
                }
                if (diff2.maj > 10) {
                    _winnings.add(10, 0);
                    continue;
                }
                if (diff2.maj > 0) {
                    _winnings.add(1, 0);
                    continue;
                }
                _winnings.add(0, diff2.min);
                continue;
            }
            diff2 = Bet.difference(winnings, _winnings);
            if (diff2.maj > 100) {
                _winnings.subtract(100, 0);
                continue;
            }
            if (diff2.maj > 10) {
                _winnings.subtract(10, 0);
                continue;
            }
            if (diff2.maj > 0) {
                _winnings.subtract(1, 0);
                continue;
            }
            _winnings.subtract(0, diff2.min);
        }
        AnimatedObject ao = null;
        for (int i = 0; i < this.mAnimationQueue.size(); ++i) {
            ao = (AnimatedObject)this.mAnimationQueue.elementAt(i);
            if (ao.animate()) continue;
            this.mAnimationQueue.removeElementAt(i);
            --i;
            this.animationFinished(ao);
        }
    }

    private void animationFinished(AnimatedObject ao) {
        System.out.println(ao.toString() + " finished!");
        int id = ao.id;
        int token = ao.token;
        int playerCardsDealt = (Integer)this.mPlayerCardsDealt.elementAt(this.mPlayerHand);
        switch (id) {
            case 0: {
                this.mPlayerCardsDealt.setElementAt(new Integer(++playerCardsDealt), this.mPlayerHand);
                break;
            }
            case 1: {
                this.mPlayerCardsDealt.setElementAt(new Integer(++playerCardsDealt), this.mPlayerHand);
                break;
            }
            case 4: {
                this.mPlayerCardsDealt.setElementAt(new Integer(++playerCardsDealt), this.mPlayerHand);
                break;
            }
            case 14: {
                this.mPlayerCardsDealt.setElementAt(new Integer(++playerCardsDealt), this.mPlayerHand);
                break;
            }
            case 2: {
                ++this.mDealerCardsDealt;
                break;
            }
            case 3: {
                ++this.mDealerCardsDealt;
                break;
            }
            case 5: {
                ++this.mDealerCardsDealt;
            }
        }
        if (playerCardsDealt >= 2) {
            this.calculateHandTotalStrings();
        }
        if (id == 3) {
            this.dealtFinalCard();
        } else if (id == 14) {
            int dealerUpCard = this.mGame.getDealerHand().getCard(1).getValue();
            boolean alreadyOfferedInsurance = (Boolean)this.mPlayerOfferedInsurance.elementAt(this.mPlayerHand);
            if (dealerUpCard == 1 && !Game.ruleDealerPeeksHoleCard) {
                Bet insuranceBet = new Bet(this.mBet);
                insuranceBet.divideByTwo();
                if (Game.ruleDealerInsurance > 0 && !alreadyOfferedInsurance && this.mCash.isGreaterThanOrEqualTo(insuranceBet)) {
                    this.mInsuranceOfferVisible = true;
                    if (this.mSelectedButton != -1) {
                        this.mSelectedButton = 7;
                    }
                } else if (this.mGame.getPlayerHand().canHit()) {
                    if (this.mGame.getPlayerHand().getTotal() == 21 && !this.mGame.getPlayerHand().canDoubleDown()) {
                        this.stand();
                    } else {
                        this.mTurn = 3;
                    }
                } else {
                    this.stand();
                }
            } else if (this.mGame.getPlayerHand().canHit()) {
                if (this.mGame.getPlayerHand().getTotal() == 21 && !this.mGame.getPlayerHand().canDoubleDown()) {
                    this.stand();
                } else {
                    this.mTurn = 3;
                }
            } else {
                this.stand();
            }
        } else if (id == 5 || id == 6) {
            this.calculateDealerHandTotalStrings();
            if (this.mGame.dealerNeedsMoreCards()) {
                this.dealSingleCard(2);
            } else {
                this.mTurn = 5;
                this.calculateWinnings();
            }
        } else if (id == 4) {
            if (this.mGame.getPlayerHand().hasBust()) {
                this.stand();
            } else if (this.mGame.getPlayerHand().hasBlackjack() || this.mGame.getPlayerHand().getTotal() == 21) {
                this.stand();
            } else if (id == 4 && this.mGame.getPlayerHand().hasDoubledDown()) {
                this.stand();
            }
        } else if (id == 8) {
            this.mLastBetChipShown = token + 1;
            if (this.mLastBetChipShown == 5) {
                this.mChipSelectorVisible = true;
            }
        } else if (id == 17) {
            this.mPlaceBetsLabelShown = true;
        } else if (id == 12 || id == 11) {
            if (this.mAnimationQueue.isEmpty()) {
                this.nextGame();
            }
        } else if (id == 13) {
            if (ao.token == 1) {
                this.mTurn = 1;
                this.mAnimationQueue.addElement(new AnimatedObject(14, 1, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.PLAYER_CARD_2_X, GameRenderer.PLAYER_CARD_2_Y, 15, 0L));
                Common.doSound("card_deal_1");
            }
        } else if (id == 15) {
            if (this.mAnimationQueue.isEmpty()) {
                if (this.mTurn == 7) {
                    this.mTurn = 1;
                    this.mAnimationQueue.addElement(new AnimatedObject(14, 1, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, GameRenderer.PLAYER_CARD_2_X, GameRenderer.PLAYER_CARD_2_Y, 15, 0L));
                    Common.doSound("card_deal_1");
                } else if (this.mTurn == 8) {
                    this.mTurn = 5;
                }
            }
        } else if (id == 16) {
            this.moveHands(2);
        }
    }

    public void dealtFinalCard() {
        int dealerHoleCard = this.mGame.getDealerHand().getCard(0).getValue();
        int dealerUpCard = this.mGame.getDealerHand().getCard(1).getValue();
        boolean alreadyOfferedInsurance = (Boolean)this.mPlayerOfferedInsurance.elementAt(this.mPlayerHand);
        boolean alreadyOfferedSurrender = (Boolean)this.mPlayerOfferedSurrender.elementAt(this.mPlayerHand);
        if (dealerUpCard != 10 && dealerUpCard != 1) {
            this.mDealerHasPeekedHoleCard = true;
        }
        if (this.mGame.getPlayerHand().hasBlackjack()) {
            if (Game.ruleDealerInsurance == 2 && dealerUpCard == 1) {
                this.mEvenMoneyOfferVisible = true;
                if (this.mSelectedButton != -1) {
                    this.mSelectedButton = 18;
                }
            } else {
                this.stand();
            }
        } else if (dealerUpCard == 1) {
            if (!this.mGame.getPlayerHand().hasBlackjack()) {
                Bet insuranceBet = new Bet(this.mBet);
                insuranceBet.divideByTwo();
                if (Game.ruleSurrender == 1 && !alreadyOfferedSurrender) {
                    this.mSurrenderOfferVisible = true;
                    if (this.mSelectedButton != -1) {
                        this.mSelectedButton = 14;
                    }
                    System.out.println("Early surrender offered");
                } else if (Game.ruleDealerInsurance > 0 && !alreadyOfferedInsurance && this.mCash.isGreaterThanOrEqualTo(insuranceBet)) {
                    this.mInsuranceOfferVisible = true;
                    if (this.mSelectedButton != -1) {
                        this.mSelectedButton = 7;
                    }
                    System.out.println("Insurance offered");
                } else if (Game.ruleDealerPeeksHoleCard) {
                    this.mDealerHasPeekedHoleCard = true;
                    this.mAnimationQueue.addElement(new AnimatedObject(7, 30, 0L));
                    if (dealerHoleCard == 10) {
                        this.stand();
                    } else {
                        this.mTurn = 3;
                    }
                } else {
                    this.mTurn = 3;
                }
            } else {
                this.mTurn = 3;
            }
        } else if (dealerUpCard == 10) {
            if (Game.ruleSurrender == 1 && !alreadyOfferedSurrender) {
                this.mSurrenderOfferVisible = true;
                if (this.mSelectedButton != -1) {
                    this.mSelectedButton = 14;
                }
                System.out.println("Early surrender offered");
            } else if (Game.ruleDealerPeeksHoleCard) {
                this.mDealerHasPeekedHoleCard = true;
                this.mAnimationQueue.addElement(new AnimatedObject(7, 30, 0L));
                if (dealerHoleCard == 1) {
                    this.stand();
                } else {
                    this.mTurn = 3;
                }
            } else {
                this.mTurn = 3;
            }
        } else {
            this.mTurn = 3;
        }
    }

    public void keyPressedEvent(int keyCode, int ga, int sk) {
        if (keyCode == -8) {
            return;
        }
        if (this.displayPopupMenu) {
            if (ga == 1) {
                this.popupMenuSelectedIndex = this.popupMenuSelectedIndex == 0 ? this.popupMenuItems.size() - 1 : this.popupMenuSelectedIndex - 1;
            } else if (ga == 6) {
                this.popupMenuSelectedIndex = this.popupMenuSelectedIndex == this.popupMenuItems.size() - 1 ? 0 : this.popupMenuSelectedIndex + 1;
            } else if (ga == 8 || sk == 1) {
                this.activatePopupMenu();
            } else if (sk == 2 || sk == 3) {
                this.displayPopupMenu = false;
            }
            return;
        }
        if (this.displayPopupWindow) {
            if (sk == 2 || sk == 3) {
                this.displayPopupWindow = false;
            } else if (ga == 1) {
                this.popupWindowScroll = -1;
            } else if (ga == 6) {
                this.popupWindowScroll = 1;
            }
            return;
        }
        if (this.displayStrategyTable) {
            if (sk == 2 || sk == 3) {
                this.displayStrategyTable = false;
            } else if (ga == 1) {
                this.strategyTableScroll = -1;
            } else if (ga == 6) {
                this.strategyTableScroll = 1;
            }
            return;
        }
        if (this.mPerfectPlayVisible) {
            if (ga == 2 || ga == 5 || ga == 1 || ga == 6) {
                this.perfectPlaySelectedIndex = this.perfectPlaySelectedIndex == 0 ? 1 : 0;
            } else if (ga == 8) {
                if (this.perfectPlaySelectedIndex == 0) {
                    this.activateButton(this.mChosenAction, true);
                }
                this.mPerfectPlayVisible = false;
            } else if (sk == 1) {
                this.activateButton(this.mChosenAction, true);
                this.mPerfectPlayVisible = false;
            } else if (sk == 2 || sk == 3) {
                this.mPerfectPlayVisible = false;
            }
            return;
        }
        if (sk == 1) {
            this.displayPopupMenu();
        } else if (sk == 2 || sk == 3) {
            this.mParent.displayMainMenu();
        }
        if (this.mTurn == 1) {
            if (this.mInsuranceOfferVisible) {
                if (ga == 2 || ga == 5 || ga == 1 || ga == 6) {
                    switch (this.mSelectedButton) {
                        case 8: {
                            this.mSelectedButton = 7;
                            break;
                        }
                        case 7: {
                            this.mSelectedButton = 8;
                            break;
                        }
                        default: {
                            this.mSelectedButton = 7;
                            break;
                        }
                    }
                } else if (ga == 8) {
                    this.mButtonDown = this.mSelectedButton;
                    Common.doSound("button_click");
                }
            } else if (this.mEvenMoneyOfferVisible) {
                if (ga == 2 || ga == 5 || ga == 1 || ga == 6) {
                    switch (this.mSelectedButton) {
                        case 19: {
                            this.mSelectedButton = 18;
                            break;
                        }
                        case 18: {
                            this.mSelectedButton = 19;
                            break;
                        }
                        default: {
                            this.mSelectedButton = 18;
                            break;
                        }
                    }
                } else if (ga == 8) {
                    this.mButtonDown = this.mSelectedButton;
                    Common.doSound("button_click");
                }
            } else if (this.mSurrenderOfferVisible) {
                if (ga == 2 || ga == 5 || ga == 1 || ga == 6) {
                    switch (this.mSelectedButton) {
                        case 15: {
                            this.mSelectedButton = 14;
                            break;
                        }
                        case 14: {
                            this.mSelectedButton = 15;
                            break;
                        }
                        default: {
                            this.mSelectedButton = 14;
                            break;
                        }
                    }
                } else if (ga == 8) {
                    this.mButtonDown = this.mSelectedButton;
                    Common.doSound("button_click");
                }
            }
        } else if (this.mTurn == 3) {
            if (ga == 1 || ga == 6) {
                if (this.mSelectedButton == -1) {
                    this.mSelectedButton = 0;
                }
            } else if (ga == 2) {
                switch (this.mSelectedButton) {
                    case 0: {
                        if (this.mGame.canHandSplit() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                            this.mSelectedButton = 3;
                            break;
                        }
                        if (this.mGame.canHandDouble() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                            this.mSelectedButton = 2;
                            break;
                        }
                        this.mSelectedButton = 1;
                        break;
                    }
                    case 1: {
                        this.mSelectedButton = 0;
                        break;
                    }
                    case 2: {
                        this.mSelectedButton = 1;
                        break;
                    }
                    case 3: {
                        if (this.mGame.canHandDouble() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                            this.mSelectedButton = 2;
                            break;
                        }
                        this.mSelectedButton = 1;
                        break;
                    }
                    default: {
                        this.mSelectedButton = 0;
                        break;
                    }
                }
            } else if (ga == 5) {
                switch (this.mSelectedButton) {
                    case 0: {
                        this.mSelectedButton = 1;
                        break;
                    }
                    case 1: {
                        if (this.mGame.canHandDouble() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                            this.mSelectedButton = 2;
                            break;
                        }
                        if (this.mGame.canHandSplit() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                            this.mSelectedButton = 3;
                            break;
                        }
                        this.mSelectedButton = 0;
                        break;
                    }
                    case 2: {
                        if (this.mGame.canHandSplit() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                            this.mSelectedButton = 3;
                            break;
                        }
                        this.mSelectedButton = 0;
                        break;
                    }
                    case 3: {
                        this.mSelectedButton = 0;
                        break;
                    }
                    default: {
                        this.mSelectedButton = 0;
                        break;
                    }
                }
            } else if (ga == 8) {
                this.mButtonDown = this.mSelectedButton;
                Common.doSound("button_click");
            }
        } else if (this.mTurn == 0) {
            if (this.mSelectedButton == -1) {
                this.mSelectedButton = this.mBet.isZero() ? 9 : 5;
            } else if (ga == 2) {
                switch (this.mSelectedButton) {
                    case 9: {
                        this.mSelectedButton = 13;
                        break;
                    }
                    case 10: {
                        this.mSelectedButton = 9;
                        break;
                    }
                    case 11: {
                        this.mSelectedButton = 10;
                        break;
                    }
                    case 12: {
                        this.mSelectedButton = 11;
                        break;
                    }
                    case 13: {
                        this.mSelectedButton = 12;
                        break;
                    }
                    case 6: {
                        this.mSelectedButton = 5;
                    }
                }
            } else if (ga == 5) {
                switch (this.mSelectedButton) {
                    case 9: {
                        this.mSelectedButton = 10;
                        break;
                    }
                    case 10: {
                        this.mSelectedButton = 11;
                        break;
                    }
                    case 11: {
                        this.mSelectedButton = 12;
                        break;
                    }
                    case 12: {
                        this.mSelectedButton = 13;
                        break;
                    }
                    case 13: {
                        this.mSelectedButton = 9;
                        break;
                    }
                    case 5: {
                        this.mSelectedButton = 6;
                    }
                }
            } else if (ga == 1) {
                if (!this.mBet.isZero() && this.mSelectedButton >= 9 && this.mSelectedButton <= 13) {
                    this.mSelectedButton = 6;
                } else if (this.mSelectedButton == 6) {
                    this.mSelectedButton = 5;
                }
            } else if (ga == 6) {
                if (this.mSelectedButton == 5) {
                    this.mSelectedButton = 6;
                } else if (this.mSelectedButton == 6) {
                    this.mSelectedButton = 9;
                }
            } else if (ga == 8) {
                this.mButtonDown = this.mSelectedButton;
                if (this.mButtonDown == 5 || this.mButtonDown == 6) {
                    Common.doSound("button_click");
                }
            }
        } else if (this.mTurn == 5) {
            if (ga == 2) {
                if (this.mSelectedButton == -1) {
                    this.mSelectedButton = 4;
                } else if (this.mSelectedButton == 17) {
                    this.mSelectedButton = 4;
                } else if (this.mSelectedButton == 4 && this.mPlayerHand > 0) {
                    this.mSelectedButton = 16;
                }
            } else if (ga == 5) {
                if (this.mSelectedButton == -1) {
                    this.mSelectedButton = 4;
                } else if (this.mSelectedButton == 4) {
                    if (this.mPlayerHandsDealt - 1 > this.mPlayerHand) {
                        this.mSelectedButton = 17;
                    }
                } else if (this.mSelectedButton == 16) {
                    this.mSelectedButton = 4;
                }
            } else if ((ga == 1 || ga == 6) && this.mSelectedButton == -1) {
                this.mSelectedButton = 4;
            }
            if (ga == 8) {
                this.mButtonDown = this.mSelectedButton;
                Common.doSound("button_click");
            }
        }
    }

    public void keyReleasedEvent(int keyCode, int ga, int sk) {
        if (keyCode == -8) {
            return;
        }
        if (this.mPerfectPlayVisible || this.displayPopupMenu || this.displayPopupWindow || this.displayStrategyTable) {
            this.popupWindowScroll = 0;
            this.strategyTableScroll = 0;
            if (this.displayPopupMenu) {
                if (ga == 8) {
                    this.activatePopupMenu();
                }
            } else if (this.displayStrategyTable) {
                if (ga == 1) {
                    this.strategyTableOffset += 10;
                    if (this.strategyTableOffset > 10) {
                        this.strategyTableOffset = 5;
                    }
                } else if (ga == 6) {
                    this.strategyTableOffset -= 10;
                    if (this.strategyTableOffset < -(this.strategyTableHeight - 320 + 10)) {
                        this.strategyTableOffset = -(this.strategyTableHeight - 320 + 10);
                    }
                }
            } else if (this.displayPopupWindow) {
                if (ga == 6) {
                    if (this.popupWindowOffset < this.popupWindowText.length - this.popupWindowMaxLines) {
                        ++this.popupWindowOffset;
                    }
                } else if (ga == 1 && this.popupWindowOffset > 0) {
                    --this.popupWindowOffset;
                }
            }
            return;
        }
        if (this.mSelectedButton == this.mButtonDown && this.mButtonDown != -1) {
            this.activateButton(this.mButtonDown, false);
            this.mButtonDown = -1;
        }
    }

    public void activateButton(int button, boolean ignoreWarning) {
        if (button == -1) {
            return;
        }
        int action = this.mGame.mStrategyAction;
        int recommendedActionButton = -1;
        if (this.mSurrenderOfferVisible) {
            recommendedActionButton = action == 9 ? 14 : 15;
        } else if (this.mInsuranceOfferVisible) {
            recommendedActionButton = 8;
        } else if (this.mEvenMoneyOfferVisible) {
            recommendedActionButton = 19;
        } else {
            switch (action) {
                case 9: {
                    recommendedActionButton = 14;
                    break;
                }
                case 0: {
                    recommendedActionButton = 0;
                    break;
                }
                case 1: {
                    recommendedActionButton = 1;
                    break;
                }
                case 4: {
                    recommendedActionButton = 3;
                    break;
                }
                case 8: {
                    recommendedActionButton = 2;
                }
            }
        }
        if (this.mTurn == 3 || this.mTurn == 1) {
            if (this.mDisplayPerfectPlayWarning && !ignoreWarning && button != recommendedActionButton) {
                this.mChosenAction = button;
                this.mPerfectPlayVisible = true;
                this.perfectPlaySelectedIndex = 0;
                return;
            }
            if (button != recommendedActionButton) {
                this.mGameStats.takeAction(false);
            } else {
                this.mGameStats.takeAction(true);
            }
        }
        switch (button) {
            case 5: {
                if (!this.mBet.isGreaterThanZero()) break;
                this.deal();
                this.mLastBetChipShown = 5;
                for (int i = 0; i < 5; ++i) {
                    int chip = 4 - i;
                    this.mAnimationQueue.addElement(new AnimatedObject(9, chip, GameRenderer.BUTTONS_BET_X + chip * GameRenderer.BET_BUTTONS_X_SPACING, GameRenderer.BUTTONS_BET_Y, GameRenderer.BUTTONS_BET_X + chip * GameRenderer.BET_BUTTONS_X_SPACING, 355, 6, i * 60));
                }
                this.mPlaceBetsLabelShown = false;
                this.mAnimationQueue.addElement(new AnimatedObject(17, 0, GameRenderer.PLACE_BETS_X, GameRenderer.PLACE_BETS_Y, 240, GameRenderer.PLACE_BETS_Y, 15, 0L));
                this.mChipSelectorVisible = false;
                if (this.mSelectedButton == -1) break;
                this.mSelectedButton = 0;
                break;
            }
            case 6: {
                this.mCash.add(this.mBet);
                this.mBet.set(0, 0);
                if (this.mSelectedButton == -1) break;
                this.mSelectedButton = 9;
                break;
            }
            case 0: {
                if (!this.mGame.canHandHit()) break;
                this.dealSingleCard(3);
                break;
            }
            case 1: {
                this.stand();
                break;
            }
            case 2: {
                if (this.mGame.canHandDouble() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                    this.mCash.subtract(this.mBet);
                    this.mGame.doubleDown();
                    Common.doSound("chips");
                    this.dealSingleCard(3);
                    break;
                }
                Common.displayToast("Insufficient cash to double down");
                break;
            }
            case 3: {
                if (this.mGame.canHandSplit() && this.mCash.isGreaterThanOrEqualTo(this.mBet)) {
                    this.split();
                    break;
                }
                Common.displayToast("Insufficient cash to split hand");
                break;
            }
            case 4: {
                this.clearTable();
                if (this.mSelectedButton == -1) break;
                this.mSelectedButton = 5;
                break;
            }
            case 9: {
                if (this.mCash.isGreaterThanOrEqualTo(1, 0)) {
                    Common.doSound("chips");
                    this.mBet.add(1, 0);
                    this.mCash.subtract(1, 0);
                    this.mAnimationQueue.addElement(new AnimatedObject(10, 0, GameRenderer.mButtonRect[9].left, GameRenderer.mButtonRect[9].top, GameRenderer.PLAYER_BET_X - GameRenderer.CHIP_WIDTH, GameRenderer.PLAYER_BET_Y, 25, 0L));
                    break;
                }
                Common.displayToast("Insufficient cash to place bet");
                break;
            }
            case 10: {
                if (this.mCash.isGreaterThanOrEqualTo(5, 0)) {
                    Common.doSound("chips");
                    this.mBet.add(5, 0);
                    this.mCash.subtract(5, 0);
                    this.mAnimationQueue.addElement(new AnimatedObject(10, 1, GameRenderer.mButtonRect[10].left, GameRenderer.mButtonRect[10].top, GameRenderer.PLAYER_BET_X - GameRenderer.CHIP_WIDTH, GameRenderer.PLAYER_BET_Y, 25, 0L));
                    break;
                }
                Common.displayToast("Insufficient cash to place bet");
                break;
            }
            case 11: {
                if (this.mCash.isGreaterThanOrEqualTo(10, 0)) {
                    Common.doSound("chips");
                    this.mBet.add(10, 0);
                    this.mCash.subtract(10, 0);
                    this.mAnimationQueue.addElement(new AnimatedObject(10, 2, GameRenderer.mButtonRect[11].left, GameRenderer.mButtonRect[11].top, GameRenderer.PLAYER_BET_X - GameRenderer.CHIP_WIDTH, GameRenderer.PLAYER_BET_Y, 25, 0L));
                    break;
                }
                Common.displayToast("Insufficient cash to place bet");
                break;
            }
            case 12: {
                if (this.mCash.isGreaterThanOrEqualTo(25, 0)) {
                    Common.doSound("chips");
                    this.mBet.add(25, 0);
                    this.mCash.subtract(25, 0);
                    this.mAnimationQueue.addElement(new AnimatedObject(10, 3, GameRenderer.mButtonRect[12].left, GameRenderer.mButtonRect[12].top, GameRenderer.PLAYER_BET_X - GameRenderer.CHIP_WIDTH, GameRenderer.PLAYER_BET_Y, 25, 0L));
                    break;
                }
                Common.displayToast("Insufficient cash to place bet");
                break;
            }
            case 13: {
                if (this.mCash.isGreaterThanOrEqualTo(50, 0)) {
                    Common.doSound("chips");
                    this.mBet.add(50, 0);
                    this.mCash.subtract(50, 0);
                    this.mAnimationQueue.addElement(new AnimatedObject(10, 4, GameRenderer.mButtonRect[13].left, GameRenderer.mButtonRect[13].top, GameRenderer.PLAYER_BET_X - GameRenderer.CHIP_WIDTH, GameRenderer.PLAYER_BET_Y, 25, 0L));
                    break;
                }
                Common.displayToast("Insufficient cash to place bet");
                break;
            }
            case 8: {
                this.processInsurance(false);
                break;
            }
            case 7: {
                this.processInsurance(true);
                break;
            }
            case 19: {
                this.processEvenMoney(false);
                break;
            }
            case 18: {
                this.processEvenMoney(true);
                break;
            }
            case 15: {
                this.processSurrender(false);
                break;
            }
            case 14: {
                this.processSurrender(true);
                break;
            }
            case 16: {
                this.moveHands(2);
                break;
            }
            case 17: {
                this.moveHands(5);
            }
        }
    }

    public void processInsurance(boolean takeInsurance) {
        this.mPlayerOfferedInsurance.setElementAt(new Boolean(true), this.mPlayerHand);
        if (takeInsurance) {
            this.mGame.takeInsurance();
            Bet halfBet = new Bet(this.mBet);
            halfBet.divideByTwo();
            this.mCash.subtract(halfBet);
        }
        this.mInsuranceOfferVisible = false;
        if (this.mSelectedButton != -1) {
            this.mSelectedButton = 0;
        }
        if (this.mGame.getPlayerHand().hasBlackjack()) {
            this.stand();
        } else if (Game.ruleDealerPeeksHoleCard) {
            this.mDealerHasPeekedHoleCard = true;
            this.mAnimationQueue.addElement(new AnimatedObject(7, 30, 0L));
            if (this.mGame.getDealerHand().getCard(0).getValue() == 10) {
                this.stand();
            } else {
                this.mTurn = 3;
            }
        } else if (this.mGame.getPlayerHand().canHit()) {
            if (this.mGame.getPlayerHand().getTotal() == 21 && !this.mGame.getPlayerHand().canDoubleDown()) {
                this.stand();
            } else {
                this.mTurn = 3;
            }
        } else {
            this.stand();
        }
    }

    public void processEvenMoney(boolean takeEvenMoney) {
        if (takeEvenMoney) {
            this.mGame.gameTakeEvenMoney();
        }
        this.mEvenMoneyOfferVisible = false;
        if (this.mSelectedButton != -1) {
            this.mSelectedButton = 1;
        }
        this.stand();
    }

    public void processSurrender(boolean surrender) {
        this.mPlayerOfferedSurrender.setElementAt(new Boolean(true), this.mPlayerHand);
        this.mSurrenderOfferVisible = false;
        if (this.mSelectedButton != -1) {
            this.mSelectedButton = 0;
        }
        if (surrender) {
            this.mTurn = 5;
            this.mGame.surrender();
            this.stand();
        } else {
            this.dealtFinalCard();
        }
    }

    public void surrender() {
        this.activateButton(14, false);
    }

    public void clearTable() {
        int y1;
        int x1;
        int i;
        this.mTurn = 6;
        int nCards = this.mGame.getPlayerHand().numCards();
        for (i = 0; i < nCards; ++i) {
            if (i == 0) {
                x1 = GameRenderer.PLAYER_CARD_1_X;
                y1 = GameRenderer.PLAYER_CARD_1_Y;
            } else if (i == 1) {
                x1 = GameRenderer.PLAYER_CARD_2_X;
                y1 = GameRenderer.PLAYER_CARD_2_Y;
            } else {
                x1 = GameRenderer.PLAYER_CARD_2_X + GameRenderer.PLAYER_CARD_X_INCREMENT * (i - 1);
                y1 = GameRenderer.PLAYER_CARD_2_Y + GameRenderer.PLAYER_CARD_Y_INCREMENT * (i - 1);
            }
            this.mAnimationQueue.addElement(new AnimatedObject(11, i, x1, y1, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, 15, (nCards - i) * 100));
        }
        nCards = this.mGame.getDealerHand().numCards();
        for (i = 0; i < this.mGame.getDealerHand().numCards(); ++i) {
            if (i == 0) {
                x1 = GameRenderer.DEALER_CARD_1_X;
                y1 = GameRenderer.DEALER_CARD_1_Y;
            } else if (i == 1) {
                x1 = GameRenderer.DEALER_CARD_2_X;
                y1 = GameRenderer.DEALER_CARD_2_Y;
            } else {
                x1 = GameRenderer.DEALER_CARD_2_X + GameRenderer.PLAYER_CARD_X_INCREMENT * (i - 1);
                y1 = GameRenderer.DEALER_CARD_2_Y + GameRenderer.PLAYER_CARD_Y_INCREMENT * (i - 1);
            }
            this.mAnimationQueue.addElement(new AnimatedObject(12, i, x1, y1, GameRenderer.SHOE_X, GameRenderer.SHOE_Y, 15, 50 + (nCards - i) * 100));
        }
    }

    public void calculateWinnings() {
        for (int hand = 0; hand < this.mPlayerHandsDealt; ++hand) {
            Bet winnings = this.mGame.getPlayerWinnings(hand);
            this.mGameStats.handDealt();
            this.mGameStats.addBet(this.mGame.getPlayerHand(hand).getBet());
            this.mGameStats.addBet(this.mGame.getPlayerHand(hand).getInsuranceBet());
            this.mGameStats.addWinnings(winnings);
            if (this.mGame.getPlayerHand(hand).hasBlackjack()) {
                this.mGameStats.handBlackjack();
            }
            if (winnings.flag == -4) {
                this.mCash.add(this.mGame.getPlayerHand(hand).getBet());
                this.mGameStats.handSurrender();
            } else if (winnings.flag == -2) {
                this.mCash.add(this.mGame.getPlayerHand(hand).getInsuranceBet());
                this.mCash.add(winnings);
                this.mGameStats.addLost(this.mGame.getPlayerHand(hand).getBet());
                this.mGameStats.handLost();
            } else if (winnings.flag == -3) {
                this.mCash.add(this.mGame.getPlayerHand(hand).getBet());
                this.mCash.add(this.mGame.getPlayerHand(hand).getInsuranceBet());
                this.mCash.add(winnings);
                this.mGameStats.handPush();
            } else if (winnings.flag == -1 || winnings.isGreaterThanZero()) {
                this.mCash.add(this.mGame.getPlayerHand(hand).getBet());
                this.mCash.add(winnings);
                if (winnings.flag == -1) {
                    this.mGameStats.handPush();
                } else {
                    this.mGameStats.handWon();
                }
            } else {
                this.mGameStats.addLost(this.mGame.getPlayerHand(hand).getBet());
                this.mGameStats.addLost(this.mGame.getPlayerHand(hand).getInsuranceBet());
                this.mGameStats.handLost();
            }
            this.mWinnings.setElementAt(winnings, hand);
            this._mWinnings.setElementAt(new Bet(0), hand);
        }
    }

    public void calculateHandTotalStrings() {
        String s = "";
        for (int hand = 0; hand < this.mPlayerHandsDealt; ++hand) {
            Hand h = this.mGame.getPlayerHand(hand);
            int cardsDealt = (Integer)this.mPlayerCardsDealt.elementAt(hand);
            if (cardsDealt == 1) {
                s = h.getCard(0).getValue() == 1 ? "1/11" : "" + h.getCard(0).getValue();
            } else {
                int total = this.mGame.getPlayerHand(hand).getTotal();
                int lowtotal = this.mGame.getPlayerHand(hand).getLowestTotal();
                s = h.hasBlackjack() ? "Blackjack!" : (h.isSoft() && total != lowtotal ? lowtotal + "/" + total : "" + total);
            }
            this.mPlayerTotalString.setElementAt(s, hand);
        }
    }

    public void calculateDealerHandTotalStrings() {
        String s = "";
        Hand h = this.mGame.getDealerHand();
        int total = h.getTotal();
        int lowtotal = h.getLowestTotal();
        s = h.hasBlackjack() ? "Blackjack!" : (h.isSoft() && total != lowtotal ? lowtotal + "/" + total : "" + total);
        this.mDealerTotalString = s;
    }

    public void displayStrategyTable() {
        this.strategyTableOffset = 3;
        this.strategyTableScroll = 0;
        this.strategyTableHeight = StrategyAdvisor.mTableBitmap.getHeight() + 40;
        this.displayStrategyTable = true;
    }

    public void saveGameState() {
        try {
            RecordManager.save(this.toByteArray(), "gamestate");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadGameState() {
        try {
            if (RecordManager.exists("gamestate")) {
                byte[] data = RecordManager.load("gamestate");
                this.fromByteArray(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canResume() {
        return this.mCanResume;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            int i;
            int i2;
            int i3;
            os.writeInt(this.mTurn);
            byte[] data = this.mGame.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            data = this.mBet.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            data = this._mBet.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            data = this.mCash.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            data = this._mCash.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            int nWinnings = this.mWinnings.size();
            os.writeInt(nWinnings);
            for (i3 = 0; i3 < nWinnings; ++i3) {
                data = ((Bet)this.mWinnings.elementAt(i3)).toByteArray();
                os.writeInt(data.length);
                os.write(data);
            }
            nWinnings = this._mWinnings.size();
            os.writeInt(nWinnings);
            for (i3 = 0; i3 < nWinnings; ++i3) {
                data = ((Bet)this._mWinnings.elementAt(i3)).toByteArray();
                os.writeInt(data.length);
                os.write(data);
            }
            os.writeInt(this.mDealerCardsDealt);
            int nCards = this.mPlayerCardsDealt.size();
            os.writeInt(nCards);
            for (int i4 = 0; i4 < nCards; ++i4) {
                os.writeInt((Integer)this.mPlayerCardsDealt.elementAt(i4));
            }
            int nHands = this.mPlayerOfferedInsurance.size();
            os.writeInt(nHands);
            for (i2 = 0; i2 < nHands; ++i2) {
                os.writeBoolean((Boolean)this.mPlayerOfferedInsurance.elementAt(i2));
            }
            nHands = this.mPlayerOfferedSurrender.size();
            os.writeInt(nHands);
            for (i2 = 0; i2 < nHands; ++i2) {
                os.writeBoolean((Boolean)this.mPlayerOfferedSurrender.elementAt(i2));
            }
            os.writeInt(this.mPlayerHand);
            os.writeInt(this.mPlayerHandsDealt);
            int nStrings = this.mPlayerTotalString.size();
            os.writeInt(nStrings);
            for (i = 0; i < nStrings; ++i) {
                os.writeUTF((String)this.mPlayerTotalString.elementAt(i));
            }
            os.writeInt(this.mTurnCardFrame);
            os.writeBoolean(this.mChipSelectorVisible);
            os.writeBoolean(this.mInsuranceOfferVisible);
            os.writeBoolean(this.mEvenMoneyOfferVisible);
            os.writeBoolean(this.mDealerHasPeekedHoleCard);
            os.writeBoolean(this.mSurrenderOfferVisible);
            os.writeBoolean(this.displayStrategyTable);
            os.writeInt(this.mSelectedButton);
            os.writeInt(this.mLastBetChipShown);
            os.writeBoolean(this.mPlaceBetsLabelShown);
            os.writeUTF(this.mDealerTotalString);
            os.writeInt(this.mAnimationQueue.size());
            for (i = 0; i < this.mAnimationQueue.size(); ++i) {
                AnimatedObject ao = (AnimatedObject)this.mAnimationQueue.elementAt(i);
                byte[] aoData = ao.toByteArray();
                os.writeInt(aoData.length);
                os.write(aoData);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int i;
            int i2;
            this.mTurn = is.readInt();
            int bufferSize = is.readInt();
            byte[] buffer = new byte[bufferSize];
            is.read(buffer);
            this.mGame = new Game(buffer);
            bufferSize = is.readInt();
            buffer = new byte[bufferSize];
            is.read(buffer);
            this.mBet = new Bet(buffer);
            bufferSize = is.readInt();
            buffer = new byte[bufferSize];
            is.read(buffer);
            this._mBet = new Bet(buffer);
            bufferSize = is.readInt();
            buffer = new byte[bufferSize];
            is.read(buffer);
            this.mCash = new Bet(buffer);
            bufferSize = is.readInt();
            buffer = new byte[bufferSize];
            is.read(buffer);
            this._mCash = new Bet(buffer);
            this.mWinnings = new Vector();
            int nWinnings = is.readInt();
            for (i2 = 0; i2 < nWinnings; ++i2) {
                bufferSize = is.readInt();
                buffer = new byte[bufferSize];
                is.read(buffer);
                this.mWinnings.addElement(new Bet(buffer));
            }
            this._mWinnings = new Vector();
            nWinnings = is.readInt();
            for (i2 = 0; i2 < nWinnings; ++i2) {
                bufferSize = is.readInt();
                buffer = new byte[bufferSize];
                is.read(buffer);
                this._mWinnings.addElement(new Bet(buffer));
            }
            this.mDealerCardsDealt = is.readInt();
            int nCards = is.readInt();
            this.mPlayerCardsDealt = new Vector();
            for (int i3 = 0; i3 < nCards; ++i3) {
                this.mPlayerCardsDealt.addElement(new Integer(is.readInt()));
            }
            int nHands = is.readInt();
            this.mPlayerOfferedInsurance = new Vector();
            for (i = 0; i < nHands; ++i) {
                this.mPlayerOfferedInsurance.addElement(new Boolean(is.readBoolean()));
            }
            nHands = is.readInt();
            this.mPlayerOfferedSurrender = new Vector();
            for (i = 0; i < nHands; ++i) {
                this.mPlayerOfferedSurrender.addElement(new Boolean(is.readBoolean()));
            }
            this.mPlayerHand = is.readInt();
            this.mPlayerHandsDealt = is.readInt();
            int nStrings = is.readInt();
            this.mPlayerTotalString = new Vector();
            for (int i4 = 0; i4 < nStrings; ++i4) {
                this.mPlayerTotalString.addElement(is.readUTF());
            }
            this.mTurnCardFrame = is.readInt();
            this.mChipSelectorVisible = is.readBoolean();
            this.mInsuranceOfferVisible = is.readBoolean();
            this.mEvenMoneyOfferVisible = is.readBoolean();
            this.mDealerHasPeekedHoleCard = is.readBoolean();
            this.mSurrenderOfferVisible = is.readBoolean();
            this.displayStrategyTable = is.readBoolean();
            this.mSelectedButton = is.readInt();
            this.mLastBetChipShown = is.readInt();
            this.mPlaceBetsLabelShown = is.readBoolean();
            this.mDealerTotalString = is.readUTF();
            int queueSize = is.readInt();
            this.mAnimationQueue = new Vector();
            for (int i5 = 0; i5 < queueSize; ++i5) {
                int dataLen = is.readInt();
                byte[] aoData = new byte[dataLen];
                is.read(aoData);
                AnimatedObject ao = new AnimatedObject(aoData);
                this.mAnimationQueue.addElement(ao);
            }
            this.mCanResume = this.mTurn != 0 || this.mChipSelectorVisible || this.mAnimationQueue.size() != 0;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public String formatTimeString(long t) {
        long hours = t / 3600000L;
        long mins = (t -= hours * 3600000L) / 60000L;
        long secs = (t -= mins * 60000L) / 1000L;
        return hours + "h " + mins + "m " + secs + "s";
    }

    public String formatDateString(long t) {
        Date d = new Date(t);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        String am_pm = "";
        if (c.get(9) == 0) {
            am_pm = "am";
        } else if (c.get(9) == 1) {
            am_pm = "pm";
        }
        return c.get(5) + " " + MONTHS[c.get(2)] + " " + c.get(1) + " " + c.get(10) + ":" + this.pad(c.get(12)) + am_pm;
    }

    public String pad(int i) {
        if (i < 10) {
            return "0" + Integer.toString(i);
        }
        return Integer.toString(i);
    }

    public void setSound(boolean s) {
        this.mSoundEnabled = s;
    }

    public void setCurrency(int c) {
        this.mCurrency = c;
        this.mCurrencyStr = this.mCurrency == 0 ? "$" : (this.mCurrency == 1 ? "\u00a3" : "#");
        this.mGameStats.setCurrencyString(this.mCurrencyStr);
    }

    public void setStartingCash(int cash) {
        int[] cashValues = new int[]{100, 250, 500, 1000, 2500, 5000, 10000};
        this.mStartingCash = cashValues[cash];
    }

    public void setHint(boolean v) {
        this.mDisplayHintStar = v;
    }

    public void setPerfectPlayWarning(boolean v) {
        this.mDisplayPerfectPlayWarning = v;
        this.mPerfectPlayVisible = false;
    }

    public void setGameStats(GameStats stats) {
        this.mGameStats = stats;
    }

    public boolean isInLandscapeMode() {
        return this.mLandscape;
    }

    public boolean canSurrender() {
        if (this.mTurn == 3 || this.mTurn == 1) {
            if (this.mGame.getPlayerHand().canSurrender()) {
                System.out.println("CAN SURRENDER rule=" + Game.ruleSurrender + " (" + this.mDealerHasPeekedHoleCard + ")");
                if (this.mTurn == 3) {
                    if (Game.ruleSurrender == 1) {
                        return true;
                    }
                    if (Game.ruleSurrender == 2) {
                        return !Game.ruleDealerPeeksHoleCard || Game.ruleDealerPeeksHoleCard && this.mDealerHasPeekedHoleCard;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public String getRecommendedActionString() {
        return StrategyAdvisor.ACTIONS[this.mGame.mStrategyAction];
    }

    public int getRecommendedAction() {
        return this.mGame.mStrategyAction;
    }

    public boolean canDisplayHint() {
        return this.mTurn == 1 || this.mTurn == 3;
    }

    public boolean hasSoftHand() {
        return this.mGame.getPlayerHand().isSoft();
    }

    public boolean isFirstCardAceOrEight() {
        return this.mGame.getPlayerHand().getCard(0).getValue() == 1 || this.mGame.getPlayerHand().getCard(0).getValue() == 8;
    }

    public int getTotal() {
        return this.mGame.getPlayerHand().getTotal();
    }

    public int getRemainingCards() {
        return this.mGame.getRemainingDeckCards();
    }

    public boolean isOfferingInsurance() {
        return this.mInsuranceOfferVisible;
    }

    public boolean isOfferingEarlySurrender() {
        return this.mSurrenderOfferVisible;
    }

    public boolean isOfferingEvenMoney() {
        return this.mEvenMoneyOfferVisible;
    }
}

