/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.CasinoPack;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.ImageFontRenderer;
import net.handyx.casinopack.common.RunnableCanvas;

public class GameSelector
extends RunnableCanvas {
    public static final int DISPLAY_SPLASH = 0;
    public static final int DISPLAY_SELECT_GAME_1 = 1;
    public static final int DISPLAY_SELECT_GAME_2 = 2;
    public static final int DISPLAY_SELECT_GAME_3 = 3;
    private int displayState = 0;
    private boolean flash = false;
    private int flashCounter = 0;
    private CasinoPack parent = null;
    private Image splashImage;
    private Image selectorOnImage;
    private Image selectorOffImage;
    private ImageFontRenderer largeFont;
    int f = 0;
    long startTime = 0L;

    public GameSelector(CasinoPack p) {
        this.parent = p;
        this.displayState = 0;
    }

    public void loadResources() {
        this.splashImage = GameSelector.loadImage("/splash.jpg");
        this.selectorOnImage = GameSelector.loadImage("/selector_on.jpg");
        this.selectorOffImage = GameSelector.loadImage("/selector_off.jpg");
        this.largeFont = new ImageFontRenderer("/fonts/komik");
    }

    public void purgeResources() {
        this.selectorOffImage = null;
        this.selectorOnImage = null;
        this.splashImage = null;
        if (this.largeFont != null) {
            this.largeFont.purge();
            this.largeFont = null;
        }
        System.gc();
    }

    public void processFrame(int fn) {
        ++this.flashCounter;
        if (this.flashCounter >= 8) {
            this.flash = false;
            if (this.flashCounter == 11) {
                this.flashCounter = 0;
            }
        } else {
            this.flash = true;
        }
    }

    public void paintCanvas(Graphics gfx, int sw, int sh) {
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        sw = g.getWidth();
        sh = g.getHeight();
        g.setColor(0);
        g.fillRect(0, 0, sw, sh);
        Font f = Font.getFont((int)0, (int)0, (int)8);
        g.setFont(f);
        g.setColor(0xFFFFFF);
        g.drawString("Loading, please wait ...", sw - f.stringWidth("Loading, please wait ...") >> 1, sh - f.getHeight() >> 1, 20);
        int selectX = sw - g.unscale(this.selectorOffImage.getWidth()) >> 1;
        int selectY = sh - g.unscale(this.selectorOnImage.getHeight()) >> 1;
        if (this.displayState == 0) {
            if (this.splashImage != null) {
                g.drawImage(this.splashImage, selectX, selectY, 20);
            }
            if (this.largeFont != null) {
                this.largeFont.drawString(g, "HandyX Ltd.", 1 + (sw - this.largeFont.stringWidth("HandyX Ltd.") >> 1), sh - this.largeFont.getHeight() - 5 + 1);
            }
            if (this.largeFont != null) {
                this.largeFont.drawString(g, "HandyX Ltd.", sw - this.largeFont.stringWidth("HandyX Ltd.") >> 1, sh - this.largeFont.getHeight() - 5);
            }
        } else {
            if (this.selectorOffImage != null) {
                g.drawImage(this.selectorOffImage, selectX, selectY, 20);
            }
            int h = g.unscale(this.selectorOffImage.getHeight()) / 3;
            if (this.displayState == 1) {
                g.setClip(selectX, selectY, sw, h);
            } else if (this.displayState == 2) {
                g.setClip(selectX, selectY + h, sw, h);
            } else if (this.displayState == 3) {
                g.setClip(selectX, selectY + h * 2, sw, h);
            }
            if (this.flash && this.selectorOnImage != null) {
                g.drawImage(this.selectorOnImage, selectX, selectY, 20);
            }
            g.setClip(0, 0, sw, sh);
            if (this.largeFont != null) {
                GameSelector.drawLeftCommand(g, "Start Game", this.largeFont);
            }
            if (this.largeFont != null) {
                GameSelector.drawRightCommand(g, "Exit", this.largeFont);
            }
        }
    }

    public void skipSplash() {
        this.displayState = 1;
    }

    public void keyPressedEvent(int keyCode, int ga, int sk) {
        if (this.displayState == 0) {
            this.displayState = 1;
            return;
        }
        if (sk == 1 || ga == 8) {
            this.parent.startGame(this.displayState);
        } else if (sk == 2) {
            this.parent.exitApplication();
        } else if (ga == 1) {
            if (this.displayState == 3) {
                this.displayState = 2;
            } else if (this.displayState == 2) {
                this.displayState = 1;
            } else if (this.displayState == 1) {
                this.displayState = 3;
            }
        } else if (ga == 6) {
            if (this.displayState == 3) {
                this.displayState = 1;
            } else if (this.displayState == 2) {
                this.displayState = 3;
            } else if (this.displayState == 1) {
                this.displayState = 2;
            }
        }
    }
}

