/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import net.handyx.casinopack.GameSelector;
import net.handyx.casinopack.blackjack.Blackjack;
import net.handyx.casinopack.common.GMG;
import net.handyx.casinopack.common.KickStart;
import net.handyx.casinopack.common.LoadingScreen;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.common.RunnableCanvas;
import net.handyx.casinopack.common.Settings;
import net.handyx.casinopack.slots.Slots;
import net.handyx.casinopack.videopoker.VideoPoker;

public class CasinoPack
extends MIDlet
implements Runnable {
    private static final int SELECTOR_NOSPLASH = -1;
    private static final int SELECTOR = 0;
    private static final int BLACKJACK = 1;
    private static final int VIDEOPOKER = 2;
    private static final int SLOTS = 3;
    private int loadingStage = 0;
    private boolean initialised = false;
    private Display display = null;
    private KickStart kickStart = null;
    private LoadingScreen loadingScreen = null;
    private Slots slotsApp = null;
    private VideoPoker videoPokerApp = null;
    private Blackjack blackjackApp = null;
    private GameSelector selectorCanvas = null;

    public void startApp() {
        if (!this.initialised) {
            this.display = Display.getDisplay((MIDlet)this);
            this.kickStart = new KickStart(this.display);
            this.kickStart.start();
            RunnableCanvas.getJadParameters(this);
            GMG.getJadParameters(this);
            Settings.getJadParameters(this);
            this.loadingScreen = new LoadingScreen();
            this.doLoadingStage(0);
            this.initialised = true;
        }
    }

    public void pauseApp() {
    }

    public void run() {
        try {
            if (this.loadingStage == 0 || this.loadingStage == -1) {
                RunnableCanvas.loadTouchpadResources();
                if (this.videoPokerApp != null) {
                    this.videoPokerApp.purgeResources();
                    this.videoPokerApp = null;
                }
                if (this.slotsApp != null) {
                    this.slotsApp.purgeResources();
                    this.slotsApp = null;
                }
                if (this.blackjackApp != null) {
                    this.blackjackApp.purgeResources();
                    this.blackjackApp = null;
                }
                this.selectorCanvas = new GameSelector(this);
                this.selectorCanvas.loadResources();
                if (this.loadingStage == -1) {
                    this.selectorCanvas.skipSplash();
                }
                this.display.setCurrent((Displayable)this.selectorCanvas);
            } else if (this.loadingStage == 2) {
                this.selectorCanvas.purgeResources();
                RecordManager.setPrefix("vp");
                this.videoPokerApp = new VideoPoker(this);
            } else if (this.loadingStage == 3) {
                this.selectorCanvas.purgeResources();
                RecordManager.setPrefix("slots");
                this.slotsApp = new Slots(this);
            } else if (this.loadingStage == 1) {
                this.selectorCanvas.purgeResources();
                RecordManager.setPrefix("bj");
                this.blackjackApp = new Blackjack(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doLoadingStage(int stage) {
        this.display.setCurrent((Displayable)this.loadingScreen);
        this.loadingStage = stage;
        Thread t = new Thread(this);
        t.start();
    }

    public void startGame(int game) {
        System.out.println("Starting game " + game);
        if (game == 2) {
            this.doLoadingStage(2);
        } else if (game == 3) {
            this.doLoadingStage(3);
        } else if (game == 1) {
            this.doLoadingStage(1);
        }
    }

    public void displaySelector() {
        this.doLoadingStage(-1);
    }

    public void exitApplication() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean unconditional) {
        if (this.kickStart != null) {
            this.kickStart.terminate();
            this.kickStart = null;
        }
    }
}

