/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NumericFontRenderer {
    private int[] characterWidths;
    private int[] characterOffsets;
    private Image fontImage;
    private int fontHeight;
    private int fontSpacing = 1;

    public NumericFontRenderer(String res) {
        this.loadFont(res + ".png", res + ".dat");
    }

    private void loadFont(String res, String dat) {
        try {
            this.fontImage = Image.createImage((String)res);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fontHeight = this.fontImage.getHeight();
        Vector data = NumericFontRenderer.splitString(",", this.loadTextResource(dat));
        this.characterWidths = new int[data.size()];
        this.characterOffsets = new int[this.characterWidths.length];
        Enumeration e = data.elements();
        int i = 0;
        int offset = 0;
        while (e.hasMoreElements()) {
            this.characterWidths[i] = Integer.parseInt((String)e.nextElement());
            this.characterOffsets[i] = offset;
            offset += this.characterWidths[i++] + 1;
        }
        data = null;
        System.gc();
    }

    public void purge() {
        this.characterWidths = null;
        this.characterOffsets = null;
        this.fontImage = null;
        System.gc();
    }

    public void drawString(Graphics g, String s, int x, int y) {
        int prevClipX = g.getClipX();
        int prevClipY = g.getClipY();
        int prevClipW = g.getClipWidth();
        int prevClipH = g.getClipHeight();
        int width = 0;
        char[] chars = s.toCharArray();
        for (int c = 0; c < chars.length; ++c) {
            int offset = chars[c];
            boolean displayChar = true;
            if (offset >= 48 && offset <= 57) {
                offset -= 48;
            } else if (chars[c] == ':') {
                offset = 10;
            } else if (chars[c] == '.') {
                offset = 11;
            } else if (chars[c] == '\"') {
                offset = 12;
            } else if (chars[c] == '\'') {
                offset = 13;
            } else {
                displayChar = false;
            }
            if (!displayChar) continue;
            g.setClip(x + width, y, this.characterWidths[offset], this.fontHeight);
            g.drawImage(this.fontImage, x - this.characterOffsets[offset] + width, y, 20);
            width += this.characterWidths[offset] + this.fontSpacing;
        }
        g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
    }

    public void drawInt(Graphics g, int n, int x, int y) {
        this.drawString(g, Integer.toString(n), x, y);
    }

    public int stringWidth(int n) {
        return this.stringWidth(Integer.toString(n));
    }

    public int stringWidth(String s) {
        int width = 0;
        char[] chars = s.toCharArray();
        for (int c = 0; c < chars.length; ++c) {
            int offset = chars[c];
            boolean includeChar = true;
            if (offset >= 48 && offset <= 57) {
                offset -= 48;
            } else if (chars[c] == ':') {
                offset = 10;
            } else if (chars[c] == '.') {
                offset = 11;
            } else if (chars[c] == '\"') {
                offset = 12;
            } else if (chars[c] == '\'') {
                offset = 13;
            } else {
                includeChar = false;
            }
            if (!includeChar) continue;
            width += this.characterWidths[offset] + this.fontSpacing;
        }
        return width;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    private String loadTextResource(String res) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = this.getClass().getResourceAsStream(res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString().trim();
    }

    private static Vector splitString(String c, String text) {
        Vector<String> lines = new Vector<String>();
        int length = text.trim().length();
        for (int i = 0; i < length; ++i) {
            int num = text.indexOf(c);
            if (num < 0) {
                lines.addElement(text);
                break;
            }
            lines.addElement(text.substring(0, num));
            text = text.substring(num + c.length(), text.length());
        }
        return lines;
    }
}

