/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack.game;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import net.handyx.casinopack.blackjack.game.Bet;
import net.handyx.casinopack.blackjack.game.Card;
import net.handyx.casinopack.blackjack.game.Deck;
import net.handyx.casinopack.blackjack.game.Hand;
import net.handyx.casinopack.blackjack.game.StrategyAdvisor;

public class Game {
    public static final int STAND = 0;
    public static final int HIT = 1;
    public static final int DOUBLE = 2;
    public static final int SPLIT = 3;
    public static final String[] ACTIONS = new String[]{"Stand", "Hit", "Double Down", "Split"};
    public static boolean ruleDealerHitsSoft17 = true;
    public static int ruleDoubleDown = 0;
    public static int ruleDealerInsurance = 2;
    public static boolean ruleDealerPeeksHoleCard = true;
    public static boolean ruleSplitCardsMustHaveSameRank = false;
    public static boolean ruleNo45TenSplits = false;
    public static boolean ruleHitSplitAces = false;
    public static boolean ruleResplitAces = true;
    public static boolean ruleDoubleOnSplit = true;
    public static int ruleMaxSplitHands = 2;
    public static boolean ruleSplitAces = true;
    public static int ruleSurrender = 0;
    public static int ruleShuffle = 1;
    public static int ruleNumDecks = 5;
    public static String ruleDescription = "";
    public static boolean debug_SplitAnyCards = false;
    public static boolean debug_PlayerGetsBlackjack = false;
    public static boolean debug_PlayerGets2Aces = false;
    public static boolean debug_DealerGetsBlackjack = false;
    public static boolean debug_useDebugPlayerCards = false;
    public static int debug_numDealtPlayerCards = 0;
    public static Card[] debug_playerCards = new Card[]{new Card(9, 3), new Card(2, 0), new Card(10, 2), new Card(10, 2)};
    public static boolean debug_useDebugDealerCards = false;
    public static int debug_numDealtDealerCards = 0;
    public static Card[] debug_dealerCards = new Card[]{new Card(5, 2), new Card(12, 1)};
    private Deck deck = null;
    private Hand mDealerHand;
    private Hand mPlayerHand;
    private Vector mPlayerHands = new Vector();
    private int mCurrentHand = 0;
    public int mStrategyAction = -1;
    public int[] mStrategyActionPosition = new int[]{-1, -1};
    public static final int INSURANCE_WINS = -2;
    public static final int PUSH_WINS = -1;
    public static final int EVEN_MONEY_WINS = -3;
    public static final int SURRENDER = -4;

    public Game() {
        this.deck = new Deck(2);
        this.deck.shuffle();
        this.mPlayerHands = new Vector();
    }

    public Game(byte[] data) {
        this.fromByteArray(data);
        StrategyAdvisor.generateTable();
        System.out.println(StrategyAdvisor.tableToString());
    }

    public void setDecks(int numDecks) {
        ruleNumDecks = numDecks;
        this.deck = new Deck(numDecks);
    }

    public void resetGame() {
        this.deck.collectAndReset();
        this.deck.shuffle();
        this.newGame();
    }

    public void newGame() {
        this.mPlayerHands.removeAllElements();
        this.mDealerHand = null;
        this.mPlayerHand = null;
    }

    public void applySettings(int numDecks, boolean ruleDealerHitsSoft17, int ruleDoubleDown, int ruleDealerInsurance, boolean ruleDealerPeeksHoleCard, boolean ruleSplitCardsMustHaveSameRank, boolean ruleNo45TenSplits, boolean ruleHitSplitAces, boolean ruleResplitAces, boolean ruleDoubleOnSplit, int ruleMaxSplitHands, boolean ruleSplitAces, int ruleSurrender, int ruleShuffle) {
        ruleNumDecks = numDecks + 1;
        this.deck = new Deck(ruleNumDecks);
        this.deck.shuffle();
        Game.ruleDealerHitsSoft17 = ruleDealerHitsSoft17;
        Game.ruleDoubleDown = ruleDoubleDown;
        Game.ruleDealerInsurance = ruleDealerInsurance;
        Game.ruleDealerPeeksHoleCard = ruleDealerPeeksHoleCard;
        Game.ruleSplitCardsMustHaveSameRank = ruleSplitCardsMustHaveSameRank;
        Game.ruleNo45TenSplits = ruleNo45TenSplits;
        Game.ruleHitSplitAces = ruleHitSplitAces;
        Game.ruleResplitAces = ruleResplitAces;
        Game.ruleDoubleOnSplit = ruleDoubleOnSplit;
        Game.ruleMaxSplitHands = ruleMaxSplitHands;
        Game.ruleSplitAces = ruleSplitAces;
        Game.ruleSurrender = ruleSurrender;
        Game.ruleShuffle = ruleShuffle;
        ruleDescription = "";
        ruleDescription = ruleNumDecks == 1 ? ruleDescription + ruleNumDecks + " deck, " : ruleDescription + ruleNumDecks + " decks, ";
        ruleDescription = Game.ruleDealerHitsSoft17 ? ruleDescription + "dealer hits soft 17, " : ruleDescription + "dealer stands on soft 17, ";
        if (Game.ruleDoubleDown == 0) {
            ruleDescription = ruleDescription + "double on any 2 cards, ";
        } else if (Game.ruleDoubleDown == 1) {
            ruleDescription = ruleDescription + "double on 9,10 only, ";
        } else if (Game.ruleDoubleDown == 2) {
            ruleDescription = ruleDescription + "double on 9,10,11 only, ";
        }
        ruleDescription = !Game.ruleDealerPeeksHoleCard ? ruleDescription + "dealer does not peek, " : ruleDescription + "dealer peeks, ";
        ruleDescription = !Game.ruleDoubleOnSplit ? ruleDescription + "no double on split, " : ruleDescription + "double on split is allowed, ";
        ruleDescription = !Game.ruleSplitAces ? ruleDescription + "no splitting of aces, " : ruleDescription + "splitting aces allowed, ";
        ruleDescription = !Game.ruleResplitAces ? ruleDescription + "no re-splitting of aces, " : ruleDescription + "re-splitting aces allowed, ";
        ruleDescription = !Game.ruleHitSplitAces ? ruleDescription + "no hitting on split aces, " : ruleDescription + "hitting on split aces allowed, ";
        if (Game.ruleSurrender == 0) {
            ruleDescription = ruleDescription + "no surrender";
        } else if (Game.ruleSurrender == 1) {
            ruleDescription = ruleDescription + "early surrender";
        } else if (Game.ruleSurrender == 2) {
            ruleDescription = ruleDescription + "late surrender";
        }
        if (Game.ruleMaxSplitHands > 0) {
            ruleDescription = ruleDescription + ", max " + (Game.ruleMaxSplitHands + 1) + " split hands on table";
        }
        StrategyAdvisor.generateTable();
        StrategyAdvisor.generateTableImage();
        System.out.println(StrategyAdvisor.tableToString());
    }

    public void deal(Bet playerBet, Bet playerCash) {
        if (ruleShuffle == 1) {
            this.deck.collectAndReset();
        } else {
            this.deck.collect();
        }
        this.mDealerHand = new Hand(new Bet(0), false);
        Hand playerHand = new Hand(playerBet, false);
        if (debug_PlayerGetsBlackjack) {
            playerHand.addCard(new Card(1, 32));
            playerHand.addCard(new Card(10, 32));
        } else if (debug_PlayerGets2Aces) {
            playerHand.addCard(new Card(1, 32));
            playerHand.addCard(new Card(1, 256));
        } else if (debug_useDebugPlayerCards) {
            playerHand.addCard(debug_playerCards[0]);
            playerHand.addCard(debug_playerCards[1]);
            debug_numDealtPlayerCards = 2;
        } else {
            playerHand.addCard(this.deck.dealNextCard());
            playerHand.addCard(this.deck.dealNextCard());
        }
        if (debug_DealerGetsBlackjack) {
            this.mDealerHand.addCard(new Card(10, 256));
            this.mDealerHand.addCard(new Card(1, 256));
        } else if (debug_useDebugDealerCards) {
            this.mDealerHand.addCard(debug_dealerCards[0]);
            this.mDealerHand.addCard(debug_dealerCards[1]);
            debug_numDealtDealerCards = 2;
        } else {
            this.mDealerHand.addCard(this.deck.dealNextCard());
            this.mDealerHand.addCard(this.deck.dealNextCard());
        }
        this.mCurrentHand = 0;
        this.mPlayerHands.addElement(playerHand);
        this.mPlayerHand = (Hand)this.mPlayerHands.elementAt(this.mCurrentHand);
        this.mStrategyAction = StrategyAdvisor.getSuggestedAction(this, this.mPlayerHand, this.mStrategyActionPosition, playerCash);
        System.out.println(StrategyAdvisor.ACTIONS[this.mStrategyAction] + " (" + this.mStrategyActionPosition[0] + "," + this.mStrategyActionPosition[1] + ")");
    }

    public void hit(Bet playerCash) {
        if (debug_useDebugPlayerCards && debug_numDealtPlayerCards < debug_playerCards.length) {
            this.mPlayerHand.addCard(debug_playerCards[debug_numDealtPlayerCards]);
            ++debug_numDealtPlayerCards;
        } else {
            this.mPlayerHand.addCard(this.deck.dealNextCard());
        }
        this.mStrategyAction = StrategyAdvisor.getSuggestedAction(this, this.mPlayerHand, this.mStrategyActionPosition, playerCash);
        System.out.println(StrategyAdvisor.ACTIONS[this.mStrategyAction]);
    }

    public void hitDealer() {
        if (debug_useDebugDealerCards && debug_numDealtDealerCards < debug_dealerCards.length) {
            this.mDealerHand.addCard(debug_dealerCards[debug_numDealtDealerCards]);
            ++debug_numDealtDealerCards;
        } else {
            this.mDealerHand.addCard(this.deck.dealNextCard());
        }
    }

    public void doubleDown() {
        if (this.mPlayerHand.canDoubleDown()) {
            this.mPlayerHand.doubleDown();
        }
    }

    public void split(Bet playerBet, Bet playerCash) {
        Hand splitHand = new Hand(playerBet, true);
        splitHand.addCard(this.mPlayerHand.getCard(1));
        if (debug_useDebugPlayerCards && debug_numDealtPlayerCards < debug_playerCards.length) {
            splitHand.addCard(debug_playerCards[debug_numDealtPlayerCards]);
            ++debug_numDealtPlayerCards;
        } else {
            splitHand.addCard(this.deck.dealNextCard());
        }
        this.mPlayerHand.removeCard(1);
        if (debug_useDebugPlayerCards && debug_numDealtPlayerCards < debug_playerCards.length) {
            this.mPlayerHand.addCard(debug_playerCards[debug_numDealtPlayerCards]);
            ++debug_numDealtPlayerCards;
        } else {
            this.mPlayerHand.addCard(this.deck.dealNextCard());
        }
        this.mPlayerHand.setIsSplit(true);
        ++this.mCurrentHand;
        this.mPlayerHands.insertElementAt(splitHand, this.mCurrentHand);
        this.mPlayerHand = (Hand)this.mPlayerHands.elementAt(this.mCurrentHand);
        this.mStrategyAction = StrategyAdvisor.getSuggestedAction(this, this.mPlayerHand, this.mStrategyActionPosition, playerCash);
        System.out.println(StrategyAdvisor.ACTIONS[this.mStrategyAction] + " (" + this.mStrategyActionPosition[0] + "," + this.mStrategyActionPosition[1] + ")");
    }

    public void takeInsurance() {
        this.mPlayerHand.takeInsurance();
    }

    public void gameTakeEvenMoney() {
        this.mPlayerHand.handTakeEvenMoney();
    }

    public void surrender() {
        this.mPlayerHand.surrender();
    }

    public Hand getPlayerHand(int hand) {
        try {
            return (Hand)this.mPlayerHands.elementAt(hand);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Hand getPlayerHand() {
        return this.mPlayerHand;
    }

    public void selectHand(int h, Bet playerCash) {
        this.mCurrentHand = h;
        this.mPlayerHand = (Hand)this.mPlayerHands.elementAt(this.mCurrentHand);
        this.mStrategyAction = StrategyAdvisor.getSuggestedAction(this, this.mPlayerHand, this.mStrategyActionPosition, playerCash);
        System.out.println(StrategyAdvisor.ACTIONS[this.mStrategyAction] + " (" + this.mStrategyActionPosition[0] + "," + this.mStrategyActionPosition[1] + ")");
    }

    public Hand getDealerHand() {
        return this.mDealerHand;
    }

    public boolean dealerNeedsMoreCards() {
        if (this.mDealerHand.hasBlackjack() || this.mPlayerHand.hasBlackjack()) {
            return false;
        }
        if (this.mDealerHand.getTotal() < 17 || this.mDealerHand.getTotal() == 17 && this.mDealerHand.isSoft() && ruleDealerHitsSoft17) {
            boolean dealToDealer = false;
            for (int hand = 0; hand < this.mPlayerHands.size(); ++hand) {
                if (((Hand)this.mPlayerHands.elementAt(hand)).hasBust() || ((Hand)this.mPlayerHands.elementAt(hand)).hasSurrendered()) continue;
                dealToDealer = true;
                break;
            }
            return dealToDealer;
        }
        return false;
    }

    public boolean canHandHit() {
        return this.canHandHit(this.mCurrentHand);
    }

    public boolean canHandHit(int h) {
        return ((Hand)this.mPlayerHands.elementAt(h)).canHit();
    }

    public boolean canHandSplit() {
        return this.canHandSplit(this.mCurrentHand);
    }

    public boolean canHandSplit(int h) {
        if (ruleMaxSplitHands != 0 && this.mPlayerHands.size() == ruleMaxSplitHands + 1) {
            return false;
        }
        return ((Hand)this.mPlayerHands.elementAt(h)).canSplit();
    }

    public boolean canHandDouble() {
        return this.canHandDouble(this.mCurrentHand);
    }

    public boolean canHandDouble(int h) {
        return ((Hand)this.mPlayerHands.elementAt(h)).canDoubleDown();
    }

    public int numHandsInPlay() {
        return this.mPlayerHands.size();
    }

    public Bet getPlayerWinnings(int hand) {
        Bet total = new Bet(0);
        Hand playerHand = (Hand)this.mPlayerHands.elementAt(hand);
        boolean dealerHasBlackjack = this.mDealerHand.hasBlackjack();
        int dealerTotal = this.mDealerHand.getTotal();
        boolean playerHasBlackjack = playerHand.hasBlackjack();
        int playerTotal = playerHand.getTotal();
        if (playerHand.hasSurrendered()) {
            total.setFlag(-4);
        } else if (playerHand.hasTakenEvenMoney()) {
            total.setFlag(-3);
            total.set(playerHand.getBet());
        } else if (dealerHasBlackjack && !playerHasBlackjack) {
            if (playerHand.hasTakenInsurance()) {
                total.setFlag(-2);
                total.set(playerHand.getInsuranceBet());
                total.multiplyByTwo();
            }
        } else if (playerHasBlackjack && !dealerHasBlackjack) {
            total.set(playerHand.getBet());
            total.divideByTwo();
            total.add(playerHand.getBet());
        } else if (playerHasBlackjack && dealerHasBlackjack) {
            if (playerHand.hasTakenInsurance()) {
                total.setFlag(-3);
                total.set(playerHand.getInsuranceBet());
                total.multiplyByTwo();
            } else {
                total.setFlag(-1);
            }
        } else if (!(playerTotal > 21 && dealerTotal <= 21 || playerTotal < 21 && dealerTotal <= 21 && dealerTotal > playerTotal)) {
            if (playerTotal <= 21 && dealerTotal > 21 || playerTotal <= 21 && dealerTotal < 21 && dealerTotal < playerTotal) {
                total.set(playerHand.getBet());
            } else {
                total.setFlag(-1);
            }
        }
        return total;
    }

    public int getRemainingDeckCards() {
        return this.deck.getRemainingCards();
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            byte[] data = this.deck.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            if (this.mDealerHand == null) {
                os.writeInt(-1);
            } else {
                data = this.mDealerHand.toByteArray();
                os.writeInt(data.length);
                os.write(data);
            }
            os.writeInt(this.mCurrentHand);
            int nHands = this.mPlayerHands.size();
            os.writeInt(nHands);
            for (int i = 0; i < nHands; ++i) {
                data = ((Hand)this.mPlayerHands.elementAt(i)).toByteArray();
                os.writeInt(data.length);
                os.write(data);
            }
            os.writeInt(this.mStrategyAction);
            os.writeInt(this.mStrategyActionPosition[0]);
            os.writeInt(this.mStrategyActionPosition[1]);
            os.writeBoolean(ruleDealerHitsSoft17);
            os.writeInt(ruleDoubleDown);
            os.writeInt(ruleDealerInsurance);
            os.writeBoolean(ruleDealerPeeksHoleCard);
            os.writeBoolean(ruleSplitCardsMustHaveSameRank);
            os.writeBoolean(ruleNo45TenSplits);
            os.writeBoolean(ruleHitSplitAces);
            os.writeBoolean(ruleResplitAces);
            os.writeBoolean(ruleDoubleOnSplit);
            os.writeInt(ruleMaxSplitHands);
            os.writeBoolean(ruleSplitAces);
            os.writeInt(ruleSurrender);
            os.writeInt(ruleShuffle);
            os.writeInt(ruleNumDecks);
            os.writeUTF(ruleDescription);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int datalen = is.readInt();
            byte[] buffer = new byte[datalen];
            is.read(buffer);
            this.deck = new Deck(buffer);
            datalen = is.readInt();
            if (datalen >= 0) {
                buffer = new byte[datalen];
                is.read(buffer);
                this.mDealerHand = new Hand(buffer);
            } else {
                this.mDealerHand = null;
            }
            this.mCurrentHand = is.readInt();
            int nHands = is.readInt();
            this.mPlayerHands = new Vector();
            for (int i = 0; i < nHands; ++i) {
                datalen = is.readInt();
                buffer = new byte[datalen];
                is.read(buffer);
                this.mPlayerHands.addElement(new Hand(buffer));
            }
            this.mPlayerHand = this.mCurrentHand < this.mPlayerHands.size() ? (Hand)this.mPlayerHands.elementAt(this.mCurrentHand) : null;
            this.mStrategyAction = is.readInt();
            this.mStrategyActionPosition = new int[2];
            this.mStrategyActionPosition[0] = is.readInt();
            this.mStrategyActionPosition[1] = is.readInt();
            ruleDealerHitsSoft17 = is.readBoolean();
            ruleDoubleDown = is.readInt();
            ruleDealerInsurance = is.readInt();
            ruleDealerPeeksHoleCard = is.readBoolean();
            ruleSplitCardsMustHaveSameRank = is.readBoolean();
            ruleNo45TenSplits = is.readBoolean();
            ruleHitSplitAces = is.readBoolean();
            ruleResplitAces = is.readBoolean();
            ruleDoubleOnSplit = is.readBoolean();
            ruleMaxSplitHands = is.readInt();
            ruleSplitAces = is.readBoolean();
            ruleSurrender = is.readInt();
            ruleShuffle = is.readInt();
            ruleNumDecks = is.readInt();
            ruleDescription = is.readUTF();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }
}

