/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack;

import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.ImageFontRenderer;
import net.handyx.casinopack.common.SoundManager;
import net.handyx.casinopack.common.Toast;

public class Common {
    public static String RES_FOLDER = "/blackjack";
    public static final boolean SOUND_SUPPORTS_VOLUME = false;
    public static final boolean DISABLE_ALPHA_EFFECTS = false;
    public static String VERSION_STRING = "1.0.0";
    public static final boolean DISABLE_ANIMATING_PANELS = false;
    public static final boolean DISPLAY_GET_MORE_GAMES_LINK = false;
    public static final String GET_MORE_GAMES_URL = "http://www.handyx.net";
    public static final boolean IGNORE_PLATFORM_REQUEST_EXIT = false;
    public static boolean debug = true;
    public static boolean setting_sound = true;
    public static int setting_sound_volume = 50;
    public static boolean setting_hints = true;
    public static boolean setting_perfect_play = false;
    public static int setting_currency = 0;
    public static int setting_starting_cash = 3;
    public static int setting_preset = 0;
    public static int setting_num_decks = 5;
    public static int setting_double_rule = 0;
    public static int setting_insurance = 2;
    public static boolean setting_double_on_split = true;
    public static boolean setting_dealer_hits_soft_17 = true;
    public static boolean setting_dealer_peeks = true;
    public static boolean setting_split_aces = true;
    public static boolean setting_hit_split_aces = false;
    public static boolean setting_resplit_aces = true;
    public static int setting_max_split_hands = 2;
    public static int setting_surrender_rule = 0;
    public static int setting_shuffling = 1;
    public static boolean soundEnabled = false;
    public static int soundVolume = 100;
    public static SoundManager soundMan = null;
    public static String soundExt = "amr";
    public static String soundMime = "audio/amr";
    public static String soundDir = "/blackjack/sounds/";
    public static ImageFontRenderer largeFont;
    public static ImageFontRenderer largeFontDisabled;
    public static ImageFontRenderer normalBlackFont;
    public static ImageFontRenderer normalWhiteFont;
    public static ImageFontRenderer settingsFontDisabled;
    public static ImageFontRenderer settingsFont;
    public static Image bgImage;
    public static Image meshImage;
    public static Image scrollImage;
    public static Image yesOnImage;
    public static Image yesOffImage;
    public static Image noOnImage;
    public static Image noOffImage;
    private static Random rnd;
    public static Vector toastQueue;

    public static int random(int v) {
        if (v == 0) {
            return 0;
        }
        return Math.abs(rnd.nextInt() % v);
    }

    public static void displayToast(String s) {
        if (toastQueue == null) {
            toastQueue = new Vector();
        }
        toastQueue.addElement(new Toast(s, 3000L));
    }

    public static void processToasts() {
        if (toastQueue != null) {
            for (int i = 0; i < toastQueue.size(); ++i) {
                Toast t = (Toast)toastQueue.elementAt(i);
                if (!t.hasExpired()) continue;
                toastQueue.removeElementAt(i);
                --i;
            }
        }
    }

    public static void renderToasts(GraphicsScaler g) {
        if (toastQueue != null) {
            for (int i = 0; i < toastQueue.size(); ++i) {
                Common.renderToast(g, (Toast)toastQueue.elementAt(i));
            }
        }
    }

    public static void renderToast(GraphicsScaler g, Toast t) {
        if (normalWhiteFont == null) {
            return;
        }
        int toastWidth = g.getWidth() - 50;
        String[] lines = normalWhiteFont.wrap(t.getMessage(), toastWidth - 12);
        int toastHeight = normalWhiteFont.getHeight() * lines.length + 15;
        int toastX = 25;
        int toastY = g.getHeight() - toastHeight - 20;
        g.setColor(0);
        g.fillRect(toastX, toastY, toastWidth, toastHeight);
        for (int i = 0; i < lines.length; ++i) {
            normalWhiteFont.drawString(g, lines[i], (g.getWidth() - normalWhiteFont.stringWidth(lines[i])) / 2, toastY + 7 + i * normalWhiteFont.getHeight());
        }
    }

    public static void getVersion(MIDlet parent) {
        try {
            String ver = parent.getAppProperty("MIDlet-Version");
            if (ver != null) {
                VERSION_STRING = ver.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadResources() {
        if (soundMan == null && soundMan == null) {
            soundMan = new SoundManager();
        }
        largeFont = new ImageFontRenderer("/fonts/komik");
        largeFontDisabled = new ImageFontRenderer("/fonts/komik_disabled");
        bgImage = Common.loadImage("/bg.jpg");
        normalBlackFont = new ImageFontRenderer("/fonts/komik_thin");
        normalWhiteFont = new ImageFontRenderer("/fonts/komik_thin_white");
        settingsFont = new ImageFontRenderer("/fonts/komik_12pt");
        settingsFontDisabled = new ImageFontRenderer("/fonts/komik_disabled_12pt");
        meshImage = Common.loadCommonImage("/mesh_alpha4.png");
        scrollImage = Common.loadImage("/scroll.png");
        yesOnImage = Common.loadImage("/yes_on.png");
        yesOffImage = Common.loadImage("/yes_off.png");
        noOnImage = Common.loadImage("/no_on.png");
        noOffImage = Common.loadImage("/no_off.png");
    }

    public static void purgeResources() {
        if (soundMan != null) {
            soundMan.purgeResources();
            soundMan = null;
        }
        if (largeFont != null) {
            largeFont.purge();
        }
        largeFont = null;
        if (largeFontDisabled != null) {
            largeFontDisabled.purge();
        }
        largeFontDisabled = null;
        if (normalBlackFont != null) {
            normalBlackFont.purge();
        }
        normalBlackFont = null;
        if (normalWhiteFont != null) {
            normalWhiteFont.purge();
        }
        normalWhiteFont = null;
        if (settingsFont != null) {
            settingsFont.purge();
        }
        settingsFont = null;
        if (settingsFontDisabled != null) {
            settingsFontDisabled.purge();
        }
        settingsFontDisabled = null;
        noOffImage = null;
        noOnImage = null;
        yesOffImage = null;
        yesOnImage = null;
        scrollImage = null;
        meshImage = null;
        System.gc();
    }

    public static Image loadCommonImage(String res) {
        Image img = null;
        try {
            img = Image.createImage((String)res);
        }
        catch (Exception e) {
            Common.log("Unable to load image: " + res);
        }
        return img;
    }

    public static Image loadImage(String res) {
        Image img = null;
        try {
            img = Image.createImage((String)(RES_FOLDER + res));
        }
        catch (Exception e) {
            Common.log("Unable to load image: " + RES_FOLDER + res);
        }
        return img;
    }

    public static String[] loadText(String res) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = res.getClass().getResourceAsStream(RES_FOLDER + res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            Common.log(e.toString());
        }
        return ImageFontRenderer.splitStringToArray("\n", sb.toString());
    }

    public static void doSound(String s) {
        Common.doSound(s + "." + soundExt, soundMime, 1);
    }

    public static void doSound(String s, String m) {
        Common.doSound(s, m, 1);
    }

    public static void doSound(String s, int loops) {
        if (!soundEnabled) {
            return;
        }
        Common.doSound(s + "." + soundExt, soundMime, loops);
    }

    public static void doSound(String s, String m, int loops) {
        if (!soundEnabled) {
            return;
        }
        try {
            System.out.println("Playing " + soundDir + s + " (" + m + ")");
            soundMan.playSound(soundDir + s, m, loops);
        }
        catch (Exception e) {
            System.out.println("Unable to play " + s);
        }
    }

    public static void cacheSound(String s) {
        Common.cacheSound(s + "." + soundExt, soundMime, 1);
    }

    public static void cacheSound(String s, int loops) {
        if (!soundEnabled) {
            return;
        }
        Common.cacheSound(s + "." + soundExt, soundMime, loops);
    }

    public static void cacheSound(String s, String m, int loops) {
        if (!soundEnabled) {
            return;
        }
        try {
            soundMan.cacheSound(soundDir + s, m, loops);
        }
        catch (Exception e) {
            System.out.println("Unable to cache " + s);
        }
    }

    public static void stopSounds() {
        soundMan.stopSound();
        soundMan = null;
        System.gc();
        soundMan = new SoundManager();
        Common.setSoundVolume(soundVolume);
    }

    public static void setSoundVolume(int vol) {
        if (vol == 0) {
            soundMan.enableVolumeControl(false);
        } else {
            soundMan.enableVolumeControl(true);
            soundMan.setVolume(vol);
        }
    }

    public static boolean supportsSound() {
        return true;
    }

    public static void log(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    static {
        rnd = new Random();
        toastQueue = null;
    }
}

