/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import net.handyx.casinopack.CasinoPack;
import net.handyx.casinopack.blackjack.Common;
import net.handyx.casinopack.blackjack.GameCanvas;
import net.handyx.casinopack.blackjack.GameRes;
import net.handyx.casinopack.blackjack.MenuCanvas;
import net.handyx.casinopack.blackjack.game.GameStats;
import net.handyx.casinopack.common.KickStart;
import net.handyx.casinopack.common.LoadingScreen;

public class Blackjack
implements Runnable {
    public static final int INIT = 0;
    public static final int MAIN_MENU = 1;
    public static final int NEW_GAME = 2;
    public static final int RESUME_GAME = 3;
    public static final int EXIT = 666;
    public int loadingStage = 0;
    public CasinoPack parent = null;
    public Display display;
    public MenuCanvas menuCanvas;
    public LoadingScreen loadingScreen;
    public KickStart kickStart;
    public GameCanvas gameCanvas;
    public GameStats gameStats;

    public Blackjack(CasinoPack p) {
        this.parent = p;
        this.display = Display.getDisplay((MIDlet)this.parent);
        this.loadingScreen = new LoadingScreen();
        this.doLoadingStage(0, true);
    }

    public void purgeResources() {
        this.menuCanvas.purgeResources();
        GameRes.purgeResources();
        Common.purgeResources();
    }

    public void doLoadingStage(int stage, boolean displayLoading) {
        if (displayLoading) {
            this.display.setCurrent((Displayable)this.loadingScreen);
        }
        this.loadingStage = stage;
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        if (this.loadingStage == 0) {
            Common.loadResources();
            this.gameStats = new GameStats();
            this.gameStats.loadState();
            this.gameCanvas = new GameCanvas(this);
            this.gameCanvas.setGameStats(this.gameStats);
            this.gameCanvas.loadGameState();
            this.menuCanvas = new MenuCanvas(this);
            this.menuCanvas.loadResources();
            this.menuCanvas.loadSettings();
            this.display.setCurrent((Displayable)this.menuCanvas);
        } else if (this.loadingStage == 1) {
            this.display.setCurrent((Displayable)this.menuCanvas);
        } else if (this.loadingStage == 2 || this.loadingStage == 3) {
            GameRes.loadResources();
            if (this.loadingStage == 2) {
                this.gameCanvas.applyGameSettings();
                this.gameCanvas.applySettings();
                this.gameCanvas.newGame();
            } else if (this.loadingStage == 3) {
                this.gameCanvas.applySettings();
            }
            this.display.setCurrent((Displayable)this.gameCanvas);
        }
    }

    public void startNewGame() {
        this.doLoadingStage(2, true);
    }

    public void resumeGame() {
        this.doLoadingStage(3, !GameRes.resourcesLoaded);
    }

    public void displayMainMenu() {
        this.doLoadingStage(1, false);
    }

    public void exitApplication() {
        this.menuCanvas.saveSettings();
        if (this.gameStats != null) {
            this.gameStats.saveState();
        }
        if (this.gameCanvas != null) {
            this.gameCanvas.saveGameState();
        }
        if (this.kickStart != null) {
            this.kickStart.terminate();
        }
        Common.stopSounds();
        this.parent.displaySelector();
    }

    public void splashScreenCleared() {
        this.doLoadingStage(1, false);
    }
}

