/*
 * Decompiled with CFR 0.152.
 */
package tube42.lib.ui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ImageFxUtils {
    public static Image applyFilter(Image image, int filter_w, int filter_h, ImageFilter filter) {
        int i;
        if ((filter_w & filter_h & 1) == 0) {
            return null;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int scanlength = w + w * filter_w;
        int offset_in = 0;
        int offset_out = 0;
        int[] buffer2 = new int[w * h];
        int[][] buffer1 = new int[filter_h][];
        for (i = 0; i < buffer1.length; ++i) {
            buffer1[i] = new int[scanlength];
        }
        for (i = 0; i < filter_h; ++i) {
            for (int j = 0; j < scanlength; ++j) {
                buffer1[i][j] = 0;
            }
            int n = i - filter_h / 2;
            if (n < 0 || n >= h) continue;
            image.getRGB(buffer1[i], filter_w, w, 0, n, w, 1);
        }
        for (int y = 0; y < h; ++y) {
            int i2;
            offset_in = filter_w;
            for (int x = 0; x < w; ++x) {
                buffer2[offset_out++] = filter.apply(buffer1, offset_in++, x, y);
            }
            int[] tmp = buffer1[0];
            int n = y + filter_h / 2;
            if (n >= 0 && n < h) {
                image.getRGB(tmp, filter_w, w, 0, n, w, 1);
            } else {
                for (i2 = 0; i2 < tmp.length; ++i2) {
                    tmp[i2] = 0;
                }
            }
            for (i2 = 1; i2 < filter_h; ++i2) {
                buffer1[i2 - 1] = buffer1[i2];
            }
            buffer1[filter_h - 1] = tmp;
        }
        return Image.createRGBImage((int[])buffer2, (int)w, (int)h, (boolean)true);
    }

    public static Image applyModifier(Image image, PixelModifier modifier) {
        return ImageFxUtils.applyModifier(image, modifier, false);
    }

    public static Image applyModifier(Image image, PixelModifier modifier, boolean modify_original) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] buffer = new int[w];
        Image ret = modify_original ? image : Image.createImage((int)w, (int)h);
        Graphics g = ret.getGraphics();
        for (int y = 0; y < h; ++y) {
            image.getRGB(buffer, 0, w, 0, y, w, 1);
            for (int x = 0; x < w; ++x) {
                buffer[x] = modifier.apply(buffer[x], x, y);
            }
            g.drawRGB(buffer, 0, w, 0, y, w, 1, true);
        }
        return ret;
    }

    public static Image transformARGB(Image image, byte[] ta, byte[] tr, byte[] tg, byte[] tb) {
        int i;
        int w = image.getWidth();
        int h = image.getHeight();
        int[] buffer = new int[w * h];
        image.getRGB(buffer, 0, w, 0, 0, w, h);
        image = null;
        int[] tmp = new int[256];
        if (ta != null) {
            for (i = 0; i < 256; ++i) {
                tmp[i] = (ta[i] & 0xFF) << 24;
            }
            for (i = 0; i < buffer.length; ++i) {
                buffer[i] = buffer[i] & 0xFFFFFF | tmp[buffer[i] >> 24 & 0xFF];
            }
        }
        if (tr != null) {
            for (i = 0; i < 256; ++i) {
                tmp[i] = (tr[i] & 0xFF) << 16;
            }
            for (i = 0; i < buffer.length; ++i) {
                buffer[i] = buffer[i] & 0xFF00FFFF | tmp[buffer[i] >> 16 & 0xFF];
            }
        }
        if (tg != null) {
            for (i = 0; i < 256; ++i) {
                tmp[i] = (tg[i] & 0xFF) << 8;
            }
            for (i = 0; i < buffer.length; ++i) {
                buffer[i] = buffer[i] & 0xFFFF00FF | tmp[buffer[i] >> 8 & 0xFF];
            }
        }
        if (tb != null) {
            for (i = 0; i < 256; ++i) {
                tmp[i] = (tb[i] & 0xFF) << 0;
            }
            for (i = 0; i < buffer.length; ++i) {
                buffer[i] = buffer[i] & 0xFFFFFF00 | tmp[buffer[i] >> 0 & 0xFF];
            }
        }
        return Image.createRGBImage((int[])buffer, (int)w, (int)h, (boolean)true);
    }

    public static interface PixelModifier {
        public int apply(int var1, int var2, int var3);
    }

    public static interface ImageFilter {
        public int apply(int[][] var1, int var2, int var3, int var4);
    }
}

