/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

public class Card {
    public static final boolean ACES_ARE_HIGH = true;
    public static final int CLUBS = 0;
    public static final int DIAMONDS = 1;
    public static final int HEARTS = 2;
    public static final int SPADES = 3;
    public static final String[] SUIT_NAMES = new String[]{"Clubs", "Diamonds", "Hearts", "Spades"};
    public static final int NONE = 0;
    public static final int ACE = 1;
    public static final int TWO = 2;
    public static final int THREE = 3;
    public static final int FOUR = 4;
    public static final int FIVE = 5;
    public static final int SIX = 6;
    public static final int SEVEN = 7;
    public static final int EIGHT = 8;
    public static final int NINE = 9;
    public static final int TEN = 10;
    public static final int JACK = 11;
    public static final int QUEEN = 12;
    public static final int KING = 13;
    public static final int ACE_HIGH = 14;
    public static final String[] CARD_STRINGS = new String[]{"N/A", "A", "2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K"};
    public static final int NUM_SUITS = 4;
    public static final int NUM_RANKS = 13;
    public static final int NUM_CARDS = 52;
    private int rank = 0;
    private int suit = 0;

    public Card(int rank, int suit) {
        this.rank = rank;
        this.suit = suit;
    }

    public Card(String s) {
        if (s.length() == 2) {
            char rank = s.toLowerCase().charAt(0);
            char suit = s.toLowerCase().charAt(1);
            this.suit = 2;
            if (suit == 'c') {
                this.suit = 0;
            } else if (suit == 'd') {
                this.suit = 1;
            } else if (suit == 's') {
                this.suit = 3;
            }
            if (rank == 't') {
                this.rank = 10;
            } else if (rank == 'j') {
                this.rank = 11;
            } else if (rank == 'q') {
                this.rank = 12;
            } else if (rank == 'k') {
                this.rank = 13;
            } else if (rank == 'a') {
                this.rank = 1;
            } else if (Character.isDigit(rank)) {
                this.rank = Character.digit(rank, 10);
            }
        }
    }

    public int getRank() {
        return this.rank;
    }

    public int getSuit() {
        return this.suit;
    }

    public String toString() {
        String s = CARD_STRINGS[this.rank];
        switch (this.suit) {
            case 2: {
                s = s + 'h';
                break;
            }
            case 1: {
                s = s + 'd';
                break;
            }
            case 0: {
                s = s + 'c';
                break;
            }
            case 3: {
                s = s + 's';
            }
        }
        return s;
    }

    public boolean equals(Card c2) {
        return this.rank == c2.getRank() && this.suit == c2.getSuit();
    }

    public boolean isEqualTo(Card c2) {
        return this.rank == c2.getRank();
    }

    public boolean isLessThan(Card c2) {
        return this.getRealRank() < c2.getRealRank();
    }

    public boolean isMoreThan(Card c2) {
        return this.getRealRank() > c2.getRealRank();
    }

    public Card duplicate() {
        return new Card(this.rank, this.suit);
    }

    private int getRealRank() {
        return this.rank == 1 ? 14 : this.rank;
    }
}

