/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.slots;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.FrameRenderer;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.ImageFontRenderer;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.common.RunnableCanvas;
import net.handyx.casinopack.common.Settings;
import net.handyx.casinopack.common.SoundManager;
import net.handyx.casinopack.common.SoundManagerListener;
import net.handyx.casinopack.slots.Common;
import net.handyx.casinopack.slots.Machine;
import net.handyx.casinopack.slots.Slots;
import net.handyx.casinopack.slots.Strings;

public class MachineCanvas
extends RunnableCanvas
implements SoundManagerListener {
    private static final int INTERNAL_SCREEN_WIDTH = 240;
    private static final int INTERNAL_SCREEN_HEIGHT = 320;
    private Slots parent = null;
    private Machine machine = null;
    private int ITEM_HEIGHT = 30;
    private int ITEM_WIDTH = 40;
    private Image[] itemImage = null;
    private Image blurImage;
    private Image fadeImage = null;
    private Image machineTopImage;
    private Image machineStandardBaseImage;
    private Image machineAltBaseImage;
    private Image payTableImage;
    private Image machineGlowLeftImage;
    private Image machineGlowRightImage;
    private Image machineGlowTopImage;
    private Image standardButtonsOnImage;
    private Image standardButtonsGlowImage;
    private Image holdButtonsOnImage;
    private Image holdButtonsGlowImage;
    private Image holdIconImage;
    private Image nudgeCounterImage;
    private Image buttonTextImage;
    private Image[] bannerImage = null;
    private Image handLeftImage;
    private Image handRightImage;
    private Image arrowLeftImage;
    private Image arrowRightImage;
    private int handX = 0;
    private boolean handAccelerate = true;
    private ImageFontRenderer uiFont;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int W = 2;
    private static final int H = 3;
    private static final int[][] REEL_POSITION = new int[][]{{52, 111, 40, 55}, {100, 111, 40, 55}, {147, 111, 40, 55}};
    private static final int[] NUDGE_COUNTER_POSITION = new int[]{189, 219};
    private static final int[] HOLD_COUNTER_POSITION = new int[]{189, 197};
    private static final int[] BANNER_POSITION = new int[]{45, 209};
    private static final int[] CASH_TEXT = new int[]{47, 64};
    private static final int[] BET_TEXT = new int[]{190, 64};
    private static final int[] BUTTON_AREA = new int[]{53, 167};
    private static final int[][] STANDARD_BUTTON_AREA = new int[][]{{BUTTON_AREA[0], BUTTON_AREA[1], 24, 16}, {BUTTON_AREA[0] + 24, BUTTON_AREA[1], 30, 16}, {BUTTON_AREA[0] + 54, BUTTON_AREA[1], 26, 16}};
    private static final int[] BUTTON_TEXT_AREA = new int[]{144, 167, 46, 16};
    private static final int[] HOLD_BUTTON_POSITION = new int[]{47, 183};
    private static final int[][] HOLD_BUTTON_AREA = new int[][]{{HOLD_BUTTON_POSITION[0], HOLD_BUTTON_POSITION[1], 48, 29}, {HOLD_BUTTON_POSITION[0] + 47, HOLD_BUTTON_POSITION[1], 48, 29}, {HOLD_BUTTON_POSITION[0] + 94, HOLD_BUTTON_POSITION[1], 46, 29}, {HOLD_BUTTON_POSITION[0], HOLD_BUTTON_POSITION[1] + 30, 48, 26}, {HOLD_BUTTON_POSITION[0] + 47, HOLD_BUTTON_POSITION[1] + 30, 48, 26}, {HOLD_BUTTON_POSITION[0] + 94, HOLD_BUTTON_POSITION[1] + 30, 46, 26}};
    private int selectedButton = 0;
    private int selectedHoldButton = 0;
    private boolean holdButtonsSelected = false;
    private static final int BUTTON_SPIN = 0;
    private static final int BUTTON_BETONE = 1;
    private static final int BUTTON_BETMAX = 2;
    private static final int BUTTON_HOLD1 = 3;
    private static final int BUTTON_HOLD2 = 4;
    private static final int BUTTON_HOLD3 = 5;
    private static final int BUTTON_NUDGE1 = 6;
    private static final int BUTTON_NUDGE2 = 7;
    private static final int BUTTON_NUDGE3 = 8;
    public static final int FINISHED = 0;
    public static final int PRECACHING_SOUNDS = 1;
    public static final int SPINNING_UP = 2;
    public static final int SPINNING = 3;
    public static final int WINNINGS = 4;
    public static final int NUDGING = 5;
    private int machineState = 0;
    private long spinStartTime = 0L;
    private int reelsStopped = 0;
    private long preCacheStartTime = 0L;
    private int[] spinCounter = new int[3];
    private int[] spinBounce = new int[3];
    private int spinUpCounter = 0;
    private boolean donePreBounce = false;
    private int nudgeOffset = 0;
    private int nudgingReel = 0;
    private int nudgeYV = 0;
    private int startingCash = 100;
    private int betAmount = 1;
    private int cash;
    private int _cash = this.cash = this.startingCash;
    private int spinBetAmount = 1;
    private int totalWinnings = 0;
    private boolean currentMachineCasinoStyle = false;
    public static final int MACHINE_SELECTOR = 0;
    public static final int LOADING = 1;
    public static final int PLAY_MACHINE = 2;
    public int displayState = 0;
    private Vector machines;
    private int selectedMachine = 0;
    private int machineXOffset = 0;
    private int xv = 0;
    private boolean displayPaytable = false;
    private int paytableYOffset = 0;
    private int paytableYV = 0;
    private long winningsStartTime = 0L;
    private int fl = 1;
    private int fr = 2;
    private int ft = 4;
    private int[][] flashSequence = new int[][]{{this.fl, this.fl | this.fr, this.fr, 0, this.fl, this.fl | this.fr, this.fr, 0, this.fl, this.fl | this.fr, this.fr, 0, this.fl, this.fl | this.fr, this.fr, 0, this.ft, 0, this.ft, 0, this.ft, 0, this.ft, 0}, {this.fl | this.ft, this.fl, this.fl | this.ft, this.fl, this.fr | this.ft, this.fr, this.fr | this.ft, this.fr, this.ft | this.fl, this.ft | this.fr, this.ft | this.fl, this.ft | this.fr, this.ft | this.fl, this.ft | this.fr}, {this.fl, 0, 0, this.fr, 0, 0, this.ft, 0, 0, this.fl, this.fl, 0, 0, this.fr, this.fr, 0, 0, this.ft, this.ft, 0, this.fl | this.fr | this.ft, 0, this.fl | this.fr | this.ft, 0, this.fl | this.fr | this.ft, 0, this.fl | this.fr | this.ft, 0}};
    private int flashSequenceNum = 0;
    private int flashSequenceIndex = 0;
    private boolean flashButtons = false;
    private Vector popupMenuItems = new Vector();
    private static final int POPUP_SPIN = 0;
    private static final int POPUP_PAYOUT = 1;
    private static final int POPUP_HINT = 2;
    private static final int POPUP_MENU = 3;
    private boolean displayPopupMenu = false;
    private int popupMenuSelectedIndex = 0;
    private int BOX_REVEAL = 1;
    private int BOX_HIDE = 2;
    private int displayBox = 0;
    private int boxW = 0;
    private int boxH = 0;
    private int boxNumFrames = 0;
    private int boxFrame = 0;
    private int maxLines = 10;
    private int lineOffset = 0;
    private int scrollDirection = 0;
    private String[] infoLines = null;
    private String[][] lines = null;
    private boolean displayHint = false;
    private boolean displayMessage = false;
    private Image frameBuffer = null;
    private Image scaledImage = null;
    private int[] frameData = null;
    private int[] scaledData = null;

    public MachineCanvas(Slots p) {
        Common.soundMan.setSoundManagerListener(this);
        this.parent = p;
        this.machines = new Vector();
        this.spinCounter[0] = 0;
        this.spinCounter[1] = 1;
        this.spinCounter[2] = 2;
    }

    public void addMachine(Machine m) {
        this.machines.addElement(m);
    }

    public void loadResources() {
        this.machineTopImage = Common.loadImage("/machine_top.png");
        if (Common.machineCasinoStyle) {
            this.machineStandardBaseImage = Common.loadImage("/machine_standard_base.png");
        } else {
            this.machineAltBaseImage = Common.loadImage("/machine_alt_base.png");
        }
        this.nudgeCounterImage = Common.loadImage("/nudge_counter.png");
        this.handLeftImage = Common.loadImage("/hand_left.png");
        this.handRightImage = Common.loadImage("/hand_right.png");
        this.bannerImage = new Image[this.machines.size()];
        this.itemImage = new Image[this.machines.size()];
        this.lines = new String[this.machines.size()][1];
        for (int i = 0; i < this.machines.size(); ++i) {
            Machine m = (Machine)this.machines.elementAt(i);
            this.bannerImage[i] = Common.loadImage(m.getResourceFolder() + "/banner.png");
            this.itemImage[i] = Common.loadImage(m.getResourceFolder() + "/symbols.png");
            this.lines[i] = m.getHighestScore() > 0 ? Common.normalFont.wrap(Strings.fill("Your Highest Winnings $$0\n\n$1", Integer.toString(m.getHighestScore()), m.getDescription()), 200) : Common.normalFont.wrap(m.getDescription(), 200);
        }
        this.fadeImage = Settings.DISABLE_ALPHA_EFFECTS ? Common.loadImage("/reelfade_8bit.png") : Common.loadImage("/reelfade.png");
        this.uiFont = new ImageFontRenderer("/slots/fonts/komik_thin_red");
        this.uiFont.disableCache();
    }

    public void loadInGameResources() {
        this.displayState = 1;
        System.gc();
        Runtime rt = Runtime.getRuntime();
        long freeMem = rt.freeMemory();
        System.out.println("Used Mem:" + (rt.totalMemory() - freeMem) + "  Total Mem:" + rt.totalMemory() + "  Free Mem:" + freeMem);
        this.lines = null;
        for (int i = 0; i < this.machines.size(); ++i) {
            if (i == this.selectedMachine) continue;
            this.bannerImage[i] = null;
            this.itemImage[i] = null;
        }
        this.handLeftImage = null;
        this.handRightImage = null;
        System.gc();
        this.arrowLeftImage = Common.loadImage("/arrow_left.png");
        this.arrowRightImage = Common.loadImage("/arrow_right.png");
        this.buttonTextImage = Common.loadImage("/button_text.png");
        this.machineGlowLeftImage = Common.loadImage("/machine_glow_left.png");
        this.machineGlowRightImage = Common.loadImage("/machine_glow_right.png");
        this.machineGlowTopImage = Common.loadImage("/machine_glow_top.png");
        this.standardButtonsOnImage = Common.loadImage("/standard_buttons_on.png");
        this.standardButtonsGlowImage = Common.loadImage("/standard_buttons_glow.png");
        this.holdButtonsOnImage = Common.loadImage("/hold_nudge_on.png");
        this.holdButtonsGlowImage = Common.loadImage("/hold_nudge_glow.png");
        this.blurImage = Common.loadImage(this.machine.getResourceFolder() + "/blur.png");
        this.holdIconImage = Common.loadImage("/hold.png");
        this.payTableImage = Common.loadImage(this.machine.getResourceFolder() + "/paytable.png");
        this.displayState = 2;
    }

    public void purgeResources() {
        this.machineAltBaseImage = null;
        this.machineStandardBaseImage = null;
        this.machineTopImage = null;
        this.holdIconImage = null;
        this.nudgeCounterImage = null;
        this.machineGlowTopImage = null;
        this.machineGlowRightImage = null;
        this.machineGlowLeftImage = null;
        this.holdButtonsGlowImage = null;
        this.holdButtonsOnImage = null;
        this.holdButtonsGlowImage = null;
        this.holdButtonsOnImage = null;
        this.standardButtonsGlowImage = null;
        this.standardButtonsOnImage = null;
        this.buttonTextImage = null;
        this.arrowRightImage = null;
        this.arrowLeftImage = null;
        this.handRightImage = null;
        this.handLeftImage = null;
        this.payTableImage = null;
        this.blurImage = null;
        try {
            if (this.machine != null) {
                for (int i = 0; i < this.machines.size(); ++i) {
                    if (this.bannerImage != null) {
                        this.bannerImage[i] = null;
                    }
                    if (this.itemImage == null) continue;
                    this.itemImage[i] = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fadeImage = null;
        if (this.uiFont != null) {
            this.uiFont.purge();
            this.uiFont = null;
        }
        System.gc();
    }

    public void reset() {
        this.betAmount = 1;
        this.spinBetAmount = 1;
        this.cash = this.startingCash;
        this._cash = this.startingCash;
        this.paytableYOffset = 0;
        this.displayPaytable = false;
        this.selectedMachine = 0;
        this.machineXOffset = 0;
        this.xv = 0;
        this.machineState = 0;
        this.spinStartTime = 0L;
        this.reelsStopped = 0;
        this.preCacheStartTime = 0L;
        this.spinUpCounter = 0;
        this.donePreBounce = false;
        this.selectedButton = 0;
        this.selectedHoldButton = 0;
        this.holdButtonsSelected = false;
        this.totalWinnings = 0;
        for (int m = 0; m < this.machines.size(); ++m) {
            ((Machine)this.machines.elementAt(m)).setMachineCasinoStyle(Common.machineCasinoStyle);
            ((Machine)this.machines.elementAt(m)).reset();
        }
        this.currentMachineCasinoStyle = Common.machineCasinoStyle;
        this.displayPopupMenu = false;
    }

    public boolean canResumeGame() {
        return Common.machineCasinoStyle == this.currentMachineCasinoStyle && this.displayState != 0;
    }

    public boolean gameInProgress() {
        return this.displayState != 0;
    }

    public void setDisplay(int newState) {
        this.displayState = newState;
    }

    public void processFrame(int fn) {
        if (this.handAccelerate) {
            ++this.handX;
            if (this.handX == 6) {
                this.handAccelerate = false;
            }
        } else {
            --this.handX;
            if (this.handX == 0) {
                this.handAccelerate = true;
            }
        }
        if (this.boxFrame < this.boxNumFrames) {
            ++this.boxFrame;
            if (this.boxFrame == this.boxNumFrames && this.displayBox == this.BOX_HIDE) {
                this.displayHint = false;
                this.displayMessage = false;
            }
        }
        if (this.displayPaytable) {
            if (this.paytableYV < 0) {
                this.paytableYOffset = this.paytableYOffset + this.payTableImage.getHeight() + this.paytableYV < 480 ? 480 - this.payTableImage.getHeight() : (this.paytableYOffset += this.paytableYV);
            } else if (this.paytableYV > 0) {
                this.paytableYOffset = this.paytableYOffset + this.paytableYV > 0 ? 0 : (this.paytableYOffset += this.paytableYV);
            }
        }
        if (this.displayHint && this.scrollDirection != 0) {
            if (this.scrollDirection == -1) {
                if (this.lineOffset > 0) {
                    --this.lineOffset;
                }
            } else if (this.infoLines.length - this.lineOffset > this.maxLines) {
                ++this.lineOffset;
            }
        }
        if (this.displayState == 0) {
            int targetOffset = this.selectedMachine * 240;
            if (this.machineXOffset > targetOffset) {
                this.machineXOffset -= this.xv;
                if (this.machineXOffset < targetOffset) {
                    this.machineXOffset = targetOffset;
                }
                this.xv >>= 1;
                if (this.xv <= 0) {
                    this.xv = 1;
                }
            } else if (this.machineXOffset < targetOffset) {
                this.machineXOffset += this.xv;
                if (this.machineXOffset > targetOffset) {
                    this.machineXOffset = targetOffset;
                }
                this.xv >>= 1;
                if (this.xv <= 0) {
                    this.xv = 1;
                }
            }
        } else if (this.displayState == 2) {
            int diff;
            boolean bl = this.flashButtons = !this.flashButtons;
            if (this._cash < this.cash) {
                diff = this.cash - this._cash;
                this._cash = diff > 100 ? (this._cash += 100) : (diff > 10 ? (this._cash += 10) : ++this._cash);
            } else if (this._cash > this.cash) {
                diff = this._cash - this.cash;
                this._cash = diff > 100 ? (this._cash -= 100) : (diff > 10 ? (this._cash -= 10) : --this._cash);
            }
            if (this.machineState == 2) {
                if (!this.donePreBounce) {
                    --this.spinUpCounter;
                    if (this.spinUpCounter == -2) {
                        this.donePreBounce = true;
                    }
                } else {
                    ++this.spinUpCounter;
                    if (this.spinUpCounter == 4) {
                        this.machineState = 3;
                    }
                }
            } else if (this.machineState == 3) {
                long diff2 = System.currentTimeMillis() - this.spinStartTime;
                if (diff2 > 1800L && this.reelsStopped == 0) {
                    this.reelsStopped = 1;
                    this.spinBounce[0] = 6;
                }
                if (diff2 > 2300L && this.reelsStopped == 1) {
                    this.reelsStopped = 2;
                    this.spinBounce[1] = 6;
                }
                if (diff2 > 2800L && this.reelsStopped == 2) {
                    this.reelsStopped = 3;
                    this.spinBounce[2] = 6;
                }
                if (diff2 > 3300L) {
                    if (this.machine.getPayout(this.spinBetAmount) > 0) {
                        this.flashSequenceIndex = 0;
                        this.flashSequenceNum = Common.random(this.flashSequence.length);
                        this.winningsStartTime = System.currentTimeMillis();
                        this.machineState = 4;
                        this.machine.finishSpin();
                        this.cash += this.machine.getPayout(this.spinBetAmount);
                        this.totalWinnings += this.machine.getPayout(this.spinBetAmount);
                        if (this.machine.getHighestScore() < this.totalWinnings) {
                            this.machine.setHighestScore(this.totalWinnings);
                        }
                        System.out.println("Finished spin - Winner");
                    } else {
                        this.machineState = 0;
                        this.machine.finishSpin();
                        this.cash += this.machine.getPayout(this.spinBetAmount);
                        this.totalWinnings += this.machine.getPayout(this.spinBetAmount);
                        if (this.machine.getHighestScore() < this.totalWinnings) {
                            this.machine.setHighestScore(this.totalWinnings);
                        }
                        System.out.println("Finished spin");
                    }
                }
                for (int i = 0; i < 3; ++i) {
                    int n = this.spinCounter[i] = this.spinCounter[i] == 3 ? 0 : this.spinCounter[i] + 1;
                    if (this.spinBounce[i] <= 0) continue;
                    int n2 = i;
                    this.spinBounce[n2] = this.spinBounce[n2] - 1;
                }
            } else if (this.machineState == 1) {
                if (System.currentTimeMillis() - this.preCacheStartTime > 4000L) {
                    this.startSpin(false);
                }
            } else if (this.machineState == 4) {
                long diff3 = System.currentTimeMillis() - this.winningsStartTime;
                if (diff3 > 3500L) {
                    this.holdButtonsSelected = false;
                    if (this.selectedButton == 1) {
                        this.selectedButton = 0;
                    }
                    this.machineState = 0;
                } else {
                    this.flashSequenceIndex = this.flashSequenceIndex == this.flashSequence[this.flashSequenceNum].length - 1 ? 0 : ++this.flashSequenceIndex;
                }
            } else if (this.machineState == 5) {
                if (this.nudgeOffset < this.ITEM_HEIGHT + 6 && this.nudgeYV > 0) {
                    this.nudgeOffset += this.nudgeYV;
                    this.nudgeYV /= 2;
                    if (this.nudgeYV <= 4) {
                        this.nudgeYV = 4;
                    }
                } else {
                    if (this.nudgeYV > 0) {
                        this.nudgeYV = -4;
                    } else {
                        ++this.nudgeYV;
                        if (this.nudgeYV >= -2) {
                            this.nudgeYV = -2;
                        }
                    }
                    this.nudgeOffset += this.nudgeYV;
                    if (this.nudgeOffset <= this.ITEM_HEIGHT) {
                        this.nudgeOffset = this.ITEM_HEIGHT;
                        if (this.machine.getPayout(this.spinBetAmount) > 0) {
                            Common.doSound("win");
                            this.flashSequenceIndex = 0;
                            this.flashSequenceNum = Common.random(this.flashSequence.length);
                            this.winningsStartTime = System.currentTimeMillis();
                            this.machineState = 4;
                            this.machine.finishSpin();
                            this.cash += this.machine.getPayout(this.spinBetAmount);
                            this.totalWinnings += this.machine.getPayout(this.spinBetAmount);
                            if (this.machine.getHighestScore() < this.totalWinnings) {
                                this.machine.setHighestScore(this.totalWinnings);
                            }
                            System.out.println("Finished spin - Winner");
                        } else {
                            this.machineState = 0;
                        }
                    }
                }
            }
        }
    }

    public void paintCanvas(Graphics gfx, int sw, int sh) {
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        sw = g.getWidth();
        sh = g.getHeight();
        if (this.displayState == 2) {
            this.renderMachine(g);
            if (this.displayHint || this.displayMessage) {
                this.renderInfoWindow(g, this.machine.getName());
            } else if (this.displayPopupMenu) {
                this.renderPopupMenu(g);
                MachineCanvas.drawLeftCommand(g, Strings.CMD_SELECT, Common.largeFont);
                MachineCanvas.drawRightCommand(g, Strings.CMD_CANCEL, Common.largeFont);
            } else if (this.machineState == 0) {
                if (this.displayPaytable) {
                    MachineCanvas.drawRightCommand(g, Strings.CMD_OK, Common.largeFont);
                } else {
                    MachineCanvas.drawLeftCommand(g, Strings.CMD_OPTIONS, Common.largeFont);
                }
            }
        } else if (this.displayState == 1 || this.displayState == 0) {
            this.renderMachineSelector(g);
        }
    }

    public void renderMachine(GraphicsScaler g) {
        int sw = g.getWidth();
        int sh = g.getHeight();
        if (this.machineState == 0 || this.machineState == 1 || this.machineState == 2 || this.machineState == 4) {
            g.drawImage(this.machineTopImage, 0, 0, 20);
            if (this.machine.supportsHolds() && this.machine.supportsNudges()) {
                if (this.machineAltBaseImage != null) {
                    g.drawImage(this.machineAltBaseImage, 0, g.unscale(this.machineTopImage.getHeight()), 20);
                }
                if (this.bannerImage[this.selectedMachine] != null) {
                    g.drawImage(this.bannerImage[this.selectedMachine], BANNER_POSITION[0], BANNER_POSITION[1] + 40, 20);
                }
                g.setClip(NUDGE_COUNTER_POSITION[0], NUDGE_COUNTER_POSITION[1], 9, 9);
                g.drawImage(this.nudgeCounterImage, NUDGE_COUNTER_POSITION[0] - this.machine.numNudgesAvailable() * 9, NUDGE_COUNTER_POSITION[1], 20);
                g.setClip(HOLD_COUNTER_POSITION[0], HOLD_COUNTER_POSITION[1], 9, 9);
                g.drawImage(this.nudgeCounterImage, HOLD_COUNTER_POSITION[0] - this.machine.numHoldsAvailable() * 9, HOLD_COUNTER_POSITION[1], 20);
                g.setClip(0, 0, sw, sh);
            } else {
                if (this.machineStandardBaseImage != null) {
                    g.drawImage(this.machineStandardBaseImage, 0, g.unscale(this.machineTopImage.getHeight()), 20);
                }
                if (this.bannerImage[this.selectedMachine] != null) {
                    g.drawImage(this.bannerImage[this.selectedMachine], BANNER_POSITION[0], BANNER_POSITION[1], 20);
                }
            }
            if (this.machineState == 4) {
                int flash = this.flashSequence[this.flashSequenceNum][this.flashSequenceIndex];
                if ((flash & this.fl) == this.fl) {
                    g.drawImage(this.machineGlowLeftImage, 0, 0, 20);
                }
                if ((flash & this.fr) == this.fr) {
                    g.drawImage(this.machineGlowRightImage, sw - g.unscale(this.machineGlowRightImage.getWidth()), 0, 20);
                }
                if ((flash & this.ft) == this.ft) {
                    g.drawImage(this.machineGlowTopImage, 24, 0, 20);
                }
            }
        }
        if (this.machineState == 0 || this.machineState == 1 || this.machineState == 2 && this.spinUpCounter <= 0) {
            if (this.machine.supportsHolds() && this.machine.supportsNudges()) {
                int i;
                for (i = 0; i < 3; ++i) {
                    g.setClip(HOLD_BUTTON_AREA[i][0], HOLD_BUTTON_AREA[i][1], HOLD_BUTTON_AREA[i][2], HOLD_BUTTON_AREA[i][3]);
                    if ((this.machine.numHoldsAvailable() <= 0 || !this.flashButtons) && !this.machine.reelHeld(i)) continue;
                    g.drawImage(this.holdButtonsOnImage, HOLD_BUTTON_POSITION[0], HOLD_BUTTON_POSITION[1], 20);
                }
                g.setClip(0, 0, sw, sh);
                if (this.machine.numNudgesAvailable() > 0 && this.flashButtons) {
                    for (i = 0; i < 3; ++i) {
                        g.setClip(HOLD_BUTTON_AREA[i + 3][0], HOLD_BUTTON_AREA[i + 3][1], HOLD_BUTTON_AREA[i + 3][2], HOLD_BUTTON_AREA[i + 3][3]);
                        g.drawImage(this.holdButtonsOnImage, HOLD_BUTTON_POSITION[0], HOLD_BUTTON_POSITION[1], 20);
                    }
                }
                g.setClip(0, 0, sw, sh);
                if (this.holdButtonsSelected) {
                    g.setClip(HOLD_BUTTON_AREA[this.selectedHoldButton][0], HOLD_BUTTON_AREA[this.selectedHoldButton][1], HOLD_BUTTON_AREA[this.selectedHoldButton][2], HOLD_BUTTON_AREA[this.selectedHoldButton][3]);
                    g.drawImage(this.holdButtonsGlowImage, HOLD_BUTTON_POSITION[0], HOLD_BUTTON_POSITION[1], 20);
                    g.setClip(0, 0, sw, sh);
                }
            }
            if (this.flashButtons) {
                g.getGraphics().drawImage(this.standardButtonsOnImage, 79, 251, 20);
            }
            if (!this.holdButtonsSelected) {
                g.setClip(STANDARD_BUTTON_AREA[this.selectedButton][0], STANDARD_BUTTON_AREA[this.selectedButton][1], STANDARD_BUTTON_AREA[this.selectedButton][2], STANDARD_BUTTON_AREA[this.selectedButton][1]);
                g.getGraphics().drawImage(this.standardButtonsGlowImage, 79, 251, 20);
                g.setClip(BUTTON_TEXT_AREA[0], BUTTON_TEXT_AREA[1], BUTTON_TEXT_AREA[2], BUTTON_TEXT_AREA[3]);
                g.drawImage(this.buttonTextImage, BUTTON_TEXT_AREA[0], BUTTON_TEXT_AREA[1] - BUTTON_TEXT_AREA[3] * this.selectedButton, 20);
                g.setClip(0, 0, sw, sh);
                g.drawImage(this.arrowLeftImage, BUTTON_TEXT_AREA[0] - 8 - (this.handX >> 1), BUTTON_TEXT_AREA[1] + 6, 20);
                g.drawImage(this.arrowRightImage, BUTTON_TEXT_AREA[0] + BUTTON_TEXT_AREA[2] + 3 + (this.handX >> 1), BUTTON_TEXT_AREA[1] + 6, 20);
            }
        }
        if (this.machineState != 3) {
            if (this.machineState == 4) {
                String s = "You Win $" + Integer.toString(this.machine.getPayout(this.spinBetAmount));
                this.uiFont.drawString(g, s, sw - this.uiFont.stringWidth(s) >> 1, CASH_TEXT[1]);
            } else {
                this.uiFont.drawString(g, "Cash $" + this._cash, CASH_TEXT[0], CASH_TEXT[1]);
                if (this.betAmount > 1) {
                    this.uiFont.drawString(g, this.betAmount + " " + "Coins", BET_TEXT[0] - this.uiFont.stringWidth(this.betAmount + " " + "Coins"), BET_TEXT[1]);
                } else {
                    this.uiFont.drawString(g, this.betAmount + " " + "Coin", BET_TEXT[0] - this.uiFont.stringWidth(this.betAmount + " " + "Coin"), BET_TEXT[1]);
                }
            }
        }
        this.renderReels(g);
        g.setClip(0, 0, sw, sh);
        if (this.machineState == 0) {
            for (int reel = 0; reel < 3; ++reel) {
                if (!this.machine.reelHeld(reel)) continue;
                g.drawImage(this.holdIconImage, REEL_POSITION[reel][0] + (this.ITEM_WIDTH - g.unscale(this.holdIconImage.getWidth()) >> 1), REEL_POSITION[reel][1] + (REEL_POSITION[reel][3] >> 1) - (g.unscale(this.holdIconImage.getHeight()) >> 1), 20);
            }
        }
        if (this.displayPaytable) {
            this.renderPayTable(g);
        }
    }

    public void renderReels(GraphicsScaler g) {
        int sw = g.getWidth();
        int sh = g.getHeight();
        int centreY = REEL_POSITION[0][1] + (REEL_POSITION[0][3] >> 1) - (this.ITEM_HEIGHT >> 1);
        int x = 0;
        int y = 0;
        int tmpY = 0;
        for (int reel = 0; reel < 3; ++reel) {
            int symb;
            int reelOffset;
            int symb2;
            x = REEL_POSITION[reel][0];
            y = REEL_POSITION[reel][1];
            if (this.machineState == 5) {
                if (reel == this.nudgingReel) {
                    tmpY = centreY - 2 * this.ITEM_HEIGHT + this.nudgeOffset;
                    for (symb2 = 0; symb2 < 4; ++symb2) {
                        if (tmpY < y) {
                            g.setClip(x, y, this.ITEM_WIDTH, this.ITEM_HEIGHT - (y - tmpY));
                        } else if (tmpY + this.ITEM_HEIGHT > y + REEL_POSITION[reel][3]) {
                            g.setClip(x, tmpY, this.ITEM_WIDTH, y + REEL_POSITION[reel][3] - tmpY);
                        } else {
                            g.setClip(x, tmpY, this.ITEM_WIDTH, this.ITEM_HEIGHT);
                        }
                        if (this.itemImage[this.selectedMachine] != null) {
                            g.drawImage(this.itemImage[this.selectedMachine], x, tmpY - this.machine.getReelSymbol(reel, -1 + symb2) * this.ITEM_HEIGHT, 20);
                        }
                        tmpY += this.ITEM_HEIGHT;
                    }
                } else {
                    tmpY = centreY - this.ITEM_HEIGHT;
                    for (symb2 = 0; symb2 < 3; ++symb2) {
                        if (tmpY < y) {
                            g.setClip(x, y, this.ITEM_WIDTH, this.ITEM_HEIGHT - (y - tmpY));
                        } else if (tmpY + this.ITEM_HEIGHT > y + REEL_POSITION[reel][3]) {
                            g.setClip(x, tmpY, this.ITEM_WIDTH, y + REEL_POSITION[reel][3] - tmpY);
                        } else {
                            g.setClip(x, tmpY, this.ITEM_WIDTH, this.ITEM_HEIGHT);
                        }
                        if (this.itemImage[this.selectedMachine] != null) {
                            g.drawImage(this.itemImage[this.selectedMachine], x, tmpY - this.machine.getReelSymbol(reel, -1 + symb2) * this.ITEM_HEIGHT, 20);
                        }
                        tmpY += this.ITEM_HEIGHT;
                    }
                }
            } else if (this.machineState == 0 || this.machineState == 4 || this.machineState == 3 && this.reelsStopped >= reel + 1) {
                reelOffset = 0;
                reelOffset = this.spinBounce[reel] > 3 ? 2 * (6 - this.spinBounce[reel]) : 2 * this.spinBounce[reel];
                tmpY = centreY - this.ITEM_HEIGHT + reelOffset;
                for (symb = 0; symb < 3; ++symb) {
                    if (tmpY < y) {
                        g.setClip(x, y, this.ITEM_WIDTH, this.ITEM_HEIGHT - (y - tmpY));
                    } else if (tmpY + this.ITEM_HEIGHT > y + REEL_POSITION[reel][3]) {
                        g.setClip(x, tmpY, this.ITEM_WIDTH, y + REEL_POSITION[reel][3] - tmpY);
                    } else {
                        g.setClip(x, tmpY, this.ITEM_WIDTH, this.ITEM_HEIGHT);
                    }
                    if (this.itemImage[this.selectedMachine] != null) {
                        g.drawImage(this.itemImage[this.selectedMachine], x, tmpY - this.machine.getReelSymbol(reel, -1 + symb) * this.ITEM_HEIGHT, 20);
                    }
                    tmpY += this.ITEM_HEIGHT;
                }
            } else if (this.machineState == 2 || this.machineState == 1) {
                reelOffset = this.spinUpCounter * 2;
                if (this.machine.reelHeld(reel)) {
                    reelOffset = 0;
                }
                tmpY = centreY - this.ITEM_HEIGHT + reelOffset;
                for (symb = 0; symb < 3; ++symb) {
                    if (tmpY < y) {
                        g.setClip(x, y, this.ITEM_WIDTH, this.ITEM_HEIGHT - (y - tmpY));
                    } else if (tmpY + this.ITEM_HEIGHT > y + REEL_POSITION[reel][3]) {
                        g.setClip(x, tmpY, this.ITEM_WIDTH, y + REEL_POSITION[reel][3] - tmpY);
                    } else {
                        g.setClip(x, tmpY, this.ITEM_WIDTH, this.ITEM_HEIGHT);
                    }
                    if (this.itemImage[this.selectedMachine] != null) {
                        g.drawImage(this.itemImage[this.selectedMachine], x, tmpY - this.machine.getPreviousReelSymbol(reel, -1 + symb) * this.ITEM_HEIGHT, 20);
                    }
                    tmpY += this.ITEM_HEIGHT;
                }
            } else if (this.machine.reelHeld(reel)) {
                tmpY = centreY - this.ITEM_HEIGHT;
                for (symb2 = 0; symb2 < 3; ++symb2) {
                    if (tmpY < y) {
                        g.setClip(x, y, this.ITEM_WIDTH, this.ITEM_HEIGHT - (y - tmpY));
                    } else if (tmpY + this.ITEM_HEIGHT > y + REEL_POSITION[reel][3]) {
                        g.setClip(x, tmpY, this.ITEM_WIDTH, y + REEL_POSITION[reel][3] - tmpY);
                    } else {
                        g.setClip(x, tmpY, this.ITEM_WIDTH, this.ITEM_HEIGHT);
                    }
                    if (this.itemImage[this.selectedMachine] != null) {
                        g.drawImage(this.itemImage[this.selectedMachine], x, tmpY - this.machine.getReelSymbol(reel, -1 + symb2) * this.ITEM_HEIGHT, 20);
                    }
                    tmpY += this.ITEM_HEIGHT;
                }
            } else {
                g.setClip(x, REEL_POSITION[reel][1], REEL_POSITION[reel][2], REEL_POSITION[reel][3]);
                g.drawImage(this.blurImage, REEL_POSITION[reel][0] - this.spinCounter[reel] * this.ITEM_WIDTH, REEL_POSITION[reel][1], 20);
            }
            g.setClip(0, 0, sw, sh);
            g.drawImage(this.fadeImage, REEL_POSITION[reel][0], REEL_POSITION[reel][1], 20);
        }
    }

    public void renderMachineSelector(GraphicsScaler g) {
        int sw = g.getWidth();
        int sh = g.getHeight();
        int machineX = 0;
        int machineY = 0;
        int centreY = REEL_POSITION[0][1] + (REEL_POSITION[0][3] >> 1) - (this.ITEM_HEIGHT >> 1);
        if (this.displayState == 1) {
            g.drawImage(this.machineTopImage, machineX, machineY, 20);
            if (this.machine.supportsHolds() && this.machine.supportsNudges()) {
                if (this.machineAltBaseImage != null) {
                    g.drawImage(this.machineAltBaseImage, machineX, g.unscale(this.machineTopImage.getHeight()), 20);
                }
                if (this.bannerImage[this.selectedMachine] != null) {
                    g.drawImage(this.bannerImage[this.selectedMachine], machineX + BANNER_POSITION[0], BANNER_POSITION[1] + 40 + machineY, 20);
                }
            } else {
                if (this.machineStandardBaseImage != null) {
                    g.drawImage(this.machineStandardBaseImage, machineX, g.unscale(this.machineTopImage.getHeight()), 20);
                }
                if (this.bannerImage[this.selectedMachine] != null) {
                    g.drawImage(this.bannerImage[this.selectedMachine], machineX + BANNER_POSITION[0], BANNER_POSITION[1] + machineY, 20);
                }
            }
            for (int reel = 0; reel < 3; ++reel) {
                int y = REEL_POSITION[reel][1];
                int tmpY = centreY - this.ITEM_HEIGHT;
                for (int symb = 0; symb < 3; ++symb) {
                    if (tmpY < y) {
                        g.setClip(machineX + REEL_POSITION[reel][0], y, this.ITEM_WIDTH, this.ITEM_HEIGHT - (y - tmpY));
                    } else if (tmpY + this.ITEM_HEIGHT > y + REEL_POSITION[reel][3]) {
                        g.setClip(machineX + REEL_POSITION[reel][0], tmpY, this.ITEM_WIDTH, y + REEL_POSITION[reel][3] - tmpY);
                    } else {
                        g.setClip(machineX + REEL_POSITION[reel][0], tmpY, this.ITEM_WIDTH, this.ITEM_HEIGHT);
                    }
                    if (this.itemImage[this.selectedMachine] != null) {
                        g.drawImage(this.itemImage[this.selectedMachine], machineX + REEL_POSITION[reel][0], tmpY - this.machine.getReelSymbol(reel, -1 + symb) * this.ITEM_HEIGHT, 20);
                    }
                    tmpY += this.ITEM_HEIGHT;
                }
                g.setClip(0, 0, sw, sh);
                g.drawImage(this.fadeImage, machineX + REEL_POSITION[reel][0], REEL_POSITION[reel][1], 20);
            }
            this.uiFont.drawString(g, "Loading ...", (sw - this.uiFont.stringWidth("Loading ...")) / 2, CASH_TEXT[1]);
        } else {
            for (int i = 0; i < this.machines.size(); ++i) {
                Machine m = (Machine)this.machines.elementAt(i);
                int x = sw * i - this.machineXOffset;
                g.drawImage(this.machineTopImage, x, machineY, 20);
                if (m.supportsHolds() && m.supportsNudges()) {
                    if (this.machineAltBaseImage != null) {
                        g.drawImage(this.machineAltBaseImage, x, g.unscale(this.machineTopImage.getHeight()), 20);
                    }
                    if (this.bannerImage[i] != null) {
                        g.drawImage(this.bannerImage[i], x + BANNER_POSITION[0], BANNER_POSITION[1] + 40 + machineY, 20);
                    }
                } else {
                    if (this.machineStandardBaseImage != null) {
                        g.drawImage(this.machineStandardBaseImage, x, g.unscale(this.machineTopImage.getHeight()), 20);
                    }
                    if (this.bannerImage[i] != null) {
                        g.drawImage(this.bannerImage[i], x + BANNER_POSITION[0], BANNER_POSITION[1] + machineY, 20);
                    }
                }
                for (int reel = 0; reel < 3; ++reel) {
                    int y = REEL_POSITION[reel][1];
                    int tmpY = centreY - this.ITEM_HEIGHT;
                    for (int symb = 0; symb < 3; ++symb) {
                        if (tmpY < y) {
                            g.setClip(x + REEL_POSITION[reel][0], y, this.ITEM_WIDTH, this.ITEM_HEIGHT - (y - tmpY));
                        } else if (tmpY + this.ITEM_HEIGHT > y + REEL_POSITION[reel][3]) {
                            g.setClip(x + REEL_POSITION[reel][0], tmpY, this.ITEM_WIDTH, y + REEL_POSITION[reel][3] - tmpY);
                        } else {
                            g.setClip(x + REEL_POSITION[reel][0], tmpY, this.ITEM_WIDTH, this.ITEM_HEIGHT);
                        }
                        if (this.itemImage[i] != null) {
                            g.drawImage(this.itemImage[i], x + REEL_POSITION[reel][0], tmpY - m.getReelSymbol(reel, -1 + symb) * this.ITEM_HEIGHT, 20);
                        }
                        tmpY += this.ITEM_HEIGHT;
                    }
                    g.setClip(0, 0, sw, sh);
                    g.drawImage(this.fadeImage, x + REEL_POSITION[reel][0], REEL_POSITION[reel][1], 20);
                }
                g.setClip(0, 0, sw, sh);
                int panelW = sw - 20;
                int panelH = 110;
                int panelX = sw - panelW >> 1;
                if (x + panelX + panelW >= 0 && x < sw) {
                    int panelY = 5;
                    FrameRenderer.renderFrame(g, x + panelX, panelY, panelW, panelH);
                    Common.largeFont.drawString(g, m.getName(), x + (sw - Common.largeFont.stringWidth(m.getName()) >> 1), panelY + 5);
                    int lineY = panelY + 27;
                    for (int l = 0; l < this.lines[i].length; ++l) {
                        Common.normalFont.drawString(g, this.lines[i][l], x + (sw - Common.normalFont.stringWidth(this.lines[i][l]) >> 1), lineY);
                        lineY += Common.normalFont.getHeight() - 1;
                    }
                }
                if (this.selectedMachine > 0 && this.handLeftImage != null) {
                    g.drawImage(this.handLeftImage, 5 + this.handX, sh - g.unscale(this.handLeftImage.getHeight()) >> 1, 20);
                }
                if (this.selectedMachine < 3 && this.handRightImage != null) {
                    g.drawImage(this.handRightImage, sw - 5 - this.handX - g.unscale(this.handRightImage.getWidth()), sh - g.unscale(this.handRightImage.getHeight()) >> 1, 20);
                }
                MachineCanvas.drawLeftCommand(g, Strings.CMD_SELECT, Common.largeFont);
                MachineCanvas.drawRightCommand(g, Strings.CMD_MENU, Common.largeFont);
            }
        }
    }

    public void renderPayTable(GraphicsScaler g) {
        int sw = g.getWidth();
        int sh = g.getHeight();
        if (this.payTableImage != null) {
            if (this.payTableImage.getHeight() <= g.getRealHeight()) {
                for (int meshX = 0; meshX < sw; meshX += 48) {
                    for (int meshY = 0; meshY < sh; meshY += 64) {
                        g.drawImage(Common.meshImage, meshX, meshY, 20);
                    }
                }
                g.getGraphics().drawImage(this.payTableImage, 0, (g.getRealHeight() - this.payTableImage.getHeight()) / 2, 20);
            } else {
                g.getGraphics().drawImage(this.payTableImage, 0, this.paytableYOffset, 20);
            }
        }
        MachineCanvas.drawRightCommand(g, Strings.CMD_OK, Common.largeFont);
    }

    public void renderPopupMenu(GraphicsScaler g) {
        int sw = g.getWidth();
        int sh = g.getHeight();
        for (int meshX = 0; meshX < sw; meshX += 48) {
            for (int meshY = 0; meshY < sh; meshY += 64) {
                g.drawImage(Common.meshImage, meshX, meshY, 20);
            }
        }
        int pIH = Common.largeFont.getHeight() + 4;
        int pH = pIH * this.popupMenuItems.size();
        int pW = 150;
        int pX = 3;
        int pY = sh - Common.largeFont.getHeight() - 4 - pH;
        g.setColor(3042334);
        g.fillRect(pX, pY, pW, pH);
        g.setColor(5158195);
        g.fillRect(pX, pY + this.popupMenuSelectedIndex * pIH, pW, pIH);
        g.setColor(0xFFFFFF);
        g.drawRect(pX, pY, pW - 1, pH);
        for (int i = 0; i < this.popupMenuItems.size(); ++i) {
            MenuItem menuItem = (MenuItem)this.popupMenuItems.elementAt(i);
            if (i == this.popupMenuSelectedIndex) {
                Common.largeFont.drawString(g, menuItem.getLabel(), pX + 5, pY + pIH * i + 2);
                continue;
            }
            Common.largeFontDisabled.drawString(g, menuItem.getLabel(), pX + 5, pY + pIH * i + 2);
        }
    }

    public void renderInfoWindow(GraphicsScaler g, String title) {
        int sw = g.getWidth();
        int sh = g.getHeight();
        for (int meshX = 0; meshX < sw; meshX += 48) {
            for (int meshY = 0; meshY < sh; meshY += 64) {
                g.drawImage(Common.meshImage, meshX, meshY, 20);
            }
        }
        if (this.boxFrame < this.boxNumFrames) {
            int tmpH;
            int tmpW;
            if (this.displayBox == this.BOX_REVEAL) {
                tmpW = this.boxFrame * (this.boxW / this.boxNumFrames);
                tmpH = this.boxFrame * (this.boxH / this.boxNumFrames);
                FrameRenderer.renderFrame(g, sw >> 1, sh - Common.largeFont.getHeight() >> 1, tmpW, tmpH, 3, null);
            } else if (this.displayBox == this.BOX_HIDE) {
                tmpW = (this.boxNumFrames - this.boxFrame) * (this.boxW / this.boxNumFrames);
                tmpH = (this.boxNumFrames - this.boxFrame) * (this.boxH / this.boxNumFrames);
                FrameRenderer.renderFrame(g, sw >> 1, sh - Common.largeFont.getHeight() >> 1, tmpW, tmpH, 3, null);
            }
        } else {
            if (this.displayMessage) {
                int boxX = sw - this.boxW >> 1;
                int boxY = sh - this.boxH - Common.largeFont.getHeight() >> 1;
                FrameRenderer.renderFrame(g, boxX, boxY, this.boxW, this.boxH, 20, null);
                int lineY = sh - Common.largeFont.getHeight() - Common.normalFont.getHeight() * this.infoLines.length >> 1;
                if (this.infoLines != null) {
                    for (int i = 0; i < this.infoLines.length; ++i) {
                        Common.normalFont.drawString(g, this.infoLines[i], sw - Common.normalFont.stringWidth(this.infoLines[i]) >> 1, lineY);
                        lineY += Common.normalFont.getHeight();
                    }
                }
            } else if (this.displayHint) {
                FrameRenderer.renderFrame(g, 15, 15, this.boxW, this.boxH, 20, null);
                int lineY = 25;
                Common.largeFont.drawString(g, title, 25, lineY);
                int scrollY = lineY += 2 * Common.largeFont.getHeight();
                if (this.infoLines != null) {
                    for (int i = 0; i < this.maxLines && i + this.lineOffset < this.infoLines.length; ++i) {
                        Common.normalFont.drawString(g, this.infoLines[i + this.lineOffset], 25, lineY);
                        lineY += Common.normalFont.getHeight();
                    }
                }
                if (this.infoLines.length > this.maxLines) {
                    int scrollBarHeight = Common.normalFont.getHeight() * this.maxLines;
                    g.setColor(0);
                    g.fillRect(15 + this.boxW - 12, scrollY, 3, scrollBarHeight);
                    int maxBarPos = scrollBarHeight - 3 - g.unscale(Common.scrollerImage.getHeight());
                    int offset = maxBarPos * 10000 / (this.infoLines.length - this.maxLines) * this.lineOffset / 10000;
                    if (this.infoLines.length - this.lineOffset <= this.maxLines) {
                        offset = maxBarPos;
                    }
                    g.drawImage(Common.scrollerImage, 15 + this.boxW - 14, scrollY + 2 + offset, 20);
                }
            }
            MachineCanvas.drawRightCommand(g, Strings.CMD_OK, Common.largeFont);
        }
    }

    public void keyReleasedEvent(int keyCode, int ga, int softkey) {
        this.scrollDirection = 0;
    }

    public void keyPressedEvent(int keyCode, int ga, int softkey) {
        if (this.displayHint || this.displayMessage) {
            if (softkey == 2 || softkey == 1) {
                if (Settings.DISABLE_ANIMATING_PANELS) {
                    this.displayHint = false;
                    this.displayMessage = false;
                } else {
                    this.displayBox = this.BOX_HIDE;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                }
                return;
            }
            if ((ga == 1 || ga == 6) && this.infoLines.length > this.maxLines) {
                if (ga == 1) {
                    this.scrollDirection = -1;
                } else if (ga == 6) {
                    this.scrollDirection = 1;
                }
            }
            return;
        }
        if (this.displayPaytable) {
            if (ga == 1) {
                this.paytableYV = 10;
            } else if (ga == 6) {
                this.paytableYV = -10;
            } else if (softkey == 2 || softkey == 1) {
                this.displayPaytable = false;
            }
            return;
        }
        if (this.displayPopupMenu) {
            if (softkey == 2) {
                this.displayPopupMenu = false;
            } else if (ga == 1) {
                this.popupMenuSelectedIndex = this.popupMenuSelectedIndex == 0 ? this.popupMenuItems.size() - 1 : --this.popupMenuSelectedIndex;
            } else if (ga == 6) {
                this.popupMenuSelectedIndex = this.popupMenuSelectedIndex == this.popupMenuItems.size() - 1 ? 0 : ++this.popupMenuSelectedIndex;
            } else if (ga == 8 || softkey == 1) {
                MenuItem selectedMenuItem = (MenuItem)this.popupMenuItems.elementAt(this.popupMenuSelectedIndex);
                this.activatePopupMenu(selectedMenuItem.getId());
            }
            return;
        }
        if (this.displayState == 2) {
            if (softkey == 1) {
                if (this.machineState == 0) {
                    this.displayPopupMenu();
                }
            } else if (ga == 2 && this.machineState == 0) {
                if (this.holdButtonsSelected) {
                    this.selectedHoldButton = this.selectedHoldButton == 0 ? 2 : (this.selectedHoldButton == 3 ? 5 : --this.selectedHoldButton);
                } else {
                    this.selectedButton = this.selectedButton == 0 ? 2 : --this.selectedButton;
                }
            } else if (ga == 5 && this.machineState == 0) {
                if (this.holdButtonsSelected) {
                    this.selectedHoldButton = this.selectedHoldButton == 2 ? 0 : (this.selectedHoldButton == 5 ? 3 : ++this.selectedHoldButton);
                } else {
                    this.selectedButton = this.selectedButton == 2 ? 0 : ++this.selectedButton;
                }
            } else if (ga == 8 && this.machineState == 0) {
                if (this.holdButtonsSelected) {
                    switch (this.selectedHoldButton) {
                        case 0: {
                            this.activateButton(3);
                            break;
                        }
                        case 1: {
                            this.activateButton(4);
                            break;
                        }
                        case 2: {
                            this.activateButton(5);
                            break;
                        }
                        case 3: {
                            this.activateButton(6);
                            break;
                        }
                        case 4: {
                            this.activateButton(7);
                            break;
                        }
                        case 5: {
                            this.activateButton(8);
                        }
                    }
                } else if (this.selectedButton == 0) {
                    this.activateButton(0);
                } else if (this.selectedButton == 2) {
                    this.activateButton(2);
                } else if (this.selectedButton == 1) {
                    this.activateButton(1);
                }
            } else if (ga == 6 && this.machineState == 0) {
                if (this.holdButtonsSelected) {
                    if (this.selectedHoldButton < 3) {
                        this.selectedHoldButton += 3;
                    }
                } else if (this.machine.supportsHolds() && this.machine.supportsNudges() && (this.machine.numNudgesAvailable() > 0 || this.machine.numHoldsAvailable() > 0 || this.machine.reelHeld(0) || this.machine.reelHeld(1) || this.machine.reelHeld(2))) {
                    this.selectedHoldButton = this.selectedButton == 2 ? 1 : 0;
                    this.holdButtonsSelected = true;
                }
            } else if (ga == 1 && this.machineState == 0) {
                if (this.holdButtonsSelected && this.selectedHoldButton >= 3) {
                    this.selectedHoldButton -= 3;
                } else {
                    this.selectedButton = this.selectedHoldButton >= 1 ? 2 : 0;
                    this.holdButtonsSelected = false;
                }
            }
        } else if (this.displayState == 0) {
            if (softkey == 2) {
                this.parent.displayMainMenu();
            } else if (ga == 2) {
                this.xv = 120;
                if (this.selectedMachine > 0) {
                    --this.selectedMachine;
                }
            } else if (ga == 5) {
                this.xv = 120;
                if (this.selectedMachine < this.machines.size() - 1) {
                    ++this.selectedMachine;
                }
            } else if (ga == 8 || softkey == 1) {
                this.machine = (Machine)this.machines.elementAt(this.selectedMachine);
                this.parent.loadMachine();
            }
        }
    }

    public void pointerPressedEvent(int x, int y) {
        block19: {
            block17: {
                block20: {
                    block18: {
                        if (this.displayHint || this.displayMessage) {
                            return;
                        }
                        if (this.displayState != 0) break block17;
                        if (x >= 50) break block18;
                        this.xv = 120;
                        if (this.selectedMachine > 0) {
                            --this.selectedMachine;
                        }
                        break block19;
                    }
                    if (x <= 190) break block20;
                    this.xv = 120;
                    if (this.selectedMachine < this.machines.size() - 1) {
                        ++this.selectedMachine;
                    }
                    break block19;
                }
                if (x <= 95 || x >= 145) break block19;
                this.machine = (Machine)this.machines.elementAt(this.selectedMachine);
                this.parent.loadMachine();
                break block19;
            }
            if (this.displayState == 2 && this.machineState == 0) {
                int i;
                if (this.displayPopupMenu) {
                    int pIH = Common.largeFont.getHeight() + 4;
                    int pH = pIH * this.popupMenuItems.size();
                    int pW = 150;
                    int pX = 3;
                    int pY = 320 - Common.largeFont.getHeight() - 4 - pH;
                    for (int i2 = 0; i2 < this.popupMenuItems.size(); ++i2) {
                        if (x < pX || x > pX + pW || y < pY + i2 * pIH || y > pY + i2 * pIH + pIH) continue;
                        if (this.popupMenuSelectedIndex != i2) {
                            this.popupMenuSelectedIndex = i2;
                        } else {
                            this.activatePopupMenu(i2);
                        }
                        return;
                    }
                    return;
                }
                for (i = 0; i < 3; ++i) {
                    if (x < STANDARD_BUTTON_AREA[i][0] || x > STANDARD_BUTTON_AREA[i][0] + STANDARD_BUTTON_AREA[i][2] || y < STANDARD_BUTTON_AREA[i][1] || y > STANDARD_BUTTON_AREA[i][1] + STANDARD_BUTTON_AREA[i][3]) continue;
                    if (i != this.selectedButton || this.holdButtonsSelected) {
                        this.selectedButton = i;
                        this.holdButtonsSelected = false;
                        continue;
                    }
                    if (i == 1) {
                        this.activateButton(1);
                        continue;
                    }
                    if (i == 0) {
                        this.activateButton(0);
                        continue;
                    }
                    if (i != 2) continue;
                    this.activateButton(2);
                }
                if (this.machine.supportsHolds() && this.machine.supportsNudges()) {
                    for (i = 0; i < 6; ++i) {
                        if (x < HOLD_BUTTON_AREA[i][0] || x > HOLD_BUTTON_AREA[i][0] + HOLD_BUTTON_AREA[i][2] || y < HOLD_BUTTON_AREA[i][1] || y > HOLD_BUTTON_AREA[i][1] + HOLD_BUTTON_AREA[i][3]) continue;
                        if (i < 3) {
                            if (this.machine.numHoldsAvailable() <= 0 && !this.machine.reelHeld(0) && !this.machine.reelHeld(1) && !this.machine.reelHeld(2)) continue;
                            if (this.selectedHoldButton != i || !this.holdButtonsSelected) {
                                this.selectedHoldButton = i;
                                this.holdButtonsSelected = true;
                                continue;
                            }
                            this.activateButton(3 + i);
                            continue;
                        }
                        if (this.machine.numNudgesAvailable() <= 0) continue;
                        if (this.selectedHoldButton != i || !this.holdButtonsSelected) {
                            this.selectedHoldButton = i;
                            this.holdButtonsSelected = true;
                            continue;
                        }
                        this.activateButton(6 + (i - 3));
                    }
                }
            }
        }
    }

    public void activateButton(int buttonNum) {
        switch (buttonNum) {
            case 1: {
                int n = this.betAmount = this.betAmount == 3 ? 1 : this.betAmount + 1;
                if (this.betAmount == 3) {
                    Common.doSound("3coin");
                    break;
                }
                if (this.betAmount == 2) {
                    Common.doSound("2coin");
                    break;
                }
                Common.doSound("1coin");
                break;
            }
            case 2: {
                this.betAmount = 3;
                if (this.cash < this.betAmount) {
                    this.displayMessage("Sorry, you don't have enough money to place that bet");
                    return;
                }
                if (Common.soundEnabled) {
                    this.preCacheStartTime = System.currentTimeMillis();
                    this.reelsStopped = 0;
                    this.spinUpCounter = 0;
                    this.donePreBounce = false;
                    this.machineState = 1;
                    this.machine.spin();
                    Common.cacheSound(this.machine.getPayout(this.betAmount) > 0 ? "spin_win" : "spin");
                    break;
                }
                this.reelsStopped = 0;
                this.spinUpCounter = 0;
                this.donePreBounce = false;
                this.machineState = 2;
                this.machine.spin();
                this.startSpin(false);
                break;
            }
            case 0: {
                if (this.cash < this.betAmount) {
                    this.displayMessage("Sorry, you don't have enough money to place that bet");
                    return;
                }
                if (Common.soundEnabled) {
                    this.preCacheStartTime = System.currentTimeMillis();
                    this.reelsStopped = 0;
                    this.spinUpCounter = 0;
                    this.donePreBounce = false;
                    this.machineState = 1;
                    this.machine.spin();
                    Common.cacheSound(this.machine.getPayout(this.betAmount) > 0 ? "spin_win" : "spin");
                    break;
                }
                this.reelsStopped = 0;
                this.spinUpCounter = 0;
                this.donePreBounce = false;
                this.machineState = 2;
                this.machine.spin();
                this.startSpin(false);
                break;
            }
            case 3: {
                this.machine.toggleHold(0);
                break;
            }
            case 4: {
                this.machine.toggleHold(1);
                break;
            }
            case 5: {
                this.machine.toggleHold(2);
                break;
            }
            case 6: {
                if (!this.machine.nudge(0)) break;
                Common.doSound("nudge");
                this.nudgeOffset = 0;
                this.nudgingReel = 0;
                this.nudgeYV = this.ITEM_HEIGHT - this.ITEM_HEIGHT / 3;
                this.machineState = 5;
                break;
            }
            case 7: {
                if (!this.machine.nudge(1)) break;
                Common.doSound("nudge");
                this.nudgeOffset = 0;
                this.nudgingReel = 1;
                this.nudgeYV = this.ITEM_HEIGHT - this.ITEM_HEIGHT / 3;
                this.machineState = 5;
                break;
            }
            case 8: {
                if (!this.machine.nudge(2)) break;
                Common.doSound("nudge");
                this.nudgeOffset = 0;
                this.nudgingReel = 2;
                this.nudgeYV = this.ITEM_HEIGHT - this.ITEM_HEIGHT / 3;
                this.machineState = 5;
            }
        }
    }

    public void soundManagerEvent(SoundManager soundMan, int eventType) {
        System.out.println("soundManagerEvent: " + SoundManager.EVENT_NAMES[eventType] + " @ " + System.currentTimeMillis());
        if (this.machineState == 1) {
            if (eventType == 2) {
                this.startSpin(true);
            } else if (eventType == 7 || eventType == 8) {
                this.startSpin(false);
            }
        }
    }

    public void startSpin(boolean playSound) {
        this.machineState = 2;
        this.spinStartTime = System.currentTimeMillis();
        this.spinBetAmount = this.betAmount;
        this.cash -= this.spinBetAmount;
        if (playSound) {
            if (this.machine.getPayout(this.betAmount) > 0) {
                Common.doSound("spin_win");
            } else {
                Common.doSound("spin");
            }
        }
    }

    public void saveCurrentHighscore() {
        if (this.displayState != 0 && this.machine != null && this.machine.getHighestScore() < this.totalWinnings) {
            this.machine.setHighestScore(this.totalWinnings);
            this.machine.saveHighestScore();
        }
    }

    public void displayHint() {
        this.displayBox = this.BOX_REVEAL;
        this.boxFrame = 0;
        this.boxNumFrames = 5;
        if (Settings.DISABLE_ANIMATING_PANELS) {
            this.boxFrame = this.boxNumFrames;
        }
        this.boxW = 210;
        this.boxH = 320 - Common.largeFont.getHeight() - 30;
        this.lineOffset = 0;
        this.maxLines = this.boxH - 20 - Common.largeFont.getHeight() - 2 * Common.normalFont.getHeight();
        this.maxLines /= Common.normalFont.getHeight();
        this.infoLines = Common.normalFont.wrap(this.machine.getHint(), 180);
        this.displayHint = true;
    }

    public void displayMessage(String message) {
        this.displayBox = this.BOX_REVEAL;
        this.boxFrame = 0;
        this.boxNumFrames = 5;
        if (Settings.DISABLE_ANIMATING_PANELS) {
            this.boxFrame = this.boxNumFrames;
        }
        this.boxW = 210;
        this.boxH = Common.normalFont.getHeight() * 5;
        this.lineOffset = 0;
        this.maxLines = (this.boxH - 20) / Common.normalFont.getHeight();
        this.infoLines = Common.normalFont.wrap(message, 180);
        this.displayMessage = true;
    }

    public void displayPopupMenu() {
        this.popupMenuItems.removeAllElements();
        this.popupMenuItems.addElement(new MenuItem(Strings.CMD_OPTIONS_MENU[0], 0));
        this.popupMenuItems.addElement(new MenuItem(Strings.CMD_OPTIONS_MENU[1], 1));
        this.popupMenuItems.addElement(new MenuItem(Strings.CMD_OPTIONS_MENU[2], 2));
        this.popupMenuItems.addElement(new MenuItem(Strings.CMD_OPTIONS_MENU[3], 3));
        this.popupMenuSelectedIndex = 0;
        this.displayPopupMenu = true;
    }

    public void activatePopupMenu(int id) {
        this.displayPopupMenu = false;
        switch (id) {
            case 0: {
                this.activateButton(0);
                break;
            }
            case 1: {
                this.displayPaytable = true;
                break;
            }
            case 2: {
                this.displayHint();
                break;
            }
            case 3: {
                this.saveCurrentHighscore();
                this.saveGameState();
                this.parent.displayMainMenu();
            }
        }
    }

    public void saveGameState() {
        if (this.displayState != 2) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeBoolean(this.currentMachineCasinoStyle);
            os.writeInt(this.selectedMachine);
            os.writeInt(this.cash);
            os.writeInt(this.betAmount);
            os.writeInt(this.totalWinnings);
            byte[] machineData = this.machine.toByteArray();
            os.writeInt(machineData.length);
            os.write(machineData, 0, machineData.length);
            RecordManager.save(baos.toByteArray(), "session_data");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadGameState() {
        byte[] data = null;
        try {
            if (!RecordManager.exists("session_data")) {
                return;
            }
            data = RecordManager.load("session_data");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            Common.machineCasinoStyle = this.currentMachineCasinoStyle = is.readBoolean();
            this.selectedMachine = is.readInt();
            this.machine = (Machine)this.machines.elementAt(this.selectedMachine);
            this.machine.setMachineCasinoStyle(Common.machineCasinoStyle);
            this._cash = this.cash = is.readInt();
            this.betAmount = is.readInt();
            this.totalWinnings = is.readInt();
            int machineDataLen = is.readInt();
            byte[] machineData = new byte[machineDataLen];
            is.read(machineData);
            this.machine.fromByteArray(machineData);
            this.displayState = 2;
            this.machineState = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MenuItem {
        private String label = "";
        private int id = 0;

        public MenuItem(String label, int code) {
            this.label = label;
            this.id = code;
        }

        public String getLabel() {
            return this.label;
        }

        public int getId() {
            return this.id;
        }
    }
}

