/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.slots;

import java.util.Random;

public abstract class Machine {
    private Random rnd = null;

    public abstract void reset();

    public abstract void spin();

    public abstract void finishSpin();

    public abstract int getReelSymbol(int var1, int var2);

    public abstract int getPreviousReelSymbol(int var1, int var2);

    public abstract int getPayout(int var1);

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getHint();

    public abstract String getResourceFolder();

    public abstract int getNumSymbols();

    public abstract boolean supportsHolds();

    public abstract boolean supportsNudges();

    public abstract int numHoldsAvailable();

    public abstract int numNudgesAvailable();

    public abstract void toggleHold(int var1);

    public abstract boolean nudge(int var1);

    public abstract boolean reelHeld(int var1);

    public abstract void setMachineCasinoStyle(boolean var1);

    public abstract void loadHighestScore();

    public abstract void saveHighestScore();

    public abstract int getHighestScore();

    public abstract void setHighestScore(int var1);

    public abstract byte[] toByteArray();

    public abstract void fromByteArray(byte[] var1);

    public void seedRandom() {
        if (this.rnd == null) {
            this.rnd = new Random();
        } else {
            this.rnd.setSeed(System.currentTimeMillis());
        }
    }

    public int random(int max) {
        if (this.rnd == null) {
            this.rnd = new Random();
        }
        if (max == 0) {
            return 0;
        }
        return Math.abs(this.rnd.nextInt() % max);
    }
}

