/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.slots;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.slots.Machine;
import net.handyx.casinopack.slots.Strings;

public final class JuicyFruityMachine
extends Machine {
    public static final int LUCKY_SEVEN = 0;
    public static final int CHERRY = 1;
    public static final int DOUBLE_BELL = 2;
    public static final int BELL = 3;
    public static final int CLOVER = 4;
    public static final int DIAMOND = 5;
    public static final int HORSESHOE = 6;
    public static final int BAR = 7;
    public static final String[] ITEM_NAMES = new String[]{"Lucky Seven", "Cherry", "Double Bell", "Bell", "Clover", "Diamond", "Horseshoe", "Bar"};
    private final int[][] REEL = new int[][]{{3, 1, 3}, {2, 5, 1}, {5, 4, 5}, {1, 0, 2}, {5, 4, 4}, {4, 3, 1}, {0, 5, 3}, {3, 3, 4}, {4, 2, 3}, {1, 4, 5}, {2, 3, 1}, {5, 2, 7}, {4, 5, 4}, {3, 3, 3}, {1, 1, 0}, {5, 7, 4}, {2, 4, 5}, {3, 5, 4}, {7, 4, 5}, {1, 2, 4}};
    private int[] BW = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096};
    private final int[][] PAYOUTS = new int[][]{{this.BW[0], this.BW[0], this.BW[0], 500, 1000, 2000}, {this.BW[7], this.BW[7], this.BW[7], 100, 200, 300}, {this.BW[2], this.BW[2], this.BW[2], 50, 100, 150}, {this.BW[5], this.BW[5], this.BW[5], 20, 40, 60}, {this.BW[3], this.BW[3], this.BW[3], 15, 30, 45}, {this.BW[1], this.BW[1], this.BW[1], 10, 20, 30}, {this.BW[1], this.BW[1], 0xFFFFFF, 5, 10, 15}, {this.BW[1], 0xFFFFFF, 0xFFFFFF, 2, 4, 6}, {this.BW[4], this.BW[4], this.BW[4], 1, 2, 3}};
    private int[] reelLookupPosition;
    private int[] result = new int[3];
    private int[] prevResult = null;
    private int[] prevReelLookupPosition = null;
    private static final int[] INITIAL_REEL_POSITION = new int[]{6, 3, 14};
    private boolean casinoPlayStyle = true;
    private int nudgesAvailable = 0;
    private int holdsAvailable = 0;
    private boolean[] holdReels;
    public int highestScore = 0;
    public int highestScoreCasino = 0;

    public JuicyFruityMachine() {
        this.reelLookupPosition = new int[3];
        this.prevReelLookupPosition = new int[3];
        this.prevResult = new int[3];
        this.holdReels = new boolean[3];
        this.reset();
    }

    public void reset() {
        this.holdsAvailable = 0;
        this.nudgesAvailable = 0;
        for (int i = 0; i < 3; ++i) {
            this.result[i] = this.REEL[INITIAL_REEL_POSITION[i]][i];
            this.prevResult[i] = this.result[i];
            this.reelLookupPosition[i] = INITIAL_REEL_POSITION[i];
            this.prevReelLookupPosition[i] = this.reelLookupPosition[i];
            this.holdReels[i] = false;
        }
    }

    public void calculateStats() {
        long[] probability = new long[this.PAYOUTS.length];
        int totalCombinations = 8000;
        int winningCombinations = 0;
        System.out.println("--- " + this.getName() + " stats ------------------------");
        System.out.println("\tTotal Combinations=" + totalCombinations);
        long totalPayout = 0L;
        for (int i = 0; i < this.PAYOUTS.length; ++i) {
            long prob = 1L;
            for (int r = 0; r < 3; ++r) {
                long count = 0L;
                for (int rpos = 0; rpos < this.REEL.length; ++rpos) {
                    int symbol = this.BW[this.REEL[rpos][r]];
                    if (this.PAYOUTS[i][r] == 0xFFFFFF) {
                        int payoutSymbol = this.PAYOUTS[i][0];
                        if (r == 2 && this.PAYOUTS[i][1] == 0xFFFFFF) {
                            ++count;
                            continue;
                        }
                        if ((payoutSymbol & this.BW[this.REEL[rpos][r]]) == this.BW[this.REEL[rpos][r]]) continue;
                        ++count;
                        continue;
                    }
                    if ((this.PAYOUTS[i][r] & symbol) != symbol) continue;
                    ++count;
                }
                prob *= count;
            }
            probability[i] = prob * (long)this.PAYOUTS[i][3];
            winningCombinations = (int)((long)winningCombinations + prob);
            totalPayout += probability[i];
            System.out.println("\tPayout " + i + " = " + probability[i] + "/" + totalCombinations);
        }
        long totalPay = totalPayout * 10000L / (long)totalCombinations;
        if (totalPay > 10000L) {
            System.out.println("\tTotal Payout=" + totalPay);
        } else {
            System.out.println("\tTotal Payout=0." + totalPay);
        }
        System.out.println("\tWinning spins: " + winningCombinations * 100 / totalCombinations + "%");
    }

    public void spin() {
        this.seedRandom();
        if (!this.holdReels[0]) {
            this.reelLookupPosition[0] = this.random(this.REEL.length);
        }
        if (!this.holdReels[1]) {
            this.reelLookupPosition[1] = this.random(this.REEL.length);
        }
        if (!this.holdReels[2]) {
            this.reelLookupPosition[2] = this.random(this.REEL.length);
        }
        this.result[0] = this.REEL[this.reelLookupPosition[0]][0];
        this.result[1] = this.REEL[this.reelLookupPosition[1]][1];
        this.result[2] = this.REEL[this.reelLookupPosition[2]][2];
    }

    public void finishSpin() {
        if (!(this.getPayout(1) != 0 || this.holdReels[0] || this.holdReels[1] || this.holdReels[2])) {
            int matches = 0;
            int chances = 100;
            for (int i = 0; i < this.PAYOUTS.length; ++i) {
                matches = 0;
                if ((this.PAYOUTS[i][0] & this.BW[this.result[0]]) == this.BW[this.result[0]]) {
                    ++matches;
                }
                if ((this.PAYOUTS[i][1] & this.BW[this.result[1]]) == this.BW[this.result[1]]) {
                    ++matches;
                }
                if ((this.PAYOUTS[i][2] & this.BW[this.result[2]]) == this.BW[this.result[2]]) {
                    ++matches;
                }
                if (matches != 2) continue;
                chances = 150;
            }
            int n = this.random(chances);
            if (n < 60) {
                this.holdsAvailable = 1;
            }
            if (n < 25) {
                this.holdsAvailable = 2;
            }
            if ((n = this.random(chances)) < 40) {
                this.nudgesAvailable = 1;
            }
            if (n < 20) {
                this.nudgesAvailable = 2;
            }
            if (n < 10) {
                this.nudgesAvailable = 3;
            }
        } else {
            this.holdsAvailable = 0;
            this.nudgesAvailable = 0;
        }
        for (int i = 0; i < 3; ++i) {
            this.prevReelLookupPosition[i] = this.reelLookupPosition[i];
            this.prevResult[i] = this.result[i];
            this.holdReels[i] = false;
        }
    }

    public int getReelSymbol(int reelNum, int offset) {
        int reelPosition = this.reelLookupPosition[reelNum];
        if (offset == 0) {
            return this.REEL[reelPosition][reelNum];
        }
        if ((reelPosition += offset) >= this.REEL.length) {
            reelPosition -= this.REEL.length;
        } else if (reelPosition < 0) {
            reelPosition += this.REEL.length;
        }
        return this.REEL[reelPosition][reelNum];
    }

    public int getPreviousReelSymbol(int reelNum, int offset) {
        int reelPosition = this.prevReelLookupPosition[reelNum];
        if (offset == 0) {
            return this.REEL[reelPosition][reelNum];
        }
        if ((reelPosition += offset) >= this.REEL.length) {
            reelPosition -= this.REEL.length;
        } else if (reelPosition < 0) {
            reelPosition += this.REEL.length;
        }
        return this.REEL[reelPosition][reelNum];
    }

    public int getPayout(int nCoins) {
        for (int i = 0; i < this.PAYOUTS.length; ++i) {
            if ((this.PAYOUTS[i][0] & this.BW[this.result[0]]) != this.BW[this.result[0]] || (this.PAYOUTS[i][1] & this.BW[this.result[1]]) != this.BW[this.result[1]] || (this.PAYOUTS[i][2] & this.BW[this.result[2]]) != this.BW[this.result[2]]) continue;
            return this.PAYOUTS[i][3 + (nCoins - 1)];
        }
        return 0;
    }

    public String getResourceFolder() {
        return "/symbols/juicy";
    }

    public int getNumSymbols() {
        return ITEM_NAMES.length;
    }

    public String getName() {
        return "Lucky 777";
    }

    public String getDescription() {
        return "Feeling Lucky? Try your luck with this action packed slot machine";
    }

    public String getHint() {
        String s = Strings.fill("Total Payout: 89.75%\nWinning Spins: 22%\nYour Highest Winnings: $$0\n\nAlthough the 'Lucky 777' machine features the lowest total payout it offers a 22% probability of winning on each spin. So if you love non-stop action this is the machine for you.\n\n", Integer.toString(this.getHighestScore()));
        if (!this.casinoPlayStyle) {
            s = s + "The ability and nudge and hold reels gives you a real advantage, if used wisely. It is best to only hold high paying symbols, to hold a low paying one will only reduce your chances of getting anything higher.\n\nThe way the machines are programmed means that the highest paying symbols are less likely to appear on the third reel than the first two, for this reason it is best to hold the highest symbols when they appear in the third reel.\n\nDon't hold reels for the sake of it, as when a reel is held and the reels spun, you will not recieve any more holds for that spin!\n\nNudges are a huge advantage but be careful not to nudge the reels to a lower payout when a higher one can also be made.";
        }
        s = s + "Many machines will payout slightly more if the maximum number of coins is played, so, if your budget allows, it is best to play the maximum number of coins each spin.\n\nContrary to popular belief, casino slot machines are infact totally random. So just because the machine hasn't paid out for a time doesn't mean that a jackpot is 'due'!\n\nEach paying line has a particular probability of coming up and the machines are programmed to payout at a rate of anything from 80% to 95%.\n";
        return s;
    }

    public boolean supportsHolds() {
        return !this.casinoPlayStyle;
    }

    public boolean supportsNudges() {
        return !this.casinoPlayStyle;
    }

    public int numHoldsAvailable() {
        return this.casinoPlayStyle ? 0 : this.holdsAvailable;
    }

    public int numNudgesAvailable() {
        return this.casinoPlayStyle ? 0 : this.nudgesAvailable;
    }

    public void toggleHold(int reelNum) {
        if (this.holdReels[reelNum]) {
            this.holdReels[reelNum] = false;
            ++this.holdsAvailable;
        } else if (this.holdsAvailable > 0) {
            this.holdReels[reelNum] = true;
            --this.holdsAvailable;
        }
    }

    public boolean reelHeld(int reelNum) {
        return this.holdReels[reelNum];
    }

    public boolean nudge(int reelNum) {
        if (this.nudgesAvailable > 0) {
            --this.nudgesAvailable;
            int reelPosition = this.reelLookupPosition[reelNum];
            if (--reelPosition < 0) {
                reelPosition += this.REEL.length;
            }
            this.reelLookupPosition[reelNum] = reelPosition;
            this.result[reelNum] = this.REEL[reelPosition][reelNum];
            this.prevReelLookupPosition[reelNum] = reelPosition;
            return true;
        }
        return false;
    }

    public void setMachineCasinoStyle(boolean casinoStyle) {
        this.casinoPlayStyle = casinoStyle;
    }

    public void loadHighestScore() {
        try {
            if (RecordManager.exists("hs_dt")) {
                this.highestScore = RecordManager.byteArrayToInt(RecordManager.load("hs_lucky"));
                this.highestScoreCasino = RecordManager.byteArrayToInt(RecordManager.load("hs_lucky_casino"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveHighestScore() {
        try {
            RecordManager.save(this.highestScore, "hs_lucky");
            RecordManager.save(this.highestScoreCasino, "hs_lucky_casino");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHighestScore() {
        if (this.casinoPlayStyle) {
            return this.highestScoreCasino;
        }
        return this.highestScore;
    }

    public void setHighestScore(int s) {
        if (this.casinoPlayStyle) {
            this.highestScoreCasino = s;
        } else {
            this.highestScore = s;
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            for (int i = 0; i < 3; ++i) {
                os.writeInt(this.reelLookupPosition[i]);
                os.writeInt(this.prevReelLookupPosition[i]);
                os.writeBoolean(this.holdReels[i]);
            }
            os.writeInt(this.nudgesAvailable);
            os.writeInt(this.holdsAvailable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            for (int i = 0; i < 3; ++i) {
                this.reelLookupPosition[i] = is.readInt();
                this.prevReelLookupPosition[i] = is.readInt();
                this.holdReels[i] = is.readBoolean();
            }
            this.nudgesAvailable = is.readInt();
            this.holdsAvailable = is.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

