/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.common;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.ImageFontRenderer;

public abstract class RunnableCanvas
extends Canvas {
    public static final int LSK = 1;
    public static final int RSK = 2;
    public static final int BACK_SK = 3;
    public static final int CLEAR_SK = 4;
    public static boolean FLIP_SOFT_KEYS = false;
    public static boolean SOFTKEYS_GENERATE_KEY_RELEASED = true;
    public static boolean DISABLE_SERVICE_REPAINTS = true;
    public static boolean ALLOW_LANDSCAPE = false;
    public static boolean USE_DOUBLE_BUFFER = false;
    public static final int[] LSK_VALUES = new int[]{-6, -21, -202, 21};
    public static final int[] RSK_VALUES = new int[]{-7, -22, -203, 22};
    public static final int[] BACK_KEY_VALUES = new int[]{-11};
    public static final int[] CLEAR_KEY_VALUES = new int[]{-8, -204};
    public boolean finishedRepainting = false;
    public boolean showNotifyCalled = false;
    private boolean isInLandscape = false;
    public static int screenWidth = 0;
    public static int screenHeight = 0;
    private static Image buffer = null;
    private static boolean touchpadEnabled = false;
    private static Image touchpadOnImage = null;
    private static Image touchpadOffImage = null;
    private static final int TOUCHPAD_NONE = -1;
    private static final int TOUCHPAD_LSK = 0;
    private static final int TOUCHPAD_RSK = 1;
    private static final int TOUCHPAD_BACK = 2;
    private static final int TOUCHPAD_LEFT = 3;
    private static final int TOUCHPAD_RIGHT = 4;
    private static final int TOUCHPAD_UP = 5;
    private static final int TOUCHPAD_DOWN = 6;
    private static final int TOUCHPAD_FIRE = 7;
    private static int touchpadDown = -1;
    private static int touchpadXOffset = 0;
    private static int touchpadYOffset = 0;
    private static int[][] TOUCHPAD_AREAS = new int[][]{{0, 0, 108, 34}, {252, 0, 108, 34}, {18, 90, 69, 69}, {96, 44, 52, 72}, {215, 44, 52, 72}, {137, 0, 86, 44}, {137, 116, 86, 44}, {151, 51, 59, 59}};

    public RunnableCanvas() {
        this.setFullScreenMode(true);
        screenWidth = this.getWidth();
        screenHeight = this.getHeight();
        if (USE_DOUBLE_BUFFER) {
            this.createBuffer();
        }
    }

    public final void showNotify() {
        if (!this.showNotifyCalled) {
            this.startNotify();
        }
        this.showNotifyCalled = true;
        touchpadDown = -1;
    }

    public final void hideNotify() {
        this.showNotifyCalled = false;
        this.stopNotify();
    }

    public static void loadTouchpadResources() {
        try {
            if (touchpadOnImage == null) {
                touchpadEnabled = true;
                touchpadOnImage = Image.createImage((String)"/touchpad_on.png");
                touchpadOffImage = Image.createImage((String)"/touchpad_off.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void purgeTouchpadResources() {
        touchpadOffImage = null;
        touchpadOnImage = null;
    }

    private void createBuffer() {
        if (buffer == null) {
            buffer = Image.createImage((int)screenWidth, (int)screenHeight);
        } else if (buffer.getWidth() != screenWidth || buffer.getHeight() != screenHeight) {
            buffer = Image.createImage((int)screenWidth, (int)screenHeight);
        }
    }

    public final void paint(Graphics g) {
        if (this.getHeight() > screenHeight) {
            screenWidth = this.getWidth();
            screenHeight = this.getHeight();
        }
        if (!ALLOW_LANDSCAPE && this.getWidth() > this.getHeight()) {
            this.isInLandscape = true;
            g.setColor(0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(0xFFFFFF);
            Font f = Font.getFont((int)0, (int)0, (int)8);
            g.setFont(f);
            g.drawString("Return handset to portrait mode to continue.", (this.getWidth() - f.stringWidth("Return handset to portrait mode to continue.")) / 2, (this.getHeight() - f.getHeight()) / 2, 20);
        } else if (USE_DOUBLE_BUFFER && buffer != null) {
            this.isInLandscape = false;
            Graphics bg = buffer.getGraphics();
            this.paintCanvas(bg, screenWidth, screenHeight);
            if (touchpadEnabled) {
                this.paintTouchpad(bg, screenWidth, screenHeight, touchpadDown);
            }
            g.drawImage(buffer, 0, 0, 20);
        } else {
            this.isInLandscape = false;
            this.paintCanvas(g, screenWidth, screenHeight);
            if (touchpadEnabled) {
                this.paintTouchpad(g, screenWidth, screenHeight, touchpadDown);
            }
        }
        this.finishedRepainting = true;
    }

    private void paintTouchpad(Graphics g, int sw, int sh, int keydown) {
        if (touchpadOffImage != null && touchpadOnImage != null) {
            touchpadXOffset = sw - touchpadOffImage.getWidth() >> 1;
            touchpadYOffset = sh - touchpadOffImage.getHeight();
            g.setClip(0, 0, sw, sh);
            g.drawImage(touchpadOffImage, touchpadXOffset, touchpadYOffset, 20);
            if (keydown != -1) {
                g.setClip(touchpadXOffset + TOUCHPAD_AREAS[keydown][0], touchpadYOffset + TOUCHPAD_AREAS[keydown][1], TOUCHPAD_AREAS[keydown][2], TOUCHPAD_AREAS[keydown][3]);
                g.drawImage(touchpadOnImage, touchpadXOffset, touchpadYOffset, 20);
                g.setClip(0, 0, sw, sh);
            }
        }
    }

    public void startNotify() {
    }

    public void stopNotify() {
    }

    public abstract void paintCanvas(Graphics var1, int var2, int var3);

    public void processFrame(int frameNum) {
    }

    public void loadResources() {
    }

    public void purgeResources() {
    }

    public void keyPressedEvent(int keyCode, int gameAction, int softkey) {
    }

    public void keyReleasedEvent(int keyCode, int gameAction, int softkey) {
    }

    public void pointerPressedEvent(int x, int y) {
    }

    public void pointerReleasedEvent(int x, int y) {
    }

    public final void pointerPressed(int x, int y) {
        if (this.isInLandscape) {
            return;
        }
        if (touchpadEnabled) {
            if (y >= touchpadYOffset) {
                for (int i = 0; i < TOUCHPAD_AREAS.length; ++i) {
                    int tpx = touchpadXOffset + TOUCHPAD_AREAS[i][0];
                    int tpy = touchpadYOffset + TOUCHPAD_AREAS[i][1];
                    int tpw = TOUCHPAD_AREAS[i][2];
                    int tph = TOUCHPAD_AREAS[i][3];
                    if (x < tpx || x > tpx + tpw || y < tpy || y > tpy + tph) continue;
                    touchpadDown = i;
                    System.out.println("touchpad down=" + touchpadDown);
                    switch (touchpadDown) {
                        case 0: {
                            this.keyPressedEvent(0, 0, 1);
                            break;
                        }
                        case 1: {
                            this.keyPressedEvent(0, 0, 2);
                            break;
                        }
                        case 2: {
                            this.keyPressedEvent(0, 0, 3);
                            break;
                        }
                        case 5: {
                            this.keyPressedEvent(this.getKeyCode(1), 1, 0);
                            break;
                        }
                        case 6: {
                            this.keyPressedEvent(this.getKeyCode(6), 6, 0);
                            break;
                        }
                        case 3: {
                            this.keyPressedEvent(this.getKeyCode(2), 2, 0);
                            break;
                        }
                        case 4: {
                            this.keyPressedEvent(this.getKeyCode(5), 5, 0);
                            break;
                        }
                        case 7: {
                            this.keyPressedEvent(this.getKeyCode(8), 8, 0);
                        }
                    }
                    return;
                }
                return;
            }
        } else if (y > screenHeight - 20) {
            if (x > 0 && x < screenWidth >> 1) {
                this.keyPressedEvent(0, 0, 1);
            } else {
                this.keyPressedEvent(0, 0, 2);
            }
            return;
        }
        this.pointerPressedEvent(x, y);
    }

    public final void pointerReleased(int x, int y) {
        if (this.isInLandscape) {
            return;
        }
        if (touchpadEnabled) {
            if (y >= touchpadYOffset && touchpadDown != -1) {
                int tpx = touchpadXOffset + TOUCHPAD_AREAS[touchpadDown][0];
                int tpy = touchpadYOffset + TOUCHPAD_AREAS[touchpadDown][1];
                int tpw = TOUCHPAD_AREAS[touchpadDown][2];
                int tph = TOUCHPAD_AREAS[touchpadDown][3];
                if (x >= tpx && x <= tpx + tpw && y >= tpy && y <= tpy + tph) {
                    switch (touchpadDown) {
                        case 0: {
                            this.keyReleasedEvent(0, 0, 1);
                            break;
                        }
                        case 1: {
                            this.keyReleasedEvent(0, 0, 2);
                            break;
                        }
                        case 2: {
                            this.keyReleasedEvent(0, 0, 3);
                            break;
                        }
                        case 5: {
                            this.keyReleasedEvent(this.getKeyCode(1), 1, 0);
                            break;
                        }
                        case 6: {
                            this.keyReleasedEvent(this.getKeyCode(6), 6, 0);
                            break;
                        }
                        case 3: {
                            this.keyReleasedEvent(this.getKeyCode(2), 2, 0);
                            break;
                        }
                        case 4: {
                            this.keyReleasedEvent(this.getKeyCode(5), 5, 0);
                            break;
                        }
                        case 7: {
                            this.keyReleasedEvent(this.getKeyCode(8), 8, 0);
                        }
                    }
                }
                touchpadDown = -1;
                return;
            }
        } else if (y > screenHeight - 20) {
            if (x > 0 && x < screenWidth >> 1) {
                this.keyReleasedEvent(0, 0, 1);
            } else {
                this.keyReleasedEvent(0, 0, 2);
            }
            return;
        }
        touchpadDown = -1;
        this.pointerReleasedEvent(x, y);
    }

    public final void keyPressed(int keyCode) {
        if (this.isInLandscape) {
            return;
        }
        this._processKey(keyCode, true);
    }

    public final void keyReleased(int keyCode) {
        if (this.isInLandscape) {
            return;
        }
        this._processKey(keyCode, false);
    }

    private void _processKey(int keyCode, boolean isKeyPressed) {
        int ga = 0;
        int sk = 0;
        try {
            ga = this.getGameAction(keyCode);
        }
        catch (Exception e) {
            ga = 0;
        }
        switch (keyCode) {
            case 50: {
                ga = 1;
                break;
            }
            case 52: {
                ga = 2;
                break;
            }
            case 53: {
                ga = 8;
                break;
            }
            case 54: {
                ga = 5;
                break;
            }
            case 56: {
                ga = 6;
            }
        }
        if (ga != 1 && ga != 6 && ga != 2 && ga != 5) {
            int i;
            for (i = 0; i < BACK_KEY_VALUES.length; ++i) {
                if (keyCode != BACK_KEY_VALUES[i]) continue;
                sk = 3;
            }
            for (i = 0; i < CLEAR_KEY_VALUES.length; ++i) {
                if (keyCode != CLEAR_KEY_VALUES[i]) continue;
                sk = 4;
            }
            for (i = 0; i < LSK_VALUES.length; ++i) {
                if (keyCode != LSK_VALUES[i]) continue;
                sk = FLIP_SOFT_KEYS ? 2 : 1;
            }
            for (i = 0; i < RSK_VALUES.length; ++i) {
                if (keyCode != RSK_VALUES[i]) continue;
                sk = FLIP_SOFT_KEYS ? 1 : 2;
            }
        }
        if (isKeyPressed) {
            this.keyPressedEvent(keyCode, ga, sk);
        } else {
            if (!SOFTKEYS_GENERATE_KEY_RELEASED) {
                sk = 0;
            }
            this.keyReleasedEvent(keyCode, ga, sk);
        }
    }

    public static Image loadImage(String r) {
        try {
            return Image.createImage((String)r);
        }
        catch (Exception e) {
            System.out.println("WARNING: Unable to load image: " + r);
            return null;
        }
    }

    public static void drawLeftCommand(Graphics g, String s, ImageFontRenderer fnt) {
        fnt.drawString(g, s, 5, screenHeight - fnt.getHeight() - 3);
    }

    public static void drawRightCommand(Graphics g, String s, ImageFontRenderer fnt) {
        fnt.drawString(g, s, screenWidth - 5 - fnt.stringWidth(s), screenHeight - fnt.getHeight() - 3);
    }

    public static void drawLeftCommand(GraphicsScaler g, String s, ImageFontRenderer fnt) {
        fnt.drawString(g, s, 5, g.getHeight() - fnt.getHeight() - 3);
    }

    public static void drawRightCommand(GraphicsScaler g, String s, ImageFontRenderer fnt) {
        fnt.drawString(g, s, g.getWidth() - 5 - fnt.stringWidth(s), g.getHeight() - fnt.getHeight() - 3);
    }

    public static void getJadParameters(MIDlet parent) {
        try {
            String setting = "";
            setting = parent.getAppProperty("Sprite-Flip-Softkeys");
            if (setting != null && (setting = setting.toLowerCase().trim()).equals("true")) {
                FLIP_SOFT_KEYS = true;
            }
            if ((setting = parent.getAppProperty("Sprite-Allow-Landscape")) != null && (setting = setting.toLowerCase().trim()).equals("true")) {
                ALLOW_LANDSCAPE = true;
            }
            if ((setting = parent.getAppProperty("Sprite-Use-Double-Buffer")) != null && (setting = setting.toLowerCase().trim()).equals("true")) {
                USE_DOUBLE_BUFFER = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

