/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.blackjack.GameRes;
import net.handyx.casinopack.blackjack.game.Bet;
import net.handyx.casinopack.blackjack.game.Card;
import net.handyx.casinopack.blackjack.game.Game;
import net.handyx.casinopack.blackjack.game.Hand;
import net.handyx.casinopack.common.GraphicsScaler;

public class StrategyAdvisor {
    public static final int STRATEGY_TABLE_X_OFFSET = 32;
    public static final int STRATEGY_TABLE_Y_OFFSET = 25;
    public static final int STRATEGY_TABLE_ROW_HEIGHT = 8;
    public static final int STRATEGY_TABLE_COL_WIDTH = 16;
    public static final int STRATEGY_TABLE_WIDTH = 177;
    public static final int STRATEGY_TABLE_HEIGHT = 259;
    public static final int STRATEGY_TABLE_HIGHLIGHT_X_OFFSET = -3;
    public static final int STRATEGY_TABLE_HIGHLIGHT_Y_OFFSET = -4;
    private static final byte _ = -1;
    private static final byte H = 0;
    private static final byte S = 1;
    private static final byte D = 2;
    private static final byte F = 3;
    private static final byte P = 4;
    private static final byte SH = 5;
    private static final byte SS = 6;
    private static final byte SP = 7;
    public static final int NONE = -1;
    public static final int HIT = 0;
    public static final int STAND = 1;
    public static final int DOUBLE_OR_HIT = 2;
    public static final int DOUBLE_OR_STAND = 3;
    public static final int SPLIT = 4;
    public static final int SURRENDER_OR_HIT = 5;
    public static final int SURRENDER_OR_STAND = 6;
    public static final int SURRENDER_OR_SPLIT = 7;
    public static final int DOUBLE = 8;
    public static final int SURRENDER = 9;
    public static final String[] ACTIONS = new String[]{"Hit", "Stand", "Double Down (or hit if you can't double)", "Double Down (or stand if you can't double)", "Split", "Surrender (or hit if you can't surrender)", "Surrender (or stand if you can't surrender)", "Surrender (or split it you can't surrender)", "Double", "Surrender"};
    private static final byte[] ROW_TOTALS = new byte[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 3, 4, 5, 6, 7, 8, 9, 10, 4, 6, 8, 10, 12, 14, 16, 18, 20, 20};
    private static final boolean[] ROW_USES_ACE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, true};
    private static final byte[][] SINGLE_DECK_S17 = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {1, 2, 2, 2, 2, 1, 1, 0, 0, 1}, {1, 1, 1, 1, 2, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 0, 0}, {0, 0, 4, 4, 4, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 1, 0}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private static final byte[][] SINGLE_DECK_H17 = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {1, 2, 2, 2, 2, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 2, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 0, 0}, {0, 0, 4, 4, 4, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 1, 0}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private static final byte[][] TWO_DECK_S17 = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {1, 3, 3, 3, 3, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {0, 0, 0, 4, 4, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private static final byte[][] TWO_DECK_H17 = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {3, 3, 3, 3, 3, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 3, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {0, 0, 0, 4, 4, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private static final byte[][] MULTI_DECK_S17 = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {1, 3, 3, 3, 3, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {0, 0, 0, 4, 4, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {4, 4, 4, 4, 4, 0, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private static final byte[][] MULTI_DECK_H17 = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 0, 0, 0}, {0, 2, 2, 2, 2, 0, 0, 0, 0, 0}, {3, 3, 3, 3, 3, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 3, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {0, 0, 0, 4, 4, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 0, 0}, {4, 4, 4, 4, 4, 0, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 1, 4, 4, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private static final byte[][][] NO_DOUBLE_AFTER_SPLIT = new byte[][][]{new byte[][]{{0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 0, -1, -1, -1, 0, -1, -1, -1, -1}, {-1, -1, 0, 2, 2, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, 0, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 0, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new byte[][]{{0, 0, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 0, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 0, 0, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, 0, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 0, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}, new byte[][]{{0, 0, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 0, -1, -1, -1, 0, -1, -1, -1, -1}, {-1, -1, -1, 0, 0, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}}};
    private static byte[][] mTable = null;
    public static Image mTableBitmap = null;

    public static int getSuggestedAction(Game g, Hand h, int[] tablePosition, Bet playerCash) {
        if (mTable == null) {
            StrategyAdvisor.generateTable();
        }
        System.out.println("Player hand: " + h.toString());
        tablePosition[0] = -1;
        tablePosition[1] = -1;
        if (h == null || h.numCards() < 2) {
            return 1;
        }
        Card dealerCard = g.getDealerHand().getLastCard();
        int dealerIndex = dealerCard.getValue() - 2;
        if (dealerCard.getValue() == 1) {
            dealerIndex = 9;
        }
        int handTotal = h.getTotal();
        int playerIndex = -1;
        int action = -1;
        boolean splitsUsedUp = false;
        if (Game.ruleMaxSplitHands != 0 && g.numHandsInPlay() >= Game.ruleMaxSplitHands + 1) {
            splitsUsedUp = true;
        }
        if (!splitsUsedUp && h.canSplit() && playerCash.isGreaterThanOrEqualTo(h.getBet())) {
            Card c1 = h.getCard(0);
            playerIndex = c1.getValue() == 1 ? 30 : c1.getValue() - 2 + 21;
        } else if (h.isSoft()) {
            int softTotal = h.getLowestTotal();
            if (h.hasBlackjack() || handTotal == 21) {
                action = 1;
            } else if (softTotal == 2) {
                action = 0;
            } else {
                playerIndex = softTotal - 3 + 13;
            }
        } else if (handTotal >= 18) {
            action = 1;
        } else if (handTotal < 5) {
            action = 0;
        } else {
            playerIndex = handTotal - 5;
        }
        if (action == -1 && (playerIndex < 0 || playerIndex >= mTable.length || dealerIndex < 0 || dealerIndex >= mTable[0].length)) {
            System.out.println("Index out of bounds! [" + playerIndex + "][" + dealerIndex + "]");
            return 1;
        }
        if (action == -1) {
            action = mTable[playerIndex][dealerIndex];
        }
        if (action == 2 && (!h.canDoubleDown() || playerCash.isLessThan(h.getBet()))) {
            action = 0;
        } else if (action == 3 && (!h.canDoubleDown() || playerCash.isLessThan(h.getBet()))) {
            action = 1;
        } else if (action == 5 && !h.canSurrender()) {
            action = 0;
        } else if (action == 6 && !h.canSurrender()) {
            action = 1;
        } else if (action == 7 && !h.canSurrender()) {
            action = 4;
            if (!h.canSplit() || playerCash.isLessThan(h.getBet())) {
                action = 0;
            }
        }
        if (action == 0 && !h.canHit()) {
            action = 1;
        }
        if (action == 2 || action == 3) {
            action = 8;
        } else if (action == 5 || action == 7 || action == 6) {
            action = 9;
        }
        if (playerIndex >= 0 && playerIndex < mTable.length && dealerIndex >= 0 && dealerIndex < 10) {
            tablePosition[0] = playerIndex;
            tablePosition[1] = dealerIndex;
        }
        return action;
    }

    public static void generateTable() {
        int col;
        byte val;
        boolean rowUsesAce;
        byte rowTotal;
        int col2;
        int row;
        if (mTable == null) {
            mTable = new byte[31][10];
        }
        for (row = 0; row < 31; ++row) {
            for (col2 = 0; col2 < 10; ++col2) {
                if (Game.ruleNumDecks == 1) {
                    if (Game.ruleDealerHitsSoft17) {
                        StrategyAdvisor.mTable[row][col2] = SINGLE_DECK_H17[row][col2];
                        continue;
                    }
                    StrategyAdvisor.mTable[row][col2] = SINGLE_DECK_S17[row][col2];
                    continue;
                }
                if (Game.ruleNumDecks == 2) {
                    if (Game.ruleDealerHitsSoft17) {
                        StrategyAdvisor.mTable[row][col2] = TWO_DECK_H17[row][col2];
                        continue;
                    }
                    StrategyAdvisor.mTable[row][col2] = TWO_DECK_S17[row][col2];
                    continue;
                }
                StrategyAdvisor.mTable[row][col2] = Game.ruleDealerHitsSoft17 ? MULTI_DECK_H17[row][col2] : MULTI_DECK_S17[row][col2];
            }
        }
        if (Game.ruleDoubleDown == 2) {
            for (row = 0; row < 31; ++row) {
                for (col2 = 0; col2 < 10; ++col2) {
                    rowTotal = ROW_TOTALS[row];
                    rowUsesAce = ROW_USES_ACE[row];
                    val = mTable[row][col2];
                    if (!rowUsesAce && rowTotal >= 9 && rowTotal <= 11) continue;
                    if (val == 2) {
                        StrategyAdvisor.mTable[row][col2] = 0;
                        continue;
                    }
                    if (val != 3) continue;
                    StrategyAdvisor.mTable[row][col2] = 1;
                }
            }
        } else if (Game.ruleDoubleDown == 1) {
            for (row = 0; row < 31; ++row) {
                for (col2 = 0; col2 < 10; ++col2) {
                    rowTotal = ROW_TOTALS[row];
                    rowUsesAce = ROW_USES_ACE[row];
                    val = mTable[row][col2];
                    if (!rowUsesAce && rowTotal >= 9 && rowTotal <= 10) continue;
                    if (val == 2) {
                        StrategyAdvisor.mTable[row][col2] = 0;
                        continue;
                    }
                    if (val != 3) continue;
                    StrategyAdvisor.mTable[row][col2] = 1;
                }
            }
        }
        if (!Game.ruleDoubleOnSplit) {
            int n = 0;
            if (Game.ruleNumDecks == 2) {
                n = 1;
            } else if (Game.ruleNumDecks >= 3) {
                n = 2;
            }
            for (int row2 = 0; row2 < NO_DOUBLE_AFTER_SPLIT[n].length; ++row2) {
                for (int col3 = 0; col3 < 10; ++col3) {
                    byte val2 = NO_DOUBLE_AFTER_SPLIT[n][row2][col3];
                    if (val2 == -1) continue;
                    StrategyAdvisor.mTable[21 + row2][col3] = val2;
                }
            }
        }
        if (Game.ruleNo45TenSplits) {
            for (col = 0; col < 10; ++col) {
                if (mTable[23][col] == 4) {
                    StrategyAdvisor.mTable[23][col] = 0;
                }
                if (mTable[24][col] != 4) continue;
                StrategyAdvisor.mTable[24][col] = 0;
            }
        }
        if (!Game.ruleSplitAces) {
            for (col = 0; col < 10; ++col) {
                if (mTable[30][col] != 4) continue;
                StrategyAdvisor.mTable[30][col] = 0;
            }
        }
        if (!Game.ruleDealerPeeksHoleCard) {
            StrategyAdvisor.mTable[6][8] = 0;
            if (Game.ruleNumDecks < 3) {
                StrategyAdvisor.mTable[6][9] = 0;
            }
            StrategyAdvisor.mTable[27][8] = 0;
            StrategyAdvisor.mTable[27][9] = 0;
            StrategyAdvisor.mTable[30][9] = 0;
        }
        if (Game.ruleSurrender == 1) {
            StrategyAdvisor.mTable[2][9] = 5;
            StrategyAdvisor.mTable[7][9] = 5;
            StrategyAdvisor.mTable[8][9] = 5;
            StrategyAdvisor.mTable[9][9] = 5;
            StrategyAdvisor.mTable[9][8] = 5;
            StrategyAdvisor.mTable[10][9] = 5;
            StrategyAdvisor.mTable[10][8] = 5;
            StrategyAdvisor.mTable[11][9] = 5;
            StrategyAdvisor.mTable[11][8] = 5;
            StrategyAdvisor.mTable[12][9] = 6;
            StrategyAdvisor.mTable[22][9] = 5;
            StrategyAdvisor.mTable[25][9] = 5;
            StrategyAdvisor.mTable[26][9] = 5;
            StrategyAdvisor.mTable[26][8] = 5;
            StrategyAdvisor.mTable[27][9] = 5;
            StrategyAdvisor.mTable[27][8] = 5;
            if (Game.ruleNumDecks >= 4) {
                StrategyAdvisor.mTable[11][7] = 5;
            }
        } else if (Game.ruleSurrender == 2) {
            if (Game.ruleDealerHitsSoft17) {
                if (Game.ruleNumDecks == 1) {
                    StrategyAdvisor.mTable[10][9] = 5;
                    StrategyAdvisor.mTable[11][8] = 5;
                    StrategyAdvisor.mTable[11][9] = 5;
                    StrategyAdvisor.mTable[12][9] = 6;
                    StrategyAdvisor.mTable[26][8] = 6;
                    StrategyAdvisor.mTable[26][9] = 5;
                } else if (Game.ruleNumDecks == 2) {
                    StrategyAdvisor.mTable[10][8] = 5;
                    StrategyAdvisor.mTable[10][9] = 5;
                    StrategyAdvisor.mTable[11][8] = 5;
                    StrategyAdvisor.mTable[11][9] = 5;
                    StrategyAdvisor.mTable[12][9] = 6;
                    StrategyAdvisor.mTable[27][9] = 7;
                } else {
                    StrategyAdvisor.mTable[10][8] = 5;
                    StrategyAdvisor.mTable[10][9] = 5;
                    StrategyAdvisor.mTable[11][7] = 5;
                    StrategyAdvisor.mTable[11][8] = 5;
                    StrategyAdvisor.mTable[11][9] = 5;
                    StrategyAdvisor.mTable[12][9] = 6;
                    StrategyAdvisor.mTable[27][9] = 7;
                }
            } else if (Game.ruleNumDecks == 1) {
                StrategyAdvisor.mTable[11][8] = 5;
                StrategyAdvisor.mTable[11][9] = 5;
                StrategyAdvisor.mTable[26][8] = 6;
            } else if (Game.ruleNumDecks == 2 || Game.ruleNumDecks == 3) {
                StrategyAdvisor.mTable[10][8] = 5;
                StrategyAdvisor.mTable[11][8] = 5;
                StrategyAdvisor.mTable[11][9] = 5;
            } else {
                StrategyAdvisor.mTable[10][8] = 5;
                StrategyAdvisor.mTable[11][7] = 5;
                StrategyAdvisor.mTable[11][8] = 5;
                StrategyAdvisor.mTable[11][9] = 5;
            }
        }
    }

    public static void generateTableImage() {
        if (mTable == null) {
            StrategyAdvisor.generateTable();
        }
        if (mTableBitmap == null) {
            mTableBitmap = Image.createImage((int)GameRes.mStatTableBitmap.getWidth(), (int)GameRes.mStatTableBitmap.getHeight());
        }
        Graphics gfx = mTableBitmap.getGraphics();
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, mTableBitmap.getWidth(), mTableBitmap.getHeight());
        g.drawImage(GameRes.mStatTableBitmap, 0, 0, 20);
        for (int row = 0; row < mTable.length; ++row) {
            for (int col = 0; col < 10; ++col) {
                int x = 32 + col * 16;
                int y = 25 + row * 8;
                byte v = mTable[row][col];
                g.setClip(x, y, 16, 8);
                g.drawImage(GameRes.mStatTableBlocksBitmap, x, y - v * 8, 20);
                g.setClip(0, 0, mTableBitmap.getWidth(), mTableBitmap.getHeight());
            }
        }
    }

    public static String tableToString() {
        String[] yAxis = new String[]{" 5", " 6", " 7", " 8", " 9", "10", "11", "12", "13", "14", "15", "16", "17", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "22", "33", "44", "55", "66", "77", "88", "99", "TT", "AA"};
        String[] vals = new String[]{"H ", "S ", "Ds", "Dh", "S ", "Sh", "Ss", "Sp"};
        String s = "    2, 3, 4, 5, 6, 7, 8, 9, T, A\n";
        s = s + "---------------------------------\n";
        for (int row = 0; row < mTable.length; ++row) {
            s = s + yAxis[row] + "|";
            for (int col = 0; col < mTable[row].length; ++col) {
                if (col > 0) {
                    s = s + ",";
                }
                s = s + vals[mTable[row][col]];
            }
            s = s + "\n";
        }
        s = s + "---------------------------------\n";
        return s;
    }
}

