/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack.game;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import java.util.Stack;
import net.handyx.casinopack.blackjack.game.Card;

public class Deck {
    public static final int CLUB = 0;
    public static final int DIAMOND = 1;
    public static final int SPADE = 2;
    public static final int HEART = 3;
    public static final int SUIT_CLUB = 32;
    public static final int SUIT_DIAMOND = 64;
    public static final int SUIT_SPADE = 128;
    public static final int SUIT_HEART = 256;
    public static final int ACE = 1;
    public static final int JACK = 11;
    public static final int QUEEN = 12;
    public static final int KING = 13;
    private Random rand = new Random();
    private int numDecks = 1;
    private Stack mTempDeck;
    private Stack mDeck;
    private Stack mDeckDrawn;
    private Stack mDeckUsed;

    public Deck(int numDecks) {
        this.numDecks = numDecks;
        this.mTempDeck = new Stack();
        this.mDeck = new Stack();
        this.mDeckDrawn = new Stack();
        this.mDeckUsed = new Stack();
        for (int d = 0; d < numDecks; ++d) {
            for (int i = 0; i < 13; ++i) {
                this.mDeck.push(new Integer(i + 1 + 32));
                this.mDeck.push(new Integer(i + 1 + 64));
                this.mDeck.push(new Integer(i + 1 + 128));
                this.mDeck.push(new Integer(i + 1 + 256));
            }
        }
    }

    public Deck(byte[] data) {
        this.fromByteArray(data);
    }

    public void shuffle() {
        this.mTempDeck.removeAllElements();
        int r = 0;
        while (!this.mDeck.isEmpty()) {
            r = this.rnd(this.mDeck.size());
            this.mTempDeck.addElement(this.mDeck.elementAt(r));
            this.mDeck.removeElementAt(r);
        }
        while (!this.mTempDeck.isEmpty()) {
            this.mDeck.push((Integer)this.mTempDeck.pop());
        }
    }

    private int rnd(int v) {
        return Math.abs(this.rand.nextInt() % v);
    }

    public Card dealNextCard() {
        if (this.mDeck.isEmpty()) {
            for (int i = 0; i < this.mDeckUsed.size(); ++i) {
                this.mDeck.addElement((Integer)this.mDeckUsed.elementAt(i));
            }
            this.mDeckUsed.removeAllElements();
            this.shuffle();
        }
        return this.getNextCard();
    }

    public void collect() {
        for (int i = 0; i < this.mDeckDrawn.size(); ++i) {
            this.mDeckUsed.addElement((Integer)this.mDeckDrawn.elementAt(i));
        }
        this.mDeckDrawn.removeAllElements();
        System.out.println("Deck Status: " + this.mDeckUsed.size() + " cards used, " + this.mDeckDrawn.size() + " cards on table, " + this.mDeck.size() + " cards in shoe.");
    }

    public void collectAndReset() {
        int i;
        for (i = 0; i < this.mDeckDrawn.size(); ++i) {
            this.mDeck.addElement((Integer)this.mDeckDrawn.elementAt(i));
        }
        for (i = 0; i < this.mDeckUsed.size(); ++i) {
            this.mDeck.addElement((Integer)this.mDeckUsed.elementAt(i));
        }
        this.mDeckUsed.removeAllElements();
        this.mDeckDrawn.removeAllElements();
        this.shuffle();
        System.out.println("Deck Status: " + this.mDeckUsed.size() + " cards used, " + this.mDeckDrawn.size() + " cards on table, " + this.mDeck.size() + " cards in shoe.");
    }

    public Card getNextCard() {
        int c = (Integer)this.mDeck.pop();
        this.mDeckDrawn.push(new Integer(c));
        int suit = 32;
        if ((c & 0x40) > 0) {
            suit = 64;
        } else if ((c & 0x80) > 0) {
            suit = 128;
        } else if ((c & 0x100) > 0) {
            suit = 256;
        }
        return new Card(c - suit, suit);
    }

    public int getRemainingCards() {
        return this.mDeck.size();
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            int i;
            os.writeInt(this.numDecks);
            int ncards = this.mDeck.size();
            os.writeInt(ncards);
            for (i = 0; i < ncards; ++i) {
                os.writeInt((Integer)this.mDeck.elementAt(i));
            }
            ncards = this.mDeckUsed.size();
            os.writeInt(ncards);
            for (i = 0; i < ncards; ++i) {
                os.writeInt((Integer)this.mDeckUsed.elementAt(i));
            }
            ncards = this.mDeckDrawn.size();
            os.writeInt(ncards);
            for (i = 0; i < ncards; ++i) {
                os.writeInt((Integer)this.mDeckDrawn.elementAt(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int i;
            this.numDecks = is.readInt();
            this.mDeck = new Stack();
            this.mDeckUsed = new Stack();
            this.mDeckDrawn = new Stack();
            this.mTempDeck = new Stack();
            int ncards = is.readInt();
            for (i = 0; i < ncards; ++i) {
                this.mDeck.push(new Integer(is.readInt()));
            }
            ncards = is.readInt();
            for (i = 0; i < ncards; ++i) {
                this.mDeckUsed.push(new Integer(is.readInt()));
            }
            ncards = is.readInt();
            for (i = 0; i < ncards; ++i) {
                this.mDeckDrawn.push(new Integer(is.readInt()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

