/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack;

import net.handyx.casinopack.blackjack.AnimatedObject;
import net.handyx.casinopack.blackjack.Common;
import net.handyx.casinopack.blackjack.GameCanvas;
import net.handyx.casinopack.blackjack.GameRes;
import net.handyx.casinopack.blackjack.game.Bet;
import net.handyx.casinopack.blackjack.game.Card;
import net.handyx.casinopack.blackjack.game.Game;
import net.handyx.casinopack.blackjack.game.Hand;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.Rect;
import net.handyx.casinopack.common.RunnableCanvas;

public class GameRenderer {
    public static int SHOE_X = 240;
    public static int SHOE_Y = -115;
    public static int SCREEN_HEIGHT = 320;
    public static int HAND_POINTER_WIDTH = 20;
    public static int HAND_POINTER_HEIGHT = 26;
    public static int HAND_POINTER_LEFT_X = 9;
    public static int HAND_POINTER_LEFT_Y = 265;
    public static int HAND_POINTER_RIGHT_X = 213;
    public static int HAND_POINTER_RIGHT_Y = 265;
    public static int PLAYER_CARD_1_X = 90;
    public static int PLAYER_CARD_1_Y = 161;
    public static int PLAYER_CARD_2_X = PLAYER_CARD_1_X + 21;
    public static int PLAYER_CARD_2_Y = PLAYER_CARD_1_Y + 4;
    public static int PLAYER_CARD_X_INCREMENT = 17;
    public static int PLAYER_CARD_Y_INCREMENT = 0;
    public static int PLAYER_TOTAL_X = PLAYER_CARD_1_X + 38;
    public static int PLAYER_TOTAL_Y = PLAYER_CARD_1_Y - 16;
    public static int PLAYER_HAND_LABEL_X = PLAYER_CARD_1_X - 5;
    public static int PLAYER_HAND_LABEL_Y = PLAYER_CARD_1_Y + 33;
    public static int PLAYER_HAND_X_OFFSET = 250;
    public static int PLAYER_BET_X = PLAYER_CARD_1_X - 10;
    public static int PLAYER_BET_Y = PLAYER_CARD_1_Y - 3;
    public static int PLAYER_INSURANCE_X = PLAYER_CARD_1_X - 10;
    public static int PLAYER_INSURANCE_Y = PLAYER_CARD_1_Y + 24;
    public static int PLAYER_WINNINGS_X = PLAYER_CARD_1_X - 10;
    public static int PLAYER_WINNINGS_Y = PLAYER_CARD_1_Y + 51;
    public static int DEALER_CARD_1_X = 90;
    public static int DEALER_CARD_1_Y = 27;
    public static int DEALER_CARD_2_X = DEALER_CARD_1_X + 21;
    public static int DEALER_CARD_2_Y = DEALER_CARD_1_Y + 4;
    public static int DEALER_CARD_X_INCREMENT = 17;
    public static int DEALER_TOTAL_X = DEALER_CARD_1_X + 38;
    public static int DEALER_TOTAL_Y = DEALER_CARD_1_Y + 10;
    public static int DEALER_HAND_LABEL_X = DEALER_CARD_1_X - 5;
    public static int DEALER_HAND_LABEL_Y = DEALER_CARD_1_Y + 33;
    public static int DEALER_CARD_PEEK_X = DEALER_CARD_1_X - 5;
    public static int DEALER_CARD_PEEK_Y = DEALER_CARD_1_Y;
    public static int BG_DEALER_HITS_17_X = 54;
    public static int BG_DEALER_HITS_17_Y = 104;
    public static int BG_INSURANCE_X = 59;
    public static int BG_INSURANCE_Y = 140;
    public static int CHIP_WIDTH = 26;
    public static int PLACE_BETS_Y = 235;
    public static int PLACE_BETS_X = 62;
    public static int BIG_BANNER_X = 21;
    public static int BIG_BANNER_Y = 82;
    public static int BIG_BANNER_TEXT_X = BIG_BANNER_X + 52;
    public static int BIG_BANNER_TEXT_Y = BIG_BANNER_Y + 21;
    public static int YES_BUTTON_X = BIG_BANNER_X + 42;
    public static int NO_BUTTON_X = BIG_BANNER_X + 108;
    public static int YES_BUTTON_Y = BIG_BANNER_Y + 42;
    public static int NO_BUTTON_Y = BIG_BANNER_Y + 42;
    public static int BUTTON_WIDTH = 52;
    public static int BUTTON_HEIGHT = 36;
    public static int BUTTONS_Y = 261;
    public static int BUTTONS_X = 6;
    public static int BUTTONS_X_INCREMENT = 59;
    public static int BUTTONS_NEXTGAME_X = 93;
    public static int BUTTONS_NEXTGAME_Y = BUTTONS_Y;
    public static int BUTTONS_DEAL_X = 95;
    public static int BUTTONS_DEAL_Y = 158;
    public static int BUTTONS_CLEARBETS_X = 95;
    public static int BUTTONS_CLEARBETS_Y = 194;
    public static int BUTTONS_BET_X = 29;
    public static int BUTTONS_BET_Y = 264;
    public static int BET_BUTTONS_X_SPACING = 40;
    public static int BUTTONS_BET_WIDTH = 43;
    public static int BUTTONS_BET_HEIGHT = 45;
    public static int BUTTON_HINT_STAR_X_OFFSET = 40;
    public static int BUTTON_HINT_STAR_Y_OFFSET = -4;
    public static int BUTTON_HIGHLIGHTER_X_OFFSET = -3;
    public static int BUTTON_HIGHLIGHTER_Y_OFFSET = -4;
    public static Rect[] mButtonRect = new Rect[]{new Rect(BUTTONS_X + 0 * BUTTONS_X_INCREMENT, BUTTONS_Y, BUTTONS_X + 0 * BUTTONS_X_INCREMENT + BUTTON_WIDTH, BUTTONS_Y + BUTTON_HEIGHT), new Rect(BUTTONS_X + 1 * BUTTONS_X_INCREMENT, BUTTONS_Y, BUTTONS_X + 1 * BUTTONS_X_INCREMENT + BUTTON_WIDTH, BUTTONS_Y + BUTTON_HEIGHT), new Rect(BUTTONS_X + 2 * BUTTONS_X_INCREMENT, BUTTONS_Y, BUTTONS_X + 2 * BUTTONS_X_INCREMENT + BUTTON_WIDTH, BUTTONS_Y + BUTTON_HEIGHT), new Rect(BUTTONS_X + 3 * BUTTONS_X_INCREMENT, BUTTONS_Y, BUTTONS_X + 3 * BUTTONS_X_INCREMENT + BUTTON_WIDTH, BUTTONS_Y + BUTTON_HEIGHT), new Rect(BUTTONS_NEXTGAME_X, BUTTONS_NEXTGAME_Y, BUTTONS_NEXTGAME_X + BUTTON_WIDTH, BUTTONS_NEXTGAME_Y + BUTTON_HEIGHT), new Rect(BUTTONS_DEAL_X, BUTTONS_DEAL_Y, BUTTONS_DEAL_X + BUTTON_WIDTH, BUTTONS_DEAL_Y + BUTTON_HEIGHT), new Rect(BUTTONS_CLEARBETS_X, BUTTONS_CLEARBETS_Y, BUTTONS_CLEARBETS_X + BUTTON_WIDTH, BUTTONS_CLEARBETS_Y + BUTTON_HEIGHT), new Rect(YES_BUTTON_X, YES_BUTTON_Y, YES_BUTTON_X + BUTTON_WIDTH, YES_BUTTON_Y + BUTTON_HEIGHT), new Rect(NO_BUTTON_X, NO_BUTTON_Y, NO_BUTTON_X + BUTTON_WIDTH, NO_BUTTON_Y + BUTTON_HEIGHT), new Rect(BUTTONS_BET_X, BUTTONS_BET_Y, BUTTONS_BET_X + BUTTONS_BET_WIDTH, BUTTONS_BET_Y + BUTTONS_BET_HEIGHT), new Rect(BUTTONS_BET_X + 1 * BET_BUTTONS_X_SPACING, BUTTONS_BET_Y, BUTTONS_BET_X + 1 * BET_BUTTONS_X_SPACING + BUTTONS_BET_WIDTH, BUTTONS_BET_Y + BUTTONS_BET_HEIGHT), new Rect(BUTTONS_BET_X + 2 * BET_BUTTONS_X_SPACING, BUTTONS_BET_Y, BUTTONS_BET_X + 2 * BET_BUTTONS_X_SPACING + BUTTONS_BET_WIDTH, BUTTONS_BET_Y + BUTTONS_BET_HEIGHT), new Rect(BUTTONS_BET_X + 3 * BET_BUTTONS_X_SPACING, BUTTONS_BET_Y, BUTTONS_BET_X + 3 * BET_BUTTONS_X_SPACING + BUTTONS_BET_WIDTH, BUTTONS_BET_Y + BUTTONS_BET_HEIGHT), new Rect(BUTTONS_BET_X + 4 * BET_BUTTONS_X_SPACING, BUTTONS_BET_Y, BUTTONS_BET_X + 4 * BET_BUTTONS_X_SPACING + BUTTONS_BET_WIDTH, BUTTONS_BET_Y + BUTTONS_BET_HEIGHT), new Rect(YES_BUTTON_X, YES_BUTTON_Y, YES_BUTTON_X + BUTTON_WIDTH, YES_BUTTON_Y + BUTTON_HEIGHT), new Rect(NO_BUTTON_X, NO_BUTTON_Y, NO_BUTTON_X + BUTTON_WIDTH, NO_BUTTON_Y + BUTTON_HEIGHT), new Rect(HAND_POINTER_LEFT_X, HAND_POINTER_LEFT_Y, HAND_POINTER_LEFT_X + HAND_POINTER_WIDTH, HAND_POINTER_LEFT_Y + HAND_POINTER_HEIGHT), new Rect(HAND_POINTER_RIGHT_X, HAND_POINTER_RIGHT_Y, HAND_POINTER_RIGHT_X + HAND_POINTER_WIDTH, HAND_POINTER_RIGHT_Y + HAND_POINTER_HEIGHT), new Rect(YES_BUTTON_X, YES_BUTTON_Y, YES_BUTTON_X + BUTTON_WIDTH, YES_BUTTON_Y + BUTTON_HEIGHT), new Rect(NO_BUTTON_X, NO_BUTTON_Y, NO_BUTTON_X + BUTTON_WIDTH, NO_BUTTON_Y + BUTTON_HEIGHT)};
    public static int X = 0;
    public static int Y = 1;
    public static int[][] BET_BUTTON_HIGHTLIGHT_OFFSET = new int[][]{{19, 428}, {78, 434}, {138, 437}, {197, 434}, {258, 426}};
    public int mWidth;
    public int mHeight;
    private GameCanvas parent = null;
    private int labelXOffset = 0;

    public GameRenderer(GameCanvas c) {
        this.parent = c;
    }

    public void paintCanvas(GraphicsScaler g, int sw, int sh) {
        this.mWidth = sw;
        this.mHeight = sh;
        if (!GameRes.resourcesLoaded) {
            g.setColor(0);
            g.fillRect(0, 0, this.mWidth, this.mHeight);
            return;
        }
        g.drawImage(GameRes.mBackgroundBitmap, 0, 0, 20);
        if (Game.ruleDealerHitsSoft17) {
            g.drawImage(GameRes.mBackgroundDealerHitsSoft17Bitmap, BG_DEALER_HITS_17_X, BG_DEALER_HITS_17_Y, 20);
        }
        if (Game.ruleDealerInsurance > 0) {
            g.drawImage(GameRes.mBackgroundInsuranceBitmap, BG_INSURANCE_X, BG_INSURANCE_Y, 20);
        }
        if (this.parent.mTurn == 0) {
            this.renderAnimatedObjects(g, false);
            if (this.parent.mChipSelectorVisible) {
                this.renderMoneyLabel(g, PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent._mBet.toString());
                if (this.parent.mBet.isGreaterThanZero()) {
                    this.renderButton(g, BUTTONS_DEAL_X, BUTTONS_DEAL_Y, 5, this.parent.mButtonDown == 5, false);
                    this.renderButton(g, BUTTONS_CLEARBETS_X, BUTTONS_CLEARBETS_Y, 6, this.parent.mButtonDown == 6, false);
                } else {
                    this.renderButton(g, BUTTONS_DEAL_X, BUTTONS_DEAL_Y, 5, false, true);
                    this.renderButton(g, BUTTONS_CLEARBETS_X, BUTTONS_CLEARBETS_Y, 6, false, true);
                }
                if (this.parent.mSelectedButton == 5) {
                    g.drawImage(GameRes.mButtonHighlightBitmap, BUTTONS_DEAL_X + BUTTON_HIGHLIGHTER_X_OFFSET, BUTTONS_DEAL_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
                } else if (this.parent.mSelectedButton == 6) {
                    g.drawImage(GameRes.mButtonHighlightBitmap, BUTTONS_CLEARBETS_X + BUTTON_HIGHLIGHTER_X_OFFSET, BUTTONS_CLEARBETS_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
                } else if (this.parent.mSelectedButton >= 9 && this.parent.mSelectedButton <= 13) {
                    int buttonSelected = this.parent.mSelectedButton - 9;
                    g.drawImage(GameRes.mChipHighlightBitmap, BUTTONS_BET_X + buttonSelected * BET_BUTTONS_X_SPACING - 4, BUTTONS_BET_Y - 4, 20);
                }
                if (this.parent.mBet.isZero() && this.parent.mCash.isLessThan(1, 0)) {
                    g.drawImage(GameRes.mBigBannerBitmap, BIG_BANNER_X, BIG_BANNER_Y - 20, 20);
                    g.drawImage(GameRes.mBigBannerGameOverBitmap, BIG_BANNER_TEXT_X, BIG_BANNER_TEXT_Y - 20, 20);
                }
            }
            this.renderUI(g);
            if (this.parent.mPlaceBetsLabelShown) {
                g.drawImage(GameRes.mPlaceBetsBitmap, PLACE_BETS_X, PLACE_BETS_Y, 20);
            }
            if (this.parent.mLastBetChipShown > 0) {
                for (int i = 0; i < this.parent.mLastBetChipShown; ++i) {
                    g.setClip(BUTTONS_BET_X + i * BET_BUTTONS_X_SPACING, BUTTONS_BET_Y, 26, 25);
                    int buttonDown = -1;
                    if (this.parent.mButtonDown >= 9 && this.parent.mButtonDown <= 13) {
                        buttonDown = this.parent.mButtonDown - 9;
                    }
                    if (buttonDown == i) {
                        g.drawImage(GameRes.mChipsBitmap, BUTTONS_BET_X - 26 + i * BET_BUTTONS_X_SPACING, BUTTONS_BET_Y - 25 * i, 20);
                        continue;
                    }
                    g.drawImage(GameRes.mChipsBitmap, BUTTONS_BET_X + i * BET_BUTTONS_X_SPACING, BUTTONS_BET_Y - 25 * i, 20);
                }
            }
            g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
            this.renderAnimatedObjects(g, true);
        } else if (this.parent.mTurn == 6) {
            this.renderAnimatedObjects(g);
            this.renderUI(g);
        } else if (this.parent.mTurn == 4 || this.parent.mTurn == 7 || this.parent.mTurn == 8) {
            this.renderDealerCards(g);
            this.renderAnimatedObjects(g);
            this.renderUI(g);
        } else if (this.parent.mTurn == 1) {
            this.renderDealerCards(g);
            int xo = -(this.parent.mPlayerHand * PLAYER_HAND_X_OFFSET);
            for (int h = 0; h < this.parent.mPlayerHandsDealt; ++h) {
                this.renderPlayerCards(g, h, xo);
                xo += PLAYER_HAND_X_OFFSET;
            }
            if (this.parent.mInsuranceOfferVisible) {
                this.renderInsurance(g);
            } else if (this.parent.mSurrenderOfferVisible) {
                this.renderSurrender(g);
            } else if (this.parent.mEvenMoneyOfferVisible) {
                this.renderEvenMoney(g);
            }
            this.renderAnimatedObjects(g, false);
            this.renderUI(g);
            this.renderButtons(g);
            this.renderAnimatedObjects(g, true);
        } else {
            this.renderDealerCards(g);
            int xo = -(this.parent.mPlayerHand * PLAYER_HAND_X_OFFSET);
            for (int h = 0; h < this.parent.mPlayerHandsDealt; ++h) {
                this.renderPlayerCards(g, h, xo);
                xo += PLAYER_HAND_X_OFFSET;
            }
            this.renderAnimatedObjects(g);
            this.renderCardLabels(g);
            if (this.parent.mInsuranceOfferVisible) {
                this.renderInsurance(g);
            } else if (this.parent.mSurrenderOfferVisible) {
                this.renderSurrender(g);
            } else if (this.parent.mEvenMoneyOfferVisible) {
                this.renderEvenMoney(g);
            }
            this.renderUI(g);
            this.renderButtons(g);
        }
    }

    public void renderButton(GraphicsScaler g, int x, int y, int button, boolean buttonDown, boolean buttonDisabled) {
        int xoff = 0;
        if (buttonDown) {
            xoff = 52;
        }
        if (buttonDisabled) {
            xoff = 104;
        }
        g.setClip(x, y, 52, 32);
        g.drawImage(GameRes.mButtonsBitmap, x - xoff, y - button * 32, 20);
        g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
    }

    public void renderUI(GraphicsScaler g) {
        String cashStr = this.parent.mCurrencyStr + this.parent._mCash.toString();
        if (RunnableCanvas.screenHeight <= 260) {
            GameRes.mCashSmallFont.drawString(g.getGraphics(), cashStr, g.scale(18) - GameRes.mCashSmallFont.stringWidth(cashStr) / 2, g.scale(20));
        } else {
            GameRes.mCashSmallFont.drawString(g.getGraphics(), cashStr, g.scale(38), g.scale(5));
        }
    }

    public void renderPlayerCards(GraphicsScaler g, int hand, int xoff) {
        if (xoff + PLAYER_CARD_1_X > RunnableCanvas.screenWidth) {
            return;
        }
        int cardsDealt = (Integer)this.parent.mPlayerCardsDealt.elementAt(hand);
        String totalString = (String)this.parent.mPlayerTotalString.elementAt(hand);
        Bet winnings = (Bet)this.parent.mWinnings.elementAt(hand);
        Bet _winnings = (Bet)this.parent._mWinnings.elementAt(hand);
        for (int i = 0; i < cardsDealt; ++i) {
            Card card = this.parent.mGame.getPlayerHand(hand).getCard(i);
            if (i == 0) {
                GameRenderer.renderCard(g, card, xoff + PLAYER_CARD_1_X, PLAYER_CARD_1_Y, false);
                continue;
            }
            if (i == 1) {
                GameRenderer.renderCard(g, card, xoff + PLAYER_CARD_2_X, PLAYER_CARD_2_Y, false);
                continue;
            }
            GameRenderer.renderCard(g, card, xoff + PLAYER_CARD_2_X + PLAYER_CARD_X_INCREMENT * (i - 1), PLAYER_CARD_2_Y + PLAYER_CARD_Y_INCREMENT * (i - 1), false);
        }
        if (cardsDealt >= 2) {
            int totalX = xoff + PLAYER_CARD_2_X + PLAYER_CARD_X_INCREMENT * (cardsDealt - 2) + 53;
            int totalY = PLAYER_CARD_2_Y + 4;
            Common.normalBlackFont.drawString(g, totalString, totalX + 1, totalY + 1);
            Common.normalWhiteFont.drawString(g, totalString, totalX, totalY);
        }
        this.parent.mBetStr = this.parent.mGame.getPlayerHand(hand).getBet().toString();
        this.parent.mInsuranceStr = this.parent.mGame.getPlayerHand(hand).getInsuranceBet().toString();
        if (this.parent.mTurn == 5) {
            if (winnings.flag == -2) {
                this.renderMoneyLabel(g, xoff + PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent.mBetStr, true);
                this.renderMoneyLabel(g, xoff + PLAYER_WINNINGS_X, PLAYER_WINNINGS_Y, "WINNINGS", _winnings.toString(), false);
            } else if (winnings.flag == -3) {
                this.renderMoneyLabel(g, xoff + PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent.mBetStr, false);
                this.renderMoneyLabel(g, xoff + PLAYER_WINNINGS_X, PLAYER_WINNINGS_Y, "WINNINGS", _winnings.toString(), false);
            } else if (winnings.flag == -4) {
                this.renderMoneyLabel(g, xoff + PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent.mBetStr, false);
            } else if (winnings.flag == -1) {
                this.renderMoneyLabel(g, xoff + PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent.mBetStr, false);
                this.renderMoneyLabel(g, xoff + PLAYER_WINNINGS_X, PLAYER_WINNINGS_Y, "WINNINGS", "0", false);
            } else if (winnings.isZero()) {
                this.renderMoneyLabel(g, xoff + PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent.mBetStr, true);
            } else {
                this.renderMoneyLabel(g, xoff + PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent.mBetStr, false);
                this.renderMoneyLabel(g, xoff + PLAYER_WINNINGS_X, PLAYER_WINNINGS_Y, "WINNINGS", _winnings.toString(), false);
            }
            if (this.parent.mGame.getPlayerHand(hand).hasTakenInsurance()) {
                if (winnings.flag == -2) {
                    this.renderMoneyLabel(g, xoff + PLAYER_INSURANCE_X, PLAYER_INSURANCE_Y, "INSURANCE", this.parent.mInsuranceStr, false);
                } else {
                    this.renderMoneyLabel(g, xoff + PLAYER_INSURANCE_X, PLAYER_INSURANCE_Y, "INSURANCE", this.parent.mInsuranceStr, true);
                }
            }
        } else {
            this.renderMoneyLabel(g, xoff + PLAYER_BET_X, PLAYER_BET_Y, "BET", this.parent.mBetStr);
            if (this.parent.mGame.getPlayerHand(hand).hasTakenInsurance()) {
                this.renderMoneyLabel(g, xoff + PLAYER_INSURANCE_X, PLAYER_INSURANCE_Y, "INSURANCE", this.parent.mInsuranceStr);
            }
        }
    }

    public void renderDealerCards(GraphicsScaler g) {
        for (int i = 0; i < this.parent.mDealerCardsDealt; ++i) {
            Card card = this.parent.mGame.getDealerHand().getCard(i);
            if (i == 0) {
                if (this.parent.mTurnCardFrame > 0) {
                    if (this.parent.mTurnCardFrame > 10) {
                        GameRenderer.renderCard(g, card, DEALER_CARD_1_X - 2 * (20 - this.parent.mTurnCardFrame), DEALER_CARD_1_Y, true);
                    } else {
                        GameRenderer.renderCard(g, card, DEALER_CARD_1_X - 2 * this.parent.mTurnCardFrame, DEALER_CARD_1_Y, true);
                    }
                    --this.parent.mTurnCardFrame;
                    continue;
                }
                if (this.parent.mTurn == 2 || this.parent.mTurn == 5 || this.parent.mTurn == 8 || this.parent.mTurn == 6) {
                    GameRenderer.renderCard(g, card, DEALER_CARD_1_X, DEALER_CARD_1_Y, false);
                    continue;
                }
                GameRenderer.renderCard(g, card, DEALER_CARD_1_X, DEALER_CARD_1_Y, true);
                continue;
            }
            if (i == 1) {
                GameRenderer.renderCard(g, card, DEALER_CARD_2_X, DEALER_CARD_2_Y, false);
                continue;
            }
            GameRenderer.renderCard(g, card, DEALER_CARD_2_X + PLAYER_CARD_X_INCREMENT * (i - 1), DEALER_CARD_2_Y + PLAYER_CARD_Y_INCREMENT * (i - 1), false);
        }
        if (this.parent.mTurn == 2 || this.parent.mTurn == 5 || this.parent.mTurn == 8) {
            String totalString = this.parent.mDealerTotalString;
            int totalX = DEALER_CARD_2_X + DEALER_CARD_X_INCREMENT * (this.parent.mDealerCardsDealt - 2) + 53;
            int totalY = DEALER_CARD_2_Y + 4;
            Common.normalBlackFont.drawString(g, totalString, totalX + 1, totalY + 1);
            Common.normalWhiteFont.drawString(g, totalString, totalX, totalY);
        }
    }

    public void renderCardLabels(GraphicsScaler g) {
        int dRes = -1;
        int pRes = -1;
        this.labelXOffset = 0;
        if (this.parent.mTurn == 3 || this.parent.mTurn == 9) {
            Hand ph = this.parent.mGame.getPlayerHand();
            if (ph.hasSurrendered()) {
                pRes = 6;
            } else if (ph.getTotal() == 21) {
                pRes = 1;
            } else if (ph.hasBust()) {
                pRes = 8;
            } else if (this.parent.mTurn == 9) {
                pRes = 5;
            }
        } else if (this.parent.mTurn == 2) {
            Hand ph = this.parent.mGame.getPlayerHand();
            pRes = ph.hasSurrendered() ? 6 : (ph.hasBlackjack() ? 0 : (ph.getTotal() == 21 ? 1 : (ph.hasBust() ? 8 : 5)));
        } else if (this.parent.mTurn == 5) {
            Hand dh = this.parent.mGame.getDealerHand();
            Hand ph = this.parent.mGame.getPlayerHand();
            if (ph.hasSurrendered()) {
                dRes = -1;
                pRes = 6;
            } else if (ph.hasTakenEvenMoney()) {
                dRes = -1;
                pRes = 7;
            } else if (ph.hasBlackjack()) {
                if (dh.hasBlackjack()) {
                    pRes = 4;
                    dRes = 4;
                } else {
                    dRes = 3;
                    pRes = 0;
                }
            } else if (dh.hasBlackjack()) {
                dRes = 0;
                pRes = 3;
            } else if (ph.hasBust()) {
                if (dh.hasBust()) {
                    dRes = 4;
                    pRes = 4;
                } else {
                    dRes = 2;
                    pRes = 8;
                }
            } else if (ph.getTotal() <= 21) {
                if (dh.hasBust()) {
                    dRes = 8;
                    pRes = ph.getTotal() == 21 ? 1 : 2;
                } else if (dh.getTotal() < this.parent.mGame.getPlayerHand().getTotal()) {
                    dRes = 3;
                    pRes = ph.getTotal() == 21 ? 1 : 2;
                } else if (dh.getTotal() == ph.getTotal()) {
                    pRes = 4;
                    dRes = 4;
                } else {
                    dRes = ph.getTotal() == 21 ? 1 : 2;
                    pRes = 3;
                }
            }
        }
        if (pRes > -1) {
            g.setClip(PLAYER_HAND_LABEL_X + this.labelXOffset, PLAYER_HAND_LABEL_Y, 84, 30);
            g.drawImage(GameRes.mHandLabelsBitmap, PLAYER_HAND_LABEL_X + this.labelXOffset, PLAYER_HAND_LABEL_Y - pRes * 30, 20);
            g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
        }
        if (dRes > -1) {
            g.setClip(DEALER_HAND_LABEL_X + this.labelXOffset, DEALER_HAND_LABEL_Y, 84, 30);
            g.drawImage(GameRes.mHandLabelsBitmap, DEALER_HAND_LABEL_X + this.labelXOffset, DEALER_HAND_LABEL_Y - dRes * 30, 20);
            g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
        }
    }

    public static void renderCard(GraphicsScaler g, Card card, int x, int y) {
        GameRenderer.renderCard(g, card, x, y, false);
    }

    public static void renderCard(GraphicsScaler g, Card card, int x, int y, boolean drawCardBack) {
        if (drawCardBack) {
            g.setClip(x, y, 51, 73);
            g.drawImage(GameRes.mCardBasesBitmap, x - 204, y, 20);
            g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
        } else if (card != null) {
            int s = card.getSuitIndex();
            int v = card.getRank();
            g.setClip(x, y, 51, 73);
            g.drawImage(GameRes.mCardBasesBitmap, x - s * 51, y, 20);
            g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
            int textY = y + 7;
            int textX = x + 5;
            g.setClip(textX, textY, 10, 12);
            if (s == 0 || s == 2) {
                g.drawImage(GameRes.mCardNumbersBitmap, textX - 10 * v, textY, 20);
            } else {
                g.drawImage(GameRes.mCardNumbersBitmap, textX - 10 * v, textY - 12, 20);
            }
            g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
        }
    }

    public void renderButtons(GraphicsScaler g) {
        if (this.parent.mTurn == 3) {
            if (this.parent.mGame.canHandHit()) {
                this.renderButton(g, BUTTONS_X, BUTTONS_Y, 0, this.parent.mButtonDown == 0, false);
            } else {
                this.renderButton(g, BUTTONS_X, BUTTONS_Y, 0, false, true);
            }
            this.renderButton(g, BUTTONS_X + BUTTONS_X_INCREMENT, BUTTONS_Y, 1, this.parent.mButtonDown == 1, false);
            if (this.parent.mGame.canHandDouble()) {
                this.renderButton(g, BUTTONS_X + 2 * BUTTONS_X_INCREMENT, BUTTONS_Y, 2, this.parent.mButtonDown == 2, false);
            } else {
                this.renderButton(g, BUTTONS_X + 2 * BUTTONS_X_INCREMENT, BUTTONS_Y, 2, false, true);
            }
            if (this.parent.mGame.canHandSplit()) {
                this.renderButton(g, BUTTONS_X + 3 * BUTTONS_X_INCREMENT, BUTTONS_Y, 3, this.parent.mButtonDown == 3, false);
            } else {
                this.renderButton(g, BUTTONS_X + 3 * BUTTONS_X_INCREMENT, BUTTONS_Y, 3, false, true);
            }
            if (this.parent.mSelectedButton == 0) {
                g.drawImage(GameRes.mButtonHighlightBitmap, BUTTONS_X + BUTTON_HIGHLIGHTER_X_OFFSET, BUTTONS_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
            } else if (this.parent.mSelectedButton == 1) {
                g.drawImage(GameRes.mButtonHighlightBitmap, BUTTONS_X + 1 * BUTTONS_X_INCREMENT + BUTTON_HIGHLIGHTER_X_OFFSET, BUTTONS_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
            } else if (this.parent.mSelectedButton == 2) {
                g.drawImage(GameRes.mButtonHighlightBitmap, BUTTONS_X + 2 * BUTTONS_X_INCREMENT + BUTTON_HIGHLIGHTER_X_OFFSET, BUTTONS_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
            } else if (this.parent.mSelectedButton == 3) {
                g.drawImage(GameRes.mButtonHighlightBitmap, BUTTONS_X + 3 * BUTTONS_X_INCREMENT + BUTTON_HIGHLIGHTER_X_OFFSET, BUTTONS_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
            }
            if (this.parent.mDisplayHintStar && this.parent.mAnimationQueue.isEmpty()) {
                int starX = BUTTONS_X + BUTTON_HINT_STAR_X_OFFSET;
                int starY = BUTTONS_Y + BUTTON_HINT_STAR_Y_OFFSET;
                boolean drawStar = false;
                if (this.parent.mGame.mStrategyAction == 0) {
                    drawStar = true;
                } else if (this.parent.mGame.mStrategyAction == 1) {
                    drawStar = true;
                    starX += BUTTONS_X_INCREMENT;
                } else if (this.parent.mGame.mStrategyAction == 8) {
                    drawStar = true;
                    starX += 2 * BUTTONS_X_INCREMENT;
                } else if (this.parent.mGame.mStrategyAction == 4) {
                    drawStar = true;
                    starX += 3 * BUTTONS_X_INCREMENT;
                } else if (this.parent.mGame.mStrategyAction == 9) {
                    drawStar = true;
                    starX = 4;
                    starY = RunnableCanvas.screenHeight - 60;
                    Common.normalBlackFont.drawString(g, "Surrender", starX + 24 + 1, starY + 4 + 1);
                    Common.normalWhiteFont.drawString(g, "Surrender", starX + 24, starY + 4);
                }
                if (drawStar) {
                    g.drawImage(GameRes.mHintStarBitmap, starX, starY, 20);
                }
            }
        } else if (this.parent.mTurn == 5) {
            this.renderButton(g, BUTTONS_NEXTGAME_X, BUTTONS_NEXTGAME_Y, 4, this.parent.mButtonDown == 4, false);
            if (this.parent.mSelectedButton == 4) {
                g.drawImage(GameRes.mButtonHighlightBitmap, BUTTONS_NEXTGAME_X + BUTTON_HIGHLIGHTER_X_OFFSET, BUTTONS_NEXTGAME_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
            }
            if (this.parent.mPlayerHand > 0) {
                if (this.parent.mButtonDown == 16) {
                    g.drawImage(GameRes.mHandLeftDownBitmap, HAND_POINTER_LEFT_X, HAND_POINTER_LEFT_Y, 20);
                } else {
                    g.drawImage(GameRes.mHandLeftUpBitmap, HAND_POINTER_LEFT_X, HAND_POINTER_LEFT_Y, 20);
                }
                if (this.parent.mSelectedButton == 16) {
                    g.drawImage(GameRes.mHandLeftHighlightBitmap, HAND_POINTER_LEFT_X - 5, HAND_POINTER_LEFT_Y - 5, 20);
                }
            }
            if (this.parent.mPlayerHandsDealt - 1 > this.parent.mPlayerHand) {
                if (this.parent.mButtonDown == 17) {
                    g.drawImage(GameRes.mHandRightDownBitmap, HAND_POINTER_RIGHT_X, HAND_POINTER_RIGHT_Y, 20);
                } else {
                    g.drawImage(GameRes.mHandRightUpBitmap, HAND_POINTER_RIGHT_X, HAND_POINTER_RIGHT_Y, 20);
                }
                if (this.parent.mSelectedButton == 17) {
                    g.drawImage(GameRes.mHandRightHighlightBitmap, HAND_POINTER_RIGHT_X - 3, HAND_POINTER_RIGHT_Y - 5, 20);
                }
            }
        }
    }

    public void renderAnimatedObjects(GraphicsScaler g) {
        this.renderAnimatedObjects(g, true);
    }

    public void renderAnimatedObjects(GraphicsScaler g, boolean topMost) {
        int queueLength = this.parent.mAnimationQueue.size();
        AnimatedObject ao = null;
        for (int i = 0; i < queueLength; ++i) {
            ao = (AnimatedObject)this.parent.mAnimationQueue.elementAt(i);
            int id = ao.id;
            int token = ao.token;
            int token2 = ao.token2;
            if (topMost) {
                if (id == 7) {
                    g.drawImage(GameRes.mCardPeekBitmap, DEALER_CARD_PEEK_X, DEALER_CARD_PEEK_Y, 20);
                    continue;
                }
                if (id == 8 || id == 9 || id == 10) {
                    g.setClip(ao.x, ao.y, 26, 25);
                    g.drawImage(GameRes.mChipsBitmap, ao.x, ao.y - 25 * ao.token, 20);
                    g.setClip(0, 0, RunnableCanvas.screenWidth, RunnableCanvas.screenHeight);
                    continue;
                }
                if (id == 2) {
                    GameRenderer.renderCard(g, this.parent.mGame.getDealerHand().getCard(0), ao.x, ao.y, true);
                    continue;
                }
                if (id == 3 || id == 5 || id == 12) {
                    GameRenderer.renderCard(g, this.parent.mGame.getDealerHand().getCard(token), ao.x, ao.y, false);
                    continue;
                }
                if (id == 4 || id == 1 || id == 0 || id == 11 || id == 14) {
                    GameRenderer.renderCard(g, this.parent.mGame.getPlayerHand().getCard(token), ao.x, ao.y, false);
                    continue;
                }
                if (id == 13) {
                    if (token == 0) {
                        GameRenderer.renderCard(g, this.parent.mGame.getPlayerHand(this.parent.mPlayerHand - 1).getCard(0), ao.x, ao.y, false);
                        continue;
                    }
                    if (token != 1) continue;
                    GameRenderer.renderCard(g, this.parent.mGame.getPlayerHand().getCard(0), ao.x, ao.y, false);
                    continue;
                }
                if (id != 15) continue;
                GameRenderer.renderCard(g, this.parent.mGame.getPlayerHand(token).getCard(token2), ao.x, ao.y, false);
                continue;
            }
            if (id != 17 && id != 18) continue;
            g.drawImage(GameRes.mPlaceBetsBitmap, ao.x, ao.y, 20);
        }
    }

    public void renderMoneyLabel(GraphicsScaler g, int x, int y, String label_string, String value) {
        this.renderMoneyLabel(g, x, y, label_string, value, false);
    }

    public void renderMoneyLabel(GraphicsScaler g, int x, int y, String label, String value, boolean isRed) {
        if (label.equals("BET")) {
            g.drawImage(GameRes.mBetLabelBitmap, x, y, 24);
            y += GameRes.mBetLabelBitmap.getHeight() + 1;
        } else if (label.equals("INSURANCE")) {
            g.drawImage(GameRes.mInsuranceLabelBitmap, x, y, 24);
            y += GameRes.mInsuranceLabelBitmap.getHeight() + 1;
        } else if (label.equals("WINNINGS")) {
            g.drawImage(GameRes.mWinningsLabelBitmap, x, y, 24);
            y += GameRes.mWinningsLabelBitmap.getHeight() + 1;
        }
        if (isRed) {
            GameRes.mCashRedFont.drawString(g.getGraphics(), this.parent.mCurrencyStr + value, g.scale(x) - GameRes.mCashFont.stringWidth(this.parent.mCurrencyStr + value), g.scale(y));
        } else {
            GameRes.mCashFont.drawString(g.getGraphics(), this.parent.mCurrencyStr + value, g.scale(x) - GameRes.mCashFont.stringWidth(this.parent.mCurrencyStr + value), g.scale(y));
        }
    }

    private void renderInsurance(GraphicsScaler g) {
        g.drawImage(GameRes.mBigBannerBitmap, BIG_BANNER_X, BIG_BANNER_Y, 20);
        g.drawImage(GameRes.mBigBannerInsuranceBitmap, BIG_BANNER_TEXT_X, BIG_BANNER_TEXT_Y, 20);
        this.renderButton(g, YES_BUTTON_X, YES_BUTTON_Y, 7, this.parent.mButtonDown == 7, false);
        this.renderButton(g, NO_BUTTON_X, NO_BUTTON_Y, 8, this.parent.mButtonDown == 8, false);
        if (this.parent.mSelectedButton == 8) {
            g.drawImage(GameRes.mButtonHighlightBitmap, NO_BUTTON_X + BUTTON_HIGHLIGHTER_X_OFFSET, NO_BUTTON_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
        } else if (this.parent.mSelectedButton == 7) {
            g.drawImage(GameRes.mButtonHighlightBitmap, YES_BUTTON_X + BUTTON_HIGHLIGHTER_X_OFFSET, YES_BUTTON_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
        }
        if (this.parent.mDisplayHintStar) {
            int starX = NO_BUTTON_X + BUTTON_HINT_STAR_X_OFFSET;
            int starY = NO_BUTTON_Y + BUTTON_HINT_STAR_Y_OFFSET;
            g.drawImage(GameRes.mHintStarBitmap, starX, starY, 20);
        }
    }

    private void renderEvenMoney(GraphicsScaler g) {
        g.drawImage(GameRes.mBigBannerBitmap, BIG_BANNER_X, BIG_BANNER_Y, 20);
        g.drawImage(GameRes.mBigBannerEvenMoneyBitmap, BIG_BANNER_TEXT_X, BIG_BANNER_TEXT_Y, 20);
        this.renderButton(g, YES_BUTTON_X, YES_BUTTON_Y, 7, this.parent.mButtonDown == 18, false);
        this.renderButton(g, NO_BUTTON_X, NO_BUTTON_Y, 8, this.parent.mButtonDown == 19, false);
        if (this.parent.mSelectedButton == 19) {
            g.drawImage(GameRes.mButtonHighlightBitmap, NO_BUTTON_X + BUTTON_HIGHLIGHTER_X_OFFSET, NO_BUTTON_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
        } else if (this.parent.mSelectedButton == 18) {
            g.drawImage(GameRes.mButtonHighlightBitmap, YES_BUTTON_X + BUTTON_HIGHLIGHTER_X_OFFSET, YES_BUTTON_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
        }
        if (this.parent.mDisplayHintStar) {
            int starX = NO_BUTTON_X + BUTTON_HINT_STAR_X_OFFSET;
            int starY = NO_BUTTON_Y + BUTTON_HINT_STAR_Y_OFFSET;
            g.drawImage(GameRes.mHintStarBitmap, starX, starY, 20);
        }
    }

    private void renderSurrender(GraphicsScaler g) {
        g.drawImage(GameRes.mBigBannerBitmap, BIG_BANNER_X, BIG_BANNER_Y, 20);
        g.drawImage(GameRes.mBigBannerSurrenderBitmap, BIG_BANNER_TEXT_X, BIG_BANNER_TEXT_Y, 20);
        this.renderButton(g, YES_BUTTON_X, YES_BUTTON_Y, 7, this.parent.mButtonDown == 14, false);
        this.renderButton(g, NO_BUTTON_X, NO_BUTTON_Y, 8, this.parent.mButtonDown == 15, false);
        if (this.parent.mSelectedButton == 15) {
            g.drawImage(GameRes.mButtonHighlightBitmap, NO_BUTTON_X + BUTTON_HIGHLIGHTER_X_OFFSET, NO_BUTTON_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
        } else if (this.parent.mSelectedButton == 14) {
            g.drawImage(GameRes.mButtonHighlightBitmap, YES_BUTTON_X + BUTTON_HIGHLIGHTER_X_OFFSET, YES_BUTTON_Y + BUTTON_HIGHLIGHTER_Y_OFFSET, 20);
        }
        if (this.parent.mDisplayHintStar) {
            int starX = NO_BUTTON_X + BUTTON_HINT_STAR_X_OFFSET;
            int starY = NO_BUTTON_Y + BUTTON_HINT_STAR_Y_OFFSET;
            if (this.parent.mGame.mStrategyAction == 9) {
                starX = YES_BUTTON_X + BUTTON_HINT_STAR_X_OFFSET;
                starY = YES_BUTTON_Y + BUTTON_HINT_STAR_Y_OFFSET;
                g.drawImage(GameRes.mHintStarBitmap, starX, starY, 20);
            } else {
                g.drawImage(GameRes.mHintStarBitmap, starX, starY, 20);
            }
        }
    }
}

