/*
 * Decompiled with CFR 0.152.
 */
package tube42.lib.ui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tube42.lib.ui.ColorUtils;

public final class ImageUtils {
    public static Image moveToGPU(Image img) {
        return Image.createImage((Image)img);
    }

    public static Image moveToCPU(Image img) {
        Image ret = Image.createImage((int)img.getWidth(), (int)img.getHeight());
        Graphics g = ret.getGraphics();
        g.drawImage(img, 0, 0, 0);
        return ret;
    }

    public static Image blend(Image img1, Image img2, int value256) {
        if (value256 == 255) {
            return img1;
        }
        if (value256 == 0) {
            return img2;
        }
        int w1 = img1.getWidth();
        int h1 = img1.getHeight();
        int w2 = img2.getWidth();
        int h2 = img2.getHeight();
        int w0 = Math.min(w1, w2);
        int h0 = Math.min(h1, h2);
        int[] data = new int[w0 * h0];
        int[] b1 = new int[w0];
        int[] b2 = new int[w0];
        value256 &= 0xFF;
        int offset = 0;
        for (int i = 0; i < h0; ++i) {
            img1.getRGB(b1, 0, w1, 0, i, w0, 1);
            img2.getRGB(b2, 0, w2, 0, i, w0, 1);
            for (int j = 0; j < w0; ++j) {
                data[offset++] = ColorUtils.blend(b1[j], b2[j], value256);
            }
        }
        Image tmp = Image.createRGBImage((int[])data, (int)w0, (int)h0, (boolean)true);
        data = null;
        return tmp;
    }

    public static Image halve(Image org) {
        int w1 = org.getWidth();
        int h1 = org.getHeight();
        int w2 = w1 / 2;
        int h2 = h1 / 2;
        int[] data = new int[w2 * h2];
        int[] buffer = new int[w1 * 2];
        int offset = 0;
        for (int i = 0; i < h2; ++i) {
            org.getRGB(buffer, 0, w1, 0, i * 2, w1, 2);
            int o1 = 0;
            int o2 = 1;
            int o3 = w1;
            int o4 = w1 + 1;
            for (int j = 0; j < w2; ++j) {
                data[offset++] = ColorUtils.mix(buffer[o1], buffer[o2], buffer[o3], buffer[o4]);
                o1 += 2;
                o2 += 2;
                o3 += 2;
                o4 += 2;
            }
        }
        Image tmp = Image.createRGBImage((int[])data, (int)w2, (int)h2, (boolean)true);
        data = null;
        return tmp;
    }

    public static Image crop(Image src_i, int x0, int y0, int x1, int y1) {
        int tmp;
        if (x0 > x1) {
            tmp = x0;
            x0 = x1;
            x1 = tmp;
        }
        if (y0 > y1) {
            tmp = y0;
            y0 = y1;
            y1 = tmp;
        }
        Image ret = Image.createImage((int)(x1 - x0 + 1), (int)(y1 - y0 + 1));
        Graphics g = ret.getGraphics();
        g.drawImage(src_i, -x0, -y0, 0);
        return ret;
    }

    public static Image resize(Image src_i, int size_w, int size_h, boolean filter, boolean mipmap) {
        int h;
        int w = src_i.getWidth();
        if (size_w == w && size_h == h) {
            return src_i;
        }
        if (mipmap) {
            for (h = src_i.getHeight(); w > size_w * 2 && h > size_h * 2; w /= 2, h /= 2) {
                src_i = ImageUtils.halve(src_i);
            }
        }
        int[] dst = new int[size_w * size_h];
        if (filter) {
            ImageUtils.resize_rgb_filtered(src_i, dst, w, h, size_w, size_h);
        } else {
            ImageUtils.resize_rgb_unfiltered(src_i, dst, w, h, size_w, size_h);
        }
        src_i = null;
        return Image.createRGBImage((int[])dst, (int)size_w, (int)size_h, (boolean)true);
    }

    public static Image resize(int[] src_d, int src_w, int src_h, int size_w, int size_h, boolean filter) {
        if (size_w == src_w && size_h == src_h) {
            return Image.createRGBImage((int[])src_d, (int)src_w, (int)src_h, (boolean)true);
        }
        int[] dst = new int[size_w * size_h];
        if (filter) {
            ImageUtils.resize_rgb_filtered(src_d, dst, src_w, src_h, size_w, size_h);
        } else {
            ImageUtils.resize_rgb_unfiltered(src_d, dst, src_w, src_h, size_w, size_h);
        }
        src_d = null;
        return Image.createRGBImage((int[])dst, (int)size_w, (int)size_h, (boolean)true);
    }

    private static final void resize_rgb_unfiltered(Image src_i, int[] dst, int w0, int h0, int w1, int h1) {
        int[] buffer = new int[w0];
        int index1 = 0;
        int index0_y = 0;
        for (int y = 0; y < h1; ++y) {
            int y_ = index0_y / h1;
            int index0_x = 0;
            src_i.getRGB(buffer, 0, w0, 0, y_, w0, 1);
            for (int x = 0; x < w1; ++x) {
                int x_ = index0_x / w1;
                dst[index1++] = buffer[x_];
                index0_x += w0;
            }
            index0_y += h0;
        }
    }

    private static final void resize_rgb_unfiltered(int[] src_d, int[] dst, int src_w, int src_h, int dest_w, int dest_h) {
        int index1 = 0;
        int index0_y = 0;
        for (int y = 0; y < dest_h; ++y) {
            int y_ = index0_y / dest_h;
            int index0_x = 0;
            for (int x = 0; x < dest_w; ++x) {
                int x_ = index0_x / dest_w;
                dst[index1++] = src_d[y_ * src_w + x_];
                index0_x += src_w;
            }
            index0_y += src_h;
        }
    }

    private static final void resize_rgb_filtered(Image src_i, int[] dst, int w0, int h0, int w1, int h1) {
        int[] buffer1 = new int[w0];
        int[] buffer2 = new int[w0];
        int index1 = 0;
        for (int y = 0; y < h1; ++y) {
            int y_a = (y * h0 << 8) / h1;
            int y_a1 = y_a >> 8;
            int y_d = y_a & 0xFF;
            int y_b1 = y_a1 + 1;
            if (y_b1 >= h0) {
                y_b1 = h0 - 1;
                y_d = 0;
            }
            src_i.getRGB(buffer1, 0, w0, 0, y_a1, w0, 1);
            if (y_d != 0) {
                src_i.getRGB(buffer2, 0, w0, 0, y_b1, w0, 1);
            }
            for (int x = 0; x < w1; ++x) {
                int c34;
                int c12;
                int x_a = (x * w0 << 8) / w1;
                int x_a1 = x_a >> 8;
                int x_d = x_a & 0xFF;
                int x_b1 = x_a1 + 1;
                if (x_b1 >= w0) {
                    x_b1 = w0 - 1;
                    x_d = 0;
                }
                int c1 = buffer1[x_a1];
                int c3 = buffer1[x_b1];
                if (y_d == 0) {
                    c12 = c1;
                    c34 = c3;
                } else {
                    int c2 = buffer2[x_a1];
                    int c4 = buffer2[x_b1];
                    c12 = ColorUtils.blend(c2, c1, y_d);
                    c34 = ColorUtils.blend(c4, c3, y_d);
                }
                dst[index1++] = ColorUtils.blend(c34, c12, x_d);
            }
        }
    }

    private static final void resize_rgb_filtered(int[] src_d, int[] dst, int src_w, int src_h, int dest_w, int dest_h) {
        int index1 = 0;
        for (int y = 0; y < dest_h; ++y) {
            int y_a = (y * src_h << 8) / dest_h;
            int y_a1 = y_a >> 8;
            int y_d = y_a & 0xFF;
            int y_b1 = y_a1 + 1;
            if (y_b1 >= src_h) {
                y_b1 = src_h - 1;
                y_d = 0;
            }
            for (int x = 0; x < dest_w; ++x) {
                int c34;
                int c12;
                int x_a = (x * src_w << 8) / dest_w;
                int x_a1 = x_a >> 8;
                int x_d = x_a & 0xFF;
                int x_b1 = x_a1 + 1;
                if (x_b1 >= src_w) {
                    x_b1 = src_w - 1;
                    x_d = 0;
                }
                int c1 = src_d[y_a1 * src_w + x_a1];
                int c3 = src_d[y_a1 * src_w + x_b1];
                if (y_d == 0) {
                    c12 = c1;
                    c34 = c3;
                } else {
                    int c2 = src_d[y_b1 * src_w + x_a1];
                    int c4 = src_d[y_b1 * src_w + x_b1];
                    c12 = ColorUtils.blend(c2, c1, y_d);
                    c34 = ColorUtils.blend(c4, c3, y_d);
                }
                dst[index1++] = ColorUtils.blend(c34, c12, x_d);
            }
        }
    }
}

