/*
 * Decompiled with CFR 0.152.
 */
package tube42.lib.ui;

public final class ColorUtils {
    public static final int blend(int c1, int c2, int value256) {
        int v1 = value256 & 0xFF;
        int c1_RB = c1 & 0xFF00FF;
        int c2_RB = c2 & 0xFF00FF;
        int c1_AG = c1 >>> 8 & 0xFF00FF;
        int c2_AG_org = c2 & 0xFF00FF00;
        int c2_AG = c2_AG_org >>> 8;
        int rb = c2_RB + ((c1_RB - c2_RB) * v1 >> 8) & 0xFF00FF;
        int ag = c2_AG_org + (c1_AG - c2_AG) * v1 & 0xFF00FF00;
        return ag | rb;
    }

    public static int darker(int c) {
        int a = c >> 24 & 0xFF;
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c >> 0 & 0xFF;
        r = r * 15 >> 4;
        g = g * 15 >> 4;
        b = b * 15 >> 4;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int lighter(int c) {
        int a = c >> 24 & 0xFF;
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c >> 0 & 0xFF;
        r = Math.max(1, Math.min(255, r * 17 >> 4));
        g = Math.max(1, Math.min(255, g * 17 >> 4));
        b = Math.max(1, Math.min(255, b * 17 >> 4));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int mix(int c1, int c2) {
        int c_RB = (c1 & 0xFF00FF) + (c2 & 0xFF00FF) >> 1 & 0xFF00FF;
        int c_AG = ((c1 & 0xFF00FF00) >>> 1) + ((c2 & 0xFF00FF00) >>> 1) & 0xFF00FF00;
        return c_RB | c_AG;
    }

    public static int mix(int c1, int c2, int c3, int c4) {
        int c_RB = (c1 & 0xFF00FF) + (c2 & 0xFF00FF) + (c3 & 0xFF00FF) + (c4 & 0xFF00FF) >> 2 & 0xFF00FF;
        int c_AG = ((c1 & 0xFF00FF00) >>> 2) + ((c2 & 0xFF00FF00) >>> 2) + ((c3 & 0xFF00FF00) >>> 2) + ((c4 & 0xFF00FF00) >>> 2) & 0xFF00FF00;
        return c_RB | c_AG;
    }

    public static final void ARGB2AYCbCr(int argb, int[] result) {
        int a = argb >>> 24;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        result[0] = a;
        result[1] = r * 77 + g * 150 + b * 29 >> 8;
        result[2] = 32768 - r * 43 - g * 85 + b * 128 >> 8;
        result[3] = 32768 + r * 128 - g * 107 - b * 21 >> 8;
    }

    public static final int AYCbCr2ARGB(int[] components) {
        int Y8 = components[1] << 8;
        int r = Math.max(0, Math.min(255, Y8 + (components[3] - 128) * 359 >> 8));
        int g = Math.max(0, Math.min(255, Y8 - (components[3] - 128) * 183 - (components[2] - 128) * 88 >> 8));
        int b = Math.max(0, Math.min(255, Y8 + (components[2] - 128) * 454 >> 8));
        return components[0] << 24 | r << 16 | g << 8 | b;
    }
}

