/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.FrameRenderer;
import net.handyx.casinopack.common.GMG;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.common.RunnableCanvas;
import net.handyx.casinopack.common.Settings;
import net.handyx.casinopack.videopoker.Common;
import net.handyx.casinopack.videopoker.VideoPoker;

public class MenuCanvas
extends RunnableCanvas {
    private VideoPoker parent;
    private Image titleImage;
    private Image scrollerImage;
    private Image[] alphaMesh = new Image[5];
    private int alphaIndex = -1;
    private int MAIN_MENU = 0;
    private int OPTIONS_MENU = 1;
    private int HELP_MENU = 2;
    private int displayMode = this.MAIN_MENU;
    private String[] menuItems = new String[]{"New Game", "Resume Game", "Settings", "Help", "About", "Exit"};
    private String[] menuItemsGMG = new String[]{"New Game", "Resume Game", "Settings", "Get More Games", "Help", "About", "Exit"};
    private int GMG_INDEX = 3;
    private static final String ABOUT_TEXT = "Ace Roller\nCasino Classics\n\nHandyX Ltd.\nVersion " + Settings.VERSION_STRING + "\n\nFor more information visit www.handyx.net or contact us on support@sprite.net";
    private static final String NEW_GAME_TEXT = "Start New Game?\n\nWarning: This will reset any winnings you have obtained in your current game.";
    private static final String EXIT_GAME_TEXT = "Are you sure you want to exit?\n\nNote. The money you have bet in your current round will be lost.";
    private String[] optionsMenuItems = new String[]{"Sound", "Card Strategy Hints", "Double or Nothing", "Perfect Play Warning", "Starting Cash", "Coin Value"};
    private String[][] optionsMenuItemSettings = new String[][]{{"On (loud)", "Off", "On (quiet)", "On (med)"}, {"On", "Off"}, {"On", "Off"}, {"On", "Off"}, {"$250", "$500", "$1,000", "$5,000", "$10,000"}, {"$1", "$3", "$5", "$10", "$25", "$50", "$100", "$250"}};
    public static final int SOUND_MENU_INDEX = 0;
    public static final String[] VOLUME_OPTIONS = new String[]{"On (med)", "On (loud)", "Off", "On (quiet)"};
    public static final int[] VOLUME_SETTINGS = new int[]{50, 75, 0, 25};
    public static final String[] NON_VOLUME_OPTIONS = new String[]{"On", "Off"};
    public static final int[] NON_VOLUME_SETTINGS = new int[]{100, 0};
    private String[] optionsMenuDescription = new String[]{"This options turns the sound effects on or off.", "If enabled, the best cards to hold will be highlighted using a star when your hand is dealt.", "If enabled, you get the chance to double your money if you get a winning hand. Changes will update the next round of your game.", "If enabled, a warning message will be displayed if you don't make the recommended play for your hand.", "This setting defines how much money you start with. Changes will update the next game you play.", "This setting defines how much each coin is worth. Changes will update the next round of your game."};
    private int[] actualStartingCashValues = new int[]{250, 500, 1000, 5000, 10000};
    private int[] actualCoinValues = new int[]{1, 3, 5, 10, 25, 50, 100, 250};
    private int descriptionBoxWidth = 220;
    private int descriptionBoxHeight = 75;
    private int descriptionBoxY = 215;
    private int descriptionBoxX = 10;
    private int[] optionsSettings = new int[]{0, 0, 0, 1, 0, 0};
    private int maxLines = 18;
    private int lineOffset = 0;
    private int scrolling = 0;
    private String[] helpMenuItems = new String[]{"Objective", "Betting", "How to Play", "Game Controls", "Poker Hands"};
    private String[] helpMenuText = new String[]{"Jacks or Better is a game of draw poker. The player receives five cards from the deck; they then choose which of the cards to keep or \"hold\". The un-held cards are then discarded and new ones dealt. The final 5 card hand is determined a winning hand if the player has a pair of Jacks or better.\n\nBefore the cards are dealt you must select how many coins you will bet on the next hand. One to five coins can be bet and the payout increases depending the size of the bet.\n\nThe payout table is displayed above the cards and shows how much will be payed out for each winning hand. The actual winnings will be the value shown on the payout table multiplied by the value of the coin, e.g. if the payout table shows 15 and the coin value is $5 then the actual payout will be $75.\n\nIf you recieve a winning hand you are also given the opportunity to play 'double or nothing', by winning each round you will double your winnings for that hand. However, if you lose you will lose all your winnings for that hand!", "First select the number of coins to bet by selecting the 'Bet One' button to increment the bet by one coin, the current bet is shown as the highlighted column on the paytable.\n\nNext, select the 'Deal/Draw' button to deal the first five cards. Alternatively, select the 'Bet Max' button to automatically put down the maximum bet (5 coins) and deal the hand.", "Once the cards have been dealt you are given the chance to hold any number of cards by pressing left/right to select the cards, and fire to hold or un-hold the card.\n\nWhen you have chosen your cards, press 'Deal' to replace the un-held cards and get your final hand.\n\nEach time you receive a winning hand you have the option to play Double or Nothing to double or lose your earnings for that game.\nHere you are dealt one card face up and must pick a higher one one out of the remaining four that are face down. If the card you pick is higher then you have double that game's winnings and can play Double or Nothing again using your new winnings (until you lose).\nIf the card you pick is lower then you lose all your current winnings. If the same then it's a tie and you can play Double or Nothing again (until you lose).", "You control the game with the standard phone direction joystick.\nUse the direction left & right or 4 & 8 keys to scroll focus through the Bet One, Deal Draw and Bet Max game buttons. Use the left soft key or direction fire to select the focused game button.\n\nNext use the direction left & right or 4 & 8 keys to scroll focus through the dealt cards. Use the left soft key or direction fire to hold or un-hold the focused card.\n\nWhen you're ready use the left soft key to get your final hand. If you have a winning hand then you have the option play Double or Nothing, use the left or right soft keys to select Yes or No to this respectively.\n\nUse the right soft key at any point to open the Options submenu. Use the direction up & down or 2 & keys to scroll focus through the options which can include Show Hint, Game Stats or a return to the Main Menu. Use the left soft key or direction fire to choose the focused option or right soft key to Cancel the submenu and return to the game.", "The following list is from best to worst in terms of payout, so any hand on the list is better than any hand below it.\n\n1. Royal Flush\nAn Ace-High straight of one suit.\n\n2. Straight Flush\nA straight of entirely one suit\n\n3. Four-of-a-Kind\nFour cards of the same rank.\n\n4. Full House\nThree-of-a-kind and a pair\n\n5. Flush\nFive cards of the same suit.\n\n6. Straight\nFive cards of sequential rank. An Ace can be considered high is the straight is 10,J,Q,K,A or low if the hand is A,2,3,4,5. \n\n7. Three-of-a-Kind\nThree cards of the same rank.\n\n8. Two Pair\n\nTwo cards of the same rank and another two cards of the same rank.\n\n9. Jacks or Better\nA pair or Jacks, Queens, Kings or Aces.\n\n"};
    private String[] helpLines = null;
    public int selectedIndex = 0;
    public int optionsSelectedIndex = 0;
    public int helpSelectedIndex = 0;
    private int POPUP_REVEAL = 1;
    private int POPUP_HIDE = 2;
    private int displayPopup = 0;
    private int POPUP_ABOUT = 0;
    private int POPUP_NEW_GAME = 1;
    private int POPUP_HELP = 2;
    private int POPUP_EXIT_CONFIRM = 3;
    private int POPUP_GMG_CONNECTION = 4;
    private int popupType = this.POPUP_ABOUT;
    private int boxW = 0;
    private int boxH = 0;
    private int boxNumFrames = 0;
    private int boxFrame = 0;

    public MenuCanvas(VideoPoker p) {
        this.parent = p;
    }

    public void loadResources() {
        this.titleImage = Common.loadImage("/title.jpg");
        this.scrollerImage = Common.loadImage("/scroller.png");
        if (!Settings.DISABLE_ALPHA_EFFECTS) {
            for (int i = 0; i < 5; ++i) {
                this.alphaMesh[i] = Common.loadCommonImage("/mesh_alpha" + i + ".png");
            }
        }
    }

    public void purgeResources() {
        this.titleImage = null;
        this.scrollerImage = null;
        if (!Settings.DISABLE_ALPHA_EFFECTS) {
            for (int i = 0; i < 5; ++i) {
                this.alphaMesh[i] = null;
            }
        }
        System.gc();
    }

    public void processFrame(int fn) {
        if (this.boxFrame < this.boxNumFrames) {
            ++this.boxFrame;
            if (this.displayPopup == this.POPUP_HIDE) {
                if (this.alphaIndex > -1) {
                    --this.alphaIndex;
                }
            } else if (this.alphaIndex < 4) {
                ++this.alphaIndex;
            }
            if (this.boxFrame == this.boxNumFrames && this.displayPopup == this.POPUP_HIDE) {
                this.displayPopup = 0;
                this.alphaIndex = -1;
            }
        }
        if (this.scrolling == 1) {
            if (this.lineOffset + this.maxLines < this.helpLines.length) {
                ++this.lineOffset;
            }
        } else if (this.scrolling == -1 && this.lineOffset > 0) {
            --this.lineOffset;
        }
    }

    public void paintCanvas(Graphics gfx, int sw, int sh) {
        int y;
        int x;
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        sw = g.getWidth();
        sh = g.getHeight();
        g.drawImage(Common.bgImage, 0, 0, 20);
        g.drawImage(this.titleImage, 0, 0, 20);
        if (this.displayMode == this.MAIN_MENU) {
            int i;
            x = 0;
            y = 110;
            if (GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                for (i = 0; i < this.menuItemsGMG.length; ++i) {
                    String s = this.menuItemsGMG[i];
                    if (i == this.GMG_INDEX) {
                        s = GMG.GET_MORE_GAMES_LABEL;
                    }
                    x = (sw - Common.largeFont.stringWidth(s)) / 2;
                    if (i == this.selectedIndex) {
                        Common.largeFont.drawString(g, s, x + 1, y + 1);
                        Common.largeFont.drawString(g, s, x, y);
                    } else {
                        Common.largeFontDisabled.drawString(g, s, x, y);
                    }
                    y += Common.largeFont.getHeight() + 5;
                }
            } else {
                for (i = 0; i < this.menuItems.length; ++i) {
                    x = (sw - Common.largeFont.stringWidth(this.menuItems[i])) / 2;
                    if (i == this.selectedIndex) {
                        Common.largeFont.drawString(g, this.menuItems[i], x + 1, y + 1);
                        Common.largeFont.drawString(g, this.menuItems[i], x, y);
                    } else {
                        Common.largeFontDisabled.drawString(g, this.menuItems[i], x, y);
                    }
                    y += Common.largeFont.getHeight() + 5;
                }
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, "Select", Common.largeFont);
            }
        } else if (this.displayMode == this.HELP_MENU) {
            x = 0;
            y = 110;
            for (int i = 0; i < this.helpMenuItems.length; ++i) {
                x = (sw - Common.largeFont.stringWidth(this.helpMenuItems[i])) / 2;
                if (i == this.helpSelectedIndex) {
                    Common.largeFont.drawString(g, this.helpMenuItems[i], x + 1, y + 1);
                    Common.largeFont.drawString(g, this.helpMenuItems[i], x, y);
                } else {
                    Common.largeFontDisabled.drawString(g, this.helpMenuItems[i], x, y);
                }
                y += Common.largeFont.getHeight() + 5;
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, "Select", Common.largeFont);
                MenuCanvas.drawRightCommand(g, "back", Common.largeFont);
            }
        } else if (this.displayMode == this.OPTIONS_MENU) {
            x = 0;
            y = 90;
            for (int i = 0; i < this.optionsMenuItems.length; ++i) {
                String setting = "";
                setting = i == 0 ? (Settings.DISABLE_VOLUME_SETTING ? this.optionsMenuItems[i] + ": " + NON_VOLUME_OPTIONS[this.optionsSettings[i]] : this.optionsMenuItems[i] + ": " + VOLUME_OPTIONS[this.optionsSettings[i]]) : this.optionsMenuItems[i] + ": " + this.optionsMenuItemSettings[i][this.optionsSettings[i]];
                x = (sw - Common.largeFont.stringWidth(setting)) / 2;
                if (i == this.optionsSelectedIndex) {
                    Common.largeFont.drawString(g, setting, x + 1, y + 1);
                    Common.largeFont.drawString(g, setting, x, y);
                } else {
                    Common.largeFontDisabled.drawString(g, setting, x, y);
                }
                y += Common.largeFont.getHeight() + 2;
            }
            FrameRenderer.renderFrame(g, this.descriptionBoxX, this.descriptionBoxY, this.descriptionBoxWidth, this.descriptionBoxHeight, 20);
            String[] lines = Common.normalFont.wrap(this.optionsMenuDescription[this.optionsSelectedIndex], this.descriptionBoxWidth - 30);
            for (int i = 0; i < lines.length; ++i) {
                Common.normalFont.drawString(g, lines[i], this.descriptionBoxX + 15, this.descriptionBoxY + 10 + i * Common.normalFont.getHeight());
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, "Change", Common.largeFont);
                MenuCanvas.drawRightCommand(g, "Back", Common.largeFont);
            }
        }
        if (this.displayPopup > 0) {
            int meshY;
            int meshX;
            if (!Settings.DISABLE_ALPHA_EFFECTS) {
                if (this.alphaIndex >= 0) {
                    for (meshX = 0; meshX < sw; meshX += 48) {
                        for (meshY = 0; meshY < sh; meshY += 64) {
                            g.drawImage(this.alphaMesh[this.alphaIndex], meshX, meshY, 20);
                        }
                    }
                }
            } else {
                for (meshX = 0; meshX < sw; meshX += 48) {
                    for (meshY = 0; meshY < sh; meshY += 64) {
                        g.drawImage(Common.meshImage, meshX, meshY, 20);
                    }
                }
            }
            if (this.boxFrame < this.boxNumFrames) {
                int tmpH;
                int tmpW;
                if (this.displayPopup == this.POPUP_REVEAL) {
                    tmpW = this.boxFrame * (this.boxW / this.boxNumFrames);
                    tmpH = this.boxFrame * (this.boxH / this.boxNumFrames);
                    FrameRenderer.renderFrame(g, sw / 2, sh / 2, tmpW, tmpH, 3, null);
                } else if (this.displayPopup == this.POPUP_HIDE) {
                    tmpW = (this.boxNumFrames - this.boxFrame) * (this.boxW / this.boxNumFrames);
                    tmpH = (this.boxNumFrames - this.boxFrame) * (this.boxH / this.boxNumFrames);
                    FrameRenderer.renderFrame(g, sw / 2, sh / 2, tmpW, tmpH, 3, null);
                }
            } else {
                int boxX = (sw - this.boxW) / 2;
                int boxY = (sh - this.boxH) / 2;
                FrameRenderer.renderFrame(g, boxX, boxY, this.boxW, this.boxH, 20, null);
                String[] lines = null;
                if (this.popupType == this.POPUP_ABOUT) {
                    lines = Common.normalFont.wrap(ABOUT_TEXT, this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, "OK", Common.largeFont);
                } else if (this.popupType == this.POPUP_NEW_GAME) {
                    lines = Common.normalFont.wrap(NEW_GAME_TEXT, this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, "No", Common.largeFont);
                    MenuCanvas.drawLeftCommand(g, "Yes", Common.largeFont);
                } else if (this.popupType == this.POPUP_GMG_CONNECTION) {
                    lines = Common.normalFont.wrap(GMG.GMG_CONNECTION_TEXT, this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, "OK", Common.largeFont);
                } else if (this.popupType == this.POPUP_HELP) {
                    MenuCanvas.drawRightCommand(g, "Back", Common.largeFont);
                } else if (this.popupType == this.POPUP_EXIT_CONFIRM) {
                    lines = Common.normalFont.wrap(EXIT_GAME_TEXT, this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, "No", Common.largeFont);
                    MenuCanvas.drawLeftCommand(g, "Yes", Common.largeFont);
                }
                if (this.popupType == this.POPUP_ABOUT || this.popupType == this.POPUP_NEW_GAME || this.popupType == this.POPUP_EXIT_CONFIRM) {
                    int y2 = (sh - lines.length * Common.normalFont.getHeight()) / 2;
                    for (int i = 0; i < lines.length; ++i) {
                        int x2 = (sw - Common.normalFont.stringWidth(lines[i])) / 2;
                        Common.normalFont.drawString(g, lines[i], x2, y2);
                        y2 += Common.normalFont.getHeight();
                    }
                } else if (this.popupType == this.POPUP_HELP) {
                    int y3 = boxY + 10;
                    int x3 = boxX + 10;
                    Common.largeFont.drawCenteredString(g, this.helpMenuItems[this.helpSelectedIndex], y3);
                    y3 += Common.largeFont.getHeight() + 7;
                    for (int l = 0; l < this.maxLines; ++l) {
                        if (l + this.lineOffset >= this.helpLines.length) continue;
                        Common.normalFont.drawString(g, this.helpLines[l + this.lineOffset], x3, y3);
                        y3 += Common.normalFont.getHeight();
                    }
                    if (this.helpLines.length > this.maxLines) {
                        int scrollBarHeight = Common.normalFont.getHeight() * this.maxLines;
                        g.setColor(0);
                        g.fillRect(boxX + this.boxW - 12, boxY + 17 + Common.largeFont.getHeight(), 3, scrollBarHeight);
                        int maxBarPos = scrollBarHeight - 3 - this.scrollerImage.getHeight();
                        int offset = maxBarPos * 10000 / (this.helpLines.length - this.maxLines) * this.lineOffset / 10000;
                        if (this.helpLines.length - this.lineOffset <= this.maxLines) {
                            offset = maxBarPos;
                        }
                        g.drawImage(this.scrollerImage, boxX + this.boxW - 14, boxY + 19 + Common.largeFont.getHeight() + offset, 20);
                    }
                }
            }
        }
    }

    public void keyReleasedEvent(int keyCode, int ga, int sk) {
        this.scrolling = 0;
    }

    public void keyPressedEvent(int keyCode, int ga, int sk) {
        if (this.displayPopup == this.POPUP_REVEAL) {
            if (sk == 2) {
                this.displayPopup = this.POPUP_HIDE;
                this.boxFrame = 0;
                this.boxNumFrames = 5;
            } else if (sk == 1) {
                if (this.popupType == this.POPUP_NEW_GAME) {
                    this.displayPopup = 0;
                    this.parent.startNewGame();
                } else if (this.popupType == this.POPUP_EXIT_CONFIRM) {
                    this.parent.exitApplication();
                }
            }
            if (this.popupType == this.POPUP_HELP) {
                if (ga == 1) {
                    this.scrolling = -1;
                } else if (ga == 6) {
                    this.scrolling = 1;
                }
            }
        } else if (this.displayMode == this.MAIN_MENU) {
            if (sk == 1) {
                this.performMenuSelect();
            }
            if (ga == 1) {
                this.selectedIndex = this.selectedIndex == 2 && !this.parent.vpCanvas.gameInProgress ? 0 : (GMG.DISPLAY_GET_MORE_GAMES_LINK ? (this.selectedIndex == 0 ? this.menuItemsGMG.length - 1 : this.selectedIndex - 1) : (this.selectedIndex == 0 ? this.menuItems.length - 1 : this.selectedIndex - 1));
            } else if (ga == 6) {
                this.selectedIndex = this.selectedIndex == 0 && !this.parent.vpCanvas.gameInProgress ? 2 : (GMG.DISPLAY_GET_MORE_GAMES_LINK ? (this.selectedIndex == this.menuItemsGMG.length - 1 ? 0 : this.selectedIndex + 1) : (this.selectedIndex == this.menuItems.length - 1 ? 0 : this.selectedIndex + 1));
            } else if (ga == 8) {
                this.performMenuSelect();
            }
        } else if (this.displayMode == this.HELP_MENU) {
            if (sk == 1) {
                this.performMenuSelect();
            } else if (sk == 2) {
                this.displayMode = this.MAIN_MENU;
            }
            if (ga == 1) {
                this.helpSelectedIndex = this.helpSelectedIndex == 0 ? this.helpMenuItems.length - 1 : this.helpSelectedIndex - 1;
            } else if (ga == 6) {
                this.helpSelectedIndex = this.helpSelectedIndex == this.helpMenuItems.length - 1 ? 0 : this.helpSelectedIndex + 1;
            } else if (ga == 8) {
                this.performMenuSelect();
            }
        } else if (this.displayMode == this.OPTIONS_MENU) {
            if (sk == 1) {
                this.changeSetting(this.optionsSelectedIndex);
                return;
            }
            if (sk == 2 || sk == 3) {
                this.displayMode = this.MAIN_MENU;
                this.applySettings();
                this.saveSettings();
                return;
            }
            if (ga == 1) {
                this.optionsSelectedIndex = this.optionsSelectedIndex == 0 ? this.optionsMenuItems.length - 1 : this.optionsSelectedIndex - 1;
            } else if (ga == 6) {
                this.optionsSelectedIndex = this.optionsSelectedIndex == this.optionsMenuItems.length - 1 ? 0 : this.optionsSelectedIndex + 1;
            } else if (ga == 8) {
                this.changeSetting(this.optionsSelectedIndex);
            }
        }
    }

    public void performMenuSelect() {
        if (this.displayMode == this.MAIN_MENU) {
            int si = this.selectedIndex;
            if (GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                if (si == this.GMG_INDEX) {
                    block20: {
                        try {
                            if (this.parent.parent.platformRequest(GMG.GET_MORE_GAMES_URL) && !GMG.IGNORE_PLATFORM_REQUEST_EXIT) {
                                this.parent.exitApplication();
                            }
                        }
                        catch (Exception e) {
                            this.displayPopup = this.POPUP_REVEAL;
                            this.popupType = this.POPUP_GMG_CONNECTION;
                            this.boxFrame = 0;
                            this.boxNumFrames = 5;
                            this.boxW = 200;
                            this.boxH = 140;
                            if (!Settings.DISABLE_ANIMATING_PANELS) break block20;
                            this.boxFrame = this.boxNumFrames;
                        }
                    }
                    return;
                }
                if (si > this.GMG_INDEX) {
                    --si;
                }
            }
            switch (si) {
                case 0: {
                    if (this.parent.vpCanvas.gameInProgress) {
                        this.displayPopup = this.POPUP_REVEAL;
                        this.popupType = this.POPUP_NEW_GAME;
                        this.boxFrame = 0;
                        this.boxNumFrames = 5;
                        this.boxW = 200;
                        this.boxH = 140;
                        if (!Settings.DISABLE_ANIMATING_PANELS) break;
                        this.boxFrame = this.boxNumFrames;
                        break;
                    }
                    this.parent.startNewGame();
                    break;
                }
                case 1: {
                    if (!this.parent.vpCanvas.gameInProgress) break;
                    this.parent.resumeGame();
                    break;
                }
                case 2: {
                    this.optionsSelectedIndex = 0;
                    this.displayMode = this.OPTIONS_MENU;
                    break;
                }
                case 3: {
                    this.helpSelectedIndex = 0;
                    this.displayMode = this.HELP_MENU;
                    break;
                }
                case 4: {
                    this.displayPopup = this.POPUP_REVEAL;
                    this.popupType = this.POPUP_ABOUT;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                    this.boxW = 200;
                    this.boxH = 140;
                    if (!Settings.DISABLE_ANIMATING_PANELS) break;
                    this.boxFrame = this.boxNumFrames;
                    break;
                }
                case 5: {
                    if (this.parent.vpCanvas.roundInPlay()) {
                        this.displayPopup = this.POPUP_REVEAL;
                        this.popupType = this.POPUP_EXIT_CONFIRM;
                        this.boxFrame = 0;
                        this.boxNumFrames = 5;
                        this.boxW = 200;
                        this.boxH = 140;
                        if (!Settings.DISABLE_ANIMATING_PANELS) break;
                        this.boxFrame = this.boxNumFrames;
                        break;
                    }
                    this.parent.exitApplication();
                }
            }
        } else if (this.displayMode == this.HELP_MENU) {
            this.boxW = 220;
            this.boxH = 280;
            this.helpLines = Common.normalFont.wrap(this.helpMenuText[this.helpSelectedIndex], this.boxW - 30);
            this.lineOffset = 0;
            this.displayPopup = this.POPUP_REVEAL;
            this.popupType = this.POPUP_HELP;
            this.boxFrame = 0;
            this.boxNumFrames = 5;
            if (Settings.DISABLE_ANIMATING_PANELS) {
                this.boxFrame = this.boxNumFrames;
            }
        }
    }

    public void changeSetting(int idx) {
        if (idx == 0) {
            if (Settings.DISABLE_VOLUME_SETTING) {
                if (this.optionsSettings[idx] == NON_VOLUME_OPTIONS.length - 1) {
                    this.optionsSettings[idx] = 0;
                } else {
                    int n = idx;
                    this.optionsSettings[n] = this.optionsSettings[n] + 1;
                }
            } else if (this.optionsSettings[idx] == VOLUME_OPTIONS.length - 1) {
                this.optionsSettings[idx] = 0;
            } else {
                int n = idx;
                this.optionsSettings[n] = this.optionsSettings[n] + 1;
            }
        } else if (this.optionsSettings[idx] == this.optionsMenuItemSettings[idx].length - 1) {
            this.optionsSettings[idx] = 0;
        } else {
            int n = idx;
            this.optionsSettings[n] = this.optionsSettings[n] + 1;
        }
    }

    public void applySettings() {
        Common.hintsEnabled = this.optionsSettings[1] == 0;
        Common.doubleOrNothingEnabled = this.optionsSettings[2] == 0;
        Common.perfectPlayWarningEnabled = this.optionsSettings[3] == 0;
        Common.startingBalance = this.actualStartingCashValues[this.optionsSettings[4]];
        Common.coinValue = this.actualCoinValues[this.optionsSettings[5]];
        if (Settings.DISABLE_VOLUME_SETTING) {
            Common.soundEnabled = this.optionsSettings[0] == 0;
        } else {
            Common.soundVolume = VOLUME_SETTINGS[this.optionsSettings[0]];
            Common.soundEnabled = Common.soundVolume != 0;
            Common.setSoundVolume(Common.soundVolume);
        }
    }

    public void loadSettings() {
        try {
            if (RecordManager.exists("settings")) {
                DataInputStream is = new DataInputStream(new ByteArrayInputStream(RecordManager.load("settings")));
                for (int i = 0; i < this.optionsSettings.length; ++i) {
                    this.optionsSettings[i] = is.readInt();
                }
            }
            this.applySettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveSettings() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            for (int i = 0; i < this.optionsSettings.length; ++i) {
                os.writeInt(this.optionsSettings[i]);
            }
            RecordManager.save(baos.toByteArray(), "settings");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

