/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import java.util.Vector;
import net.handyx.casinopack.videopoker.Card;

public class Hand {
    private boolean isFlush = true;
    private boolean isStraight = true;
    private int firstStraightRank = -1;
    private Vector cards = new Vector();
    private Vector sortedCards = new Vector();

    public void reset() {
        this.isFlush = true;
        this.isStraight = true;
        this.sortedCards.removeAllElements();
        this.cards.removeAllElements();
    }

    public void addCard(Card c) {
        boolean addedCard = false;
        this.cards.addElement(c);
        if (c.getRank() == 1) {
            this.sortedCards.addElement(c);
        } else {
            for (int i = 0; i < this.sortedCards.size(); ++i) {
                Card c1 = (Card)this.sortedCards.elementAt(i);
                if (addedCard || c1.getRank() < c.getRank() && c1.getRank() != 1) continue;
                this.sortedCards.insertElementAt(c, i);
                addedCard = true;
                break;
            }
            if (!addedCard) {
                this.sortedCards.addElement(c);
            }
        }
        this._calcStats();
    }

    public void addCards(Hand h) {
        for (int i = 0; i < h.size(); ++i) {
            Card c1 = h.getCard(i);
            this.addCard(c1.duplicate());
        }
    }

    private void _calcStats() {
        Card c2;
        int j;
        Card c1;
        int firstSuit = -1;
        int nextRank = 0;
        this.isFlush = true;
        for (int i = 0; i < this.sortedCards.size(); ++i) {
            c1 = (Card)this.sortedCards.elementAt(i);
            if (!this.isFlush) continue;
            if (i == 0) {
                firstSuit = c1.getSuit();
                continue;
            }
            if (c1.getSuit() == firstSuit) continue;
            this.isFlush = false;
        }
        c1 = (Card)this.sortedCards.firstElement();
        nextRank = c1.getRank() == 13 ? 1 : c1.getRank() + 1;
        this.firstStraightRank = -1;
        this.isStraight = true;
        for (j = 1; j < this.sortedCards.size(); ++j) {
            c2 = (Card)this.sortedCards.elementAt(j);
            if (c2.getRank() != nextRank) {
                this.isStraight = false;
                break;
            }
            if (nextRank == 13) {
                nextRank = 1;
                continue;
            }
            ++nextRank;
        }
        if (this.isStraight) {
            this.firstStraightRank = c1.getRank();
        }
        if (!this.isStraight && (c1 = (Card)this.sortedCards.lastElement()).getRank() == 1) {
            nextRank = 2;
            this.isStraight = true;
            for (j = 0; j < this.sortedCards.size() - 1; ++j) {
                c2 = (Card)this.sortedCards.elementAt(j);
                if (c2.getRank() != nextRank) {
                    this.isStraight = false;
                    break;
                }
                if (nextRank == 13) {
                    nextRank = 1;
                    continue;
                }
                ++nextRank;
            }
            if (this.isStraight) {
                this.firstStraightRank = 1;
            }
        }
    }

    public Card getUnsortedCard(int idx) {
        try {
            return (Card)this.cards.elementAt(idx);
        }
        catch (Exception e) {
            System.out.println("Invalid card index " + idx);
            return null;
        }
    }

    public Card getCard(int idx) {
        try {
            return (Card)this.sortedCards.elementAt(idx);
        }
        catch (Exception e) {
            System.out.println("Invalid card index " + idx);
            return null;
        }
    }

    public Card getLowestCard() {
        return (Card)this.sortedCards.firstElement();
    }

    public Card getHighestCard() {
        return (Card)this.sortedCards.lastElement();
    }

    public void removeCard(int idx) {
        try {
            Card c = (Card)this.sortedCards.elementAt(idx);
            this.removeCard(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeUnsortedCard(int idx) {
        try {
            Card c = (Card)this.cards.elementAt(idx);
            this.removeCard(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeCard(Card c) {
        int i;
        Card c1 = null;
        for (i = 0; i < this.cards.size(); ++i) {
            c1 = (Card)this.cards.elementAt(i);
            if (!c1.equals(c)) continue;
            this.cards.removeElementAt(i);
            break;
        }
        for (i = 0; i < this.sortedCards.size(); ++i) {
            c1 = (Card)this.sortedCards.elementAt(i);
            if (!c1.equals(c)) continue;
            this.sortedCards.removeElementAt(i);
            break;
        }
        this._calcStats();
    }

    public void replaceCard(int idx, Card newCard) {
        try {
            Card c = (Card)this.sortedCards.elementAt(idx);
            this.replaceCard(c, newCard);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void replaceUnsortedCard(int idx, Card newCard) {
        try {
            Card c = (Card)this.cards.elementAt(idx);
            this.replaceCard(c, newCard);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void replaceCard(Card oldCard, Card newCard) {
        int i;
        Card c1 = null;
        for (i = 0; i < this.cards.size(); ++i) {
            c1 = (Card)this.cards.elementAt(i);
            if (!c1.equals(oldCard)) continue;
            this.cards.setElementAt(newCard, i);
            break;
        }
        for (i = 0; i < this.sortedCards.size(); ++i) {
            c1 = (Card)this.sortedCards.elementAt(i);
            if (!c1.equals(oldCard)) continue;
            this.sortedCards.removeElementAt(i);
            break;
        }
        if (newCard.getRank() == 1) {
            this.sortedCards.addElement(newCard);
        } else {
            boolean addedCard = false;
            for (int i2 = 0; i2 < this.sortedCards.size(); ++i2) {
                c1 = (Card)this.sortedCards.elementAt(i2);
                if (addedCard || c1.getRank() < newCard.getRank() && c1.getRank() != 1) continue;
                this.sortedCards.insertElementAt(newCard, i2);
                addedCard = true;
                break;
            }
            if (!addedCard) {
                this.sortedCards.addElement(newCard);
            }
        }
        this._calcStats();
    }

    public int size() {
        return this.cards.size();
    }

    public String toString() {
        int i;
        String s = "";
        for (i = 0; i < this.sortedCards.size(); ++i) {
            s = s + ((Card)this.sortedCards.elementAt(i)).toString() + " ";
        }
        s = s + "[";
        for (i = 0; i < this.cards.size(); ++i) {
            s = s + ((Card)this.cards.elementAt(i)).toString() + " ";
        }
        s = s + "]";
        if (this.isFlush && this.cards.size() > 1) {
            s = s + " (flush)";
        }
        if (this.isStraight && this.cards.size() > 1) {
            s = s + " (straight from " + this.firstStraightRank + ")";
        }
        return s;
    }

    public boolean isFlush() {
        return this.isFlush;
    }

    public boolean isStraight() {
        return this.isStraight;
    }

    public boolean containsRank(int r) {
        int l = this.cards.size();
        for (int i = 0; i < l; ++i) {
            if (((Card)this.cards.elementAt(i)).getRank() != r) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Card c) {
        return this.contains(c.getRank(), c.getSuit());
    }

    public boolean contains(Hand h) {
        for (int i = 0; i < h.size(); ++i) {
            Card c = h.getCard(i);
            if (this.contains(c)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int r, int s) {
        int l = this.cards.size();
        Card c1 = null;
        for (int i = 0; i < l; ++i) {
            c1 = (Card)this.cards.elementAt(i);
            if (c1.getRank() != r || c1.getSuit() != s) continue;
            return true;
        }
        return false;
    }

    public int findCardUnsorted(Card c) {
        for (int i = 0; i < this.cards.size(); ++i) {
            Card c1 = (Card)this.cards.elementAt(i);
            if (!c1.equals(c)) continue;
            return i;
        }
        return -1;
    }

    public Hand duplicate() {
        Hand newHand = new Hand();
        for (int i = 0; i < this.cards.size(); ++i) {
            newHand.addCard(((Card)this.cards.elementAt(i)).duplicate());
        }
        return newHand;
    }

    public int getFirstStraightRank() {
        return this.firstStraightRank;
    }
}

