/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.ImageFontRenderer;
import net.handyx.casinopack.common.Settings;
import net.handyx.casinopack.common.SoundManager;
import net.handyx.casinopack.videopoker.NumericFontRenderer;

public class Common {
    public static final boolean USE_FASTER_FONT_RENDERER = false;
    public static final boolean SOUND_SUPPORTS_VOLUME = false;
    public static final boolean DISABLE_SERVICE_REPAINT = false;
    public static final boolean DISABLE_GARBAGE_COLLECTION = false;
    public static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static boolean debug = true;
    public static boolean hintsEnabled = true;
    public static boolean doubleOrNothingEnabled = true;
    public static boolean perfectPlayWarningEnabled = false;
    public static int startingBalance = 100;
    public static int coinValue = 1;
    public static boolean soundEnabled = false;
    public static int soundVolume = 100;
    public static SoundManager soundMan = null;
    public static String soundExt = "amr";
    public static String soundMime = "audio/amr";
    public static String soundDir = "/videopoker/sounds/";
    public static ImageFontRenderer largeFont;
    public static ImageFontRenderer largeFontDisabled;
    public static ImageFontRenderer normalFont;
    public static ImageFontRenderer smallFont;
    public static NumericFontRenderer digitFont;
    public static Image bgImage;
    public static Image meshImage;
    private static Random rnd;

    public static int random(int v) {
        if (v == 0) {
            Common.log("Sanity check " + v);
            return 0;
        }
        return Math.abs(rnd.nextInt() % v);
    }

    public static void loadResources() {
        if (soundMan == null) {
            soundMan = new SoundManager();
        }
        largeFont = new ImageFontRenderer("/fonts/komik");
        largeFontDisabled = new ImageFontRenderer("/fonts/komik_disabled");
        normalFont = new ImageFontRenderer("/fonts/komik_thin");
        smallFont = new ImageFontRenderer("/fonts/bwmini");
        digitFont = new NumericFontRenderer("/videopoker/fonts/digits2");
        bgImage = Common.loadImage("/bg.jpg");
        meshImage = Settings.DISABLE_ALPHA_EFFECTS ? Common.loadCommonImage("/mesh.png") : Common.loadCommonImage("/mesh_alpha4.png");
    }

    public static void purgeResources() {
        if (soundMan != null) {
            soundMan.purgeResources();
        }
        soundMan = null;
        if (largeFont != null) {
            largeFont.purge();
        }
        largeFont = null;
        if (largeFontDisabled != null) {
            largeFontDisabled.purge();
        }
        largeFontDisabled = null;
        if (normalFont != null) {
            normalFont.purge();
        }
        normalFont = null;
        if (smallFont != null) {
            smallFont.purge();
        }
        smallFont = null;
        if (digitFont != null) {
            digitFont.purge();
        }
        digitFont = null;
        bgImage = null;
        meshImage = null;
        System.gc();
    }

    public static Image loadImage(String res) {
        Image img = null;
        try {
            img = Image.createImage((String)("/videopoker" + res));
        }
        catch (Exception e) {
            Common.log("Unable to load image: " + res);
        }
        return img;
    }

    public static Image loadCommonImage(String res) {
        Image img = null;
        try {
            img = Image.createImage((String)res);
        }
        catch (Exception e) {
            Common.log("Unable to load image: " + res);
        }
        return img;
    }

    public static String[] loadText(String res) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = res.getClass().getResourceAsStream("/videopoker" + res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            Common.log(e.toString());
        }
        return ImageFontRenderer.splitStringToArray("\n", sb.toString());
    }

    public static void doSound(String s) {
        Common.doSound(s + "." + soundExt, soundMime, 1);
    }

    public static void doSound(String s, String m) {
        Common.doSound(s, m, 1);
    }

    public static void doSound(String s, int loops) {
        if (!soundEnabled) {
            return;
        }
        Common.doSound(s + "." + soundExt, soundMime, loops);
    }

    public static void doSound(String s, String m, int loops) {
        if (!soundEnabled) {
            return;
        }
        try {
            System.out.println("Playing " + soundDir + s + " (" + m + ")");
            soundMan.playSound(soundDir + s, m, loops);
        }
        catch (Exception e) {
            System.out.println("Unable to play " + s);
        }
    }

    public static void cacheSound(String s) {
        Common.cacheSound(s + "." + soundExt, soundMime, 1);
    }

    public static void cacheSound(String s, int loops) {
        if (!soundEnabled) {
            return;
        }
        Common.cacheSound(s + "." + soundExt, soundMime, loops);
    }

    public static void cacheSound(String s, String m, int loops) {
        if (!soundEnabled) {
            return;
        }
        try {
            soundMan.cacheSound(soundDir + s, m, loops);
        }
        catch (Exception e) {
            System.out.println("Unable to cache " + s);
        }
    }

    public static void stopSounds() {
        soundMan.stopSound();
        soundMan = null;
        System.gc();
        soundMan = new SoundManager();
        Common.setSoundVolume(soundVolume);
    }

    public static void setSoundVolume(int vol) {
        if (vol == 0) {
            soundMan.enableVolumeControl(false);
        } else {
            soundMan.enableVolumeControl(true);
            soundMan.setVolume(vol);
        }
    }

    public static void log(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    static {
        rnd = new Random();
    }
}

