/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.common;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NumericFontRenderer {
    private static final int NUMBER_CHARS = 18;
    private int[] numCharWidths;
    private int[] numCharOffsets;
    private Image fontImage;
    private int fontHeight;
    private int spaceWidth = 4;
    private int fontColour = 0;
    private int fontSpacing = 1;
    private int sourceCharacterSpacing = 1;
    private int baseline = 0;
    private int canvasY = 0;
    private int canvasWidth = 1000;
    private int canvasHeight = 1000;
    private boolean debug = true;

    public NumericFontRenderer(String res) {
        this._create(res);
    }

    private void _create(String res) {
        String dat_res;
        String png_res = res + ".png";
        if (!png_res.startsWith("/")) {
            png_res = "/" + png_res;
        }
        if (!(dat_res = res + ".dat").startsWith("/")) {
            dat_res = "/" + dat_res;
        }
        this.loadFont(png_res, dat_res);
    }

    public void setCanvasSize(int cWidth, int cHeight) {
        this.canvasWidth = cWidth;
        this.canvasHeight = cHeight;
    }

    public NumericFontRenderer(String res, int spacing) {
        this._create(res);
        this.sourceCharacterSpacing = spacing;
    }

    private void loadFont(String res, String dat) {
        if (this.debug) {
            System.out.println("Loading font " + res + " ...");
        }
        try {
            this.fontImage = Image.createImage((String)res);
        }
        catch (Exception e) {
            System.out.println("Unable to load font resource: " + res);
            return;
        }
        this.baseline = this.fontHeight = this.fontImage.getHeight();
        Vector data = NumericFontRenderer.splitString("\n", this.loadTextResource(dat));
        int startLine = 0;
        while (((String)data.elementAt(startLine)).trim().length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector nums = NumericFontRenderer.splitString(",", (String)data.elementAt(startLine++));
        this.numCharWidths = new int[18];
        this.numCharOffsets = new int[18];
        int offset = 0;
        for (int i = 0; i < nums.size(); ++i) {
            if (i >= this.numCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for number characters");
                break;
            }
            try {
                this.numCharWidths[i] = Integer.parseInt(((String)nums.elementAt(i)).trim());
                this.numCharOffsets[i] = offset;
                offset += this.numCharWidths[i] + this.sourceCharacterSpacing;
                continue;
            }
            catch (Exception e) {
                System.out.println("Error parsing " + (String)nums.elementAt(i) + " : " + e.toString());
            }
        }
        if (nums.size() < this.numCharWidths.length && this.debug) {
            System.out.println("Warning: Missing " + (this.numCharWidths.length - nums.size()) + " character definitions for number characters");
        }
        nums = null;
        data = null;
    }

    private void parseSetting(String s) {
        String settingName = "";
        String settingValue = "";
        if (this.debug) {
            System.out.println("Parsing setting " + s);
        }
        if (s.startsWith("$")) {
            int eq = (s = s.substring(1)).indexOf("=");
            if (eq >= 0) {
                settingName = s.substring(0, eq).toLowerCase().trim();
                settingValue = s.substring(eq + 1).toLowerCase().trim();
                if (settingName.equals("baseline")) {
                    try {
                        this.baseline = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("colour")) {
                    try {
                        this.fontColour = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("png_character_spacing")) {
                    try {
                        this.sourceCharacterSpacing = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("font_spacing")) {
                    try {
                        this.fontSpacing = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                }
            } else {
                System.out.println("Warning: Invalid setting $" + s);
            }
        }
    }

    public int drawString(Graphics g, String s, int x, int y) {
        return this.drawString(g, s, x, y, -1, 0);
    }

    public int drawString(Graphics g, String s, int x, int y, int bgcol) {
        return this.drawString(g, s, x, y, bgcol, 0);
    }

    public int drawString(Graphics g, String s, int x, int y, int bgcol, int wrapWidth) {
        int width = 0;
        int lines = 1;
        if (wrapWidth > 0) {
            s = this.wrapString(s, wrapWidth);
        }
        char[] chars = s.toCharArray();
        if (bgcol >= 0) {
            int blankWidth = this.stringWidth(s);
            g.setColor(bgcol);
            g.fillRect(x, y, blankWidth, this.fontHeight);
        }
        boolean drawChar = true;
        int offset = 0;
        int prevClipX = g.getClipX();
        int prevClipY = g.getClipY();
        int prevClipW = g.getClipWidth();
        int prevClipH = g.getClipHeight();
        for (int c = 0; c < chars.length; ++c) {
            offset = chars[c];
            drawChar = true;
            if (chars[c] == '\n') {
                offset = -1;
                y += this.fontHeight;
                width = 0;
                ++lines;
            } else if (offset == 32) {
                offset = -1;
                width += this.spaceWidth;
            } else if (offset >= 48 && offset <= 57) {
                offset -= 48;
            } else {
                switch (offset) {
                    case 36: {
                        offset = 15;
                        break;
                    }
                    case 43: {
                        offset = 14;
                        break;
                    }
                    case 44: {
                        offset = 12;
                        break;
                    }
                    case 45: {
                        offset = 13;
                        break;
                    }
                    case 46: {
                        offset = 11;
                        break;
                    }
                    case 58: {
                        offset = 10;
                        break;
                    }
                    case 163: {
                        offset = 16;
                        break;
                    }
                    case 35: {
                        offset = 17;
                        break;
                    }
                    default: {
                        offset = -1;
                        System.out.println("Warning: No symbol for " + chars[c] + " (" + offset + ")");
                    }
                }
            }
            if (offset < 0) continue;
            if (drawChar) {
                g.setClip(x + width, y, this.numCharWidths[offset], this.fontHeight);
                g.drawImage(this.fontImage, x - this.numCharOffsets[offset] + width, y, 0x10 | 4);
            }
            width += this.numCharWidths[offset] + this.fontSpacing;
        }
        g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
        return lines;
    }

    public int stringWidth(String s) {
        char[] chars = s.toCharArray();
        int width = 0;
        int offset = 0;
        try {
            for (int c = 0; c < chars.length; ++c) {
                offset = chars[c];
                if (offset == 32) {
                    offset = -1;
                    width += this.spaceWidth;
                } else if (offset >= 48 && offset <= 57) {
                    offset -= 48;
                } else {
                    switch (chars[c]) {
                        case ':': {
                            offset = 10;
                            break;
                        }
                        case '+': {
                            offset = 14;
                            break;
                        }
                        case ',': {
                            offset = 12;
                            break;
                        }
                        case '-': {
                            offset = 13;
                            break;
                        }
                        case '.': {
                            offset = 11;
                            break;
                        }
                        case '$': {
                            offset = 15;
                            break;
                        }
                        case '\u00a3': {
                            offset = 16;
                            break;
                        }
                        case '#': {
                            offset = 17;
                            break;
                        }
                        default: {
                            System.out.println("Warning: No symbol for " + chars[c] + " (" + offset + ")");
                            offset = -1;
                        }
                    }
                }
                if (offset < 0) continue;
                width += this.numCharWidths[offset] + this.fontSpacing;
            }
        }
        catch (Exception e) {
            System.out.println("offset=" + offset);
        }
        return width;
    }

    public int charWidth(char c) {
        int width = 0;
        int offset = c;
        if (offset == 32) {
            offset = -1;
            width = this.spaceWidth;
        } else if (offset >= 48 && offset <= 57) {
            offset -= 48;
        } else {
            switch (offset) {
                case 58: {
                    offset = 10;
                    break;
                }
                case 43: {
                    offset = 14;
                    break;
                }
                case 44: {
                    offset = 12;
                    break;
                }
                case 45: {
                    offset = 13;
                    break;
                }
                case 46: {
                    offset = 11;
                    break;
                }
                case 36: {
                    offset = 15;
                    break;
                }
                case 163: {
                    offset = 16;
                    break;
                }
                case 35: {
                    offset = 17;
                    break;
                }
                default: {
                    offset = -1;
                    System.out.println("Warning: No symbol for " + (char)c + " (" + offset + ")");
                }
            }
        }
        if (offset >= 0) {
            width = this.numCharWidths[offset] + this.fontSpacing;
        }
        return width;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public void setFontSpacing(int v) {
        this.fontSpacing = v;
    }

    public int getFontSpacing() {
        return this.fontSpacing;
    }

    public void setSpaceWidth(int v) {
        this.spaceWidth = v;
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    private String loadTextResource(String res) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = this.getClass().getResourceAsStream(res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load text resource: " + res);
            return "";
        }
        return sb.toString();
    }

    public static Vector splitString(String c, String text) {
        Vector<String> lines = new Vector<String>();
        int length = text.trim().length();
        int num = 0;
        for (int i = length; i != 0; --i) {
            num = text.indexOf(c);
            if (num < 0) {
                if (text.length() <= 0) break;
                lines.addElement(text);
                break;
            }
            lines.addElement(text.substring(0, num));
            text = text.substring(num + c.length(), text.length());
        }
        return lines;
    }

    public static String[] splitStringToArray(String c, String text) {
        Vector v = NumericFontRenderer.splitString(c, text);
        String[] ret = new String[v.size()];
        int i = 0;
        while (!v.isEmpty()) {
            ret[i++] = (String)v.firstElement();
            v.removeElementAt(0);
        }
        return ret;
    }

    private String arrayToString(int[] arr) {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(arr[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public String wrapString(String s, int w) {
        StringBuffer wrapped = new StringBuffer("");
        Vector lines = NumericFontRenderer.splitString("\n", s);
        int lsize = lines.size();
        Vector words = null;
        String word = null;
        for (int i = 0; i < lsize; ++i) {
            words = NumericFontRenderer.splitString(" ", ((String)lines.elementAt(i)).trim());
            int lineWidth = 0;
            int wsize = words.size();
            for (int j = 0; j < wsize; ++j) {
                word = (String)words.elementAt(j);
                int wordWidth = this.stringWidth(word);
                if (lineWidth + 4 + wordWidth >= w) {
                    wrapped.append('\n');
                    if (wordWidth > w) {
                        wrapped.append(this.wrapWord(word, w));
                        lineWidth = this.stringWidth(this.wrapWord(word, w));
                        continue;
                    }
                    wrapped.append((String)words.elementAt(j));
                    lineWidth = wordWidth;
                    continue;
                }
                if (lineWidth > 0) {
                    wrapped.append(' ');
                    lineWidth += 4;
                }
                wrapped.append((String)words.elementAt(j));
                lineWidth += wordWidth;
            }
            wrapped.append("\n");
        }
        return wrapped.toString();
    }

    private String wrapWord(String s, int w) {
        StringBuffer wrapped = new StringBuffer("");
        int dashWidth = this.charWidth('-');
        int wordWidth = 0;
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            int cWidth = this.charWidth(c);
            if (wordWidth + dashWidth + this.charWidth(c) > w) {
                wrapped.append('-');
                wrapped.append('\n');
                wrapped.append(c);
                wordWidth = cWidth;
                continue;
            }
            wrapped.append(c);
            wordWidth += cWidth;
        }
        return wrapped.toString();
    }

    public void purge() {
        this.fontImage = null;
        this.numCharWidths = null;
        this.numCharOffsets = null;
    }
}

