/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.common;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsScaler {
    public static final int TOP = 16;
    public static final int LEFT = 4;
    public static final int BOTTOM = 32;
    public static final int RIGHT = 8;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    private int srcWidth = 240;
    private int srcHeight = 320;
    private int destWidth = 360;
    private int destHeight = 480;
    private int upscaleRatio = 1024;
    private int downscaleRatio = 1024;
    private Graphics g = null;

    public GraphicsScaler(Graphics gfx, int srcWidth, int srcHeight, int destWidth, int destHeight) {
        this.g = gfx;
        this.srcWidth = srcWidth;
        this.srcHeight = srcHeight;
        this.destWidth = destWidth;
        this.destHeight = destHeight;
        this.upscaleRatio = (this.destWidth << 11) / this.srcWidth;
        this.downscaleRatio = (this.srcWidth << 11) / this.destWidth;
    }

    public final void setGraphics(Graphics g) {
        this.g = g;
    }

    public final Graphics getGraphics() {
        return this.g;
    }

    public final int getWidth() {
        return this.srcWidth;
    }

    public final int getHeight() {
        return this.srcHeight;
    }

    public final int getRealWidth() {
        return this.destWidth;
    }

    public final int getRealHeight() {
        return this.destHeight;
    }

    public final void drawImage(Image img, int x, int y, int alignment) {
        if (this.g != null) {
            this.g.drawImage(img, this.scale(x), this.scale(y), alignment);
        }
    }

    public final void drawLine(int x1, int y1, int x2, int y2) {
        if (this.g != null) {
            this.g.drawLine(this.scale(x1), this.scale(y1), this.scale(x2), this.scale(y2));
        }
    }

    public final void drawRect(int x, int y, int w, int h) {
        if (this.g != null) {
            this.g.drawRect(this.scale(x), this.scale(y), this.scale(w), this.scale(h));
        }
    }

    public final void fillRect(int x, int y, int w, int h) {
        if (this.g != null) {
            this.g.fillRect(this.scale(x), this.scale(y), this.scale(w), this.scale(h));
        }
    }

    public final void setClip(int x, int y, int w, int h) {
        if (this.g != null) {
            this.g.setClip(this.scale(x), this.scale(y), this.scale(w), this.scale(h));
        }
    }

    public final int getClipX() {
        return this.g != null ? this.unscale(this.g.getClipX()) : 0;
    }

    public final int getClipY() {
        return this.g != null ? this.unscale(this.g.getClipY()) : 0;
    }

    public final int getClipWidth() {
        return this.g != null ? this.unscale(this.g.getClipWidth()) : 0;
    }

    public final int getClipHeight() {
        return this.g != null ? this.unscale(this.g.getClipHeight()) : 0;
    }

    public final void setColor(int c) {
        if (this.g != null) {
            this.g.setColor(c);
        }
    }

    public final void setFont(Font f) {
        if (this.g != null) {
            this.g.setFont(f);
        }
    }

    public final void drawString(String s, int x, int y, int alignment) {
        if (this.g != null) {
            this.g.drawString(s, this.scale(x), this.scale(y), alignment);
        }
    }

    public final int scale(int l) {
        return l * this.upscaleRatio >> 11;
    }

    public final int unscale(int l) {
        return l * this.downscaleRatio >> 11;
    }
}

