/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack.game;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.handyx.casinopack.blackjack.game.Bet;
import net.handyx.casinopack.common.RecordManager;

public class GameStats {
    public int mGlobalHandsDealt = 0;
    public int mGlobalHandsWon = 0;
    public int mGlobalHandsLost = 0;
    public int mGlobalHandsPush = 0;
    public int mGlobalHandsSurrender = 0;
    public int mGlobalHandsBlackjack = 0;
    public int mGlobalActionsTaken = 0;
    public int mGlobalRecommendedActionsTaken = 0;
    public Bet mTotalBet = new Bet(0);
    public Bet mGlobalTotalBet;
    public Bet mTotalLost = new Bet(0);
    public Bet mGlobalTotalLost;
    public Bet mTotalWinnings = new Bet(0);
    public Bet mGlobalTotalWinnings;
    public int mHandsDealt = 0;
    public int mHandsWon = 0;
    public int mHandsLost = 0;
    public int mHandsPush = 0;
    public int mHandsSurrender = 0;
    public int mHandsBlackjack = 0;
    public int mActionsTaken = 0;
    public int mRecommendedActionsTaken = 0;
    private String mCurrencyString = "$";

    public GameStats() {
        this.mGlobalTotalBet = new Bet(0);
        this.mGlobalTotalLost = new Bet(0);
        this.mGlobalTotalWinnings = new Bet(0);
    }

    public void setCurrencyString(String c) {
        this.mCurrencyString = c;
    }

    public void addBet(Bet b) {
        this.mTotalBet.add(b);
        this.mGlobalTotalBet.add(b);
    }

    public void addLost(Bet b) {
        this.mTotalLost.add(b);
        this.mGlobalTotalLost.add(b);
    }

    public void addWinnings(Bet b) {
        this.mTotalWinnings.add(b);
        this.mGlobalTotalWinnings.add(b);
    }

    public void handDealt() {
        ++this.mHandsDealt;
        ++this.mGlobalHandsDealt;
    }

    public void handWon() {
        ++this.mHandsWon;
        ++this.mGlobalHandsWon;
    }

    public void handLost() {
        ++this.mHandsLost;
        ++this.mGlobalHandsLost;
    }

    public void handPush() {
        ++this.mHandsPush;
        ++this.mGlobalHandsPush;
    }

    public void handSurrender() {
        ++this.mHandsSurrender;
        ++this.mGlobalHandsSurrender;
    }

    public void handBlackjack() {
        ++this.mHandsBlackjack;
        ++this.mGlobalHandsBlackjack;
    }

    public void takeAction(boolean recommended) {
        ++this.mActionsTaken;
        ++this.mGlobalActionsTaken;
        if (recommended) {
            ++this.mRecommendedActionsTaken;
            ++this.mGlobalRecommendedActionsTaken;
        }
    }

    public void resetGameStats() {
        this.mHandsSurrender = 0;
        this.mHandsPush = 0;
        this.mHandsWon = 0;
        this.mHandsDealt = 0;
        this.mHandsLost = 0;
        this.mHandsBlackjack = 0;
        this.mRecommendedActionsTaken = 0;
        this.mActionsTaken = 0;
        this.mTotalBet = new Bet(0);
        this.mTotalLost = new Bet(0);
        this.mTotalWinnings = new Bet(0);
    }

    public String toString() {
        String s = "Hands Dealt: " + this.mHandsDealt + "\n";
        s = s + "Hands Won: " + this.mHandsWon + "\n";
        s = s + "Hands Lost: " + this.mHandsLost + "\n";
        s = s + "Hands Pushed: " + this.mHandsPush + "\n";
        s = s + "Hands Surrendered: " + this.mHandsSurrender + "\n";
        s = s + "Blackjacks Dealt: " + this.mHandsBlackjack + "\n\n";
        s = s + "Bets Placed: " + this.mCurrencyString + this.mTotalBet.toString() + "\n";
        s = s + "Bets Lost: " + this.mCurrencyString + this.mTotalLost.toString() + "\n";
        s = s + "Winnings: " + this.mCurrencyString + this.mTotalWinnings.toString() + "\n";
        if (this.mTotalLost.isGreaterThan(this.mTotalWinnings)) {
            Bet diff = new Bet(this.mTotalLost);
            diff.subtract(this.mTotalWinnings);
            s = s + "Overall: " + this.mCurrencyString + diff.toString() + " down\n\n";
        } else if (this.mTotalLost.isEqualTo(this.mTotalWinnings)) {
            s = s + "Overall: Breaking even\n\n";
        } else {
            Bet diff = new Bet(this.mTotalWinnings);
            diff.subtract(this.mTotalLost);
            s = s + "Overall: " + this.mCurrencyString + diff.toString() + " up\n\n";
        }
        if (this.mActionsTaken == 0 || this.mActionsTaken == this.mRecommendedActionsTaken) {
            s = s + "Perfect Play: 100%\n";
        }
        return s;
    }

    public void saveState() {
        try {
            RecordManager.save(this.toByteArray(), "statsdata");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadState() {
        try {
            if (RecordManager.exists("statsdata")) {
                byte[] data = RecordManager.load("statsdata");
                this.fromByteArray(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(this.mGlobalHandsDealt);
            os.writeInt(this.mGlobalHandsWon);
            os.writeInt(this.mGlobalHandsLost);
            os.writeInt(this.mGlobalHandsPush);
            os.writeInt(this.mGlobalHandsSurrender);
            os.writeInt(this.mGlobalHandsBlackjack);
            os.writeInt(this.mGlobalActionsTaken);
            os.writeInt(this.mGlobalRecommendedActionsTaken);
            os.writeInt(this.mHandsDealt);
            os.writeInt(this.mHandsWon);
            os.writeInt(this.mHandsLost);
            os.writeInt(this.mHandsPush);
            os.writeInt(this.mHandsSurrender);
            os.writeInt(this.mHandsBlackjack);
            os.writeInt(this.mActionsTaken);
            os.writeInt(this.mRecommendedActionsTaken);
            byte[] betData = this.mTotalBet.toByteArray();
            os.writeInt(betData.length);
            os.write(betData);
            betData = this.mTotalLost.toByteArray();
            os.writeInt(betData.length);
            os.write(betData);
            betData = this.mTotalWinnings.toByteArray();
            os.writeInt(betData.length);
            os.write(betData);
            betData = this.mGlobalTotalBet.toByteArray();
            os.writeInt(betData.length);
            os.write(betData);
            betData = this.mGlobalTotalLost.toByteArray();
            os.writeInt(betData.length);
            os.write(betData);
            betData = this.mGlobalTotalWinnings.toByteArray();
            os.writeInt(betData.length);
            os.write(betData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            this.mGlobalHandsDealt = is.readInt();
            this.mGlobalHandsWon = is.readInt();
            this.mGlobalHandsLost = is.readInt();
            this.mGlobalHandsPush = is.readInt();
            this.mGlobalHandsSurrender = is.readInt();
            this.mGlobalHandsBlackjack = is.readInt();
            this.mGlobalActionsTaken = is.readInt();
            this.mGlobalRecommendedActionsTaken = is.readInt();
            this.mHandsDealt = is.readInt();
            this.mHandsWon = is.readInt();
            this.mHandsLost = is.readInt();
            this.mHandsPush = is.readInt();
            this.mHandsSurrender = is.readInt();
            this.mHandsBlackjack = is.readInt();
            this.mActionsTaken = is.readInt();
            this.mRecommendedActionsTaken = is.readInt();
            int dataLen = is.readInt();
            byte[] betData = new byte[dataLen];
            is.read(betData);
            this.mTotalBet = new Bet(betData);
            dataLen = is.readInt();
            betData = new byte[dataLen];
            is.read(betData);
            this.mTotalLost = new Bet(betData);
            dataLen = is.readInt();
            betData = new byte[dataLen];
            is.read(betData);
            this.mTotalWinnings = new Bet(betData);
            dataLen = is.readInt();
            betData = new byte[dataLen];
            is.read(betData);
            this.mGlobalTotalBet = new Bet(betData);
            dataLen = is.readInt();
            betData = new byte[dataLen];
            is.read(betData);
            this.mGlobalTotalLost = new Bet(betData);
            dataLen = is.readInt();
            betData = new byte[dataLen];
            is.read(betData);
            this.mGlobalTotalWinnings = new Bet(betData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

