/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.videopoker;

import java.util.Vector;
import net.handyx.casinopack.videopoker.Card;
import net.handyx.casinopack.videopoker.Common;
import net.handyx.casinopack.videopoker.Hand;

public class HandEvaluator {
    public static final int NOTHING = -1;
    public static final int HIGH_CARD = -1;
    public static final int ROYAL_FLUSH = 8;
    public static final int STRAIGHT_FLUSH = 7;
    public static final int FOUR_OF_A_KIND = 6;
    public static final int FULL_HOUSE = 5;
    public static final int FLUSH = 4;
    public static final int STRAIGHT = 3;
    public static final int THREE_OF_A_KIND = 2;
    public static final int TWO_PAIR = 1;
    public static final int ONE_PAIR = 0;
    public static final String[] HAND_NAMES = new String[]{"Jacks or Better", "Two Pair", "Three of a Kind", "Straight", "Flush", "Full House", "Four of a Kind", "Straight Flush", "Royal Flush"};
    public static final String[] STRATEGY = new String[]{"Four of a kind, straight flush, royal flush", "4 to a royal flush", "Three of a kind, straight, flush, full house", "4 to a straight flush", "Two pair", "High pair", "3 to a royal flush", "4 to a flush", "Low pair", "4 to an outside straight", "2 suited high cards", "3 to a straight flush", "2 unsuited high cards", "Suited 10/J, 10/Q, or 10/K", "One high card", "Discard everything"};
    public static final String[] STRATEGY_EXAMPLES = new String[]{"", "7d Th Jh Qh Kh", "", "5d 6d 8d 9d Js", "4d 4s Jh Js Qd", "5d 9s Qh Qs Ac", "5d 7h Jc Kc Ac", "6s 9s 2s Js 5d", "2s 6d 6s Jh 9d", "4s 5h 6d 7d Qs", "3s 9h Js Qh Ks", "4s 6h 7h 9h Ks", "5s 8h Jc Ks Ad", "3c 8s 5s Th Qh", "3s 9h 5c Tc Qs", "3s 7c 4d 9d Th"};
    public static final String[] STRATEGY_TEXT = new String[]{"These are the the top three hands in poker and you should always hold all the cards to receive the payout. Often a royal flush will give an even higher payout if you have placed a maximum bet so it is important to always bet the maximum if you can afford to.", "If you hold 4 cards to a royal flush you should always hold them, even if your 5 card hand is a flush or a straight. This is because the royal flush has a such a high payout that it is worth taking a risk for the highest payout.", "These are great hands and you should always hold all the cards (or the three of a kind). The only deviation from this rule is when you hold 4 cards to a royal flush in which case it is better to hold those 4 cards as the payout for a royal flush is so high.", "A straight flush is only bettered by a royal flush and has a good payout. If you hold 4 cards to a straight flush you should always hold those four cards unless your hand also forms a flush or straight. A flush or straight is only worth breaking if you have 4 cards to a royal flush.", "This is a fairly common hand in video poker and you should hold the two pairs unless you have anything better. Unlike a single pair, the value of each pair doesn't have to be a high pair meaning that any card values can form the two pairs, not just jacks or better.", "This is the most common paying hand in video poker, although it only ever pays even money. The pair must be formed of two high cards (jack, queen, king or ace).", "If you have 3 cards to a royal flush it is best to hold those cards over other non-paying hands such as a low pair or 4 to a flush. Although the odds of getting the two remaining cards are slim the payout is so high that it is worth the risk, there is also the better chance of getting a flush or or non-flush straight.", "When you have four cards of the same suit it is almost always best to hold these cards. The odds of getting the remaining suit card to finish the flush are quite good as there are a possible 9 cards that can complete the hand. However, don't be tempted to hold 3 cards to flush as the odds of drawing two suited cards are too high.", "A low pair is any pair lower than a pair of Jacks (Ace is considered a high card). Although a low pair is not a winning hand, by holding the pair you have a good chance of drawing to three (or even four) of a kind, two pair or even a full house. A common mistake is to hold an additional high card with the low pair. As two pair pays the same with both low and high pairs,  holding the extra card just reduces the odds of improving the hand.", "If you hold 4 cards to outside straight this means that that there are a possible 8 cards that can complete your straight, in this example either a 3 or 8. However, don't be tempted to hold 4 cards to an inside straight (e.g. 4s 5h 7d 8d Qh) as only 4 cards can complete an inside straight. Remember, both A234 and JQKA are inside straights as only one card can complete the straight.", "If your initial hand only has a number of unpaired high cards it is always best to hold the two high cards of the same suit. This way you have the chance of drawing a high pair or two pair with the more unlikely possibility of getting a flush, straight or even straight flush.", "Although unlikely, if you have 3 cards to a straight flush it is best to hold onto these as the payout for a straight flush is so high and there is also the possibility of drawing a flush or straight. 3 cards to a royal flush is an even better hand to hold and is preferable to 4 cards to a flush!", "A very common initial hand, where it is always best to hold 2 high cards, even better if they are suited. The aim will be to draw to pair or two pair. The reason for choosing the lower two high cards is because they have a better chance of forming a straight. Don't be tempted to hold more than two high cards though, as this will only reduce your chances of improving your hand.", "A weak starting hand, the reason for holding the suited ten is because of the slim probability of drawing to a royal flush. It is more probable to draw a pair or possibly a straight or flush but don't get your hopes up.", "Unfortunately a common opening hand but only slightly better than discarding everything. It is best to hold a single high card if you have one in the hope of drawing to a high pair or possibly two pair.", "Fortunately this isn't a particularly common opening hand which is just as well. Don't hold anything and hope to draw that winning hand! Don't be tempted to hold a low card just for the sake of it."};
    private Hand longestFlush;
    private Hand matches34OfAKind;
    private Hand highCards;
    private Hand holdCards;
    private Vector pairs;
    private Vector partialStraights;
    private int currentHand = -1;
    private int suggestedStrategy = 15;

    public int eval(Hand h) {
        int i;
        if (h.size() < 5) {
            return -1;
        }
        this._calculateHandStats(h);
        Common.log("-- Stats -----------------------------------------------------------------");
        Common.log("Best flush ....... " + this.longestFlush.toString());
        if (this.matches34OfAKind.size() >= 3) {
            Common.log("3/4 of a Kind .... " + this.matches34OfAKind.toString());
        }
        if (this.pairs.size() > 0) {
            Common.log("Pairs: ");
            for (i = 0; i < this.pairs.size(); ++i) {
                Common.log("\t" + ((Hand)this.pairs.elementAt(i)).toString());
            }
        }
        if (this.partialStraights.size() > 0) {
            Common.log("Partial Straights:");
            for (i = 0; i < this.partialStraights.size(); ++i) {
                Common.log("\t" + ((Hand)this.partialStraights.elementAt(i)).toString());
            }
        }
        this._calculateStrategy(h);
        Common.log("Suggested Strategy: " + STRATEGY[this.suggestedStrategy]);
        Common.log("Hold Cards : " + this.holdCards.toString());
        return this.currentHand;
    }

    private void _calculateHandStats(Hand h) {
        Hand h1;
        int r;
        this.longestFlush = this._findLongestFlush(h);
        this.matches34OfAKind = this._findMatching(h);
        this.pairs = this._findPairs(h);
        this.partialStraights = this._findPartialStraights(h);
        this.highCards = new Hand();
        for (int i = 0; i < h.size(); ++i) {
            Card c1 = h.getCard(i);
            if (c1.getRank() < 11 && c1.getRank() != 1) continue;
            this.highCards.addCard(c1);
        }
        this.currentHand = -1;
        if (h.isStraight() && h.isFlush()) {
            this.currentHand = h.getFirstStraightRank() == 10 ? 8 : 7;
        } else if (this.matches34OfAKind.size() == 4) {
            this.currentHand = 6;
        } else if (this.matches34OfAKind.size() == 3 && this.pairs.size() >= 1) {
            this.currentHand = 5;
        } else if (h.isFlush()) {
            this.currentHand = 4;
        } else if (h.isStraight()) {
            this.currentHand = 3;
        } else if (this.matches34OfAKind.size() == 3) {
            this.currentHand = 2;
        } else if (this.pairs.size() >= 2) {
            this.currentHand = 1;
        } else if (this.pairs.size() > 0 && ((r = (h1 = (Hand)this.pairs.firstElement()).getCard(0).getRank()) >= 11 || r == 1)) {
            this.currentHand = 0;
        }
    }

    public void _calculateStrategy(Hand h) {
        Hand rf1;
        int s;
        Hand h1;
        int i;
        this.suggestedStrategy = 15;
        this.holdCards = new Hand();
        if (this.highCards.size() > 0) {
            this.holdCards.reset();
            this.holdCards.addCard(this.highCards.getLowestCard());
            this.suggestedStrategy = 14;
        }
        for (int suit = 0; suit < 4; ++suit) {
            if (!h.contains(10, suit) || !h.contains(11, suit) && !h.contains(12, suit) && !h.contains(13, suit)) continue;
            this.holdCards.reset();
            this.holdCards.addCard(new Card(10, suit));
            if (h.contains(11, suit)) {
                this.holdCards.addCard(new Card(11, suit));
            } else if (h.contains(12, suit)) {
                this.holdCards.addCard(new Card(12, suit));
            } else if (h.contains(13, suit)) {
                this.holdCards.addCard(new Card(13, suit));
            }
            this.suggestedStrategy = 13;
            break;
        }
        if (this.highCards.size() >= 2) {
            this.holdCards.reset();
            this.holdCards.addCard(this.highCards.getCard(0));
            this.holdCards.addCard(this.highCards.getCard(1));
            this.suggestedStrategy = 12;
        }
        for (i = 0; i < this.partialStraights.size(); ++i) {
            h1 = (Hand)this.partialStraights.elementAt(i);
            if (!h1.isFlush()) continue;
            this.holdCards.reset();
            this.holdCards.addCards(h1);
            this.suggestedStrategy = 11;
            break;
        }
        block2: for (i = 0; i < this.highCards.size(); ++i) {
            Card c1 = this.highCards.getCard(i);
            for (int j = 0; j < this.highCards.size(); ++j) {
                Card c2;
                if (j == i || (c2 = this.highCards.getCard(j)).getSuit() != c1.getSuit()) continue;
                this.suggestedStrategy = 10;
                this.holdCards.reset();
                this.holdCards.addCard(c1);
                this.holdCards.addCard(c2);
                continue block2;
            }
        }
        for (i = 0; i < this.partialStraights.size(); ++i) {
            h1 = (Hand)this.partialStraights.elementAt(i);
            if (!h1.isStraight() || h1.size() != 4 || h1.getFirstStraightRank() < 2 || h1.getFirstStraightRank() > 10) continue;
            this.holdCards.reset();
            this.holdCards.addCards(h1);
            this.suggestedStrategy = 9;
            break;
        }
        if (this.pairs.size() > 0) {
            h1 = (Hand)this.pairs.firstElement();
            this.holdCards.reset();
            this.holdCards.addCards(h1);
            this.suggestedStrategy = 8;
        }
        if (this.longestFlush.size() >= 4) {
            this.holdCards.reset();
            this.holdCards.addCards(this.longestFlush);
            this.suggestedStrategy = 7;
        }
        block5: for (i = 0; i < this.partialStraights.size(); ++i) {
            h1 = (Hand)this.partialStraights.elementAt(i);
            if (h1.size() != 3 || !h1.isFlush()) continue;
            for (s = 0; s < 4; ++s) {
                rf1 = new Hand();
                rf1.addCard(new Card(10, s));
                rf1.addCard(new Card(11, s));
                rf1.addCard(new Card(12, s));
                rf1.addCard(new Card(13, s));
                rf1.addCard(new Card(1, s));
                if (!rf1.contains(h1)) continue;
                this.holdCards.reset();
                this.holdCards.addCards(h1);
                this.suggestedStrategy = 6;
                continue block5;
            }
        }
        for (i = 0; i < this.pairs.size(); ++i) {
            h1 = (Hand)this.pairs.elementAt(i);
            if (h1.getLowestCard().getRank() < 11 && h1.getLowestCard().getRank() != 1) continue;
            this.holdCards.reset();
            this.holdCards.addCards(h1);
            this.suggestedStrategy = 5;
            break;
        }
        if (this.pairs.size() >= 2) {
            this.holdCards.reset();
            this.holdCards.addCards((Hand)this.pairs.elementAt(0));
            this.holdCards.addCards((Hand)this.pairs.elementAt(1));
            this.suggestedStrategy = 4;
        }
        for (i = 0; i < this.partialStraights.size(); ++i) {
            h1 = (Hand)this.partialStraights.elementAt(i);
            if (h1.size() < 4 || !h1.isFlush()) continue;
            this.holdCards.reset();
            this.holdCards.addCards(h1);
            this.suggestedStrategy = 3;
            break;
        }
        if (this.currentHand == 2 || this.currentHand == 3 || this.currentHand == 5 || this.currentHand == 4) {
            this.holdCards.reset();
            this.holdCards.addCards(this.currentHand == 2 ? this.matches34OfAKind : h);
            this.suggestedStrategy = 2;
        }
        block9: for (i = 0; i < this.partialStraights.size(); ++i) {
            h1 = (Hand)this.partialStraights.elementAt(i);
            if (h1.size() < 4 || !h1.isFlush()) continue;
            for (s = 0; s < 4; ++s) {
                rf1 = new Hand();
                rf1.addCard(new Card(10, s));
                rf1.addCard(new Card(11, s));
                rf1.addCard(new Card(12, s));
                rf1.addCard(new Card(13, s));
                rf1.addCard(new Card(1, s));
                if (!rf1.contains(h1)) continue;
                this.holdCards.reset();
                this.holdCards.addCards(h1);
                this.suggestedStrategy = 1;
                continue block9;
            }
        }
        if (this.currentHand == 6 || this.currentHand == 7 || this.currentHand == 8) {
            this.holdCards.reset();
            this.holdCards.addCards(this.currentHand == 6 ? this.matches34OfAKind : h);
            this.suggestedStrategy = 0;
        }
    }

    public Hand _findLongestFlush(Hand h) {
        int numClubs = 0;
        int numSpades = 0;
        int numDiamonds = 0;
        int numHearts = 0;
        Hand returnHand = new Hand();
        block6: for (int i = 0; i < h.size(); ++i) {
            switch (h.getCard(i).getSuit()) {
                case 0: {
                    ++numClubs;
                    continue block6;
                }
                case 2: {
                    ++numHearts;
                    continue block6;
                }
                case 1: {
                    ++numDiamonds;
                    continue block6;
                }
                case 3: {
                    ++numSpades;
                }
            }
        }
        int s = 2;
        if (numClubs >= numSpades && numClubs >= numDiamonds && numClubs >= numHearts) {
            s = 0;
        } else if (numSpades >= numClubs && numSpades >= numDiamonds && numSpades >= numHearts) {
            s = 3;
        } else if (numDiamonds >= numClubs && numDiamonds >= numSpades && numDiamonds >= numHearts) {
            s = 1;
        }
        for (int i = 0; i < h.size(); ++i) {
            Card c1 = h.getCard(i);
            if (c1.getSuit() != s) continue;
            returnHand.addCard(c1);
        }
        return returnHand;
    }

    public Hand _findMatching(Hand h) {
        Hand matches = new Hand();
        for (int i = 0; i < h.size(); ++i) {
            Card c1 = h.getCard(i);
            matches = new Hand();
            matches.addCard(c1);
            for (int j = 0; j < h.size(); ++j) {
                Card c2;
                if (j == i || (c2 = h.getCard(j)).getRank() != c1.getRank()) continue;
                matches.addCard(c2);
            }
            if (matches.size() < 3) continue;
            return matches;
        }
        return new Hand();
    }

    public Vector _findPairs(Hand h) {
        Vector<Hand> pairedCards = new Vector<Hand>();
        Hand tmp = new Hand();
        Hand h2 = h.duplicate();
        for (int i = 0; i < h2.size(); ++i) {
            Card c1 = h2.getCard(i);
            tmp = new Hand();
            tmp.addCard(c1);
            for (int j = 0; j < h2.size(); ++j) {
                if (j == i) continue;
                Card c2 = h2.getCard(j);
                if (c1.getRank() != c2.getRank()) continue;
                tmp.addCard(c2);
            }
            if (tmp.size() != 2) continue;
            pairedCards.addElement(tmp);
            for (int k = 0; k < tmp.size(); ++k) {
                h2.removeCard(tmp.getCard(k));
            }
        }
        return pairedCards;
    }

    public Vector _findPartialStraights(Hand h) {
        Vector<Hand> matches = new Vector<Hand>();
        for (int i = 1; i < 11; ++i) {
            Hand target = new Hand();
            for (int j = 0; j < 5; ++j) {
                if (i + j == 14) {
                    target.addCard(new Card(1, 2));
                    continue;
                }
                target.addCard(new Card(i + j, 2));
            }
            Hand partialStraight = new Hand();
            for (int j = 0; j < h.size(); ++j) {
                Card c1 = h.getCard(j);
                if (!target.containsRank(c1.getRank()) || partialStraight.containsRank(c1.getRank())) continue;
                partialStraight.addCard(c1);
            }
            if (partialStraight.size() < 3) continue;
            matches.addElement(partialStraight);
        }
        return matches;
    }

    public String getLastStrategy() {
        return STRATEGY[this.suggestedStrategy];
    }

    public String getLastStrategyDescription() {
        return STRATEGY_TEXT[this.suggestedStrategy];
    }

    public String getLastStrategyExample() {
        return STRATEGY_EXAMPLES[this.suggestedStrategy];
    }

    public Hand getHoldCards() {
        return this.holdCards;
    }

    public int[] getHoldCardsArray(Hand orig) {
        int[] cardIdxs = new int[this.holdCards.size()];
        for (int i = 0; i < cardIdxs.length; ++i) {
            cardIdxs[i] = orig.findCardUnsorted(this.holdCards.getCard(i));
        }
        return cardIdxs;
    }

    public boolean hasHoldCards() {
        return this.holdCards.size() > 0;
    }
}

