/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.slots;

import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.FrameRenderer;
import net.handyx.casinopack.common.GMG;
import net.handyx.casinopack.common.GraphicsScaler;
import net.handyx.casinopack.common.RecordManager;
import net.handyx.casinopack.common.RunnableCanvas;
import net.handyx.casinopack.common.Settings;
import net.handyx.casinopack.slots.Common;
import net.handyx.casinopack.slots.Slots;
import net.handyx.casinopack.slots.Strings;

public class MenuCanvas
extends RunnableCanvas {
    private Slots parent;
    private Image titleImage;
    private Image[] alphaMesh = new Image[5];
    private int MAIN_MENU = 0;
    private int HELP_MENU = 2;
    private int displayMode = this.MAIN_MENU;
    private int soundSetting = 0;
    private int maxLines = 18;
    private int lineOffset = 0;
    private int scrolling = 0;
    private String[] helpLines = null;
    public int selectedIndex = 0;
    public int optionsSelectedIndex = 0;
    public int helpSelectedIndex = 0;
    private int POPUP_REVEAL = 1;
    private int POPUP_HIDE = 2;
    private int displayPopup = 0;
    private int POPUP_ABOUT = 0;
    private int POPUP_NEW_GAME = 1;
    private int POPUP_HELP = 2;
    private int POPUP_EXIT_CONFIRM = 3;
    private int POPUP_GMG_CONNECTION = 4;
    private int POPUP_MACHINE_TYPE = 5;
    private int popupType = this.POPUP_ABOUT;
    private int boxW = 0;
    private int boxH = 0;
    private int boxNumFrames = 0;
    private int boxFrame = 0;
    private int alphaIndex = -1;
    private Image handSmallLeftImage;
    private Image handSmallRightImage;
    private int handX = 0;
    private boolean handAccelerate = true;
    private int machineType = 0;
    private String[] machineDescriptionLines;
    public int pointerStartY = -1;

    public MenuCanvas(Slots p) {
        this.parent = p;
    }

    public void loadResources() {
        this.titleImage = Common.loadImage("/title.jpg");
        this.handSmallLeftImage = Common.loadImage("/hand_small_left.png");
        this.handSmallRightImage = Common.loadImage("/hand_small_right.png");
        if (!Settings.DISABLE_ALPHA_EFFECTS) {
            for (int i = 0; i < 5; ++i) {
                this.alphaMesh[i] = Common.loadCommonImage("/mesh_alpha" + i + ".png");
            }
        }
        this.machineDescriptionLines = Common.normalFont.wrap(Strings.MACHINE_TYPE_DESCRIPTION[this.machineType], 160);
    }

    public void purgeResources() {
        this.titleImage = null;
        this.machineDescriptionLines = null;
        this.handSmallRightImage = null;
        this.handSmallLeftImage = null;
        if (!Settings.DISABLE_ALPHA_EFFECTS) {
            for (int i = 0; i < 5; ++i) {
                this.alphaMesh[i] = null;
            }
        }
        System.gc();
    }

    public void processFrame(int fn) {
        if (this.boxFrame < this.boxNumFrames) {
            ++this.boxFrame;
            if (this.displayPopup == this.POPUP_HIDE) {
                if (this.alphaIndex > -1) {
                    --this.alphaIndex;
                }
            } else if (this.alphaIndex < 4) {
                ++this.alphaIndex;
            }
            if (this.boxFrame == this.boxNumFrames && this.displayPopup == this.POPUP_HIDE) {
                this.displayPopup = 0;
                this.alphaIndex = -1;
            }
        }
        if (this.scrolling == 1) {
            if (this.lineOffset + this.maxLines < this.helpLines.length) {
                ++this.lineOffset;
            }
        } else if (this.scrolling == -1 && this.lineOffset > 0) {
            --this.lineOffset;
        }
        if (this.handAccelerate) {
            ++this.handX;
            if (this.handX == 6) {
                this.handAccelerate = false;
            }
        } else {
            --this.handX;
            if (this.handX == 0) {
                this.handAccelerate = true;
            }
        }
    }

    public void paintCanvas(Graphics gfx, int sw, int sh) {
        int i;
        int y;
        int x;
        GraphicsScaler g = new GraphicsScaler(gfx, 240, 320, 360, 480);
        sw = g.getWidth();
        sh = g.getHeight();
        g.drawImage(Common.bgImage, 0, 0, 20);
        g.drawImage(this.titleImage, 0, 0, 20);
        if (this.displayMode == this.MAIN_MENU) {
            String s;
            x = 0;
            y = 110;
            if (GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                for (i = 0; i < Strings.MENU_ITEMS_GMG.length; ++i) {
                    s = Strings.MENU_ITEMS_GMG[i];
                    if (i == 2) {
                        s = Settings.DISABLE_VOLUME_SETTING ? s + " " + Strings.NON_VOLUME_OPTIONS[this.soundSetting] : s + " " + Strings.VOLUME_OPTIONS[this.soundSetting];
                    } else if (i == 3) {
                        s = GMG.GET_MORE_GAMES_LABEL;
                    }
                    x = sw - Common.largeFont.stringWidth(s) >> 1;
                    if (i == this.selectedIndex) {
                        Common.largeFont.drawString(g, s, x + 1, y + 1);
                        Common.largeFont.drawString(g, s, x, y);
                    } else {
                        Common.largeFontDisabled.drawString(g, s, x, y);
                    }
                    y += Common.largeFont.getHeight() + 5;
                }
            } else {
                for (i = 0; i < Strings.MENU_ITEMS.length; ++i) {
                    s = Strings.MENU_ITEMS[i];
                    if (i == 2) {
                        s = Settings.DISABLE_VOLUME_SETTING ? s + " " + Strings.NON_VOLUME_OPTIONS[this.soundSetting] : s + " " + Strings.VOLUME_OPTIONS[this.soundSetting];
                    }
                    x = sw - Common.largeFont.stringWidth(s) >> 1;
                    if (i == this.selectedIndex) {
                        Common.largeFont.drawString(g, s, x + 1, y + 1);
                        Common.largeFont.drawString(g, s, x, y);
                    } else {
                        Common.largeFontDisabled.drawString(g, s, x, y);
                    }
                    y += Common.largeFont.getHeight() + 5;
                }
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, Strings.CMD_SELECT, Common.largeFont);
            }
        } else if (this.displayMode == this.HELP_MENU) {
            x = 0;
            y = 110;
            for (i = 0; i < Strings.HELP_MENU_ITEMS.length; ++i) {
                x = sw - Common.largeFont.stringWidth(Strings.HELP_MENU_ITEMS[i]) >> 1;
                if (i == this.helpSelectedIndex) {
                    Common.largeFont.drawString(g, Strings.HELP_MENU_ITEMS[i], x + 1, y + 1);
                    Common.largeFont.drawString(g, Strings.HELP_MENU_ITEMS[i], x, y);
                } else {
                    Common.largeFontDisabled.drawString(g, Strings.HELP_MENU_ITEMS[i], x, y);
                }
                y += Common.largeFont.getHeight() + 5;
            }
            if (this.displayPopup == 0) {
                MenuCanvas.drawLeftCommand(g, Strings.CMD_SELECT, Common.largeFont);
                MenuCanvas.drawRightCommand(g, Strings.CMD_BACK, Common.largeFont);
            }
        }
        if (this.displayPopup > 0) {
            int meshY;
            int meshX;
            if (!Settings.DISABLE_ALPHA_EFFECTS) {
                if (this.alphaIndex >= 0) {
                    for (meshX = 0; meshX < sw; meshX += 48) {
                        for (meshY = 0; meshY < sh; meshY += 64) {
                            g.drawImage(this.alphaMesh[this.alphaIndex], meshX, meshY, 20);
                        }
                    }
                }
            } else {
                for (meshX = 0; meshX < sw; meshX += 48) {
                    for (meshY = 0; meshY < sh; meshY += 64) {
                        g.drawImage(Common.meshImage, meshX, meshY, 20);
                    }
                }
            }
            if (this.boxFrame < this.boxNumFrames) {
                int tmpH;
                int tmpW;
                if (this.displayPopup == this.POPUP_REVEAL) {
                    tmpW = this.boxFrame * (this.boxW / this.boxNumFrames);
                    tmpH = this.boxFrame * (this.boxH / this.boxNumFrames);
                    FrameRenderer.renderFrame(g, sw >> 1, sh >> 1, tmpW, tmpH, 3, null);
                } else if (this.displayPopup == this.POPUP_HIDE) {
                    tmpW = (this.boxNumFrames - this.boxFrame) * (this.boxW / this.boxNumFrames);
                    tmpH = (this.boxNumFrames - this.boxFrame) * (this.boxH / this.boxNumFrames);
                    FrameRenderer.renderFrame(g, sw >> 1, sh >> 1, tmpW, tmpH, 3, null);
                }
            } else {
                int boxX = sw - this.boxW >> 1;
                int boxY = sh - this.boxH >> 1;
                FrameRenderer.renderFrame(g, boxX, boxY, this.boxW, this.boxH, 20, null);
                String[] lines = null;
                if (this.popupType == this.POPUP_ABOUT) {
                    lines = Common.normalFont.wrap(Strings.ABOUT_TEXT, this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, Strings.CMD_OK, Common.largeFont);
                } else if (this.popupType == this.POPUP_NEW_GAME) {
                    lines = Common.normalFont.wrap("Start New Game?\n\nWarning: This will reset any winnings you have obtained in your current game.", this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, Strings.CMD_NO, Common.largeFont);
                    MenuCanvas.drawLeftCommand(g, Strings.CMD_YES, Common.largeFont);
                } else if (this.popupType == this.POPUP_HELP) {
                    MenuCanvas.drawRightCommand(g, Strings.CMD_BACK, Common.largeFont);
                } else if (this.popupType == this.POPUP_EXIT_CONFIRM) {
                    lines = Common.normalFont.wrap("Are you sure you want to exit?\n\nNote. Any bets still on the table (that cannot be removed) will be lost.", this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, Strings.CMD_NO, Common.largeFont);
                    MenuCanvas.drawLeftCommand(g, Strings.CMD_YES, Common.largeFont);
                } else if (this.popupType == this.POPUP_GMG_CONNECTION) {
                    lines = Common.normalFont.wrap("Sorry, there was a connection problem.\n\nPlease check your network settings or contact your service provider.", this.boxW - 16);
                    MenuCanvas.drawRightCommand(g, Strings.CMD_OK, Common.largeFont);
                } else if (this.popupType == this.POPUP_MACHINE_TYPE) {
                    MenuCanvas.drawRightCommand(g, Strings.CMD_BACK, Common.largeFont);
                    MenuCanvas.drawLeftCommand(g, Strings.CMD_CONTINUE, Common.largeFont);
                }
                if (this.popupType == this.POPUP_MACHINE_TYPE) {
                    int y2 = boxY + 10;
                    Common.normalFont.drawCenteredString(g, "Select Machine Type", y2);
                    int txtX = (sw - Common.largeFont.stringWidth(Strings.MACHINE_TYPES[this.machineType])) / 2;
                    Common.largeFont.drawString(g, Strings.MACHINE_TYPES[this.machineType], txtX, y2 += Common.normalFont.getHeight() + 10);
                    g.drawImage(this.handSmallLeftImage, txtX - g.unscale(this.handSmallLeftImage.getWidth()) - 10 - this.handX, y2 + 1, 20);
                    g.drawImage(this.handSmallRightImage, txtX + Common.largeFont.stringWidth(Strings.MACHINE_TYPES[this.machineType]) + 10 + this.handX, y2 + 1, 20);
                    y2 += Common.largeFont.getHeight() + 10;
                    for (int i2 = 0; i2 < this.machineDescriptionLines.length; ++i2) {
                        Common.normalFont.drawCenteredString(g, this.machineDescriptionLines[i2], y2);
                        y2 += Common.normalFont.getHeight();
                    }
                } else if (this.popupType != this.POPUP_HELP) {
                    int y3 = sh - lines.length * Common.normalFont.getHeight() >> 1;
                    for (int i3 = 0; i3 < lines.length; ++i3) {
                        Common.normalFont.drawCenteredString(g, lines[i3], y3);
                        y3 += Common.normalFont.getHeight();
                    }
                } else {
                    int y4 = boxY + 10;
                    int x2 = boxX + 10;
                    Common.largeFont.drawCenteredString(g, Strings.HELP_MENU_ITEMS[this.helpSelectedIndex], y4);
                    y4 += Common.largeFont.getHeight() + 7;
                    if (this.helpLines != null) {
                        for (int l = 0; l < this.maxLines && l + this.lineOffset < this.helpLines.length; ++l) {
                            Common.normalFont.drawString(g, this.helpLines[l + this.lineOffset], x2, y4);
                            y4 += Common.normalFont.getHeight();
                        }
                    }
                    if (this.helpLines.length > this.maxLines) {
                        int scrollBarHeight = Common.normalFont.getHeight() * this.maxLines;
                        g.setColor(0);
                        g.fillRect(boxX + this.boxW - 12, boxY + 17 + Common.largeFont.getHeight(), 3, scrollBarHeight);
                        int maxBarPos = scrollBarHeight - 3 - g.unscale(Common.scrollerImage.getHeight());
                        int offset = maxBarPos * 10000 / (this.helpLines.length - this.maxLines) * this.lineOffset / 10000;
                        if (this.helpLines.length - this.lineOffset <= this.maxLines) {
                            offset = maxBarPos;
                        }
                        g.drawImage(Common.scrollerImage, boxX + this.boxW - 14, boxY + 19 + Common.largeFont.getHeight() + offset, 20);
                    }
                }
            }
        }
    }

    public void keyPressedEvent(int keyCode, int ga, int softkey) {
        if (this.displayPopup == this.POPUP_REVEAL) {
            if (softkey == 2) {
                if (Settings.DISABLE_ANIMATING_PANELS) {
                    this.displayPopup = 0;
                } else {
                    this.displayPopup = this.POPUP_HIDE;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                }
                return;
            }
            if (softkey == 1) {
                if (this.popupType == this.POPUP_NEW_GAME) {
                    this.displayPopup = this.POPUP_REVEAL;
                    this.popupType = this.POPUP_MACHINE_TYPE;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                    this.boxW = 200;
                    this.boxH = 140;
                    if (Settings.DISABLE_ANIMATING_PANELS) {
                        this.boxFrame = this.boxNumFrames;
                    }
                } else if (this.popupType == this.POPUP_MACHINE_TYPE) {
                    this.displayPopup = 0;
                    Common.machineCasinoStyle = this.machineType == 1;
                    this.parent.startNewGame();
                } else if (this.popupType == this.POPUP_EXIT_CONFIRM) {
                    this.parent.exitApplication();
                }
                return;
            }
            if (this.popupType == this.POPUP_MACHINE_TYPE) {
                if (ga == 2 || ga == 5) {
                    this.machineType = this.machineType == 0 ? 1 : 0;
                    this.machineDescriptionLines = Common.normalFont.wrap(Strings.MACHINE_TYPE_DESCRIPTION[this.machineType], 160);
                } else if (ga == 8) {
                    this.displayPopup = 0;
                    Common.machineCasinoStyle = this.machineType == 1;
                    this.parent.startNewGame();
                }
            } else if (this.popupType == this.POPUP_HELP) {
                if (ga == 1) {
                    this.scrolling = -1;
                } else if (ga == 6) {
                    this.scrolling = 1;
                }
            }
        } else if (this.displayMode == this.MAIN_MENU) {
            if (softkey == 1) {
                this.performMenuSelect();
                return;
            }
            if (ga == 1) {
                this.selectedIndex = this.selectedIndex == 2 && !this.parent.slotMachineCanvas.canResumeGame() ? 0 : (GMG.DISPLAY_GET_MORE_GAMES_LINK ? (this.selectedIndex == 0 ? Strings.MENU_ITEMS_GMG.length - 1 : this.selectedIndex - 1) : (this.selectedIndex == 0 ? Strings.MENU_ITEMS.length - 1 : this.selectedIndex - 1));
            } else if (ga == 6) {
                this.selectedIndex = this.selectedIndex == 0 && !this.parent.slotMachineCanvas.canResumeGame() ? 2 : (GMG.DISPLAY_GET_MORE_GAMES_LINK ? (this.selectedIndex == Strings.MENU_ITEMS_GMG.length - 1 ? 0 : this.selectedIndex + 1) : (this.selectedIndex == Strings.MENU_ITEMS.length - 1 ? 0 : this.selectedIndex + 1));
            } else if (ga == 2) {
                if (this.selectedIndex == 2) {
                    this.soundSetting = Settings.DISABLE_VOLUME_SETTING ? (this.soundSetting == 0 ? Strings.NON_VOLUME_OPTIONS.length - 1 : --this.soundSetting) : (this.soundSetting == 0 ? Strings.VOLUME_OPTIONS.length - 1 : --this.soundSetting);
                    this.applySettings();
                }
            } else if (ga == 5) {
                if (this.selectedIndex == 2) {
                    this.performMenuSelect();
                }
            } else if (ga == 8) {
                this.performMenuSelect();
            }
        } else if (this.displayMode == this.HELP_MENU) {
            if (softkey == 1) {
                this.performMenuSelect();
                return;
            }
            if (softkey == 2) {
                this.displayMode = this.MAIN_MENU;
                return;
            }
            if (ga == 1) {
                this.helpSelectedIndex = this.helpSelectedIndex == 0 ? Strings.HELP_MENU_ITEMS.length - 1 : this.helpSelectedIndex - 1;
            } else if (ga == 6) {
                this.helpSelectedIndex = this.helpSelectedIndex == Strings.HELP_MENU_ITEMS.length - 1 ? 0 : this.helpSelectedIndex + 1;
            } else if (ga == 8) {
                this.performMenuSelect();
            }
        }
    }

    public void keyReleasedEvent(int keyCode, int ga, int softkey) {
        this.scrolling = 0;
    }

    public void performMenuSelect() {
        if (this.displayMode == this.MAIN_MENU) {
            int si = this.selectedIndex;
            if (GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                if (si == 3) {
                    block19: {
                        try {
                            if (this.parent.parent.platformRequest(GMG.GET_MORE_GAMES_URL) && !GMG.IGNORE_PLATFORM_REQUEST_EXIT) {
                                this.parent.exitApplication();
                            }
                        }
                        catch (Exception e) {
                            this.displayPopup = this.POPUP_REVEAL;
                            this.popupType = this.POPUP_GMG_CONNECTION;
                            this.boxFrame = 0;
                            this.boxNumFrames = 5;
                            this.boxW = 200;
                            this.boxH = 140;
                            if (!Settings.DISABLE_ANIMATING_PANELS) break block19;
                            this.boxFrame = this.boxNumFrames;
                        }
                    }
                    return;
                }
                if (si > 3) {
                    --si;
                }
            }
            switch (si) {
                case 0: {
                    if (this.parent.slotMachineCanvas.gameInProgress()) {
                        this.displayPopup = this.POPUP_REVEAL;
                        this.popupType = this.POPUP_NEW_GAME;
                        this.boxFrame = 0;
                        this.boxNumFrames = 5;
                        this.boxW = 200;
                        this.boxH = 140;
                        if (!Settings.DISABLE_ANIMATING_PANELS) break;
                        this.boxFrame = this.boxNumFrames;
                        break;
                    }
                    this.displayPopup = this.POPUP_REVEAL;
                    this.popupType = this.POPUP_MACHINE_TYPE;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                    this.boxW = 200;
                    this.boxH = 140;
                    if (!Settings.DISABLE_ANIMATING_PANELS) break;
                    this.boxFrame = this.boxNumFrames;
                    break;
                }
                case 1: {
                    if (!this.parent.slotMachineCanvas.canResumeGame()) break;
                    this.parent.resumeGame();
                    break;
                }
                case 2: {
                    this.soundSetting = Settings.DISABLE_VOLUME_SETTING ? (this.soundSetting == Strings.NON_VOLUME_OPTIONS.length - 1 ? 0 : ++this.soundSetting) : (this.soundSetting == Strings.VOLUME_OPTIONS.length - 1 ? 0 : ++this.soundSetting);
                    this.applySettings();
                    break;
                }
                case 3: {
                    this.helpSelectedIndex = 0;
                    this.displayMode = this.HELP_MENU;
                    break;
                }
                case 4: {
                    this.displayPopup = this.POPUP_REVEAL;
                    this.popupType = this.POPUP_ABOUT;
                    this.boxFrame = 0;
                    this.boxNumFrames = 5;
                    this.boxW = 200;
                    this.boxH = 140;
                    if (!Settings.DISABLE_ANIMATING_PANELS) break;
                    this.boxFrame = this.boxNumFrames;
                    break;
                }
                case 5: {
                    this.parent.exitApplication();
                }
            }
        } else if (this.displayMode == this.HELP_MENU) {
            this.boxW = 220;
            this.boxH = 280;
            String helpSectionData = this.loadTextResource("/help/help" + this.helpSelectedIndex + ".txt");
            this.helpLines = Common.normalFont.wrap(helpSectionData + "\n", this.boxW - 30);
            this.lineOffset = 0;
            this.scrolling = 0;
            this.displayPopup = this.POPUP_REVEAL;
            this.popupType = this.POPUP_HELP;
            this.boxFrame = 0;
            this.boxNumFrames = 5;
            if (Settings.DISABLE_ANIMATING_PANELS) {
                this.boxFrame = this.boxNumFrames;
            }
        }
    }

    public void applySettings() {
        if (Settings.DISABLE_VOLUME_SETTING) {
            Common.soundEnabled = this.soundSetting == 0;
        } else if (Strings.VOLUME_SETTINGS[this.soundSetting] == 0) {
            Common.soundEnabled = false;
        } else {
            Common.soundEnabled = true;
            Common.soundVolume = Strings.VOLUME_SETTINGS[this.soundSetting];
            Common.setSoundVolume(Common.soundVolume);
        }
    }

    public void loadSettings() {
        try {
            if (RecordManager.exists("slots_sound")) {
                this.soundSetting = RecordManager.byteArrayToInt(RecordManager.load("slots_sound"));
            }
            this.applySettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveSettings() {
        try {
            RecordManager.save(this.soundSetting, "slots_sound");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String loadTextResource(String res) {
        if (res == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = ((Object)((Object)this)).getClass().getResourceAsStream("/slots" + res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return sb.toString();
    }

    public void pointerPressedEvent(int px, int py) {
        block14: {
            block12: {
                block13: {
                    if (this.displayPopup != this.POPUP_REVEAL) break block12;
                    if (this.popupType != this.POPUP_HELP) break block13;
                    this.pointerStartY = py;
                    break block14;
                }
                if (this.popupType != this.POPUP_MACHINE_TYPE) break block14;
                this.machineType = this.machineType == 0 ? 1 : 0;
                break block14;
            }
            if (this.displayMode == this.MAIN_MENU) {
                int y = 110;
                int padding = 5;
                for (int i = 0; i < Strings.MENU_ITEMS.length; ++i) {
                    if (py >= y - padding && py <= y + Common.largeFont.getHeight() + padding) {
                        if (i == this.selectedIndex) {
                            this.performMenuSelect();
                        } else if (i != 1 || this.parent.slotMachineCanvas.canResumeGame()) {
                            this.selectedIndex = i;
                        }
                        return;
                    }
                    y += Common.largeFont.getHeight() + 5;
                }
            } else if (this.displayMode == this.HELP_MENU) {
                int y = 110;
                int padding = 5;
                for (int i = 0; i < Strings.HELP_MENU_ITEMS.length; ++i) {
                    if (py >= y - padding && py <= y + Common.largeFont.getHeight() + padding) {
                        if (i == this.helpSelectedIndex) {
                            this.performMenuSelect();
                        } else {
                            this.helpSelectedIndex = i;
                        }
                        return;
                    }
                    y += Common.largeFont.getHeight() + 5;
                }
            }
        }
    }

    public void pointerReleasedEvent(int x, int y) {
        this.scrolling = 0;
        this.pointerStartY = -1;
    }

    public void pointerDragged(int x, int y) {
        if (this.pointerStartY == -1) {
            return;
        }
        if (y - this.pointerStartY > 5) {
            this.scrolling = 1;
        } else if (y - this.pointerStartY < -5) {
            this.scrolling = -1;
        }
    }
}

