/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.slots;

import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.ImageFontRenderer;
import net.handyx.casinopack.common.Settings;
import net.handyx.casinopack.common.SoundManager;

public class Common {
    public static boolean debug = true;
    public static boolean machineCasinoStyle = true;
    public static int startingCash = 1000;
    public static int betAmount = 10;
    public static boolean firstTimeTutorial = true;
    public static boolean winningsPopup = true;
    public static boolean soundEnabled = false;
    public static int soundVolume = 100;
    public static SoundManager soundMan = null;
    public static String soundExt = "amr";
    public static String soundMime = "audio/amr";
    public static String soundDir = "/slots/sounds/";
    public static ImageFontRenderer largeFont;
    public static ImageFontRenderer largeFontDisabled;
    public static ImageFontRenderer normalFont;
    public static ImageFontRenderer smallFont;
    public static Image bgImage;
    public static Image meshImage;
    public static Image scrollerImage;
    private static Random rnd;

    public static int random(int v) {
        if (v == 0) {
            Common.log("Sanity check " + v);
            return 0;
        }
        return Math.abs(rnd.nextInt() % v);
    }

    public static void loadResources() {
        if (soundMan == null) {
            soundMan = new SoundManager();
        }
        largeFont = new ImageFontRenderer("/fonts/komik");
        largeFontDisabled = new ImageFontRenderer("/fonts/komik_disabled");
        normalFont = new ImageFontRenderer("/fonts/komik_thin");
        smallFont = new ImageFontRenderer("/fonts/bwmini");
        bgImage = Common.loadImage("/bg.jpg");
        scrollerImage = Common.loadImage("/scroller.png");
        meshImage = Settings.DISABLE_ALPHA_EFFECTS ? Common.loadCommonImage("/mesh.png") : Common.loadCommonImage("/mesh_alpha4.png");
    }

    public static void purgeResources() {
        if (soundMan != null) {
            soundMan.purgeResources();
        }
        soundMan = null;
        if (largeFont != null) {
            largeFont.purge();
        }
        largeFont = null;
        if (largeFontDisabled != null) {
            largeFontDisabled.purge();
        }
        largeFontDisabled = null;
        if (normalFont != null) {
            normalFont.purge();
        }
        normalFont = null;
        if (smallFont != null) {
            smallFont.purge();
        }
        smallFont = null;
        bgImage = null;
        meshImage = null;
        scrollerImage = null;
        System.gc();
    }

    public static void resetFontCache() {
        if (largeFont != null) {
            largeFont.resetCache();
        }
        if (largeFontDisabled != null) {
            largeFontDisabled.resetCache();
        }
        if (normalFont != null) {
            normalFont.resetCache();
        }
        if (smallFont != null) {
            smallFont.resetCache();
        }
        System.gc();
    }

    public static Image loadImage(String res) {
        Image img = null;
        try {
            img = Image.createImage((String)("/slots" + res));
        }
        catch (Exception e) {
            Common.log("Unable to load image: " + res);
        }
        return img;
    }

    public static Image loadCommonImage(String res) {
        Image img = null;
        try {
            img = Image.createImage((String)res);
        }
        catch (Exception e) {
            Common.log("Unable to load image: " + res);
        }
        return img;
    }

    public static String[] loadText(String res) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = res.getClass().getResourceAsStream("/slots" + res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            Common.log(e.toString());
        }
        return ImageFontRenderer.splitStringToArray("\n", sb.toString());
    }

    public static void doSound(String s) {
        Common.doSound(s + "." + soundExt, soundMime, 1);
    }

    public static void doSound(String s, String m) {
        Common.doSound(s, m, 1);
    }

    public static void doSound(String s, int loops) {
        if (!soundEnabled) {
            return;
        }
        Common.doSound(s + "." + soundExt, soundMime, loops);
    }

    public static void doSound(String s, String m, int loops) {
        if (!soundEnabled) {
            return;
        }
        try {
            System.out.println("Playing " + soundDir + s + " (" + m + ") @ " + System.currentTimeMillis());
            soundMan.playSound(soundDir + s, m, loops);
        }
        catch (Exception e) {
            System.out.println("Unable to play " + s);
        }
    }

    public static void cacheSound(String s) {
        Common.cacheSound(s + "." + soundExt, soundMime, 1);
    }

    public static void cacheSound(String s, int loops) {
        if (!soundEnabled) {
            return;
        }
        Common.cacheSound(s + "." + soundExt, soundMime, loops);
    }

    public static void cacheSound(String s, String m, int loops) {
        if (!soundEnabled) {
            return;
        }
        try {
            soundMan.cacheSound(soundDir + s, m, loops);
        }
        catch (Exception e) {
            System.out.println("Unable to cache " + s);
        }
    }

    public static void forceCacheSound(String s) {
        Common.forceCacheSound(s + "." + soundExt, soundMime, 1);
    }

    public static void forceCacheSound(String s, int loops) {
        if (!soundEnabled) {
            return;
        }
        Common.forceCacheSound(s + "." + soundExt, soundMime, loops);
    }

    public static void forceCacheSound(String s, String m, int loops) {
        if (!soundEnabled) {
            return;
        }
        try {
            soundMan.forceCacheSound(soundDir + s, m, loops);
        }
        catch (Exception e) {
            System.out.println("Unable to cache " + s);
        }
    }

    public static void stopSounds() {
        soundMan.stopSound();
        soundMan = null;
        System.gc();
        soundMan = new SoundManager();
    }

    public static void setSoundVolume(int vol) {
        if (vol == 0) {
            soundEnabled = false;
            soundMan.enableVolumeControl(false);
        } else {
            soundEnabled = true;
            soundMan.enableVolumeControl(true);
            soundMan.setVolume(vol);
        }
    }

    public static void log(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    static {
        rnd = new Random();
    }
}

