/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.common;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import net.handyx.casinopack.common.SoundManagerListener;

public class SoundManager
implements Runnable,
PlayerListener {
    public static final int LOOP_FOREVER = -1;
    public static final String NONE = "uninitialized";
    private String currentState = "uninitialized";
    public String errLog = "";
    private String cachedSoundRes = "";
    private String cachedSoundMimeType = "";
    private String soundRes = "";
    private String soundMimeType = "audio/x-wav";
    private boolean preCacheSound = false;
    private boolean garbageCollectAfterDeAlloc = true;
    private Player p = null;
    private Thread t = null;
    private int playerVolume = 100;
    private boolean volumeControlEnabled = false;
    private int soundLoopCount = 1;
    private boolean waitForEndOfMedia = false;
    private boolean logState = false;
    private String statelog = "";
    private long logStartTime = 0L;
    private SoundManagerListener listener = null;
    public static final int NOTHING = 0;
    public static final int PRECACHE_SOUND_START = 1;
    public static final int PRECACHE_SOUND_END = 2;
    public static final int PLAY_SOUND_START = 3;
    public static final int PLAY_SOUND_END = 4;
    public static final int PLAY_SOUND_ABORTED = 5;
    public static final int KILL_PLAYER_ABORTED = 6;
    public static final int PLAYER_ERROR = 7;
    public static final int PRECACHE_SOUND_ABORTED = 8;
    public static final int PLAYER_AVAILABLE = 9;
    public static final int PLAYER_UNAVAILABLE = 10;
    public static final int PLAYER_CLOSED = 11;
    public static final String[] EVENT_NAMES = new String[]{"Nothing", "Precache Sound Start", "Precache Sound End", "Play Sound Start", "Play Sound End", "Play Sound Aborted", "Kill Player Aborted", "Player Error", "Precache Sound Aborted", "Device Available", "Device Unavailable", "Player Closed"};

    public boolean playSound(String r, String mimeType) {
        return this.playSound(r, mimeType, 1);
    }

    public boolean playSound(String r, String mimeType, int loopCount) {
        if (this.waitForEndOfMedia && (this.currentState.equals("started") || this.currentState.equals("deviceUnavailable"))) {
            if (this.listener != null) {
                this.listener.soundManagerEvent(this, 5);
            }
            return false;
        }
        if (this.preCacheSound && r.equals(this.cachedSoundRes)) {
            this.preCacheSound = false;
            if (this.listener != null) {
                this.listener.soundManagerEvent(this, 2);
            }
            return true;
        }
        String testMime = this.checkMimeTypes(mimeType);
        if (testMime != null) {
            this.soundRes = r;
            this.soundMimeType = testMime;
            this.soundLoopCount = loopCount;
            this.killPlayer(false);
            this.t = new Thread(this);
            this.t.start();
            return true;
        }
        if (this.listener != null) {
            this.listener.soundManagerEvent(this, 7);
        }
        System.out.println("Unsupported mime-type: " + mimeType);
        return false;
    }

    public boolean forcePlaySound(String r, String mimeType) {
        return this.forcePlaySound(r, mimeType, 1);
    }

    public boolean forcePlaySound(String r, String mimeType, int loopCount) {
        if (this.waitForEndOfMedia && (this.currentState.equals("started") || this.currentState.equals("deviceUnavailable"))) {
            if (this.listener != null) {
                this.listener.soundManagerEvent(this, this.preCacheSound ? 8 : 5);
            }
            return false;
        }
        String testMime = this.checkMimeTypes(mimeType);
        if (testMime != null) {
            this.soundRes = r;
            this.soundMimeType = testMime;
            this.soundLoopCount = loopCount;
            this.killPlayer(true);
            this.t = new Thread(this);
            this.t.start();
            return true;
        }
        if (this.listener != null) {
            this.listener.soundManagerEvent(this, 7);
        }
        System.out.println("Unsupported mime-type: " + mimeType);
        return false;
    }

    public boolean cacheSound(String r, String mimeType) {
        this.preCacheSound = true;
        return this.playSound(r, mimeType, 1);
    }

    public boolean cacheSound(String r, String mimeType, int loopCount) {
        this.preCacheSound = true;
        return this.playSound(r, mimeType, loopCount);
    }

    public boolean forceCacheSound(String r, String mimeType) {
        this.preCacheSound = true;
        return this.forcePlaySound(r, mimeType, 1);
    }

    public boolean forceCacheSound(String r, String mimeType, int loopCount) {
        this.preCacheSound = true;
        return this.forcePlaySound(r, mimeType, loopCount);
    }

    public boolean stopSound() {
        return this.killPlayer(true);
    }

    public void purgeResources() {
        this.stopSound();
        this.listener = null;
    }

    public void run() {
        block22: {
            try {
                if (this.preCacheSound) {
                    if (this.listener != null) {
                        this.listener.soundManagerEvent(this, 1);
                    }
                    if (!this.soundRes.equals(this.cachedSoundRes)) {
                        this.createPlayer();
                        this.p.realize();
                        if (this.volumeControlEnabled && this.playerVolume != 100) {
                            System.out.println("Setting Volume to " + this.playerVolume);
                            try {
                                VolumeControl vol = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                                vol.setLevel(this.playerVolume);
                            }
                            catch (Exception e) {
                                System.out.println("Unable to set volume: " + e.toString());
                            }
                        }
                        this.p.prefetch();
                    }
                    this.preCacheSound = false;
                    if (this.listener != null) {
                        this.listener.soundManagerEvent(this, 2);
                    }
                    break block22;
                }
                if (this.soundRes.equals(this.cachedSoundRes)) {
                    if (this.volumeControlEnabled && this.playerVolume != 100) {
                        System.out.println("Setting Volume to " + this.playerVolume);
                        try {
                            VolumeControl vol = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                            vol.setLevel(this.playerVolume);
                        }
                        catch (Exception e) {
                            System.out.println("Unable to set volume: " + e.toString());
                        }
                    }
                    if (this.cachedSoundMimeType.equals("audio/midi") || this.cachedSoundMimeType.equals("audio/mid")) {
                        try {
                            this.p.setMediaTime(-1L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.p.start();
                    break block22;
                }
                this.createPlayer();
                this.p.realize();
                if (this.volumeControlEnabled && this.playerVolume != 100) {
                    System.out.println("Setting Volume to " + this.playerVolume);
                    try {
                        VolumeControl vol = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                        vol.setLevel(this.playerVolume);
                    }
                    catch (Exception e) {
                        System.out.println("Unable to set volume: " + e.toString());
                    }
                }
                this.p.start();
            }
            catch (Exception e) {
                if (this.listener != null) {
                    this.listener.soundManagerEvent(this, 7);
                }
                System.out.println("SoundManager.run(): " + e.toString());
                if (this.p == null) break block22;
                try {
                    this.p.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                if (!this.garbageCollectAfterDeAlloc) break block22;
                System.gc();
            }
        }
    }

    private void createPlayer() {
        block7: {
            try {
                if (this.logState) {
                    this.statelog = this.statelog + "-- createPlayer --\n";
                    this.statelog = this.statelog + this.soundRes + "\n";
                    this.statelog = this.statelog + this.soundMimeType + "\n";
                    this.statelog = this.statelog + "--------------------\n";
                }
                InputStream is = this.getClass().getResourceAsStream(this.soundRes);
                this.p = Manager.createPlayer((InputStream)is, (String)this.soundMimeType);
                this.p.addPlayerListener((PlayerListener)this);
                if (this.soundLoopCount != 0 && this.soundLoopCount != 1) {
                    this.p.setLoopCount(this.soundLoopCount);
                }
                this.cachedSoundRes = this.soundRes;
                this.cachedSoundMimeType = this.soundMimeType;
            }
            catch (Exception e) {
                if (this.listener != null) {
                    this.listener.soundManagerEvent(this, 7);
                }
                System.out.println("SoundManager.createPlayer(): " + e.toString());
                if (this.p == null) break block7;
                try {
                    this.p.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                if (!this.garbageCollectAfterDeAlloc) break block7;
                System.gc();
            }
        }
    }

    private boolean killPlayer(boolean forcePurge) {
        try {
            if (this.waitForEndOfMedia && (this.currentState.equals("started") || this.currentState.equals("deviceUnavailable"))) {
                if (this.listener != null) {
                    this.listener.soundManagerEvent(this, 6);
                }
                return false;
            }
            if (this.p != null && (!this.soundRes.equals(this.cachedSoundRes) || forcePurge)) {
                try {
                    this.p.stop();
                }
                catch (MediaException me) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                this.cachedSoundRes = "";
                this.cachedSoundMimeType = "";
                if (this.garbageCollectAfterDeAlloc) {
                    System.gc();
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            System.out.println("SoundManager.killPlayer(): " + ex.toString());
            return false;
        }
    }

    public String checkMimeTypes(String mime) {
        int i;
        mime = mime.toLowerCase().trim();
        String[] contentTypes = Manager.getSupportedContentTypes(null);
        for (i = 0; i < contentTypes.length; ++i) {
            if (!mime.equals(contentTypes[i])) continue;
            return contentTypes[i];
        }
        for (i = 0; i < contentTypes.length; ++i) {
            if (!(mime.equals("audio/mpeg") || mime.equals("audio/mp3") ? contentTypes[i].equals("audio/mpeg") || contentTypes[i].equals("audio/x-mpeg") || contentTypes[i].equals("audio/mpeg3") || contentTypes[i].equals("audio/x-mpeg3") || contentTypes[i].equals("audio/mp3") || contentTypes[i].equals("audio/x-mp3") || contentTypes[i].equals("audio/mpg") || contentTypes[i].equals("audio/x-mpg") : (mime.equals("audio/x-wav") || mime.equals("audio/wav") ? contentTypes[i].equals("audio/wav") || contentTypes[i].equals("audio/x-wav") : (mime.equals("audio/midi") || contentTypes[i].equals("audio/mid") ? contentTypes[i].equals("audio/mid") || contentTypes[i].equals("audio/x-mid") || contentTypes[i].equals("audio/midi") || contentTypes[i].equals("audio/x-midi") : (mime.equals("audio/x-smaf") || contentTypes[i].equals("audio/mmf") ? contentTypes[i].equals("audio/mmf") || contentTypes[i].equals("audio/x-mmf") || contentTypes[i].equals("application/x-smaf") || contentTypes[i].equals("application/x-smaf-audio") || contentTypes[i].equals("application/vnd.smaf") : (mime.equals("application/x-smaf-audio") || mime.equals("application/x-smaf-phrase") ? contentTypes[i].equals("audio/mmf") || contentTypes[i].equals("audio/x-mmf") || contentTypes[i].equals("audio/x-smaf") : !(!mime.equals("audio/m4a") && !mime.equals("audio/aac") || !contentTypes[i].equals("audio/aac") && !contentTypes[i].equals("audio/m4a") && !contentTypes[i].equals("audio/mp4") && !contentTypes[i].equals("audio/x-mp4")))))))) continue;
            return contentTypes[i];
        }
        return null;
    }

    public boolean supportsVolume(String res, String mime) {
        boolean ret = false;
        try {
            InputStream is = this.getClass().getResourceAsStream(res);
            Player tmpPlayer = Manager.createPlayer((InputStream)is, (String)mime);
            tmpPlayer.realize();
            VolumeControl vol = (VolumeControl)tmpPlayer.getControl("javax.microedition.media.control.VolumeControl");
            vol.setLevel(this.playerVolume);
            ret = true;
            try {
                tmpPlayer.stop();
            }
            catch (MediaException me) {
                // empty catch block
            }
            tmpPlayer.deallocate();
            tmpPlayer.close();
            tmpPlayer = null;
            vol = null;
            System.gc();
        }
        catch (MediaException me) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public void enableVolumeControl(boolean v) {
        this.volumeControlEnabled = v;
    }

    public void enableVolumeControl() {
        this.volumeControlEnabled = true;
    }

    public void disableVolumeControl() {
        this.volumeControlEnabled = false;
    }

    public void setVolume(int v) {
        if (v > 100) {
            v = 100;
        }
        if (v < 0) {
            v = 0;
        }
        this.playerVolume = v;
    }

    public int getVolume() {
        return this.playerVolume;
    }

    public void playerUpdate(Player ply, String state, Object obj) {
        this.currentState = state;
        if (this.logState) {
            this.statelog = this.statelog + state + " @ " + (System.currentTimeMillis() - this.logStartTime) + "ms\n";
        }
        if (this.listener != null) {
            if (state.equals("started")) {
                this.listener.soundManagerEvent(this, 3);
            } else if (state.equals("stopped") || state.equals("endOfMedia")) {
                this.listener.soundManagerEvent(this, 4);
            } else if (state.equals("error")) {
                this.listener.soundManagerEvent(this, 7);
            } else if (state.equals("closed")) {
                this.listener.soundManagerEvent(this, 11);
            } else if (state.equals("deviceUnavailable")) {
                this.listener.soundManagerEvent(this, 10);
            } else if (state.equals("deviceAvailable")) {
                this.listener.soundManagerEvent(this, 9);
            }
        }
    }

    public String getState() {
        return this.currentState;
    }

    public boolean getState(String s) {
        return this.currentState.equals(s);
    }

    public String getStateLog() {
        return this.statelog;
    }

    public void startStateLogging() {
        this.statelog = "";
        this.logState = true;
        this.logStartTime = System.currentTimeMillis();
    }

    public void stopStateLogging() {
        this.logState = false;
    }

    public void disablePlayerListener() {
    }

    public void enablePlayerListener() {
    }

    public void enableWaitForEndOfMedia() {
        this.waitForEndOfMedia = true;
    }

    public void disableWaitForEndOfMedia() {
        this.waitForEndOfMedia = false;
    }

    public void setSoundManagerListener(SoundManagerListener listener) {
        this.listener = listener;
    }
}

