/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.common;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.GraphicsScaler;
import tube42.lib.ui.ImageUtils;

public class ImageFontRenderer {
    private static final int UPPER_CHARS = 26;
    private static final int LOWER_CHARS = 26;
    private static final int NUMBER_CHARS = 17;
    private static final int SYMBOL_CHARS = 26;
    private int[] upperCharWidths;
    private int[] upperCharOffsets;
    private int[] lowerCharWidths;
    private int[] lowerCharOffsets;
    private int[] numCharWidths;
    private int[] numCharOffsets;
    private int[] symbolCharWidths;
    private int[] symbolCharOffsets;
    private Image fontImage;
    private int[] fontData;
    private int fontDataWidth = 0;
    private int fontDataHeight = 0;
    private int fontHeight;
    private int spaceWidth = 4;
    private int fontSpacing = 1;
    private int sourceCharacterSpacing = 1;
    private boolean debug = true;
    private long timeStamp = 1L;
    private int STRING_IMAGE_CACHE_SIZE = 16;
    private Image[] stringImageCache;
    private String[] stringImageCacheString;
    private long[] stringImageCacheLastUsed;
    private String sourceFilename = "none";
    private boolean useCache = true;

    public ImageFontRenderer(String res) {
        String dat_res;
        this.sourceFilename = res;
        String png_res = res + ".png";
        if (!png_res.startsWith("/")) {
            png_res = "/" + png_res;
        }
        if (!(dat_res = res + ".dat").startsWith("/")) {
            dat_res = "/" + dat_res;
        }
        this.loadFont(png_res, dat_res);
    }

    public ImageFontRenderer(String res, int spacing) {
        this(res);
        this.sourceCharacterSpacing = spacing;
    }

    private void loadFont(String res, String dat) {
        int i;
        if (this.debug) {
            System.out.println("Loading font " + res + " ...");
        }
        try {
            this.fontImage = Image.createImage((String)res);
        }
        catch (Exception e) {
            System.out.println("Unable to load font resource: " + res);
            return;
        }
        this.fontHeight = this.fontImage.getHeight() - 3 >> 2;
        Vector data = ImageFontRenderer.splitString("\n", this.loadTextResource(dat));
        int startLine = 0;
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector upper = ImageFontRenderer.splitString(",", (String)data.elementAt(startLine++));
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector lower = ImageFontRenderer.splitString(",", (String)data.elementAt(startLine++));
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector nums = ImageFontRenderer.splitString(",", (String)data.elementAt(startLine++));
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector symbs = ImageFontRenderer.splitString(",", (String)data.elementAt(startLine++));
        this.upperCharWidths = new int[26];
        this.upperCharOffsets = new int[26];
        this.lowerCharWidths = new int[26];
        this.lowerCharOffsets = new int[26];
        this.numCharWidths = new int[17];
        this.numCharOffsets = new int[17];
        this.symbolCharWidths = new int[26];
        this.symbolCharOffsets = new int[26];
        this.stringImageCache = new Image[this.STRING_IMAGE_CACHE_SIZE];
        this.stringImageCacheString = new String[this.STRING_IMAGE_CACHE_SIZE];
        this.stringImageCacheLastUsed = new long[this.STRING_IMAGE_CACHE_SIZE];
        for (i = 0; i < this.upperCharWidths.length; ++i) {
            this.upperCharOffsets[i] = 0;
            this.upperCharWidths[i] = 0;
        }
        for (i = 0; i < this.lowerCharWidths.length; ++i) {
            this.lowerCharOffsets[i] = 0;
            this.lowerCharWidths[i] = 0;
        }
        for (i = 0; i < this.numCharWidths.length; ++i) {
            this.numCharOffsets[i] = 0;
            this.numCharWidths[i] = 0;
        }
        for (i = 0; i < this.symbolCharWidths.length; ++i) {
            this.symbolCharOffsets[i] = 0;
            this.symbolCharWidths[i] = 0;
        }
        Enumeration e = upper.elements();
        int i2 = 0;
        int offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.upperCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for uppercase characters");
                break;
            }
            this.upperCharWidths[i2] = Integer.parseInt(((String)e.nextElement()).trim());
            this.upperCharOffsets[i2] = offset;
            offset += this.upperCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.upperCharWidths.length && this.debug) {
            System.out.println("Warning: Missing " + (this.upperCharWidths.length - i2) + " character definitions for uppercase characters");
        }
        e = lower.elements();
        i2 = 0;
        offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.lowerCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for lowercase characters");
                break;
            }
            this.lowerCharWidths[i2] = Integer.parseInt(((String)e.nextElement()).trim());
            this.lowerCharOffsets[i2] = offset;
            offset += this.lowerCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.numCharWidths.length && this.debug) {
            System.out.println("Warning: Missing " + (this.lowerCharWidths.length - i2) + " character definitions for lowercase characters");
        }
        e = nums.elements();
        i2 = 0;
        offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.numCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for number characters");
                break;
            }
            this.numCharWidths[i2] = Integer.parseInt(((String)e.nextElement()).trim());
            this.numCharOffsets[i2] = offset;
            offset += this.numCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.numCharWidths.length && this.debug) {
            System.out.println("Warning: Missing " + (this.numCharWidths.length - i2) + " character definitions for number characters");
        }
        e = symbs.elements();
        i2 = 0;
        offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.symbolCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for symbol characters");
                break;
            }
            this.symbolCharWidths[i2] = Integer.parseInt(((String)e.nextElement()).trim());
            this.symbolCharOffsets[i2] = offset;
            offset += this.symbolCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.symbolCharWidths.length && this.debug) {
            System.out.println("Warning: Missing " + (this.symbolCharWidths.length - i2) + " character definitions for symbol characters");
        }
        symbs = null;
        nums = null;
        lower = null;
        upper = null;
        data = null;
        this.processImage();
    }

    private void processImage() {
        int w = this.fontImage.getWidth();
        int h = this.fontImage.getHeight();
        this.fontData = new int[w * h];
        this.fontDataWidth = w;
        this.fontDataHeight = h;
        this.fontImage.getRGB(this.fontData, 0, w, 0, 0, w, h);
        this.fontImage = null;
    }

    private void parseSetting(String s) {
        String settingName = "";
        String settingValue = "";
        if (this.debug) {
            System.out.println("Parsing setting " + s);
        }
        if (s.startsWith("$")) {
            int eq = (s = s.substring(1)).indexOf("=");
            if (eq >= 0) {
                settingName = s.substring(0, eq).toLowerCase().trim();
                settingValue = s.substring(eq + 1).toLowerCase().trim();
                if (settingName.equals("png_character_spacing")) {
                    try {
                        this.sourceCharacterSpacing = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("font_spacing")) {
                    try {
                        this.fontSpacing = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("space_width")) {
                    try {
                        this.spaceWidth = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                }
            } else {
                System.out.println("Warning: Invalid setting $" + s);
            }
        }
    }

    public void drawCenteredString(Graphics g, String s, int w, int y) {
        this.drawString(g, s, (w - this.stringWidth(s)) / 2, y);
    }

    public void drawString(Graphics g, String s, int x, int y) {
        Image tmp = this.drawStringToImage(s);
        if (tmp != null) {
            g.drawImage(tmp, x, y, 20);
        }
    }

    private Image drawStringToImage(String s) {
        int imgwidth = this.stringWidth(s);
        int imgheight = this.fontHeight;
        if (imgwidth == 0) {
            return null;
        }
        int[] rgbData = new int[imgwidth * imgheight];
        char[] chars = s.toCharArray();
        int offset = 0;
        for (int c = 0; c < chars.length; ++c) {
            int charWidth = this.drawChar(rgbData, offset, imgwidth, chars[c]);
            offset += charWidth;
        }
        return Image.createRGBImage((int[])rgbData, (int)imgwidth, (int)imgheight, (boolean)true);
    }

    private ImageArray drawStringToImageArray(String s) {
        int imgwidth = this.stringWidth(s);
        int imgheight = this.fontHeight;
        ImageArray img = new ImageArray(imgwidth, imgheight);
        if (imgwidth == 0) {
            return img;
        }
        char[] chars = s.toCharArray();
        int offset = 0;
        for (int c = 0; c < chars.length; ++c) {
            int charWidth = this.drawChar(img.data, offset, img.width, chars[c]);
            offset += charWidth;
        }
        return img;
    }

    private int drawChar(int[] destRGB, int destOffset, int scanlength, char c) {
        int offset = c;
        try {
            int width = 0;
            if (offset == 32) {
                width += this.spaceWidth;
            } else if (offset >= 33 && offset <= 47) {
                offset -= 33;
                int srcOffset = 0;
                int outputOffset = 0;
                for (int srcY = 0; srcY < this.fontHeight; ++srcY) {
                    srcOffset = ((this.fontHeight + 1) * 3 + srcY) * this.fontDataWidth + this.symbolCharOffsets[offset];
                    outputOffset = srcY * scanlength + destOffset;
                    for (int srcX = 0; srcX < this.symbolCharWidths[offset]; ++srcX) {
                        destRGB[outputOffset + srcX] = this.blend(destRGB[outputOffset + srcX], this.fontData[srcOffset + srcX]);
                    }
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
            } else if (offset >= 48 && offset <= 64) {
                offset -= 48;
                int srcOffset = 0;
                int outputOffset = 0;
                for (int srcY = 0; srcY < this.fontHeight; ++srcY) {
                    srcOffset = ((this.fontHeight + 1) * 2 + srcY) * this.fontDataWidth + this.numCharOffsets[offset];
                    outputOffset = srcY * scanlength + destOffset;
                    for (int srcX = 0; srcX < this.numCharWidths[offset]; ++srcX) {
                        destRGB[outputOffset + srcX] = this.blend(destRGB[outputOffset + srcX], this.fontData[srcOffset + srcX]);
                    }
                }
                width += this.numCharWidths[offset] + this.fontSpacing;
            } else if (offset >= 65 && offset <= 90) {
                offset -= 65;
                int srcOffset = 0;
                int outputOffset = 0;
                for (int srcY = 0; srcY < this.fontHeight; ++srcY) {
                    srcOffset = srcY * this.fontDataWidth + this.upperCharOffsets[offset];
                    outputOffset = srcY * scanlength + destOffset;
                    for (int srcX = 0; srcX < this.upperCharWidths[offset]; ++srcX) {
                        destRGB[outputOffset + srcX] = this.blend(destRGB[outputOffset + srcX], this.fontData[srcOffset + srcX]);
                    }
                }
                width += this.upperCharWidths[offset] + this.fontSpacing;
            } else if (offset >= 91 && offset <= 96) {
                offset = offset - 91 + 15;
                int srcOffset = 0;
                int outputOffset = 0;
                for (int srcY = 0; srcY < this.fontHeight; ++srcY) {
                    srcOffset = ((this.fontHeight + 1) * 3 + srcY) * this.fontDataWidth + this.symbolCharOffsets[offset];
                    outputOffset = srcY * scanlength + destOffset;
                    for (int srcX = 0; srcX < this.symbolCharWidths[offset]; ++srcX) {
                        destRGB[outputOffset + srcX] = this.blend(destRGB[outputOffset + srcX], this.fontData[srcOffset + srcX]);
                    }
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
            } else if (offset >= 97 && offset <= 122) {
                offset -= 97;
                int srcOffset = 0;
                int outputOffset = 0;
                for (int srcY = 0; srcY < this.fontHeight; ++srcY) {
                    srcOffset = (this.fontHeight + 1 + srcY) * this.fontDataWidth + this.lowerCharOffsets[offset];
                    outputOffset = srcY * scanlength + destOffset;
                    for (int srcX = 0; srcX < this.lowerCharWidths[offset]; ++srcX) {
                        destRGB[outputOffset + srcX] = this.blend(destRGB[outputOffset + srcX], this.fontData[srcOffset + srcX]);
                    }
                }
                width += this.lowerCharWidths[offset] + this.fontSpacing;
            } else if (offset >= 123 && offset <= 126) {
                offset = offset - 123 + 21;
                int srcOffset = 0;
                int outputOffset = 0;
                for (int srcY = 0; srcY < this.fontHeight; ++srcY) {
                    srcOffset = ((this.fontHeight + 1) * 3 + srcY) * this.fontDataWidth + this.symbolCharOffsets[offset];
                    outputOffset = srcY * scanlength + destOffset;
                    for (int srcX = 0; srcX < this.symbolCharWidths[offset]; ++srcX) {
                        destRGB[outputOffset + srcX] = this.blend(destRGB[outputOffset + srcX], this.fontData[srcOffset + srcX]);
                    }
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
            } else if (offset == 163) {
                offset = offset - 163 + 25;
                int srcOffset = 0;
                int outputOffset = 0;
                for (int srcY = 0; srcY < this.fontHeight; ++srcY) {
                    srcOffset = ((this.fontHeight + 1) * 3 + srcY) * this.fontDataWidth + this.symbolCharOffsets[offset];
                    outputOffset = srcY * scanlength + destOffset;
                    for (int srcX = 0; srcX < this.symbolCharWidths[offset]; ++srcX) {
                        destRGB[outputOffset + srcX] = this.blend(destRGB[outputOffset + srcX], this.fontData[srcOffset + srcX]);
                    }
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
            } else {
                System.out.println("Warning: No symbol for " + (char)c + " (" + offset + ")");
            }
            return width;
        }
        catch (Exception e) {
            System.out.println("Error rendering character '" + (char)c + "' (offset:" + offset + ") destRGB.length=" + destRGB.length);
            System.out.println(e.toString());
            return 0;
        }
    }

    private int blend(int c1, int c2) {
        int c1A = c1 >> 24 & 0xFF;
        int c2A = c2 >> 24 & 0xFF;
        if (c2A == 255) {
            return c2;
        }
        if (c2A > 0) {
            int a = c1A + ((255 - c1A) * c2A >> 8);
            return (a << 24) + (c2 & 0xFFFFFF);
        }
        return c1;
    }

    public int stringWidth(String s) {
        return this.stringWidth(s.toCharArray());
    }

    public int stringWidth(char[] chars) {
        int width = 0;
        int offset = 0;
        try {
            for (int c = 0; c < chars.length; ++c) {
                offset = chars[c];
                if (offset == 32) {
                    width += this.spaceWidth;
                    continue;
                }
                if (offset >= 33 && offset <= 47) {
                    width += this.symbolCharWidths[offset -= 33] + this.fontSpacing;
                    continue;
                }
                if (offset >= 48 && offset <= 64) {
                    width += this.numCharWidths[offset -= 48] + this.fontSpacing;
                    continue;
                }
                if (offset >= 65 && offset <= 90) {
                    width += this.upperCharWidths[offset -= 65] + this.fontSpacing;
                    continue;
                }
                if (offset >= 91 && offset <= 96) {
                    offset = offset - 91 + 15;
                    width += this.symbolCharWidths[offset] + this.fontSpacing;
                    continue;
                }
                if (offset >= 97 && offset <= 122) {
                    width += this.lowerCharWidths[offset -= 97] + this.fontSpacing;
                    continue;
                }
                if (offset >= 123 && offset <= 126) {
                    offset = offset - 123 + 21;
                    width += this.symbolCharWidths[offset] + this.fontSpacing;
                    continue;
                }
                if (offset != 163) continue;
                offset = offset - 163 + 25;
                width += this.symbolCharWidths[offset] + this.fontSpacing;
            }
        }
        catch (Exception e) {
            System.out.println("offset=" + offset);
        }
        return width -= this.fontSpacing;
    }

    public int charWidth(char c) {
        int width = 0;
        int offset = c;
        if (offset == 32) {
            width = this.spaceWidth;
        } else if (offset >= 33 && offset <= 47) {
            width = this.symbolCharWidths[offset -= 33] + this.fontSpacing;
        } else if (offset >= 48 && offset <= 64) {
            width = this.numCharWidths[offset -= 48] + this.fontSpacing;
        } else if (offset >= 65 && offset <= 90) {
            width = this.upperCharWidths[offset -= 65] + this.fontSpacing;
        } else if (offset >= 91 && offset <= 96) {
            offset = offset - 91 + 15;
            width = this.symbolCharWidths[offset] + this.fontSpacing;
        } else if (offset >= 97 && offset <= 122) {
            width = this.lowerCharWidths[offset -= 97] + this.fontSpacing;
        } else if (offset >= 123 && offset <= 126) {
            offset = offset - 123 + 21;
            width = this.symbolCharWidths[offset] + this.fontSpacing;
        } else if (offset == 163) {
            offset = offset - 163 + 25;
            width = this.symbolCharWidths[offset] + this.fontSpacing;
        }
        return width;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public void setFontSpacing(int v) {
        this.fontSpacing = v;
    }

    public int getFontSpacing() {
        return this.fontSpacing;
    }

    public void setSpaceWidth(int v) {
        this.spaceWidth = v;
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    private String loadTextResource(String res) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = this.getClass().getResourceAsStream(res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load text resource: " + res);
            return "";
        }
        return sb.toString();
    }

    public static Vector splitString(String c, String text) {
        Vector<String> lines = new Vector<String>();
        int length = text.trim().length();
        int num = 0;
        for (int i = length; i != 0; --i) {
            num = text.indexOf(c);
            if (num < 0) {
                if (text.length() <= 0) break;
                lines.addElement(text);
                break;
            }
            lines.addElement(text.substring(0, num));
            text = text.substring(num + c.length(), text.length());
        }
        return lines;
    }

    public static String[] splitStringToArray(String c, String text) {
        Vector v = ImageFontRenderer.splitString(c, text);
        String[] ret = new String[v.size()];
        int i = 0;
        while (!v.isEmpty()) {
            ret[i++] = (String)v.firstElement();
            v.removeElementAt(0);
        }
        return ret;
    }

    private String arrayToString(int[] arr) {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(arr[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public String[] wrap(String s, int w) {
        return ImageFontRenderer.splitStringToArray("\n", this.wrapString(s, w));
    }

    public String wrapString(String s, int w) {
        StringBuffer wrapped = new StringBuffer("");
        Vector lines = ImageFontRenderer.splitString("\n", s);
        int lsize = lines.size();
        Vector words = null;
        String word = null;
        for (int i = 0; i < lsize; ++i) {
            words = ImageFontRenderer.splitString(" ", ((String)lines.elementAt(i)).trim());
            int lineWidth = 0;
            int wsize = words.size();
            for (int j = 0; j < wsize; ++j) {
                word = (String)words.elementAt(j);
                int wordWidth = this.stringWidth(word);
                if (lineWidth + this.spaceWidth + wordWidth >= w) {
                    wrapped.append('\n');
                    if (wordWidth > w) {
                        wrapped.append(this.wrapWord(word, w));
                        lineWidth = this.stringWidth(this.wrapWord(word, w));
                        continue;
                    }
                    wrapped.append((String)words.elementAt(j));
                    lineWidth = wordWidth;
                    continue;
                }
                if (lineWidth > 0) {
                    wrapped.append(' ');
                    lineWidth += this.spaceWidth;
                }
                wrapped.append((String)words.elementAt(j));
                lineWidth += wordWidth;
            }
            wrapped.append("\n");
        }
        return wrapped.toString();
    }

    private String wrapWord(String s, int w) {
        StringBuffer wrapped = new StringBuffer("");
        int dashWidth = this.charWidth('-');
        int wordWidth = 0;
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            int cWidth = this.charWidth(c);
            if (wordWidth + dashWidth + this.charWidth(c) > w) {
                wrapped.append('-');
                wrapped.append('\n');
                wrapped.append(c);
                wordWidth = cWidth;
                continue;
            }
            wrapped.append(c);
            wordWidth += cWidth;
        }
        return wrapped.toString();
    }

    public void purge() {
        this.fontImage = null;
        this.fontData = null;
        this.upperCharWidths = null;
        this.upperCharOffsets = null;
        this.lowerCharWidths = null;
        this.lowerCharOffsets = null;
        this.numCharWidths = null;
        this.numCharOffsets = null;
        this.symbolCharWidths = null;
        this.symbolCharOffsets = null;
        this.stringImageCacheString = null;
        this.stringImageCache = null;
        this.stringImageCacheLastUsed = null;
    }

    public void resetCache() {
        if (!this.useCache) {
            return;
        }
        for (int i = 0; i < this.STRING_IMAGE_CACHE_SIZE; ++i) {
            this.stringImageCacheString[i] = null;
            this.stringImageCache[i] = null;
            this.stringImageCacheLastUsed[i] = 0L;
        }
    }

    public void disableCache() {
        this.useCache = false;
        this.stringImageCacheString = null;
        this.stringImageCache = null;
        this.stringImageCacheLastUsed = null;
    }

    public void drawCenteredString(GraphicsScaler g, String s, int w, int y) {
        this.drawString(g, s, (w - this.stringWidth(s)) / 2, y);
    }

    public void drawString(GraphicsScaler g, String s, int x, int y) {
        if (s == null || s.trim().length() == 0) {
            return;
        }
        if (this.useCache) {
            for (int i = 0; i < this.STRING_IMAGE_CACHE_SIZE; ++i) {
                if (this.stringImageCacheString[i] == null || !this.stringImageCacheString[i].equals(s)) continue;
                ++this.timeStamp;
                g.drawImage(this.stringImageCache[i], x, y, 20);
                return;
            }
        }
        ImageArray img = this.drawStringToImageArray(s);
        if (img.data != null && img.width > 0 && img.height > 0) {
            if (this.useCache) {
                int oldestImageIndex = 0;
                for (int i = 0; i < this.STRING_IMAGE_CACHE_SIZE; ++i) {
                    if (this.stringImageCacheLastUsed[i] >= this.stringImageCacheLastUsed[oldestImageIndex]) continue;
                    oldestImageIndex = i;
                }
                System.out.println(this.sourceFilename + ": Adding '" + s + "' image #" + oldestImageIndex + " to cache");
                this.stringImageCacheString[oldestImageIndex] = s;
                ++this.timeStamp;
                this.stringImageCache[oldestImageIndex] = ImageUtils.resize(img.data, img.width, img.height, g.scale(img.width), g.scale(img.height), true);
                g.drawImage(this.stringImageCache[oldestImageIndex], x, y, 20);
            } else {
                Image scaledImage = ImageUtils.resize(img.data, img.width, img.height, g.scale(img.width), g.scale(img.height), true);
                g.drawImage(scaledImage, x, y, 20);
            }
        }
        img.purge();
    }

    public void drawCenteredString(GraphicsScaler g, String s, int y) {
        this.drawString(g, s, (g.getWidth() - this.stringWidth(s)) / 2, y);
    }

    private class ImageArray {
        public int[] data = null;
        public int width = 0;
        public int height = 0;

        public ImageArray(int w, int h) {
            if (w > 0 && h > 0) {
                this.data = new int[w * h];
            }
            this.width = w;
            this.height = h;
        }

        public void purge() {
            this.data = null;
            this.height = 0;
            this.width = 0;
        }

        public String toString() {
            if (this.data == null) {
                return "Width:" + this.width + " Height:" + this.height + " data.length=NULL";
            }
            return "Width:" + this.width + " Height:" + this.height + " data.length=" + this.data.length;
        }
    }
}

