/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.common;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.casinopack.common.GraphicsScaler;

public class FrameRenderer {
    public static final int BACKGROUND_COLOUR = 0xFFFFFF;
    public static final int OUTLINE_COLOUR = 0;
    public static final int LIGHT_SHADE_COLOUR = 0xD9D9D9;
    public static final int DARK_SHADE_COLOUR = 0x777777;

    public static void renderFrame(Graphics g, int x, int y, int w, int h, int alignment, Image tile) {
        if ((alignment & 2) == 2) {
            y -= h >> 1;
        } else if ((alignment & 0x20) == 32) {
            y -= h;
        }
        if ((alignment & 1) == 1) {
            x -= w >> 1;
        } else if ((alignment & 8) == 8) {
            x -= w;
        }
        FrameRenderer._renderFrame(g, x, y, w, h, tile);
    }

    public static void renderFrame(Graphics g, int x, int y, int w, int h) {
        FrameRenderer.renderFrame(g, x, y, w, h, 0x10 | 4, null);
    }

    public static void renderFrame(Graphics g, int x, int y, int w, int h, int alignment) {
        FrameRenderer.renderFrame(g, x, y, w, h, alignment, null);
    }

    private static void _renderFrame(Graphics g, int x, int y, int w, int h, Image tile) {
        if (tile != null) {
            int prevClipX = g.getClipX();
            int prevClipY = g.getClipY();
            int prevClipW = g.getClipWidth();
            int prevClipH = g.getClipHeight();
            g.setClip(x + 2, y + 2, w - 4, h - 4);
            int tileW = tile.getWidth();
            int tileH = tile.getHeight();
            for (int tileY = y + 2; tileY < y + h - 4; tileY += tileH) {
                for (int tileX = x + 2; tileX < x + w - 4; tileX += tileW) {
                    g.drawImage(tile, tileX, tileY, 0x10 | 4);
                }
            }
            g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
        } else {
            g.setColor(0xFFFFFF);
            g.fillRect(x + 2, y + 2, w - 4, h - 4);
        }
        g.setColor(0);
        g.drawLine(x + 2, y, x + w - 4, y);
        g.drawLine(x, y + 2, x, y + h - 4);
        g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 3);
        g.drawLine(x + w - 2, y + 3, x + w - 2, y + h - 3);
        g.drawLine(x + 3, y + h - 2, x + w - 3, y + h - 2);
        g.drawLine(x + 3, y + h - 1, x + w - 3, y + h - 1);
        g.setColor(0xD9D9D9);
        g.drawLine(x + 2, y + 1, x + w - 4, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + h - 4);
        g.setColor(0x777777);
        g.drawLine(x + w - 3, y + 2, x + w - 3, y + h - 4);
        g.drawLine(x + 3, y + h - 3, x + w - 4, y + h - 3);
        g.setColor(0);
        g.drawLine(x + 1, y + 1, x + 2, y + 1);
        g.drawLine(x + 1, y + 1, x + 1, y + 2);
        g.setColor(0xD9D9D9);
        g.drawLine(x + 2, y + 2, x + 2, y + 2);
        g.setColor(0);
        g.drawLine(x + w - 4, y + 1, x + w - 3, y + 1);
        g.drawLine(x + w - 3, y + 2, x + w - 2, y + 2);
        g.setColor(0xD9D9D9);
        g.drawLine(x + w - 4, y + 2, x + w - 4, y + 2);
        g.setColor(0);
        g.fillRect(x + w - 4, y + h - 4, 3, 3);
        g.setColor(0x777777);
        g.fillRect(x + w - 4, y + h - 4, 1, 1);
        g.setColor(0);
        g.drawLine(x + 1, y + h - 4, x + 1, y + h - 3);
        g.drawLine(x + 2, y + h - 3, x + 2, y + h - 2);
        g.setColor(0xD9D9D9);
        g.drawLine(x + 2, y + h - 4, x + 2, y + h - 4);
    }

    public static void renderFrame(GraphicsScaler g, int x, int y, int w, int h, int alignment, Image tile) {
        if ((alignment & 2) == 2) {
            y -= h >> 1;
        } else if ((alignment & 0x20) == 32) {
            y -= h;
        }
        if ((alignment & 1) == 1) {
            x -= w >> 1;
        } else if ((alignment & 8) == 8) {
            x -= w;
        }
        FrameRenderer._renderFrame(g, x, y, w, h);
    }

    public static void renderFrame(GraphicsScaler g, int x, int y, int w, int h) {
        FrameRenderer.renderFrame(g, x, y, w, h, 0x10 | 4, null);
    }

    public static void renderFrame(GraphicsScaler g, int x, int y, int w, int h, int alignment) {
        FrameRenderer.renderFrame(g, x, y, w, h, alignment, null);
    }

    private static void _renderFrame(GraphicsScaler g, int x, int y, int w, int h) {
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.setColor(0xFFFFFF);
        g.fillRect(x + 2, y + 2, w - 4, h - 4);
    }
}

