/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack.game;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import net.handyx.casinopack.blackjack.game.Bet;
import net.handyx.casinopack.blackjack.game.Card;
import net.handyx.casinopack.blackjack.game.Game;

public class Hand {
    private int mTotal = 0;
    private int mLowTotal = 0;
    private int mNumAces = 0;
    private boolean mTotalIsSoft = false;
    private boolean mHasBlackjack = false;
    private boolean mIsSplitHand = false;
    private boolean mCanDoubleDown = false;
    private boolean mCanSplit = false;
    private boolean mCanHit = false;
    private boolean mHasDoubledDown = false;
    private boolean mCanSurrender = false;
    private boolean mHasSurrendered = false;
    private boolean mHasTakenEvenMoney = false;
    private Bet mBet;
    private Bet mInsuranceBet;
    private Vector mCards;

    public Hand(Bet bet, boolean isSplitHand) {
        this.mCards = new Vector();
        this.mIsSplitHand = isSplitHand;
        this.mHasSurrendered = false;
        this.mHasDoubledDown = false;
        this.mHasTakenEvenMoney = false;
        this.mBet = new Bet(bet);
        this.mInsuranceBet = new Bet(0);
    }

    public Hand(byte[] data) {
        this.fromByteArray(data);
    }

    public Bet getBet() {
        return this.mBet;
    }

    public void setBet(Bet b) {
        this.mBet.set(b);
    }

    public void setInsuranceBet(Bet insurance) {
        this.mInsuranceBet.set(insurance);
    }

    public Bet getInsuranceBet() {
        return this.mInsuranceBet;
    }

    public void handTakeEvenMoney() {
        this.mHasTakenEvenMoney = true;
    }

    public Card getCard(int i) {
        if (i < this.mCards.size()) {
            return (Card)this.mCards.elementAt(i);
        }
        return null;
    }

    public Card getLastCard() {
        return this.getCard(this.mCards.size() - 1);
    }

    public void addCard(Card c) {
        this.mCards.addElement(c);
        this.calculateStats();
    }

    public void removeCard(int cardIndex) {
        this.mCards.removeElementAt(cardIndex);
        this.calculateStats();
    }

    public int numCards() {
        return this.mCards.size();
    }

    public int getLastCardIndex() {
        return this.mCards.size() - 1;
    }

    public void setIsSplit(boolean val) {
        this.mIsSplitHand = val;
        this.calculateStats();
    }

    private void calculateStats() {
        this.mTotal = 0;
        this.mLowTotal = 0;
        this.mTotalIsSoft = false;
        this.mNumAces = 0;
        this.mHasBlackjack = false;
        this.mCanDoubleDown = false;
        this.mCanSplit = false;
        this.mCanHit = true;
        this.mCanSurrender = false;
        if (this.mCards.size() <= 1) {
            return;
        }
        for (int d = 0; d < this.mCards.size(); ++d) {
            Card crd = (Card)this.mCards.elementAt(d);
            if (crd.getValue() == 1) {
                ++this.mNumAces;
                continue;
            }
            this.mTotal += crd.getValue();
            this.mLowTotal += crd.getValue();
        }
        for (int aces = 0; aces < this.mNumAces; ++aces) {
            if (this.mTotal + 11 == 21 && aces == this.mNumAces - 1 || this.mTotal + 11 < 21) {
                this.mTotal += 11;
                ++this.mLowTotal;
                this.mTotalIsSoft = true;
                continue;
            }
            ++this.mTotal;
            ++this.mLowTotal;
        }
        if (this.mCards.size() == 2) {
            if (this.mTotal == 21 && !this.mIsSplitHand) {
                this.mHasBlackjack = true;
            }
            if (Game.ruleDoubleDown > 0) {
                if (Game.ruleDoubleDown == 1) {
                    if (!this.mTotalIsSoft && this.mTotal >= 10 && this.mTotal <= 11) {
                        this.mCanDoubleDown = true;
                    }
                } else if (Game.ruleDoubleDown == 2 && !this.mTotalIsSoft && this.mTotal >= 9 && this.mTotal <= 11) {
                    this.mCanDoubleDown = true;
                }
                if (this.mIsSplitHand && !Game.ruleDoubleOnSplit) {
                    this.mCanDoubleDown = false;
                }
            } else if (!this.mIsSplitHand || this.mIsSplitHand && Game.ruleDoubleOnSplit) {
                this.mCanDoubleDown = true;
            }
            Card c1 = (Card)this.mCards.elementAt(0);
            Card c2 = (Card)this.mCards.elementAt(1);
            if (Game.ruleSplitCardsMustHaveSameRank) {
                if (c1.getCardNumber() == c2.getCardNumber()) {
                    this.mCanSplit = true;
                }
            } else if (c1.getValue() == c2.getValue()) {
                this.mCanSplit = true;
            }
            if (Game.ruleNo45TenSplits && (c1.getCardNumber() == 4 || c1.getCardNumber() == 5 || c1.getCardNumber() == 10)) {
                this.mCanSplit = false;
            }
            if (!Game.ruleSplitAces && c1.getValue() == c2.getValue() && c1.getValue() == 1) {
                this.mCanSplit = false;
            }
            if (this.mIsSplitHand && c1.getValue() == 1) {
                if (!Game.ruleResplitAces) {
                    this.mCanSplit = false;
                }
                if (!Game.ruleHitSplitAces) {
                    this.mCanDoubleDown = false;
                    this.mCanHit = false;
                }
            }
            if (Game.ruleSurrender > 0 && !this.mIsSplitHand && this.mCards.size() == 2) {
                this.mCanSurrender = true;
            }
            if (Game.debug_SplitAnyCards) {
                this.mCanSplit = true;
            }
        }
    }

    public void doubleDown() {
        if (!this.mHasDoubledDown) {
            this.mBet.multiplyByTwo();
            this.mHasDoubledDown = true;
            this.calculateStats();
        }
    }

    public void takeInsurance() {
        if (this.mInsuranceBet.isZero()) {
            this.mInsuranceBet.set(this.mBet);
            this.mInsuranceBet.divideByTwo();
            this.calculateStats();
        }
    }

    public void surrender() {
        if (this.mCanSurrender) {
            this.mBet.divideByTwo();
            this.mHasSurrendered = true;
            this.calculateStats();
        }
    }

    public boolean hasBlackjack() {
        return this.mHasBlackjack;
    }

    public boolean isSplitHand() {
        return this.mIsSplitHand;
    }

    public boolean canDoubleDown() {
        return this.mCanDoubleDown;
    }

    public boolean canSplit() {
        return this.mCanSplit;
    }

    public boolean canSurrender() {
        return this.mCanSurrender;
    }

    public int getTotal() {
        return this.mTotal;
    }

    public int getLowestTotal() {
        return this.mLowTotal;
    }

    public boolean isSoft() {
        return this.mTotalIsSoft;
    }

    public boolean hasBust() {
        return this.mTotal > 21;
    }

    public boolean hasDoubledDown() {
        return this.mHasDoubledDown;
    }

    public boolean hasTakenInsurance() {
        return this.mInsuranceBet.isGreaterThanZero();
    }

    public boolean hasSurrendered() {
        return this.mHasSurrendered;
    }

    public boolean canHit() {
        return this.mCanHit;
    }

    public boolean hasTakenEvenMoney() {
        return this.mHasTakenEvenMoney;
    }

    public String toString() {
        String s = "";
        for (int d = 0; d < this.mCards.size(); ++d) {
            Card crd = (Card)this.mCards.elementAt(d);
            s = s + crd.toString() + " ";
        }
        return s;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(this.mTotal);
            os.writeInt(this.mNumAces);
            os.writeBoolean(this.mTotalIsSoft);
            os.writeBoolean(this.mHasBlackjack);
            os.writeBoolean(this.mIsSplitHand);
            os.writeBoolean(this.mCanDoubleDown);
            os.writeBoolean(this.mCanSplit);
            os.writeBoolean(this.mCanHit);
            os.writeBoolean(this.mHasDoubledDown);
            os.writeBoolean(this.mCanSurrender);
            os.writeBoolean(this.mHasSurrendered);
            os.writeBoolean(this.mHasTakenEvenMoney);
            byte[] data = this.mBet.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            data = this.mInsuranceBet.toByteArray();
            os.writeInt(data.length);
            os.write(data);
            int ncards = this.mCards.size();
            os.writeInt(ncards);
            for (int i = 0; i < ncards; ++i) {
                Card c = (Card)this.mCards.elementAt(i);
                data = c.toByteArray();
                os.writeInt(data.length);
                os.write(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            this.mTotal = is.readInt();
            this.mNumAces = is.readInt();
            this.mTotalIsSoft = is.readBoolean();
            this.mHasBlackjack = is.readBoolean();
            this.mIsSplitHand = is.readBoolean();
            this.mCanDoubleDown = is.readBoolean();
            this.mCanSplit = is.readBoolean();
            this.mCanHit = is.readBoolean();
            this.mHasDoubledDown = is.readBoolean();
            this.mCanSurrender = is.readBoolean();
            this.mHasSurrendered = is.readBoolean();
            this.mHasTakenEvenMoney = is.readBoolean();
            int datalen = is.readInt();
            byte[] buffer = new byte[datalen];
            is.read(buffer);
            this.mBet = new Bet(buffer);
            datalen = is.readInt();
            buffer = new byte[datalen];
            is.read(buffer);
            this.mInsuranceBet = new Bet(buffer);
            this.mCards = new Vector();
            int ncards = is.readInt();
            for (int i = 0; i < ncards; ++i) {
                datalen = is.readInt();
                buffer = new byte[datalen];
                is.read(buffer);
                Card c = new Card(buffer);
                this.mCards.addElement(c);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

