/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack.game;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class Card {
    public static final int ACE = 1;
    public static final int TWO = 2;
    public static final int THREE = 3;
    public static final int FOUR = 4;
    public static final int FIVE = 5;
    public static final int SIX = 6;
    public static final int SEVEN = 7;
    public static final int EIGHT = 8;
    public static final int NINE = 9;
    public static final int TEN = 10;
    public static final int JACK = 11;
    public static final int QUEEN = 12;
    public static final int KING = 13;
    private static final String[] ranks = new String[]{"A", "2", "3", "4", "5", "6", "7", "8", "9", "T", "J", "Q", "K"};
    private static final String[] suits = new String[]{"C", "D", "S", "H"};
    private int suit = 32;
    private int value = 1;

    public Card(int v, int s) {
        this.suit = s;
        this.value = v;
    }

    public Card(byte[] data) {
        this.fromByteArray(data);
    }

    public int getCardNumber() {
        return this.value;
    }

    public int getRank() {
        return this.value - 1;
    }

    public int getValue() {
        if (this.value >= 10) {
            return 10;
        }
        return this.value;
    }

    public int getSuit() {
        return this.suit;
    }

    public int getSuitIndex() {
        switch (this.suit) {
            case 32: {
                return 0;
            }
            case 64: {
                return 1;
            }
            case 128: {
                return 2;
            }
            case 256: {
                return 3;
            }
        }
        return 0;
    }

    public String toString() {
        return ranks[this.value - 1] + suits[this.getSuitIndex()];
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(this.suit);
            os.writeInt(this.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            this.suit = is.readInt();
            this.value = is.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

