/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.casinopack.blackjack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class AnimatedObject {
    public static final int ANIM_PLAYER_CARD_1 = 0;
    public static final int ANIM_PLAYER_CARD_2 = 1;
    public static final int ANIM_DEALER_CARD_1 = 2;
    public static final int ANIM_DEALER_CARD_2 = 3;
    public static final int ANIM_PLAYER_CARD = 4;
    public static final int ANIM_DEALER_CARD = 5;
    public static final int ANIM_TURN_DEALER_CARD = 6;
    public static final int ANIM_PEEK_DEALER_CARD = 7;
    public static final int ANIM_SHOW_BET_CHIP = 8;
    public static final int ANIM_HIDE_BET_CHIP = 9;
    public static final int ANIM_BET_CHIP = 10;
    public static final int ANIM_REMOVE_PLAYER_CARD = 11;
    public static final int ANIM_REMOVE_DEALER_CARD = 12;
    public static final int ANIM_SPLIT_CARDS = 13;
    public static final int ANIM_DEAL_SPLIT_CARD_2 = 14;
    public static final int ANIM_MOVE_HAND = 15;
    public static final int ANIM_PAUSE_SPLIT = 16;
    public static final int ANIM_SHOW_PLACE_BETS = 17;
    public static final int ANIM_HIDE_PLACE_BETS = 18;
    public static final String[] ANIM_STATES = new String[]{"anim_player_card_1", "anim_player_card_2", "anim_dealer_card_1", "anim_dealer_card_2", "anim_player_card", "anim_dealer_card", "anim_turn_dealer_card", "anim_peek_dealer_card", "anim_show_bet_chip", "anim_hide_bet_chip", "anim_bet_chip", "anim_remove_player_card", "anim_remove_dealer_card", "anim_split_cards", "anim_deal_split_card_2", "anim_move_hand", "anim_pause_split", "anim_show_place_bets", "anim_hide_place_bets"};
    public int id = 0;
    public int token = 0;
    public int token2 = 0;
    public int x = 0;
    public int y = 0;
    private long mxv = 0L;
    private long myv = 0L;
    private long mx = 0L;
    private long my = 0L;
    private int mx1 = 0;
    private int my1 = 0;
    private int mx2 = 0;
    private int my2 = 0;
    private int mFrameCount = 0;
    private long mStartTime = 0L;

    public AnimatedObject(int id, int token, int startX, int startY, int endX, int endY, int frames, long delay) {
        this._create(id, token, 0, startX, startY, endX, endY, frames, delay);
    }

    public AnimatedObject(int id, int token, int token2, int startX, int startY, int endX, int endY, int frames, long delay) {
        this._create(id, token, token2, startX, startY, endX, endY, frames, delay);
    }

    public AnimatedObject(int id, int frames, long delay) {
        this._create(id, 0, 0, 0, 0, 0, 0, frames, delay);
    }

    public AnimatedObject(byte[] data) {
        this.fromByteArray(data);
    }

    private void _create(int id, int token, int token2, int startX, int startY, int endX, int endY, int frames, long delay) {
        this.id = id;
        this.token = token;
        this.token2 = token2;
        this.x = startX;
        this.y = startY;
        this.mx1 = startX;
        this.my1 = startY;
        this.mx2 = endX;
        this.my2 = endY;
        this.mFrameCount = frames;
        this.mxv = (endX - startX) * 10000 / this.mFrameCount;
        this.myv = (endY - startY) * 10000 / this.mFrameCount;
        this.mx = this.x * 10000;
        this.my = this.y * 10000;
        this.mStartTime = delay + System.currentTimeMillis();
    }

    public boolean animate() {
        if (this.mStartTime <= System.currentTimeMillis()) {
            if (this.mFrameCount == 0) {
                return false;
            }
            this.mx += this.mxv;
            this.my += this.myv;
            this.x = (int)(this.mx / 10000L);
            this.y = (int)(this.my / 10000L);
            --this.mFrameCount;
        }
        return true;
    }

    public String toString() {
        return "Object #" + this.id + " " + ANIM_STATES[this.id] + " (" + this.token + "): " + this.mx1 + "," + this.my1 + " -> " + this.mx2 + "," + this.my2;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(this.id);
            os.writeInt(this.token);
            os.writeInt(this.token2);
            os.writeInt(this.x);
            os.writeInt(this.y);
            os.writeInt(this.mx1);
            os.writeInt(this.my1);
            os.writeInt(this.mx2);
            os.writeInt(this.my2);
            os.writeInt(this.mFrameCount);
            os.writeLong(this.mStartTime);
            os.writeLong(System.currentTimeMillis());
            os.writeLong(this.mxv);
            os.writeLong(this.myv);
            os.writeLong(this.mx);
            os.writeLong(this.my);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void fromByteArray(byte[] data) {
        if (data == null) {
            return;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
        try {
            this.id = is.readInt();
            this.token = is.readInt();
            this.token2 = is.readInt();
            this.x = is.readInt();
            this.y = is.readInt();
            this.mx1 = is.readInt();
            this.my1 = is.readInt();
            this.mx2 = is.readInt();
            this.my2 = is.readInt();
            this.mFrameCount = is.readInt();
            this.mStartTime = is.readLong();
            this.mStartTime += System.currentTimeMillis() - is.readLong();
            this.mxv = is.readLong();
            this.myv = is.readLong();
            this.mx = is.readLong();
            this.my = is.readLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

