/*
 * Decompiled with CFR 0.152.
 */
package main;

import conf.Constants;
import java.io.DataInputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import main.GameScene;
import main.Midlet;
import main.RSManager;
import screens.AboutScreen;
import screens.GameOverScreen;
import screens.Menu;
import screens.MenuScreen;
import screens.SplashScreen;
import screens.TutorialScreen;
import sprites.Avatar;
import utils.FontUtil;
import utils.Utils;

public class MainCanvas
extends GameCanvas
implements Runnable,
CommandListener {
    private Midlet iParentMidlet;
    public static boolean isTouch = false;
    public static boolean isEastern = false;
    public static final int GAME_SPLASH = 0;
    public static final int GAME_LOGO = 1;
    public static final int GAME_UI = 2;
    public static final int GAME_TUTORIAL = 3;
    public static final int GAME_ABOUT = 4;
    public static final int GAME_GAMING = 5;
    public static final int GAME_READY = 6;
    public static final int GAME_GO = 7;
    public static final int GAME_BUTTON = 8;
    public static final int GAME_END = 9;
    public static final int GAME_STATE_NUM = 10;
    private static int nState = 0;
    private static SplashScreen splash;
    private static MenuScreen screen;
    private static AboutScreen aboutScreen;
    private static TutorialScreen tutorialScreen;
    private static GameOverScreen gameOverScreen;
    private boolean running;
    private static LayerManager layerManager;
    private static Avatar avatar;
    public static GameScene scene;
    public static FontUtil letters;
    public static FontUtil numbers;
    private static Image gameBackground;
    private static Image gameReady;
    private static Image gameGo;
    private static Image coinScore;
    private static Image paused;
    private Menu continueButton;
    private Sprite pauseButton;
    private Sprite leftButton;
    private Sprite rightButton;
    private boolean isLeftTouched;
    private boolean isRightTouched;
    public static boolean isGamePaused;
    public static int width;
    public static int height;
    public static boolean isScreenAdjusting;
    public static int languageSelected;
    public static int soundSelected;
    public static int selectedAvatar;
    public static int selectedLevel;
    public static int level;
    public static int heightScore;
    public static int highScore;
    public static int gameBgMove;
    public static int gameBgY;
    public static boolean isNewHighscore;
    public static String[] iTextArray;

    public MainCanvas(Midlet parent) {
        super(true);
        String eastern;
        this.setFullScreenMode(true);
        width = this.getWidth();
        height = this.getHeight();
        this.iParentMidlet = parent;
        String touch = this.iParentMidlet.getAppProperty("Touch");
        if (touch != null) {
            boolean bl = isTouch = touch.toLowerCase().equals("true");
        }
        if ((eastern = this.iParentMidlet.getAppProperty("Eastern")) != null) {
            isEastern = eastern.toLowerCase().equals("true");
        }
        this.init();
        MainCanvas.setState(0);
        this.start();
        RSManager.addRecord();
        RSManager.getData();
        MainCanvas.loadText();
    }

    private void init() {
        splash = new SplashScreen("/images/splash.png");
        letters = new FontUtil("/images/fonts_big.png", 0, 20, 20);
    }

    private void setViewWindow() {
        layerManager.setViewWindow(0, 0, width, height);
    }

    public static void addSprite(Sprite element) {
        layerManager.append((Layer)element);
    }

    public static void removeSprite(Sprite element) {
        layerManager.remove((Layer)element);
    }

    public void startGame() {
        int avatarHeight = 0;
        try {
            Image avatarImage = Image.createImage((String)Utils.getAvatar(selectedAvatar));
            avatar = new Avatar(selectedAvatar, avatarImage, avatarImage.getWidth() / 8, avatarImage.getHeight());
            avatarHeight = avatarImage.getHeight();
            coinScore = Image.createImage((String)"/images/score_coin.png");
            gameBackground = Image.createImage((String)Utils.getLevel(selectedLevel));
            Image buttons = Image.createImage((String)"/images/sel_btn.png");
            int buttonWidth = buttons.getWidth() / 6;
            this.pauseButton = new Sprite(buttons, buttonWidth, buttons.getHeight());
            this.pauseButton.setFrame(5);
            this.pauseButton.setPosition(5, height - buttons.getHeight());
            this.leftButton = new Sprite(buttons, buttonWidth, buttons.getHeight());
            this.leftButton.setFrame(3);
            this.leftButton.setPosition(0, height / 3 + Utils.getCenterVPosition(buttons.getHeight(), height / 2));
            this.rightButton = new Sprite(buttons, buttonWidth, buttons.getHeight());
            this.rightButton.setFrame(1);
            this.rightButton.setPosition(width - buttonWidth, height / 3 + Utils.getCenterVPosition(buttons.getHeight(), height / 2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        level = 0;
        gameBgMove = (gameBackground.getHeight() - height) / 5;
        gameBgY = -gameBgMove * (5 - level);
        layerManager = new LayerManager();
        layerManager.append((Layer)avatar);
        if (isTouch) {
            layerManager.append((Layer)this.pauseButton);
            layerManager.append((Layer)this.leftButton);
            layerManager.append((Layer)this.rightButton);
        }
        scene = new GameScene();
        scene.init();
        avatar.setPosition(Utils.getCenterPosition(avatar.getWidth(), width), height - avatarHeight - 18);
        avatar.setOnPlatformType(0);
        avatar.setState(1);
        this.setViewWindow();
    }

    public static void setState(int state) {
        nState = state;
        try {
            switch (nState) {
                case 2: {
                    screen = new MenuScreen();
                    screen.setCurrentScreen(2);
                    break;
                }
                case 3: {
                    tutorialScreen = new TutorialScreen();
                    break;
                }
                case 4: {
                    aboutScreen = new AboutScreen();
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 9: {
                    scene.close();
                    gameOverScreen = new GameOverScreen();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pointerPressed(int x, int y) {
        switch (nState) {
            case 5: {
                if (isGamePaused) break;
                if (x >= this.leftButton.getX() && x <= this.leftButton.getX() + this.leftButton.getWidth() && y >= this.leftButton.getY() && y <= this.leftButton.getY() + this.leftButton.getHeight()) {
                    this.isLeftTouched = true;
                    break;
                }
                if (x < this.rightButton.getX() || x > this.rightButton.getX() + this.rightButton.getWidth() || y < this.rightButton.getY() || y > this.rightButton.getY() + this.rightButton.getHeight()) break;
                this.isRightTouched = true;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        try {
            switch (nState) {
                case 2: {
                    this.handleMainMenu(screen.touch(x, y));
                    break;
                }
                case 4: {
                    this.handleAboutScreen();
                    break;
                }
                case 3: {
                    this.handleTutorialScreen();
                    break;
                }
                case 5: {
                    this.isLeftTouched = false;
                    this.isRightTouched = false;
                    if (isGamePaused && this.continueButton.touch(x, y) > -1) {
                        paused = null;
                        this.continueButton = null;
                        isGamePaused = false;
                        break;
                    }
                    if (x < this.pauseButton.getX() || x > this.pauseButton.getX() + this.pauseButton.getWidth() || y < this.pauseButton.getY() || y > this.pauseButton.getY() + this.pauseButton.getHeight()) break;
                    this.handleGamePause();
                    break;
                }
                case 9: {
                    this.handleGameOverScreen(gameOverScreen.touch(x, y));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void keyPressed(int keyCode) {
        this.input(keyCode);
    }

    public void keyRepeated(int keyCode) {
        if (nState == 5) {
            avatar.inputRepeated(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        if (nState == 5) {
            avatar.inputReleased(keyCode);
        }
    }

    public void handleMainMenu(int type) {
        switch (type) {
            case 0: {
                screen.close();
                screen = null;
                this.startGame();
                MainCanvas.setState(3);
                break;
            }
            case 4: {
                MainCanvas.setState(4);
                break;
            }
            case 14: {
                this.iParentMidlet.notifyDestroyed();
            }
        }
    }

    public void handleAboutScreen() {
        aboutScreen.close();
        aboutScreen = null;
        MainCanvas.setState(2);
    }

    public void handleTutorialScreen() {
        tutorialScreen.close();
        tutorialScreen = null;
        MainCanvas.setState(6);
    }

    public void handleGameOverScreen(int type) {
        this.isLeftTouched = false;
        this.isRightTouched = false;
        switch (type) {
            case 0: {
                this.startGame();
                MainCanvas.setState(6);
                break;
            }
            case 13: {
                MainCanvas.setState(2);
            }
        }
    }

    public void handleGamePause() {
        try {
            paused = Image.createImage((String)"/images/popup.png");
            this.continueButton = new Menu();
            this.continueButton.add(Utils.getText(22), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        isGamePaused = true;
    }

    public void input(int keyCode) {
        int keyStates = this.getKeyStates();
        if (keyCode != 0) {
            keyStates = keyCode;
        }
        switch (nState) {
            case 2: {
                this.handleMainMenu(screen.input(keyStates));
                break;
            }
            case 4: {
                if (aboutScreen.input(keyStates) == 0) break;
                this.handleAboutScreen();
                break;
            }
            case 3: {
                if (keyStates == 0) break;
                this.handleTutorialScreen();
                break;
            }
            case 5: {
                if (isGamePaused && (keyStates == -6 || keyStates == 256)) {
                    paused = null;
                    this.continueButton = null;
                    isGamePaused = false;
                    break;
                }
                if (keyStates == -6) {
                    this.handleGamePause();
                    break;
                }
                if (isGamePaused) break;
                if (this.isLeftTouched) {
                    keyStates = 4;
                }
                if (this.isRightTouched) {
                    keyStates = 32;
                }
                avatar.input(keyStates);
                break;
            }
            case 9: {
                this.handleGameOverScreen(gameOverScreen.input(keyStates));
            }
        }
    }

    public void logic() {
        switch (nState) {
            case 5: {
                scene.logic(avatar);
            }
        }
    }

    public void paint() {
        Graphics g = this.getGraphics();
        switch (nState) {
            case 0: 
            case 1: {
                g.setColor(16678955);
                g.fillRect(0, 0, width, height);
                splash.paint(g, width, height);
                break;
            }
            case 2: {
                screen.paint(g, width, height);
                break;
            }
            case 4: {
                aboutScreen.paint(g, width, height);
                break;
            }
            case 3: {
                tutorialScreen.paint(g, width, height);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                g.drawImage(gameBackground, 0, gameBgY, 0);
                layerManager.paint(g, 0, 0);
                int scoreX = width - letters.getStringWidth(avatar.getScore() + "");
                letters.drawString(g, avatar.getScore() + "", scoreX, 3, -1);
                int coinX = width - 5 - coinScore.getWidth() - letters.getStringWidth(avatar.getCoinsCollected() + "");
                g.drawImage(coinScore, coinX, letters.getStringHeight(), 0);
                letters.drawString(g, avatar.getCoinsCollected() + "", coinX + coinScore.getWidth() + 5, letters.getStringHeight(), -1);
                switch (nState) {
                    case 7: {
                        letters.drawString(g, Utils.getText(20), Utils.getCenterPosition(letters.getStringWidth(Utils.getText(20)), width), height / 2, -1);
                        break;
                    }
                    case 6: {
                        letters.drawString(g, Utils.getText(19), Utils.getCenterPosition(letters.getStringWidth(Utils.getText(19)), width), height / 2, -1);
                    }
                }
                if (paused == null) break;
                int yPos = Utils.getCenterVPosition(paused.getHeight(), height);
                g.drawImage(paused, Utils.getCenterPosition(paused.getWidth(), width), yPos, 0);
                letters.drawString(g, Utils.getText(21), Utils.getCenterPosition(0, Utils.getText(21), width), yPos += Utils.getCenterVPosition(letters.getStringHeight(), paused.getHeight() / 2), -1);
                this.continueButton.paint(g, -1, yPos += paused.getHeight() / 2);
                break;
            }
            case 9: {
                gameOverScreen.paint(g, width, height);
            }
        }
        this.flushGraphics();
    }

    private void start() {
        this.running = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stop() {
        this.running = false;
    }

    public void run() {
        long T1;
        long T2 = T1 = System.currentTimeMillis();
        int time = 100;
        block14: while (this.running) {
            try {
                T2 = System.currentTimeMillis();
                if (T2 - T1 > (long)time) {
                    switch (nState) {
                        case 0: {
                            splash.close();
                            splash = new SplashScreen("/images/splash1.png");
                            MainCanvas.setState(1);
                            break;
                        }
                        case 1: {
                            splash.close();
                            splash = null;
                            MainCanvas.setState(2);
                            break;
                        }
                        case 6: {
                            gameReady = null;
                            MainCanvas.setState(7);
                            break;
                        }
                        case 7: {
                            gameGo = null;
                            MainCanvas.setState(5);
                            break;
                        }
                    }
                    T1 = T2;
                    this.input(0);
                    this.logic();
                    this.paint();
                    continue;
                }
                switch (nState) {
                    case 0: 
                    case 1: {
                        this.input(0);
                        this.logic();
                        this.paint();
                        time = 2000;
                        continue block14;
                    }
                    case 6: 
                    case 7: {
                        Thread.sleep(1000L);
                        continue block14;
                    }
                    case 2: {
                        time = 300;
                        continue block14;
                    }
                    case 5: {
                        time = 50;
                        continue block14;
                    }
                }
                time = 100;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void commandAction(Command cmnd, Displayable dsplbl) {
    }

    public static void loadText() {
        if (iTextArray != null) {
            iTextArray = null;
        }
        iTextArray = new String[45];
        try {
            String language;
            switch (languageSelected) {
                case 0: {
                    language = isEastern ? Constants.languageEN : Constants.languageDE;
                    break;
                }
                default: {
                    language = isEastern ? Constants.languageRU : Constants.languageEN;
                    break;
                }
                case 2: {
                    language = isEastern ? Constants.languagePL : Constants.languageFR;
                    break;
                }
                case 3: {
                    language = isEastern ? Constants.languageCH : Constants.languageES;
                }
            }
            DataInputStream iInputStream = new DataInputStream("".getClass().getResourceAsStream(language));
            for (int i = 0; i < iTextArray.length; ++i) {
                MainCanvas.iTextArray[i] = iInputStream.readUTF();
            }
            iInputStream.close();
            Object var1_2 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Avatar getAvatar() {
        return avatar;
    }

    static {
        languageSelected = 0;
        soundSelected = 0;
        selectedAvatar = 0;
        selectedLevel = 0;
        level = 0;
        heightScore = 0;
        highScore = 0;
        gameBgMove = 0;
        gameBgY = 0;
        isNewHighscore = false;
    }
}

