/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import main.MainCanvas;
import main.RSManager;
import sprites.Avatar;
import sprites.Booster;
import sprites.Coin;
import sprites.Enemy;
import sprites.Obstacle;
import sprites.Platform;
import utils.Utils;

public class GameScene {
    private Random rand = new Random();
    private Vector obstacles;
    private Vector iObstacles;
    private Vector enemies;
    private Vector iEnemies;
    private Vector coins;
    private Vector iCoins;
    private Vector boosters;
    private Vector iBoosters;
    private Vector platforms;
    private Vector iPlatforms;
    private Image permanentPlat;
    private Image breakingPlat;
    private Image movingPlat;
    private Image coin;
    private Image rocket;
    private Image spring;
    private Platform lastPlatformHit;
    private boolean samePlatform = true;
    private boolean shiftDown;
    private int platformId;
    private long boosterTime;
    private boolean isRocketActive;
    private boolean isSpringActive;
    private int enemyObstacleCount = 0;
    private int boosterCount = 0;

    public void init() {
        this.platformId = 0;
        this.platforms = new Vector();
        this.iPlatforms = new Vector();
        this.coins = new Vector();
        this.iCoins = new Vector();
        this.boosters = new Vector();
        this.iBoosters = new Vector();
        this.obstacles = new Vector();
        this.iObstacles = new Vector();
        this.enemies = new Vector();
        this.iEnemies = new Vector();
        try {
            this.permanentPlat = Image.createImage((String)"/images/p1.png");
            this.breakingPlat = Image.createImage((String)"/images/p2.png");
            this.movingPlat = Image.createImage((String)"/images/p3.png");
            this.coin = Image.createImage((String)"/images/coin.png");
            this.rocket = Image.createImage((String)"/images/b_rocket.png");
            this.spring = Image.createImage((String)"/images/b_spring.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initializePlatforms();
    }

    public void initializePlatforms() {
        int yp = MainCanvas.height - this.permanentPlat.getHeight();
        int xp = Utils.getCenterPosition(this.permanentPlat.getWidth(), MainCanvas.width);
        this.createPlatform(0, xp, yp, false, false);
        int platformCount = MainCanvas.height / (this.permanentPlat.getHeight() * 2);
        for (int i = 0; i < platformCount; ++i) {
            this.createPlatform(0, xp, yp -= this.permanentPlat.getHeight() << 1, (xp = this.rand.nextInt(MainCanvas.width - this.permanentPlat.getWidth())) % 2 == 0, false);
        }
    }

    public void createPlatform(int type, int xp, int yp, boolean withCoin, boolean withBooster) {
        int coinAppear;
        Platform platform;
        Image platformImage = this.permanentPlat;
        int platformWidth = this.permanentPlat.getWidth();
        int platformHeight = this.permanentPlat.getHeight();
        switch (type) {
            case 2: {
                platformImage = this.breakingPlat;
                platformWidth = this.breakingPlat.getWidth();
                platformHeight = this.breakingPlat.getHeight();
                break;
            }
            case 1: {
                platformImage = this.movingPlat;
                platformWidth = this.movingPlat.getWidth();
                platformHeight = this.movingPlat.getHeight();
            }
        }
        if (this.iPlatforms.size() > 0) {
            platform = (Platform)((Object)this.iPlatforms.elementAt(0));
            platform.setType(type);
            platform.setImage(platformImage, platformWidth, platformHeight);
            this.iPlatforms.removeElementAt(0);
        } else {
            if (this.platforms.size() > 20) {
                return;
            }
            platform = new Platform(platformImage, platformWidth, platformHeight, type);
        }
        platform.setPosition(xp, yp);
        platform.setId(this.platformId);
        this.platforms.addElement(platform);
        MainCanvas.addSprite(platform);
        if (withCoin && (coinAppear = this.rand.nextInt(20)) % 2 == 0) {
            Coin gold = new Coin(this.coin, this.coin.getWidth(), this.coin.getHeight());
            if (this.iCoins.size() > 0) {
                this.iCoins.removeElementAt(0);
            }
            gold.setPlatformIndex(this.platforms.indexOf((Object)platform));
            gold.setPosition(Utils.getCenterPosition(this.coin.getWidth(), platformWidth) + xp, yp - this.coin.getHeight());
            this.coins.addElement(gold);
            MainCanvas.addSprite(gold);
        }
        if (withBooster && this.boosterCount < 2) {
            Booster booster;
            Image boosterImage;
            int boosterType = this.rand.nextInt(2);
            switch (boosterType) {
                case 0: {
                    boosterImage = this.rocket;
                    break;
                }
                default: {
                    boosterImage = this.spring;
                }
            }
            if (this.iBoosters.size() > 0) {
                booster = (Booster)((Object)this.iBoosters.elementAt(0));
                booster.setImage(boosterImage, boosterImage.getWidth(), boosterImage.getHeight());
                this.iBoosters.removeElementAt(0);
            } else {
                booster = new Booster(boosterImage, boosterImage.getWidth(), boosterImage.getHeight());
            }
            booster.setPlatformIndex(this.platformId);
            booster.setType(boosterType);
            booster.setPosition(Utils.getCenterPosition(boosterImage.getWidth(), platformWidth) + xp, yp - boosterImage.getHeight());
            this.boosters.addElement(booster);
            MainCanvas.addSprite(booster);
            ++this.boosterCount;
        }
        ++this.platformId;
    }

    public void createObstacles(int x, int y) {
        if (this.enemyObstacleCount >= 2) {
            return;
        }
        try {
            Obstacle obstacle;
            Image obstacleImage;
            Image block = Image.createImage((String)"/images/o1.png");
            Image orb = Image.createImage((String)"/images/o3.png");
            Image spike = Image.createImage((String)"/images/o2.png");
            int type = this.rand.nextInt(3);
            switch (type) {
                case 1: {
                    obstacleImage = block;
                    break;
                }
                case 2: {
                    obstacleImage = orb;
                    break;
                }
                default: {
                    obstacleImage = spike;
                }
            }
            if (this.iObstacles.size() > 0) {
                obstacle = (Obstacle)((Object)this.iObstacles.elementAt(0));
                obstacle.setImage(obstacleImage, obstacleImage.getWidth(), obstacleImage.getHeight());
                this.iObstacles.removeElementAt(0);
            } else {
                obstacle = new Obstacle(obstacleImage, obstacleImage.getWidth(), obstacleImage.getHeight());
            }
            int obstacleX = x + Utils.getCenterPosition(obstacleImage.getWidth(), this.permanentPlat.getWidth());
            int obstacleY = y - obstacleImage.getHeight();
            obstacle.setPosition(obstacleX, obstacleY);
            this.obstacles.addElement(obstacle);
            MainCanvas.addSprite(obstacle);
            ++this.enemyObstacleCount;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createEnemies(int x, int y) {
        if (this.enemyObstacleCount >= 2) {
            return;
        }
        try {
            Enemy enemy;
            Image enemyImage;
            Image sheep = Image.createImage((String)"/images/e_sheep.png");
            Image spider = Image.createImage((String)"/images/e_spider.png");
            Image squirrel = Image.createImage((String)"/images/e_squirrel.png");
            int type = this.rand.nextInt(3);
            switch (type) {
                case 1: {
                    enemyImage = sheep;
                    break;
                }
                case 2: {
                    enemyImage = spider;
                    break;
                }
                default: {
                    enemyImage = squirrel;
                }
            }
            int enemyWidth = enemyImage.getWidth() / 6;
            if (this.iEnemies.size() > 0) {
                enemy = (Enemy)((Object)this.iEnemies.elementAt(0));
                enemy.setImage(enemyImage, enemyWidth, enemyImage.getHeight());
                this.iEnemies.removeElementAt(0);
            } else {
                enemy = new Enemy(enemyImage, enemyWidth, enemyImage.getHeight());
            }
            enemy.setFrame(0);
            int enemyX = x + Utils.getCenterPosition(enemyImage.getWidth(), this.permanentPlat.getWidth());
            int enemyY = y - enemyImage.getHeight();
            enemy.setPosition(enemyX, enemyY);
            this.enemies.addElement(enemy);
            MainCanvas.addSprite(enemy);
            ++this.enemyObstacleCount;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveScene(Avatar avatar) {
        try {
            int n;
            if (this.platforms.size() < 15 - MainCanvas.level) {
                this.generateLiveRandomPlatform();
            }
            for (n = 0; n < this.platforms.size(); ++n) {
                Platform currentPlatform = (Platform)((Object)this.platforms.elementAt(n));
                if (currentPlatform.getType() == 1) {
                    currentPlatform.moveHorizontally();
                    if (this.platforms.contains((Object)currentPlatform)) {
                        this.platforms.setElementAt(currentPlatform, n);
                    }
                }
                if (this.shiftDown && avatar.getVelocity() < 0) {
                    currentPlatform.move(0, -avatar.getVelocity());
                    this.platforms.setElementAt(currentPlatform, n);
                }
                if (currentPlatform.getY() <= MainCanvas.height) continue;
                this.iPlatforms.addElement(this.platforms.elementAt(n));
                this.platforms.removeElementAt(n);
                MainCanvas.removeSprite(currentPlatform);
                this.generateLiveRandomPlatform();
            }
            for (n = 0; n < this.coins.size(); ++n) {
                Coin currentCoin = (Coin)((Object)this.coins.elementAt(n));
                currentCoin.animate();
                if (this.shiftDown && avatar.getVelocity() < 0) {
                    currentCoin.move(0, -avatar.getVelocity());
                    this.coins.setElementAt(currentCoin, n);
                }
                if ((currentCoin.getY() <= 36 || currentCoin.isVisible()) && currentCoin.getY() <= MainCanvas.height) continue;
                this.iCoins.addElement(this.coins.elementAt(n));
                this.coins.removeElementAt(n);
                MainCanvas.removeSprite(currentCoin);
            }
            for (n = 0; n < this.boosters.size(); ++n) {
                Booster currentBooster = (Booster)((Object)this.boosters.elementAt(n));
                if (this.shiftDown && avatar.getVelocity() < 0) {
                    currentBooster.move(0, -avatar.getVelocity());
                    this.boosters.setElementAt(currentBooster, n);
                }
                if ((currentBooster.getY() <= 36 || currentBooster.isVisible()) && currentBooster.getY() <= MainCanvas.height) continue;
                this.iBoosters.addElement(this.boosters.elementAt(n));
                this.boosters.removeElementAt(n);
                MainCanvas.removeSprite(currentBooster);
                --this.boosterCount;
            }
            for (n = 0; n < this.obstacles.size(); ++n) {
                Obstacle currentObstacle = (Obstacle)((Object)this.obstacles.elementAt(n));
                if (this.shiftDown && avatar.getVelocity() < 0) {
                    currentObstacle.move(0, -avatar.getVelocity());
                    this.obstacles.setElementAt(currentObstacle, n);
                }
                if ((currentObstacle.getY() <= 36 || currentObstacle.isVisible()) && currentObstacle.getY() <= MainCanvas.height) continue;
                this.iObstacles.addElement(this.obstacles.elementAt(n));
                this.obstacles.removeElementAt(n);
                MainCanvas.removeSprite(currentObstacle);
                --this.enemyObstacleCount;
            }
            for (n = 0; n < this.enemies.size(); ++n) {
                Enemy currentEnemy = (Enemy)((Object)this.enemies.elementAt(n));
                if (this.shiftDown && avatar.getVelocity() < 0) {
                    currentEnemy.move(0, -avatar.getVelocity());
                    this.enemies.setElementAt(currentEnemy, n);
                }
                if ((currentEnemy.getY() <= 36 || currentEnemy.isVisible()) && currentEnemy.getY() <= MainCanvas.height) continue;
                this.iEnemies.addElement(this.enemies.elementAt(n));
                this.enemies.removeElementAt(n);
                MainCanvas.removeSprite(currentEnemy);
                --this.enemyObstacleCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logic(Avatar avatar) {
        if (!MainCanvas.isGamePaused) {
            try {
                this.shiftDown = false;
                if (this.isRocketActive || this.isSpringActive || avatar.getY() < MainCanvas.height / 2 - avatar.getHeight() / 2) {
                    this.shiftDown = true;
                }
                if (this.isRocketActive || this.isSpringActive) {
                    this.samePlatform = false;
                }
                this.moveScene(avatar);
                if (this.shiftDown && !this.isRocketActive && !this.isSpringActive) {
                    avatar.increaseVelocity();
                    if (avatar.getVelocity() >= 0) {
                        avatar.logic(MainCanvas.width);
                        avatar.increaseVelocity();
                    } else {
                        avatar.moveHorizontally(avatar.nSpeedX, avatar.getRefPixelY(), MainCanvas.width, 0);
                    }
                } else {
                    avatar.logic(MainCanvas.width);
                }
                this.checkPlatformLanded(avatar);
                this.checkCoinGet(avatar);
                if (!this.isRocketActive) {
                    this.checkEnemyHit(avatar);
                    this.checkObstacleHit(avatar);
                    this.checkBooster(avatar);
                    this.checkGameOver(avatar);
                } else if (this.isRocketActive) {
                    if (System.currentTimeMillis() - this.boosterTime > 3000L) {
                        this.isRocketActive = false;
                        avatar.setVelocity(-3);
                        avatar.setState(2);
                        this.boosterTime = -1L;
                    } else {
                        avatar.setScore(avatar.getVelocity());
                    }
                }
                if (this.isSpringActive) {
                    if (System.currentTimeMillis() - this.boosterTime > 500L) {
                        this.isSpringActive = false;
                        avatar.setVelocity(-3);
                        avatar.setState(2);
                        this.boosterTime = -1L;
                    } else {
                        avatar.setScore(avatar.getVelocity());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkGameOver(Avatar avatar) {
        if (avatar.getY() + avatar.getHeight() > MainCanvas.height) {
            if (avatar.getTotalScore() > MainCanvas.highScore) {
                MainCanvas.highScore = avatar.getTotalScore();
                MainCanvas.heightScore = avatar.getScore();
                MainCanvas.isNewHighscore = true;
                RSManager.setHighScore(MainCanvas.highScore, MainCanvas.heightScore);
            } else {
                MainCanvas.isNewHighscore = false;
            }
            MainCanvas.setState(9);
        }
    }

    private void checkEnemyHit(Avatar avatar) {
        for (int n = 0; n < this.enemies.size(); ++n) {
            Enemy currentEnemy = (Enemy)((Object)this.enemies.elementAt(n));
            if (!avatar.collidesWith(currentEnemy, false)) continue;
            int x1 = currentEnemy.getX();
            int x2 = currentEnemy.getX() + currentEnemy.getWidth();
            int y1 = currentEnemy.getY();
            int y2 = currentEnemy.getY() + currentEnemy.getHeight();
            if (avatar.getRefPixelX() >= x1 && avatar.getRefPixelX() <= x2 && avatar.getRefPixelY() >= y1 && avatar.getRefPixelY() <= y2) continue;
            avatar.setState(3);
        }
    }

    private void checkObstacleHit(Avatar avatar) {
        for (int n = 0; n < this.obstacles.size(); ++n) {
            Obstacle currentObstacle = (Obstacle)((Object)this.obstacles.elementAt(n));
            if (!avatar.collidesWith(currentObstacle, false)) continue;
            int x1 = currentObstacle.getX();
            int x2 = currentObstacle.getX() + currentObstacle.getWidth();
            int y1 = currentObstacle.getY();
            int y2 = currentObstacle.getY() + currentObstacle.getHeight();
            if (avatar.getRefPixelX() >= x1 && avatar.getRefPixelX() <= x2 && avatar.getRefPixelY() >= y1 && avatar.getRefPixelY() <= y2) continue;
            avatar.setState(3);
        }
    }

    private void checkBooster(Avatar avatar) {
        if (this.isRocketActive || this.isSpringActive) {
            return;
        }
        for (int n = 0; n < this.boosters.size(); ++n) {
            Booster currentBooster = (Booster)((Object)this.boosters.elementAt(n));
            if (!avatar.collidesWith(currentBooster, false)) continue;
            switch (currentBooster.getType()) {
                case 0: {
                    avatar.setState(5);
                    this.boosterTime = System.currentTimeMillis();
                    this.isRocketActive = true;
                    break;
                }
                case 1: {
                    avatar.setState(6);
                    this.boosterTime = System.currentTimeMillis();
                    this.isSpringActive = true;
                }
            }
            currentBooster.setVisible(false);
            this.iBoosters.addElement(currentBooster);
            this.boosters.removeElementAt(n);
            MainCanvas.removeSprite(currentBooster);
            --this.boosterCount;
        }
    }

    private void checkCoinGet(Avatar avatar) {
        for (int n = 0; n < this.coins.size(); ++n) {
            Coin currentCoin = (Coin)((Object)this.coins.elementAt(n));
            if (!avatar.collidesWith(currentCoin, false) || !currentCoin.isAvailable()) continue;
            currentCoin.shine();
            avatar.setCoinsCollected(1);
        }
    }

    private void checkPlatformLanded(Avatar avatar) {
        int avatarWidth = avatar.getWidth();
        int avatarX = avatar.getX();
        int avatarYLowerBound = avatar.getY() + avatar.getHeight();
        if (avatar.getState() == 2 || avatar.getState() == 4) {
            for (int n = 0; n < this.platforms.size(); ++n) {
                Platform plat = (Platform)((Object)this.platforms.elementAt(n));
                if (!plat.isVisible() || plat.getY() < 0 || plat.getY() > MainCanvas.height) continue;
                int platformX = plat.getX();
                int platformWidth = plat.getWidth();
                int avatarLeftBound = avatarX;
                int avatarRightBound = avatarX + avatarWidth;
                avatarRightBound = avatarX + (avatarWidth >> 2 << 1);
                boolean collided = false;
                boolean withinXBounds = avatarRightBound > platformX && (avatarLeftBound += avatarWidth >> 2) < platformX + platformWidth;
                int distanceToPlatform = plat.getY() - avatarYLowerBound;
                if (withinXBounds && (avatarYLowerBound <= plat.getY() && distanceToPlatform < 5 && distanceToPlatform > -5 || avatarYLowerBound > plat.getY() && avatarYLowerBound < plat.getY() + plat.getHeight())) {
                    collided = true;
                }
                if (!collided && (!avatar.collidesWith(plat, true) || !withinXBounds || distanceToPlatform >= 5 || distanceToPlatform <= -5)) continue;
                avatar.setOnPlatformType(plat.getType());
                avatar.setOnPlatform(plat.getId());
                switch (plat.getType()) {
                    case 2: {
                        this.iPlatforms.addElement(plat);
                        this.platforms.removeElement((Object)plat);
                        MainCanvas.removeSprite(plat);
                        avatar.setState(2);
                        break;
                    }
                    default: {
                        avatarYLowerBound = plat.getY() - 1;
                        avatar.setState(1);
                    }
                }
                if (this.lastPlatformHit != null && this.lastPlatformHit.getId() != plat.getId() && avatar.getY() < this.lastPlatformHit.getY()) {
                    avatar.setScore(this.lastPlatformHit.getY() - plat.getY());
                    this.samePlatform = false;
                } else {
                    this.samePlatform = true;
                }
                this.lastPlatformHit = plat;
            }
        }
    }

    public void generateLiveRandomPlatform() {
        int xp;
        int type = 1;
        int score = MainCanvas.getAvatar().getScore();
        if (MainCanvas.level != 5 && score >= 5000) {
            MainCanvas.level = 5;
            MainCanvas.gameBgY = -MainCanvas.gameBgMove * (5 - MainCanvas.level);
        } else if (MainCanvas.level != 4 && score > 4000 && score <= 5000) {
            MainCanvas.level = 4;
            MainCanvas.gameBgY = -MainCanvas.gameBgMove * (5 - MainCanvas.level);
        } else if (MainCanvas.level != 3 && score > 3000 && score <= 4000) {
            MainCanvas.level = 3;
            MainCanvas.gameBgY = -MainCanvas.gameBgMove * (5 - MainCanvas.level);
        } else if (MainCanvas.level != 2 && score > 2000 && score <= 3000) {
            MainCanvas.level = 2;
            MainCanvas.gameBgY = -MainCanvas.gameBgMove * (5 - MainCanvas.level);
        } else if (MainCanvas.level != 1 && score > 1000 && score <= 2000) {
            MainCanvas.level = 1;
            MainCanvas.gameBgY = -MainCanvas.gameBgMove * (5 - MainCanvas.level);
        } else if (score <= 1000) {
            MainCanvas.level = 0;
        }
        type = this.rand.nextInt(107) + 1;
        if (MainCanvas.level == 0) {
            type = 1;
        }
        boolean hasCoin = (xp = this.rand.nextInt(MainCanvas.width - this.permanentPlat.getWidth())) % 2 == 0;
        int gap = this.permanentPlat.getHeight() << 1;
        int size = this.platforms.size();
        int yp = MainCanvas.height;
        if (this.platforms.size() > 0) {
            yp = ((Platform)((Object)this.platforms.lastElement())).getY();
        }
        yp -= gap;
        if (type > 0 && type <= 50) {
            if (MainCanvas.level == 2) {
                type = this.rand.nextInt(99) + 1;
            } else if (MainCanvas.level == 3) {
                type = this.rand.nextInt(70) + 30;
            } else if (MainCanvas.level == 4) {
                type = this.rand.nextInt(63) + 45;
            } else if (MainCanvas.level == 5) {
                type = this.rand.nextInt(63) + 45;
            }
            this.createPlatform(0, xp, yp, hasCoin, false);
            xp = this.rand.nextInt(MainCanvas.width - this.permanentPlat.getWidth());
            yp -= gap;
        }
        if (type > 50 && type <= 60) {
            this.createPlatform(1, xp, yp, false, false);
        }
        if (type > 60 && type <= 70) {
            size = this.platforms.size();
            if (size > 0 && ((Platform)((Object)this.platforms.lastElement())).getType() == 2) {
                this.createPlatform(0, xp, yp, hasCoin, false);
            } else {
                this.createPlatform(2, xp, yp, false, false);
            }
        }
        if (type > 70 && type <= 80) {
            this.createPlatform(0, xp, yp, true, false);
        }
        if (type > 80 && type <= 90) {
            this.createPlatform(0, xp, yp, false, true);
        }
        if (type > 90 && type <= 100) {
            if (MainCanvas.level >= 2 && this.obstacles.size() < 1) {
                this.createObstacles(xp, yp);
                hasCoin = false;
            }
            this.createPlatform(0, xp, yp, hasCoin, false);
        }
        if (type > 100 && type <= 105) {
            if (MainCanvas.level >= 2 && this.boosterCount < 1 && this.enemies.size() < 1) {
                this.createEnemies(xp, yp);
                hasCoin = false;
            }
            this.createPlatform(0, xp, yp, hasCoin, false);
        }
    }

    public void close() {
        this.rand = null;
        this.obstacles = null;
        this.iObstacles = null;
        this.enemies = null;
        this.iEnemies = null;
        this.coins = null;
        this.iCoins = null;
        this.boosters = null;
        this.iBoosters = null;
        this.platforms = null;
        this.iPlatforms = null;
        this.permanentPlat = null;
        this.breakingPlat = null;
        this.movingPlat = null;
        this.coin = null;
        this.rocket = null;
        this.spring = null;
        this.lastPlatformHit = null;
    }
}

