/*
 * Decompiled with CFR 0.152.
 */
package utils;

import conf.Config;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.MainCanvas;

public class FontUtil {
    public static final int FONT_TYPE_CHARACTERS = 0;
    public static final int FONT_TYPE_NUMBERS = 1;
    private int cellWidth = 20;
    private int cellHeight = 20;
    private Image fontImage;
    private int fontWidth;
    private int fontHeight;
    private int charsPerRow;
    private int fontType;

    public FontUtil(String fontname, int fontType, int cellWidth, int cellHeight) {
        try {
            this.fontImage = Image.createImage((String)fontname);
            this.fontWidth = this.fontImage.getWidth();
            this.fontHeight = this.fontImage.getHeight();
            this.cellWidth = this.fontWidth / 26;
            this.cellHeight = this.fontHeight / 9;
            this.charsPerRow = 26;
            this.fontType = fontType;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSequence() {
        if (this.fontType == 0) {
            return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f9\u00fa\u00fb\u00fc\u00fd!\"#$%&'()*+,-./0123456789:;<=>?\u00bf\u00a1\u0410\u0411\u0412\u0413\u0414\u0415\u0401\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0451\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u00df\u0104\u0106\u0118\u0141\u0143\u015a\u0179\u017b\u0105\u0107\u0119\u0142\u0144\u015b\u017a\u017c@ ";
        }
        return "1234567890";
    }

    private int[] getCharWidth() {
        if (this.fontType == 0) {
            return Config.charWidth;
        }
        return Config.charNumberWidth;
    }

    private int drawChar(Graphics g, char ch, int x, int y) {
        int i = this.getSequence().indexOf(ch);
        if (i == -1) {
            throw new IllegalArgumentException("unsupported character:" + ch);
        }
        int cx = i % this.charsPerRow * this.cellWidth;
        int cy = i / this.charsPerRow * this.cellHeight;
        g.setClip(x, y, this.cellWidth, this.cellHeight);
        g.drawImage(this.fontImage, x - cx, y - cy, 20);
        if (i > this.getCharWidth().length) {
            return 5;
        }
        return this.getCharWidth()[i];
    }

    public int drawString(Graphics g, String s, int x, int y, int width) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        if (width == -1) {
            width = MainCanvas.width;
        }
        Vector wrappedText = this.wrapToLines(s, width);
        int height = 0;
        int origX = x;
        for (int j = 0; j < wrappedText.size(); ++j) {
            String line = wrappedText.elementAt(j).toString();
            char[] chs = line.toCharArray();
            x = origX;
            for (int i = 0; i < chs.length; ++i) {
                x += this.drawChar(g, chs[i], x, y);
            }
            y += this.cellHeight + 2;
            height += this.cellHeight + 2;
        }
        g.setClip(clipX, clipY, clipW, clipH);
        return height;
    }

    public int getStringWidth(String s) {
        int stringWidth = 0;
        char[] chs = s.toCharArray();
        for (int i = 0; i < chs.length; ++i) {
            int index = this.getSequence().indexOf(chs[i]);
            if (index <= -1) continue;
            if (index > this.getCharWidth().length) {
                stringWidth += 5;
                continue;
            }
            stringWidth += this.getCharWidth()[index];
        }
        return stringWidth;
    }

    public int getStringHeight() {
        return this.cellHeight;
    }

    public Vector wrapToLines(String text, int maxWidth) {
        Vector<String> lines = new Vector<String>();
        if (text == null) {
            return lines;
        }
        if (this.getStringWidth(text) < maxWidth) {
            lines.addElement(text);
            return lines;
        }
        StringBuffer currentLine = new StringBuffer();
        StringBuffer wrapText = new StringBuffer(text);
        int index = 0;
        while (wrapText.length() > 0) {
            String currWord;
            int delimiterIndex = text.indexOf(32, index);
            if (delimiterIndex == -1 || delimiterIndex >= text.length()) {
                currWord = text.substring(index);
                wrapText.delete(0, wrapText.length());
            } else {
                currWord = text.substring(index, delimiterIndex + 1);
                wrapText.delete(0, delimiterIndex - index + 1);
            }
            index = delimiterIndex + 1;
            if (this.getStringWidth(currentLine.toString() + currWord) <= maxWidth) {
                currentLine.append(currWord);
                continue;
            }
            if (currentLine.length() <= 0) continue;
            lines.addElement(currentLine.toString());
            currentLine.delete(0, currentLine.length());
            currentLine.append(currWord);
        }
        lines.addElement(currentLine.toString());
        return lines;
    }
}

