/*
 * Decompiled with CFR 0.152.
 */
package screens;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.MainCanvas;
import screens.Button;
import utils.Utils;

public class Menu {
    private Vector menuItems;
    private int selectedIndex = 0;
    private Image activeButton;
    private Image inactiveButton;
    private Image buttons;

    public Menu() {
        try {
            this.activeButton = Image.createImage((String)"/images/menu_selected.png");
            this.inactiveButton = Image.createImage((String)"/images/menu_unselected.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.menuItems = new Vector();
    }

    public void add(String text, int type) {
        this.menuItems.addElement(new Button(text, type));
    }

    public int getSize() {
        return this.menuItems.size();
    }

    public int getStartY() {
        return Utils.getCenterVPosition((this.activeButton.getHeight() + 2) * this.getSize(), MainCanvas.height);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public int touch(int x, int y) {
        for (int i = 0; i < this.menuItems.size(); ++i) {
            Button btn = (Button)this.menuItems.elementAt(i);
            if (x < btn.x || x > btn.x + btn.w || y < btn.y || y > btn.y + btn.h) continue;
            this.selectedIndex = i;
            return btn.getType();
        }
        return -1;
    }

    public int input(int keyStates) {
        if ((keyStates & 2) != 0) {
            this.selectedIndex = this.selectedIndex <= 0 ? this.menuItems.size() - 1 : --this.selectedIndex;
        }
        if ((keyStates & 0x40) != 0) {
            this.selectedIndex = this.selectedIndex >= this.menuItems.size() - 1 ? 0 : ++this.selectedIndex;
        }
        if ((keyStates & 0x100) != 0) {
            return ((Button)this.menuItems.elementAt(this.selectedIndex)).getType();
        }
        return -1;
    }

    public void paint(Graphics g, int x, int y) {
        int buttonX = x;
        int buttonY = y;
        if (x == -1) {
            buttonX = Utils.getCenterPosition(this.activeButton.getWidth() / 2, MainCanvas.width);
        }
        if (y == -1) {
            buttonY = MainCanvas.height / 2 - this.activeButton.getHeight() / 4;
        }
        for (int i = 0; i < this.menuItems.size(); ++i) {
            Image button = this.inactiveButton;
            if (this.selectedIndex == i) {
                button = this.activeButton;
            }
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipW = g.getClipWidth();
            int clipH = g.getClipHeight();
            g.setClip(buttonX, buttonY, button.getWidth() / 2, button.getHeight());
            g.drawImage(button, buttonX, buttonY, 0);
            Button btn = (Button)this.menuItems.elementAt(i);
            btn.setDimensions(this.activeButton.getWidth(), this.activeButton.getHeight());
            btn.setPosition(buttonX, buttonY);
            g.setClip(clipX, clipY, clipW, clipH);
            String menuName = btn.getText();
            this.menuItems.setElementAt(btn, i);
            MainCanvas.letters.drawString(g, menuName, buttonX + (button.getWidth() / 2 - MainCanvas.letters.getStringWidth(menuName)) / 2, buttonY + (button.getHeight() - MainCanvas.letters.getStringHeight()) / 2, -1);
            buttonY += button.getHeight() + 2;
        }
    }
}

