/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class MainMenu
extends List
implements CommandListener {
    private BabyKickTracker _bkt;
    private Command exitCmd;
    private Image[] imageArray = new Image[5];
    private int fontSize;
    private DataStore ds;
    private Alert aboutAlert;
    private Command okCmd;
    private Alert alert;
    private Command yesCmd;
    private Command noCmd;

    public MainMenu(BabyKickTracker bkt) {
        super("Main menu", 3);
        this._bkt = bkt;
        this.ds = this._bkt.dataStore();
        this.setTitle(this._bkt.stringStore().getString("mainMenuTitleMainMenu"));
        this.exitCmd = new Command(this._bkt.stringStore().getString("exitCmd"), 7, 1);
        this.yesCmd = new Command(this._bkt.stringStore().getString("yesCmd"), 4, 1);
        this.noCmd = new Command(this._bkt.stringStore().getString("noCmd"), 8, 1);
        this.setFitPolicy(1);
        this.createImages();
        this.showNotify();
        this.addCommand(this.exitCmd);
        this.setCommandListener(this);
        this.alert = new Alert(this._bkt.stringStore().getString("confirmationTitle"), this._bkt.stringStore().getString("confirmationTextDelSes"), null, AlertType.CONFIRMATION);
        this.alert.addCommand(this.yesCmd);
        this.alert.addCommand(this.noCmd);
        this.alert.setCommandListener((CommandListener)this);
        this.okCmd = new Command(this._bkt.stringStore().getString("okCmd"), 4, 1);
        this.aboutAlert = new Alert(this._bkt.stringStore().getString("mainMenuAbout"), "DoctorMe Oy\nBaby Kick Tracker\n1.0.2\nwww.doctorme.fi\n", null, AlertType.INFO);
        this.aboutAlert.setTimeout(-2);
        this.aboutAlert.addCommand(this.okCmd);
        this.aboutAlert.setCommandListener((CommandListener)this);
    }

    private void createImages() {
        try {
            Image image;
            this.imageArray[0] = image = Image.createImage((String)"/bkt_main_menu_new_session.png");
            this.imageArray[1] = image = Image.createImage((String)"/bkt_main_menu_continue_session.png");
            this.imageArray[2] = image = Image.createImage((String)"/bkt_main_menu_diary.png");
            this.imageArray[3] = image = Image.createImage((String)"/bkt_main_menu_help.png");
            this.imageArray[4] = image = Image.createImage((String)"/bkt_main_menu_about.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showNotify() {
        this.deleteAll();
        this.append(this._bkt.stringStore().getString("newSession"), this.imageArray[0]);
        if (this.ds.savedSessionExists()) {
            this.append(this._bkt.stringStore().getString("savedSession"), this.imageArray[1]);
        }
        this.append(this._bkt.stringStore().getString("mainMenuDiary"), this.imageArray[2]);
        this.append(this._bkt.stringStore().getString("mainMenuHelp"), this.imageArray[3]);
        this.append(this._bkt.stringStore().getString("mainMenuAbout"), this.imageArray[4]);
        this.setSelectedIndex(0, true);
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this) {
            if (c == List.SELECT_COMMAND) {
                switch (this.getSelectedIndex()) {
                    case 0: {
                        if (this.ds.savedSessionExists()) {
                            Display.getDisplay((MIDlet)this._bkt).setCurrent(this.alert, (Displayable)this);
                            break;
                        }
                        this.start();
                        break;
                    }
                    case 1: {
                        if (this.size() > 4) {
                            this._bkt.dataStore().loadSession();
                            this.ds.setNewSession(false);
                            this._bkt.setScreen(4);
                            break;
                        }
                        this._bkt.setScreen(3);
                        break;
                    }
                    case 2: {
                        if (this.size() > 4) {
                            this._bkt.setScreen(3);
                            break;
                        }
                        this._bkt.setScreen(2);
                        break;
                    }
                    case 3: {
                        if (this.size() > 4) {
                            this._bkt.setScreen(2);
                            break;
                        }
                        this.showAbout();
                        break;
                    }
                    case 4: {
                        this.showAbout();
                        break;
                    }
                }
            } else if (c == this.exitCmd) {
                this._bkt.exit();
            }
        } else if (d == this.aboutAlert) {
            if (c == this.okCmd) {
                this._bkt.setScreen(1);
            }
        } else if (d == this.alert) {
            if (c == this.yesCmd) {
                this.start();
            } else if (c == this.noCmd) {
                this._bkt.setScreen(1);
            }
        }
    }

    private void start() {
        this.ds.setNewSession(true);
        this.ds.setSavedSessionExists(true);
        this.ds.setSessionExperied(false);
        this.ds.setKickCount(0);
        Date date = new Date();
        long timeNow = date.getTime();
        this.ds.setStartTime(timeNow);
        this.ds.saveSession();
        this._bkt.setScreen(4);
    }

    private void showAbout() {
        Display.getDisplay((MIDlet)this._bkt).setCurrent(this.aboutAlert, (Displayable)this);
    }
}

