/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class DataStore {
    private BabyKickTracker _bkt;
    static final String REC_STORE = "BkStore";
    private static final int storeId = 1;
    private RecordStore rs;
    private int diaryCount;
    private boolean acceptDisclaimerAlways = false;
    private boolean savedSessionExists = false;
    private boolean sessionExperied = false;
    private int kickCount;
    private int timeIndex;
    private long startTime;
    private Vector diaryEntries = new Vector();
    private boolean newSession;

    public DataStore(BabyKickTracker bkt) {
        this._bkt = bkt;
    }

    public void addDiaryEntry(String text) {
        this.diaryEntries.addElement(text);
        ++this.diaryCount;
    }

    public void deleteDiaryEntry(int index) {
        if (index < this.diaryEntries.size()) {
            --this.diaryCount;
            this.diaryEntries.removeElementAt(index);
        }
    }

    public Vector diaryEntries() {
        return this.diaryEntries;
    }

    public int diaryCount() {
        return this.diaryCount;
    }

    public void setacceptDisclaimerAlways(boolean accept) {
        this.acceptDisclaimerAlways = accept;
    }

    public boolean acceptDisclaimerAlways() {
        return this.acceptDisclaimerAlways;
    }

    public boolean savedSessionExists() {
        return this.savedSessionExists;
    }

    public void setSavedSessionExists(boolean sessionExits) {
        this.savedSessionExists = sessionExits;
    }

    public boolean sessionExperied() {
        return this.sessionExperied;
    }

    public void setSessionExperied(boolean experied) {
        this.sessionExperied = experied;
    }

    public long startTime() {
        return this.startTime;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public int kickCount() {
        return this.kickCount;
    }

    public void setKickCount(int count) {
        this.kickCount = count;
    }

    public int timeIndex() {
        return this.timeIndex;
    }

    public void setTimeIndex(int time) {
        this.timeIndex = time;
    }

    public boolean newSession() {
        return this.newSession;
    }

    public void setNewSession(boolean isNew) {
        this.newSession = isNew;
    }

    public void saveSession() {
        this.writeDataToFile();
    }

    public void loadSession() {
        this.readDataFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataToFile() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeBoolean(this.acceptDisclaimerAlways);
            dout.writeBoolean(this.savedSessionExists);
            dout.writeInt(this.kickCount);
            dout.writeInt(this.timeIndex);
            dout.writeInt(this.diaryCount);
            dout.writeBoolean(this.sessionExperied);
            dout.writeLong(this.startTime);
            for (int i = 0; i < this.diaryCount; ++i) {
                String text = (String)this.diaryEntries.elementAt(i);
                dout.writeUTF(text);
            }
            dout.close();
            byte[] data = bout.toByteArray();
            this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
            try {
                byte[] recordId = this.rs.getRecord(1);
                this.rs.setRecord(1, data, 0, data.length);
            }
            catch (InvalidRecordIDException e) {
                this.rs.addRecord(data, 0, data.length);
            }
            finally {
                this.rs.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDataFromFile() {
        try {
            this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)false);
            try {
                byte[] data = this.rs.getRecord(1);
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                this.acceptDisclaimerAlways = din.readBoolean();
                this.savedSessionExists = din.readBoolean();
                this.kickCount = din.readInt();
                this.timeIndex = din.readInt();
                this.diaryCount = din.readInt();
                this.sessionExperied = din.readBoolean();
                this.startTime = din.readLong();
                this.diaryEntries = new Vector();
                for (int i = 0; i < this.diaryCount; ++i) {
                    String text = din.readUTF();
                    this.diaryEntries.addElement(text);
                }
                din.close();
            }
            finally {
                this.rs.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetDataStore() {
        this.savedSessionExists = false;
        this.kickCount = 0;
        this.timeIndex = 3600;
        this.writeDataToFile();
    }
}

