/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphView
extends FullCanvas
implements CommandListener {
    private BabyKickTracker _bkt;
    private Image[] imageArray = new Image[2];
    private final int backgroundColor;
    private int experiedColor = 2359096;
    private int experiedColorNok = 16724259;
    private int screenWidth;
    private int screenHeight;
    private int buttonIconWidth;
    private int buttonIconHeight;
    private int pointerStartX;
    private int pointerStartY;
    private Font smallFont;
    private Font largeFont;
    private int largeFontHeight;
    private String rightCBALabel;
    private String leftCBALabel;
    private DataStore ds;
    private Image[] imageArrayTime = new Image[11];
    private Image kickIcon;
    private int timeIconColumnWidth = 20;
    private int timeIconWidth = 40;
    private int timeIconHeight = 60;
    private int buttonYOffset = 3;
    private int itemYOffset = 1;
    private String timeLabel;
    private String kicksLabel;
    private Timer timer = new Timer();
    private CountDown countDownTask;
    private int timeCount = 3600;
    private int kicks = 0;
    private boolean isTimerRunning = false;

    GraphView(BabyKickTracker bkt) {
        this.backgroundColor = 0xFFFFFF;
        this._bkt = bkt;
        this.ds = this._bkt.dataStore();
        this.rightCBALabel = this._bkt.stringStore().getString("undoCmd");
        this.leftCBALabel = this._bkt.stringStore().getString("menuCmd");
        this.timeLabel = this._bkt.stringStore().getString("graphTime");
        this.kicksLabel = this._bkt.stringStore().getString("graphKicks");
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.largeFont = Font.getFont((int)0, (int)1, (int)16);
        this.largeFontHeight = this.largeFont.getHeight();
        this.createIamges();
    }

    void createIamges() {
        try {
            Image image;
            String kickPath = "/bkt_kick_button.png";
            String kickPathFi = "/bkt_kick_button_fi.png";
            if (this.getHeight() > 400) {
                kickPath = "/bkt_kick_button_large.png";
                kickPathFi = "/bkt_kick_button_large_fi.png";
            }
            this.kickIcon = Image.createImage((String)kickPath);
            if (this._bkt.stringStore().getLanguage().equalsIgnoreCase("fi")) {
                this.kickIcon = Image.createImage((String)kickPathFi);
            }
            this.buttonIconWidth = this.kickIcon.getWidth();
            this.buttonIconHeight = this.kickIcon.getHeight();
            this.imageArrayTime[0] = image = Image.createImage((String)"/time_0.png");
            this.imageArrayTime[1] = image = Image.createImage((String)"/time_1.png");
            this.imageArrayTime[2] = image = Image.createImage((String)"/time_2.png");
            this.imageArrayTime[3] = image = Image.createImage((String)"/time_3.png");
            this.imageArrayTime[4] = image = Image.createImage((String)"/time_4.png");
            this.imageArrayTime[5] = image = Image.createImage((String)"/time_5.png");
            this.imageArrayTime[6] = image = Image.createImage((String)"/time_6.png");
            this.imageArrayTime[7] = image = Image.createImage((String)"/time_7.png");
            this.imageArrayTime[8] = image = Image.createImage((String)"/time_8.png");
            this.imageArrayTime[9] = image = Image.createImage((String)"/time_9.png");
            this.timeIconWidth = image.getWidth();
            this.timeIconHeight = image.getHeight();
            this.imageArrayTime[10] = image = Image.createImage((String)"/time_column.png");
            this.timeIconColumnWidth = image.getWidth();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void sizeChanged(int w, int h) {
        super.sizeChanged(w, h);
    }

    public void showNotify() {
        if (this.ds.newSession()) {
            this.ds.setNewSession(false);
            this.timeCount = 3600;
            this.kicks = 0;
            this.ds.setKickCount(0);
            this.ds.saveSession();
            this.repaint();
            this.startTimer();
        } else {
            this.kicks = this.ds.kickCount();
            if (!this.ds.sessionExperied()) {
                Date date = new Date();
                long timeDiff = date.getTime() - this.ds.startTime();
                if (timeDiff > 3600000L) {
                    this.timeCount = 0;
                    this.timeExperied();
                } else {
                    this.timeCount = 3600 - (int)(timeDiff /= 1000L);
                    this.startTimer();
                    this.repaint();
                }
            }
        }
    }

    public void startTimer() {
        if (this.isTimerRunning) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.countDownTask = new CountDown();
        this.timer.schedule((TimerTask)this.countDownTask, 1000L, 1000L);
        this.isTimerRunning = true;
    }

    protected void paint(Graphics g) {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        int graphAreaHeight = (this.screenHeight - this.buttonIconHeight - this.buttonYOffset) / 2;
        g.setColor(0);
        g.setFont(this.largeFont);
        g.drawString(this.timeLabel + ":", this.screenWidth / 2, this.itemYOffset, 17);
        int timeY = (graphAreaHeight + this.largeFontHeight) / 2;
        g.drawImage(this.imageArrayTime[this.timeCount / 60 / 10 % 7], this.screenWidth / 2 - this.timeIconColumnWidth / 2 - this.timeIconWidth, timeY, 10);
        g.drawImage(this.imageArrayTime[this.timeCount / 60 % 10], this.screenWidth / 2 - this.timeIconColumnWidth / 2, timeY, 10);
        g.drawImage(this.imageArrayTime[10], this.screenWidth / 2, timeY, 3);
        g.drawImage(this.imageArrayTime[this.timeCount / 10 % 6], this.screenWidth / 2 + this.timeIconColumnWidth / 2, timeY, 6);
        g.drawImage(this.imageArrayTime[this.timeCount % 10], this.screenWidth / 2 + this.timeIconColumnWidth / 2 + this.timeIconWidth, timeY, 6);
        if (this.ds.sessionExperied()) {
            if (this.kicks < 10) {
                g.setColor(this.experiedColorNok);
            } else {
                g.setColor(this.experiedColor);
            }
            g.fillRect(1, graphAreaHeight + 1, this.screenWidth - 2, graphAreaHeight - 2);
        }
        g.setColor(0);
        g.drawLine(0, graphAreaHeight, this.screenWidth, graphAreaHeight);
        g.drawString(this.kicksLabel + ":", this.screenWidth / 2, graphAreaHeight + this.itemYOffset, 17);
        int kicksY = (graphAreaHeight + this.largeFontHeight) / 2 + graphAreaHeight;
        g.drawImage(this.imageArrayTime[this.kicks / 10 % 10], this.screenWidth / 2, kicksY, 10);
        g.drawImage(this.imageArrayTime[this.kicks % 10], this.screenWidth / 2, kicksY, 6);
        g.drawLine(0, graphAreaHeight * 2, this.screenWidth, graphAreaHeight * 2);
        if (!this.ds.sessionExperied()) {
            g.drawImage(this.kickIcon, (this.screenWidth - this.buttonIconWidth) / 2, this.screenHeight - this.itemYOffset, 36);
        }
        g.setColor(0);
        g.setFont(this.smallFont);
        g.drawString(this.leftCBALabel, 1, this.screenHeight, 36);
        if (!this.ds.sessionExperied()) {
            g.drawString(this.rightCBALabel, this.screenWidth - 1, this.screenHeight, 40);
        }
    }

    public void commandAction(Command c, Displayable d) {
    }

    public void keyPressed(int keyCode) {
        this.keyPressedInternal(keyCode, false);
    }

    private void keyPressedInternal(int keyCode, boolean isTouch) {
        if (keyCode == -6) {
            this._bkt.setScreen(1);
            return;
        }
        if (keyCode == -7) {
            if (this.ds.sessionExperied()) {
                return;
            }
            --this.kicks;
            if (this.kicks < 0) {
                this.kicks = 0;
            }
            this.ds.setKickCount(this.kicks);
            this.ds.saveSession();
            this.repaint();
            return;
        }
        int action = 0;
        action = isTouch ? keyCode : this.getGameAction(keyCode);
        switch (action) {
            case 8: {
                if (this.ds.sessionExperied()) {
                    return;
                }
                this.buttonPushed();
                break;
            }
        }
        this.repaint();
    }

    protected void pointerPressed(int x, int y) {
        this.pointerStartX = x;
        this.pointerStartY = y;
    }

    private void doPointerAction(int itemIndex) {
        switch (itemIndex) {
            case 0: {
                this.keyPressedInternal(2, true);
                break;
            }
            case 1: {
                this.keyPressedInternal(1, true);
                break;
            }
            case 2: {
                this.keyPressedInternal(6, true);
                break;
            }
            case 3: {
                this.keyPressedInternal(5, true);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        if (y < this.screenHeight - this.buttonIconHeight - this.buttonYOffset) {
            this.isGestureType(x, y);
        } else if (y > this.screenHeight - this.buttonIconHeight - this.buttonYOffset) {
            int offset = (this.screenWidth - this.buttonIconWidth) / 2;
            if (offset <= x && x <= this.screenWidth - offset) {
                this.buttonPushed();
            } else if (x < 80) {
                this.keyPressedInternal(-6, true);
            } else if (x > this.screenWidth - 80) {
                this.keyPressedInternal(-7, true);
            }
        }
    }

    private void isGestureType(int endX, int endY) {
        int x = endX - this.pointerStartX;
        int y = endY - this.pointerStartY;
        if (x > 120) {
            this.keyPressedInternal(2, true);
        }
        if (x < -120) {
            this.keyPressedInternal(5, true);
        }
        if (y > 150) {
            this.keyPressedInternal(1, true);
        }
        if (y < -150) {
            this.keyPressedInternal(6, true);
        }
    }

    private void buttonPushed() {
        if (this.ds.sessionExperied()) {
            return;
        }
        ++this.kicks;
        if (this.kicks > 99) {
            this.kicks = 99;
        }
        this.ds.setKickCount(this.kicks);
        this.ds.saveSession();
        this.repaint();
    }

    private void timeExperied() {
        this.ds.setSessionExperied(true);
        this.ds.setSavedSessionExists(false);
        this.ds.addDiaryEntry(this.timeFormat());
        this.ds.saveSession();
        this.timer.cancel();
        this.repaint();
    }

    private String timeFormat() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.ds.startTime()));
        int year = calendar.get(1);
        int month = calendar.get(2);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        String minutesString = String.valueOf(minutes);
        if (minutes < 10) {
            minutesString = "0" + minutesString;
        }
        int day = calendar.get(5);
        String string = String.valueOf(this.kicks) + " " + this._bkt.stringStore().getString("diaryKicks") + " | " + String.valueOf(hours) + ":" + minutesString + " | " + String.valueOf(year) + "-" + String.valueOf(++month) + "-" + String.valueOf(day);
        return string;
    }

    private class CountDown
    extends TimerTask {
        private CountDown() {
        }

        public void run() {
            GraphView.this.timeCount--;
            if (GraphView.this.timeCount < 1) {
                GraphView.this.timeExperied();
            }
            GraphView.this.repaint();
        }
    }
}

