/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class DiaryView
extends List
implements CommandListener {
    private Command backCmd;
    private Command deleteCmd;
    private BabyKickTracker _bkt;
    private DataStore ds;
    private Alert deleteAlert;
    private Command yesCmd;
    private Command noCmd;
    private int deletionIndex;

    public DiaryView(BabyKickTracker bkt) {
        super("Diary", 3);
        this._bkt = bkt;
        this.ds = this._bkt.dataStore();
        this.setTitle(this._bkt.stringStore().getString("diaryTitle"));
        this.setFitPolicy(1);
        this.yesCmd = new Command(this._bkt.stringStore().getString("yesCmd"), 4, 1);
        this.noCmd = new Command(this._bkt.stringStore().getString("noCmd"), 8, 1);
        this.deleteAlert = new Alert(this._bkt.stringStore().getString("confirmationTitle"), this._bkt.stringStore().getString("confirmationTextDelEntry"), null, AlertType.CONFIRMATION);
        this.deleteAlert.addCommand(this.yesCmd);
        this.deleteAlert.addCommand(this.noCmd);
        this.deleteAlert.setCommandListener((CommandListener)this);
        this.backCmd = new Command(this._bkt.stringStore().getString("backCmd"), 2, 1);
        this.deleteCmd = new Command(this._bkt.stringStore().getString("deleteCmd"), 4, 1);
        this.addCommand(this.backCmd);
        this.addCommand(this.deleteCmd);
        this.removeCommand(SELECT_COMMAND);
        this.setCommandListener(this);
    }

    public void showNotify() {
        int elementCount;
        this.deleteAll();
        Vector entries = this.ds.diaryEntries();
        for (int i = elementCount = this.ds.diaryCount(); i > 0; --i) {
            String text = (String)entries.elementAt(i - 1);
            this.append(text, null);
        }
        this.updateCommands();
    }

    private void updateCommands() {
        if (this.size() > 0) {
            this.addCommand(this.deleteCmd);
        } else {
            this.removeCommand(this.deleteCmd);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this) {
            if (c == this.backCmd) {
                this._bkt.setScreen(1);
            } else if (c == this.deleteCmd) {
                this.deletionIndex = this.size() - this.getSelectedIndex() - 1;
                Display.getDisplay((MIDlet)this._bkt).setCurrent(this.deleteAlert, (Displayable)this);
            }
        } else if (d == this.deleteAlert) {
            if (c == this.yesCmd) {
                this.ds.deleteDiaryEntry(this.deletionIndex);
                this.ds.saveSession();
                this._bkt.setScreen(3);
            } else {
                this._bkt.setScreen(3);
            }
        }
    }
}

