/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniBallLine
extends MiniGame {
    private static final int LADYBUG = 0;
    private static final int LADYBUG_UNHIDE = 1;
    private static final int BACKGROUND = 2;
    private static final int BALL_SIZE = 12;
    private static final int BLACK_QUAD_PERCENTAGE = 75;
    private int mBallSize;
    private int mBallSizeInit;
    private int mBallWorldX;
    private int mBallWorldY;
    private int mBallScreenX;
    private int mBallScreenY;
    private int mReferencePointX;
    private int mReferencePointY;
    private int mBallSpeedX;
    private int mBallSpeedY;
    private int mBallColor;
    private int mBugAnimation;
    private int mQuadX;
    private int mQuadY;
    private int mQuadWidth;
    private int mQuadHeight;
    private int mLineWidth;
    private int mLinePosX;
    private static boolean smShowBall;

    public MiniBallLine(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(720907), false);
        this.initialize(n, n2);
        this.initilizeGame();
        this.createButtons(SpriteObject.loadAnimations(new int[]{458775, 458768}), null);
        this.mTutorialMaxWaitTicks = 0;
    }

    private void initilizeGame() {
        this.mSpritesPool = new SpriteObject[3];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(458778), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(458777), false);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(458772), true);
        this.mBallSize = this.mSpritesPool[0].getWidth();
        this.mLineWidth = this.mBallSize / 2;
        if (this.mLineWidth < 12) {
            this.mLineWidth = 12;
        }
        short[] sArray = this.mSpritesPool[2].getCurrentAnimationData();
        int n = this.mSpritesPool[2].getCollisionBoxes();
        n += 2;
        this.mQuadX = sArray[n++] + this.mCanvasX + this.mCanvasWidth / 2 + this.mBallSize;
        this.mQuadY = sArray[n++] + this.mCanvasY + this.mCanvasHeight / 2;
        this.mQuadWidth = sArray[n++];
        this.mQuadHeight = sArray[n++];
        this.mBallSizeInit = this.mLineWidth;
        this.mLinePosX = this.mQuadX + (this.mQuadWidth - this.mLineWidth) / 2;
        this.mReferencePointX = this.mLinePosX << 8;
        this.mReferencePointY = this.mCanvasY + this.mCanvasHeight / 2 << 8;
    }

    public void updateGame(int n) {
        while (this.mProcessedTime < this.mElapsedTime) {
            this.mBallWorldX += this.mBallSpeedX;
            this.mBallWorldY += this.mBallSpeedY;
            this.mProcessedTime += 50;
        }
        this.mBallScreenX = this.mBallWorldX >> 8;
        this.mBallScreenY = this.mBallWorldY >> 8;
        this.mHudConfirmationPosX = this.mBallScreenX;
        this.mHudConfirmationPosY = this.mBallScreenY;
        if (this.mBallScreenX + this.mLineWidth >= this.mQuadX + this.mQuadWidth + this.mLineWidth) {
            this.mBugAnimation = 1;
            this.mHudConfirmationTicks = 500;
            this.mForceFailure = true;
        }
        if (this.mBallScreenX > this.mQuadX) {
            smShowBall = this.mBugAnimation == 1;
            this.mSpritesPool[2].logicUpdate(n);
        } else {
            this.mSpritesPool[0].logicUpdate(n);
        }
    }

    protected boolean checkAnswer(int n) {
        return this.mHudConfirmationTicks <= 0;
    }

    public void drawGame(Graphics graphics) {
        graphics.setClip(this.mCanvasX, this.mCanvasY, this.mCanvasWidth, this.mCanvasHeight);
        if (smShowBall) {
            this.mSpritesPool[this.mBugAnimation].draw(graphics, this.mBallScreenX, this.mBallScreenY);
        }
        this.mSpritesPool[2].draw(graphics, this.mCanvasX + this.mCanvasWidth / 2 + this.mBallSize / 3, this.mCanvasY + this.mCanvasHeight / 2 - this.mBallSize / 3);
        graphics.setColor(0xFF0000);
        graphics.fillRect(this.mLinePosX, this.mQuadY - this.mBallSize / 3, this.mLineWidth, this.mQuadHeight);
        if (smShowBall && this.mBugAnimation == 1) {
            this.mSpritesPool[this.mBugAnimation].draw(graphics, this.mBallScreenX, this.mBallScreenY);
        }
    }

    protected void initNextQuestion() {
        smShowBall = true;
        this.mBallScreenX = 0;
        this.mBallScreenY = MiniBallLine.rnd(this.mCanvasWidth) + this.mCanvasY;
        this.mBallWorldX = this.mBallScreenX << 8;
        this.mBallWorldY = this.mBallScreenY << 8;
        int n = 25 * this.mDifficulty;
        this.mBallSpeedX = (MiniBallLine.rnd(50) + 250 + n << 8) / 100 * this.mCanvasWidth / 129;
        if (this.mBallSpeedX <= 0) {
            this.mBallSpeedX = 1;
        }
        int n2 = this.mReferencePointX - this.mBallWorldX;
        int n3 = this.mReferencePointY - this.mBallWorldY;
        this.mBallSpeedY = n3 == 0 ? 0 : this.mBallSpeedX * n3 / n2;
        this.mBugAnimation = 0;
        this.mLineWidth = this.mBallSizeInit - this.mDifficulty;
    }

    protected int isCorrectAnswer(int n) {
        boolean bl = false;
        if ((Toolkit.getToolkitGameAction(n) == 53 || n == 53) && this.mBallScreenX > this.mCanvasX) {
            this.showResult();
            bl = this.mBallScreenX + this.mBallSize - this.mSpritesPool[0].getPivotX() >= this.mLinePosX && this.mBallScreenX - this.mSpritesPool[0].getPivotX() < this.mLinePosX + this.mLineWidth;
            this.pressButton(0, bl, false);
            if (bl) {
                this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY, true);
                return 0;
            }
            return 1;
        }
        return 3;
    }

    private void showResult() {
        this.mHudConfirmationTicks = 500;
        this.mBugAnimation = 1;
        smShowBall = true;
    }
}

