/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniAnt
extends MiniGame {
    static final int CELL_USED = 1;
    static final int CELL_UP_WALL = 2;
    static final int CELL_LEFT_WALL = 4;
    static final int CELL_PAINTED = 8;
    static final int SPRITE_ANTEATER = 0;
    static final int SPRITE_ANT = 1;
    static final int MIN_LENGTH = 10;
    static final int MAX_LENGTH = 20;
    static final int WAIT_TIME = 50;
    private int[] mMaze;
    private int mMazePosX;
    private int mMazePosY;
    private int mMazeSize;
    private int[] mMazeLength = new int[2];
    private int[][] mMazePath = new int[2][21];
    private int mMazeTiles;
    private int mTileSize;
    private int mCurrentTile;
    private int mTime;
    private int mSolution;
    private int mSelection;

    public MiniAnt(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(786437), false);
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{917529, 589868}), SpriteObject.loadAnimations(new int[]{655444, 589875}));
        this.mMazeTiles = 10;
        this.mMaze = new int[this.mMazeTiles * this.mMazeTiles];
        this.mTileSize = 17;
        this.mMazeSize = (this.mMazeTiles - 1) * this.mTileSize;
        this.mMazePosX = this.mCanvasWidth - this.mMazeSize >> 1;
        this.mMazePosY = this.mCanvasHeight - this.mMazeSize >> 1;
        this.mSpritesPool = new SpriteObject[2];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131093), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(131089), true);
    }

    protected boolean checkAnswer(int n) {
        this.mTime -= n;
        if (this.mTime <= 0) {
            if (this.mCurrentTile > 20) {
                this.mHudConfirmationTicks = 0;
                return true;
            }
            this.mTime = 50 - 4 * this.mDifficulty;
            ++this.mCurrentTile;
        }
        return false;
    }

    protected void drawGame(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(this.mCanvasX + this.mMazePosX, this.mCanvasY + this.mMazePosY, this.mMazeSize, this.mMazeSize);
        for (n = 1; n < this.mCurrentTile && this.mMazePath[this.mSelection][n] > -1; ++n) {
            int n4 = 0 + 0x110000 * n;
            if (n4 > 0xFF0000) {
                n4 = 0xFF0000;
            }
            graphics.setColor(n4);
            int n5 = this.mCanvasX + this.mMazePosX + this.mMazePath[this.mSelection][n - 1] % this.mMazeTiles * this.mTileSize;
            int n6 = this.mCanvasY + this.mMazePosY + this.mMazePath[this.mSelection][n - 1] / this.mMazeTiles * this.mTileSize;
            int n7 = this.mCanvasX + this.mMazePosX + this.mMazePath[this.mSelection][n] % this.mMazeTiles * this.mTileSize;
            int n8 = this.mCanvasY + this.mMazePosY + this.mMazePath[this.mSelection][n] / this.mMazeTiles * this.mTileSize;
            graphics.drawLine(n5 + (this.mTileSize >> 1), n6 + (this.mTileSize >> 1), n7 + (this.mTileSize >> 1), n8 + (this.mTileSize >> 1));
        }
        for (n = 0; n < this.mMaze.length; ++n) {
            n2 = this.mCanvasX + this.mMazePosX + n % this.mMazeTiles * this.mTileSize;
            n3 = this.mCanvasY + this.mMazePosY + n / this.mMazeTiles * this.mTileSize;
            if ((this.mMaze[n] & 2) != 0) {
                graphics.setColor(0x888888);
                graphics.drawLine(n2, n3, n2 + this.mTileSize, n3);
            }
            if ((this.mMaze[n] & 4) == 0) continue;
            graphics.setColor(0x888888);
            graphics.drawLine(n2, n3, n2, n3 + this.mTileSize);
        }
        this.mSpritesPool[0].draw(graphics, this.mCanvasX + this.mMazePosX + (this.mMazeSize >> 1), this.mCanvasY + this.mMazePosY + (this.mMazeSize >> 1));
        for (n = 0; n < this.mMazePath[this.mSolution].length && this.mMazePath[this.mSolution][n] != -1; ++n) {
        }
        n2 = this.mCanvasX + this.mMazePosX + this.mMazePath[this.mSolution][--n] % this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
        n3 = this.mCanvasY + this.mMazePosY + this.mMazePath[this.mSolution][n] / this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
        this.mSpritesPool[1].draw(graphics, n2, n3);
    }

    protected void initNextQuestion() {
        int n = 0;
        this.mTime = 50 - 5 * this.mDifficulty;
        this.mCurrentTile = 0;
        for (n = 0; n < 1800; ++n) {
            int n2;
            this.resetMap();
            this.mMazeLength[0] = this.createLabyrinth(2, 4, 20, 0);
            this.mMazeLength[1] = this.createLabyrinth(6, 4, 20, 1);
            do {
                if ((n2 = this.searchFreeCell()) <= -1) continue;
                int n3 = n2 % this.mMazeTiles;
                int n4 = n2 / this.mMazeTiles;
                int n5 = n3 + n4 * this.mMazeTiles;
                this.mMaze[n5] = this.mMaze[n5] | 7;
                int n6 = n3 + 1 + n4 * this.mMazeTiles;
                this.mMaze[n6] = this.mMaze[n6] | 4;
                int n7 = n3 + (n4 + 1) * this.mMazeTiles;
                this.mMaze[n7] = this.mMaze[n7] | 2;
                this.createLabyrinth(n3, n4, -1, -1);
            } while (n2 != -1);
            if (this.isMapValid()) break;
        }
        this.mSolution = this.rndBin() ? 0 : 1;
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                this.mSelection = 0;
                this.pressButton(0, this.mSolution == 0, false);
                this.mHudConfirmationTicks = 2000;
                this.mHudConfirmationPosX = this.mCanvasX + this.mMazePosX + this.mMazePath[this.mSelection][0] % this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
                this.mHudConfirmationPosY = this.mCanvasY + this.mMazePosY + this.mMazePath[this.mSelection][0] / this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
                if (this.mSolution == 0) {
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                return 1;
            }
            if (n2 == 54 || n == 54) {
                this.mSelection = 1;
                this.pressButton(1, this.mSolution == 1, false);
                this.mHudConfirmationTicks = 2000;
                this.mHudConfirmationPosX = this.mCanvasX + this.mMazePosX + this.mMazePath[this.mSelection][0] % this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
                this.mHudConfirmationPosY = this.mCanvasY + this.mMazePosY + this.mMazePath[this.mSelection][0] / this.mMazeTiles * this.mTileSize + (this.mTileSize >> 1);
                if (this.mSolution == 1) {
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                    return 0;
                }
                return 1;
            }
        }
        return 3;
    }

    protected void updateGame(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        this.mSpritesPool[1].logicUpdate(n);
    }

    private void resetMap() {
        int n = 0;
        for (n = 0; n < this.mMaze.length; ++n) {
            this.mMaze[n] = 0;
        }
        for (n = 0; n < this.mMazeTiles; ++n) {
            this.mMaze[n + 0 * this.mMazeTiles] = 2;
            this.mMaze[n + 9 * this.mMazeTiles] = 3;
        }
        for (n = 0; n < this.mMazeTiles; ++n) {
            this.mMaze[0 + n * this.mMazeTiles] = 4;
            this.mMaze[9 + n * this.mMazeTiles] = 5;
        }
        this.mMaze[0 + 0 * this.mMazeTiles] = 6;
        this.mMaze[9 + 0 * this.mMazeTiles] = 5;
        this.mMaze[0 + 9 * this.mMazeTiles] = 3;
        this.mMaze[9 + 9 * this.mMazeTiles] = 1;
        this.mMaze[3 + 3 * this.mMazeTiles] = 6;
        this.mMaze[4 + 3 * this.mMazeTiles] = 2;
        this.mMaze[5 + 3 * this.mMazeTiles] = 2;
        this.mMaze[6 + 3 * this.mMazeTiles] = 4;
        this.mMaze[2 + 4 * this.mMazeTiles] = 6;
        this.mMaze[6 + 4 * this.mMazeTiles] = 2;
        this.mMaze[2 + 5 * this.mMazeTiles] = 2;
        this.mMaze[7 + 4 * this.mMazeTiles] = 4;
        this.mMaze[3 + 5 * this.mMazeTiles] = 4;
        this.mMaze[6 + 5 * this.mMazeTiles] = 6;
        this.mMaze[3 + 6 * this.mMazeTiles] = 2;
        this.mMaze[4 + 6 * this.mMazeTiles] = 2;
        this.mMaze[5 + 6 * this.mMazeTiles] = 2;
        for (n = 3; n < 6; ++n) {
            for (int i = 3; i < 6; ++i) {
                int n2 = n + i * this.mMazeTiles;
                this.mMaze[n2] = this.mMaze[n2] | 1;
            }
        }
        int n3 = 2 + 4 * this.mMazeTiles;
        this.mMaze[n3] = this.mMaze[n3] | 1;
        int n4 = 6 + 4 * this.mMazeTiles;
        this.mMaze[n4] = this.mMaze[n4] | 1;
        this.mMazeLength[0] = 0;
        this.mMazeLength[1] = 0;
        for (n = 0; n < this.mMazePath[0].length; ++n) {
            this.mMazePath[0][n] = -1;
            this.mMazePath[1][n] = -1;
        }
    }

    int createLabyrinth(int n, int n2, int n3, int n4) {
        boolean bl = false;
        int n5 = 0;
        int n6 = n;
        int n7 = n2;
        int n8 = MiniAnt.rnd(4);
        if (n4 > -1) {
            this.mMazePath[n4][n5] = n + n2 * this.mMazeTiles;
            ++n5;
        }
        while (!bl) {
            n6 = n++;
            n7 = n2--;
            n8 = MiniAnt.rnd(4);
            switch (n8) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ++n2;
                    break;
                }
                case 3: {
                    --n;
                }
            }
            if (n < 0 || n > 8 || n2 < 0 || n2 > 8 || (this.mMaze[n + n2 * this.mMazeTiles] & 1) != 0) {
                n = n6;
                n2 = n7;
            } else {
                int n9 = n + n2 * this.mMazeTiles;
                this.mMaze[n9] = this.mMaze[n9] | 1;
                if (n4 > -1) {
                    this.mMazePath[n4][n5] = n + n2 * this.mMazeTiles;
                }
                ++n5;
                switch (n8) {
                    case 0: {
                        int n10 = n + n2 * this.mMazeTiles;
                        this.mMaze[n10] = this.mMaze[n10] | 6;
                        int n11 = n + 1 + n2 * this.mMazeTiles;
                        this.mMaze[n11] = this.mMaze[n11] | 4;
                        int n12 = n + (n2 + 1) * this.mMazeTiles;
                        this.mMaze[n12] = this.mMaze[n12] & 0xFFFFFFFD;
                        break;
                    }
                    case 1: {
                        int n13 = n + n2 * this.mMazeTiles;
                        this.mMaze[n13] = this.mMaze[n13] | 2;
                        int n14 = n + (n2 + 1) * this.mMazeTiles;
                        this.mMaze[n14] = this.mMaze[n14] | 2;
                        int n15 = n + 1 + n2 * this.mMazeTiles;
                        this.mMaze[n15] = this.mMaze[n15] | 4;
                        int n16 = n + n2 * this.mMazeTiles;
                        this.mMaze[n16] = this.mMaze[n16] & 0xFFFFFFFB;
                        break;
                    }
                    case 2: {
                        int n17 = n + n2 * this.mMazeTiles;
                        this.mMaze[n17] = this.mMaze[n17] & 0xFFFFFFFD;
                        int n18 = n + (n2 + 1) * this.mMazeTiles;
                        this.mMaze[n18] = this.mMaze[n18] | 2;
                        int n19 = n + n2 * this.mMazeTiles;
                        this.mMaze[n19] = this.mMaze[n19] | 4;
                        int n20 = n + 1 + n2 * this.mMazeTiles;
                        this.mMaze[n20] = this.mMaze[n20] | 4;
                        break;
                    }
                    case 3: {
                        int n21 = n + n2 * this.mMazeTiles;
                        this.mMaze[n21] = this.mMaze[n21] | 6;
                        int n22 = n + (n2 + 1) * this.mMazeTiles;
                        this.mMaze[n22] = this.mMaze[n22] | 2;
                        int n23 = n + 1 + n2 * this.mMazeTiles;
                        this.mMaze[n23] = this.mMaze[n23] & 0xFFFFFFFB;
                    }
                }
            }
            bl = !((n != 0 && (this.mMaze[n - 1 + n2 * this.mMazeTiles] & 1) == 0 || n2 != 0 && (this.mMaze[n + (n2 - 1) * this.mMazeTiles] & 1) == 0 || n != 8 && (this.mMaze[n + 1 + n2 * this.mMazeTiles] & 1) == 0 || n2 != 8 && (this.mMaze[n + (n2 + 1) * this.mMazeTiles] & 1) == 0) && n5 != n3);
        }
        return n5;
    }

    private int searchFreeCell() {
        int n = -1;
        boolean bl = false;
        for (int i = 0; i < this.mMaze.length && !bl; ++i) {
            boolean bl2 = bl = (this.mMaze[i] & 1) == 0;
            if (!bl) continue;
            n = i;
        }
        return n;
    }

    private boolean isMapValid() {
        int n = 0;
        if (this.mMazeLength[0] < 10 || this.mMazeLength[1] < 10) {
            return false;
        }
        for (int i = 0; i < this.mMaze.length; ++i) {
            n += (Math.abs(this.mMaze[i]) + 1) * (i + 1);
        }
        if (this.isPreviouslyAnswered(n)) {
            return false;
        }
        this.mLastQuestions[this.mLastQuestionsIndex] = n;
        this.mLastQuestionsIndex = (this.mLastQuestionsIndex + 1) % this.mLastQuestions.length;
        return true;
    }
}

