/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GameEngine {
    public static final int EVENT_NONE = 0;
    public static final int EVENT_PAUSED = 1;
    public static final int EVENT_COMPLETED = 2;
    public static final int KEY_LEFT_MASK = 1;
    public static final int KEY_RIGHT_MASK = 2;
    public static final int KEY_UP_MASK = 4;
    public static final int KEY_DOWN_MASK = 8;
    public static final int KEY_ACTION_MASK = 16;
    public static final int GAMEMODE_PRACTICE = 0;
    public static final int GAMEMODE_CHALLENGE = 1;
    public static final int MG_STROOP = 0;
    public static final int MG_WORD = 1;
    public static final int MG_FIND_ANIMAL = 2;
    public static final int MG_ANT = 3;
    public static final int MG_FLOCK = 4;
    public static final int MG_MIRROR = 5;
    public static final int MG_FROGS = 6;
    public static final int MG_ELEPHANT = 7;
    public static final int MG_MUSIC = 8;
    public static final int MG_BEAR = 9;
    public static final int MG_MORE = 10;
    public static final int MG_MATCH = 11;
    public static final int MG_LADYBUG = 12;
    public static final int MG_FRUITS = 13;
    public static final int MG_FLY = 14;
    public static final int MG_KEY = 15;
    public static final int MG_STARS = 16;
    public static final int MG_SPIT = 17;
    public static final int MG_SPIDER = 18;
    public static final int MG_BIRD = 19;
    public static final int MG_TREES = 20;
    public static final int MG_CHEESE = 21;
    public static final int MG_NUT = 22;
    public static final int MG_MAMMAL = 23;
    public static final int MG_STUPID_TEST = 24;
    public static final int NUMBER_OF_CATEGORIES = 4;
    public static final int MINIGAMES_PER_CATEGORY = 6;
    public static final int CAT_PERCEPTION = 0;
    public static final int CAT_MEMORY = 1;
    public static final int CAT_SPATIAL = 2;
    public static final int CAT_LOGIC = 3;
    public static final int MAX_PERCENTAGE = 100;
    public static MiniGame mCurrentMiniGame;
    public int mMiniGameId;
    public static boolean[] mMiniGameUnlocked;
    public static int[] mMiniGameMedals;
    static final int POPUP_WAIT_TIME = 500;
    public static int mPopupWait;
    public static boolean mShowPopup;
    public static boolean mCleanScreen;
    public int mMiniGameScore;
    public int mMiniGameCorrectAnswers;
    public int mMiniGameWrongAnswers;
    public static boolean mStartMusic;
    private int mKeys;
    private int mPressedSK = -1;
    public static int mGameState;
    private int mLastGameState = -1;
    private static final int GS_NONE = -1;
    private static final int GS_LOADING = 0;
    private static final int GS_GAME = 1;
    private static final int GS_TEXT_BOX = 2;
    public static final int GS_TEST_LOAD_MG = 3;
    private static final int GS_STATISTICS_TEST = 4;
    private static final int GS_STATISTICS_PRACTICE = 5;
    private int mTestLoadSteps = 0;
    private static MenuObject mTextBox;
    private ImageFont gameFont;
    public boolean mCheatsEnabled;
    private static boolean mUpdateSoftKeys;
    public static boolean mFirstTimeStupidTest;
    public static boolean mFirstTimeTestMode;
    private int[] mTestModeSequenceId = new int[]{0, 0, 0, 0};
    public static boolean mRunningTestMode;
    public static int mTestModeIndex;
    public static int mTestModeMaxScore;
    public static String mTestModeMaxScoreStr;
    public static int mHighScoresPlayerPos;
    public static final int[] mHighScores;
    public static final String[] mHighScoresStr;
    public static final String[] mHighScoresIndexStr;
    public static boolean mRunningStupidTest;
    public static boolean mShowingStatistics;
    public static boolean mExitStatistics;
    public static SpriteObject[] mIconCategories;
    public static SpriteObject[] mIconMiniGames;
    public static boolean[] achievementDone;
    private int mStatisticsTimer;
    private int[] fakeSin = new int[]{8, 16, 32, 64, 128, 196, 224, 240, 248, 240, 224, 196, 128, 64, 32, 16};
    public static final int ACTION_CREATE_MG = 1;
    public static final int ACTION_IS_AVAILABLE_MG = 2;
    public static final int[] MINIGAME_NAMES;
    public static final int[] MINIGAME_ICONS;
    public static final int[] ACHIEVEMENTS_NAMES;
    public static final int[] MINIINSTRUCTIONS_ID;
    public static final int[] INSTRUCTIONS_ID;
    public static final int[] TITLES_ID;
    public static String mCurrentMiniGameName;
    public static int mCurrentMiniGameIconId;
    public static int[][][] mCurrentMiniGameScoresPer;
    public static int[][] mCurrentMiniGameScoresMax;
    public static int[][] mCurrentMiniGameTestScoresPer;
    public static boolean popupStatisticsTestShowed;
    public static boolean popupStatisticsPracticeShowed;
    public static int[] mGeneralInt;
    public static final int INT_FALSE = 0;
    public static final int INT_TRUE = 1;
    public static String[] mGeneralStr;
    private static int STR_STAT_TEST_AVERAGE_TITLE;
    private static int STR_STAT_TEST_AVERAGE_VALUE;
    private static int STR_STAT_TEST_SCORES_PER_FIRST;
    private static int STR_TEST_STATISTICS_HELP_TITLE;
    private static int STR_STAT_TEST_COUNT;
    private static final int STR_STAT_PRACTICE_CATEGORY_TITLE = 0;
    private static final int STR_STAT_PRACTICE_MINIGAME_NAME = 1;
    private static final int STR_STAT_PRACTICE_MINIGAME_SCORES_FIRST = 2;
    private static int STR_PRACTICE_STATISTICS_HELP_TITLE;
    private static final int STR_STAT_PRACTICE_COUNT = 9;
    public static boolean bSoundFlag;
    private int mPointArrowX;
    private int mPointArrowX1;
    private int mPointArrowX2;
    private int mPointArrowY;
    private int mPointArrowY1;
    private int mPointArrowY2;
    private int mPointArrowW;
    private int mPointArrowH;
    private int mPointArrowW1;
    private int mPointArrowH1;
    private int mPointPivotX1;
    private int mPointPivotX2;
    private int mPointPivotY1;
    private int mPointPivotY2;
    public SpriteObject mBackground;
    public SpriteObject mCategorieSelection;
    public SpriteObject mNoteBook;
    public int mCanvasX;
    public int mCanvasY;
    public int mCanvasWidth;
    public int mCanvasHeight;
    private int mStatisticsSelection;
    private int mStatisticsSelectionTest;
    private int mStatisticsSubSelection;
    int mNoteBookX;
    int mNoteBookY;
    static final int TRIGONOMETRIC_PRECISSION = 10;
    public static short[] sintable;
    public static short[] costable;
    public static short[] tantable;
    static int[] scrollTextSTE;
    static int[] formTitleSTE;
    static int[] formCathegoryTitleSTE;
    public static final int STE_AREA_SIZE = 0;
    public static final int STE_TEXT_SIZE = 1;
    public static final int STE_SIDE = 2;
    public static final int STE_POS = 3;
    public static final int STE_POSFP = 5;
    public static final int STE_PAUSE = 4;
    public static final int STE_VAR_SIZE = 6;

    public GameEngine(ImageFont imageFont, ImageFont imageFont2, ImageFont imageFont3) {
        int n;
        int n2;
        mCleanScreen = false;
        this.gameFont = imageFont2;
        this.trigon_init();
        for (n2 = 0; n2 < mCurrentMiniGameScoresPer.length; ++n2) {
            for (n = 0; n < mCurrentMiniGameScoresPer[n2].length; ++n) {
                for (int i = 0; i < mCurrentMiniGameScoresPer[n2][n].length; ++i) {
                    GameEngine.mCurrentMiniGameScoresPer[n2][n][i] = i == 0 ? 0 : -1;
                }
            }
        }
        for (n2 = 0; n2 < mCurrentMiniGameTestScoresPer.length; ++n2) {
            for (n = 0; n < mCurrentMiniGameTestScoresPer[n2].length; ++n) {
                GameEngine.mCurrentMiniGameTestScoresPer[n2][n] = n == 0 ? 0 : -1;
            }
        }
        GameEngine.mIconCategories[0] = new SpriteObject(SpriteObject.loadAnimation(196703), false);
        GameEngine.mIconCategories[1] = new SpriteObject(SpriteObject.loadAnimation(196719), false);
        GameEngine.mIconCategories[2] = new SpriteObject(SpriteObject.loadAnimation(262145), false);
        GameEngine.mIconCategories[3] = new SpriteObject(SpriteObject.loadAnimation(196675), false);
        for (n2 = 0; n2 < achievementDone.length; ++n2) {
            GameEngine.achievementDone[n2] = false;
        }
    }

    public static boolean miniGameQuerys(int n, int n2) {
        if (n == 0) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniStroop(40000, -1);
            }
            return true;
        }
        if (n == 1) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniWord(50000, -1);
            }
            return true;
        }
        if (n == 2) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniAnimal(40000, -1);
            }
            return true;
        }
        if (n == 3) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniAnt(40000, -1);
            }
            return true;
        }
        if (n == 4) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniMore(40000, -1);
            }
            return true;
        }
        if (n == 5) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniKeys(40000, -1);
            }
            return true;
        }
        if (n == 6) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniFrogs(40000, -1);
            }
            return true;
        }
        if (n == 7) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniElephant(40000, -1);
            }
            return true;
        }
        if (n == 8) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniMusic(40000, -1);
            }
            return true;
        }
        if (n == 9) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniMaze(45000, -1);
            }
            return true;
        }
        if (n == 10) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniMore(40000, -1);
            }
            return true;
        }
        if (n == 11) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniFruits(40000, -1);
            }
            return true;
        }
        if (n == 12) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniBallLine(40000, -1);
            }
            return true;
        }
        if (n == 13) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniFruits(30000, -1);
            }
            return true;
        }
        if (n == 14) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniChamaleon(40000, -1);
            }
            return true;
        }
        if (n == 15) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniKeys(40000, -1);
            }
            return true;
        }
        if (n == 16) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniStars(40000, -1);
            }
            return true;
        }
        if (n == 17) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniSpit(40000, -1);
            }
            return true;
        }
        if (n == 18) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniSpider(40000, -1);
            }
            return true;
        }
        if (n == 19) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniBird(40000, -1);
            }
            return true;
        }
        if (n == 20) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniMaze(45000, -1);
            }
            return true;
        }
        if (n == 21) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniCheese(60000, -1);
            }
            return true;
        }
        if (n == 22) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniMaze(45000, -1);
            }
            return true;
        }
        if (n == 23) {
            if (n2 == 1) {
                mCurrentMiniGame = new MiniLogicMammals(60000, -1);
            }
            return true;
        }
        return n == 24;
    }

    public void gameInit(int n, int n2) {
        MiniGame.smFont = this.gameFont;
        mRunningTestMode = false;
        mRunningStupidTest = false;
        if (n == 12) {
            switch (n2) {
                case 0: {
                    mRunningTestMode = true;
                    if (mFirstTimeTestMode) {
                        this.mTestModeSequenceId[0] = 2;
                        this.mTestModeSequenceId[1] = 8;
                        this.mTestModeSequenceId[2] = 12;
                        this.mTestModeSequenceId[3] = 20;
                    } else {
                        boolean bl = false;
                        do {
                            this.mTestModeSequenceId[0] = 0 + MiniGame.rnd(6);
                            bl = GameEngine.miniGameQuerys(this.mTestModeSequenceId[0], 2);
                            this.mTestModeSequenceId[1] = 6 + MiniGame.rnd(6);
                            bl = bl && GameEngine.miniGameQuerys(this.mTestModeSequenceId[1], 2);
                            this.mTestModeSequenceId[2] = 12 + MiniGame.rnd(6);
                            bl = bl && GameEngine.miniGameQuerys(this.mTestModeSequenceId[2], 2);
                            this.mTestModeSequenceId[3] = 18 + MiniGame.rnd(6);
                        } while (!(bl = bl && GameEngine.miniGameQuerys(this.mTestModeSequenceId[3], 2)));
                    }
                    mTestModeIndex = 0;
                    this.mTestLoadSteps = 0;
                    MiniGame.smFont = this.gameFont;
                    MiniGame.mMiniGameID = this.mMiniGameId = this.mTestModeSequenceId[mTestModeIndex];
                    mCurrentMiniGameName = Toolkit.getText(MINIGAME_NAMES[this.mMiniGameId]);
                    mCurrentMiniGameIconId = MINIGAME_ICONS[this.mMiniGameId];
                    GameEngine.miniGameQuerys(this.mMiniGameId, 1);
                    ++mTestModeIndex;
                    if (!mFirstTimeTestMode) break;
                    GameEngine.createTextBox(162, 163, null, false);
                    mFirstTimeTestMode = false;
                    break;
                }
                case 2: {
                    MiniGame.mMiniGameID = this.mMiniGameId = 24;
                    mCurrentMiniGameName = Toolkit.getText(MINIGAME_NAMES[this.mMiniGameId]);
                    mCurrentMiniGameIconId = MINIGAME_ICONS[this.mMiniGameId];
                    mCurrentMiniGame = new StupidTest(-1, 15);
                    if (mFirstTimeStupidTest) {
                        GameEngine.createTextBox(160, 161, null, false);
                        mFirstTimeStupidTest = false;
                    }
                    mRunningStupidTest = true;
                }
            }
        } else if (n == 21) {
            mShowingStatistics = true;
            mExitStatistics = false;
            switch (n2) {
                case 0: {
                    this.mStatisticsSelectionTest = GameEngine.getLastTest();
                    this.changeGameState(4);
                    break;
                }
                case 1: {
                    mIconMiniGames = new SpriteObject[MINIGAME_ICONS.length];
                    for (int i = 0; i < MINIGAME_ICONS.length; ++i) {
                        GameEngine.mIconMiniGames[i] = new SpriteObject(SpriteObject.loadAnimation(MINIGAME_ICONS[i]), false);
                    }
                    this.mStatisticsSelection = 0;
                    this.mStatisticsSubSelection = 0;
                    while (!GameEngine.miniGameQuerys(this.mStatisticsSubSelection, 2)) {
                        ++this.mStatisticsSubSelection;
                    }
                    this.changeGameState(5);
                }
            }
            this.mNoteBookX = Toolkit.getScreenWidth() >> 1;
            this.mNoteBookY = (Toolkit.getScreenHeight() - Toolkit.getSoftKeyAreaHeight()) / 2;
            this.mCategorieSelection = new SpriteObject(SpriteObject.loadAnimation(393235), true);
            if (this.mBackground == null) {
                this.mBackground = new SpriteObject(SpriteObject.loadAnimation(786443), false);
                this.mNoteBook = new SpriteObject(SpriteObject.loadAnimation(851969), false);
                short[] sArray = this.mNoteBook.getCurrentAnimationData();
                int n3 = this.mNoteBook.getCollisionBoxes();
                n3 += 2;
                this.mCanvasX = sArray[n3++] + this.mNoteBookX;
                this.mCanvasY = sArray[n3++] + this.mNoteBookY;
                this.mCanvasWidth = sArray[n3++];
                this.mCanvasHeight = sArray[n3++];
            }
        } else {
            MiniGame.mMiniGameID = this.mMiniGameId = n * 6 + n2;
            mCurrentMiniGameName = Toolkit.getText(MINIGAME_NAMES[this.mMiniGameId]);
            mCurrentMiniGameIconId = MINIGAME_ICONS[this.mMiniGameId];
            GameEngine.miniGameQuerys(this.mMiniGameId, 1);
        }
    }

    public void gameDestroy() {
        if (mCurrentMiniGame != null) {
            this.mMiniGameScore = GameEngine.mCurrentMiniGame.mScore;
            this.mMiniGameCorrectAnswers = GameEngine.mCurrentMiniGame.mCorrectAnswers;
            this.mMiniGameWrongAnswers = GameEngine.mCurrentMiniGame.mWrongAnswers;
            this.destroyTextBox();
            mCurrentMiniGame.destroy();
            mCurrentMiniGame = null;
            mRunningStupidTest = false;
            mStartMusic = true;
        }
        this.changeGameState(0);
        mGeneralStr = null;
    }

    private void changeGameState(int n) {
        this.mLastGameState = mGameState;
        mGameState = n;
        if (n == 3) {
            DCPack.mLoadingTimer = 0;
            DCPack.mLoadingFinished = false;
        } else if (n == 4 && mGeneralStr == null) {
            mGeneralStr = new String[STR_STAT_TEST_COUNT];
            GameEngine.mGeneralStr[GameEngine.STR_STAT_TEST_AVERAGE_TITLE] = Toolkit.getText(430);
            GameEngine.mGeneralStr[GameEngine.STR_TEST_STATISTICS_HELP_TITLE] = Toolkit.getText(55);
            this.updateStatisticsFields();
        } else if (n == 5 && mGeneralStr == null) {
            mGeneralStr = new String[9];
            this.statsPracticeUpdate();
        }
        mUpdateSoftKeys = true;
    }

    public int logicUpdate(int n) {
        if (mGameState == 0) {
            this.changeGameState(1);
            this.updateSoftKeys();
        }
        if (mShowPopup && mGameState != 2) {
            this.changeGameState(2);
            if (mPopupWait <= 0) {
                mTextBox.setVisible();
            }
        }
        if (mUpdateSoftKeys) {
            this.updateSoftKeys();
            mUpdateSoftKeys = false;
        }
        if (this.mPressedSK != -1) {
            int n2 = this.mPressedSK;
            this.resetKeys();
            if (n2 == 9) {
                return 1;
            }
        }
        switch (mGameState) {
            case 1: {
                mCurrentMiniGame.logicUpdate(n);
                if (mShowPopup) {
                    this.changeGameState(2);
                    mTextBox.setVisible();
                }
                if (!GameEngine.mCurrentMiniGame.mIsFinished) break;
                if (mRunningTestMode && mTestModeIndex < 4) {
                    bSoundFlag = false;
                    this.changeGameState(3);
                    this.mTestLoadSteps = 0;
                    break;
                }
                return 2;
            }
            case 2: {
                if (mPopupWait > 0) {
                    if ((mPopupWait -= n) <= 0) {
                        this.updateSoftKeys();
                    }
                } else {
                    mTextBox.logicUpdate(n);
                }
                if (!mShowPopup) {
                    this.destroyTextBox();
                    this.changeGameState(this.mLastGameState);
                }
                MiniGame.bKeyEventFlag = false;
                break;
            }
            case 3: {
                DCPack.mLoadingTimer += n;
                if (this.mTestLoadSteps == 10) {
                    if (mCurrentMiniGame != null) {
                        mCurrentMiniGame.destroy();
                        mCurrentMiniGame = null;
                    }
                } else if (this.mTestLoadSteps == 50) {
                    if (mCurrentMiniGame == null) {
                        MiniGame.smFont = this.gameFont;
                        MiniGame.mMiniGameID = this.mMiniGameId = this.mTestModeSequenceId[mTestModeIndex];
                        mCurrentMiniGameName = Toolkit.getText(MINIGAME_NAMES[this.mMiniGameId]);
                        mCurrentMiniGameIconId = MINIGAME_ICONS[this.mMiniGameId];
                        GameEngine.miniGameQuerys(this.mMiniGameId, 1);
                        ++mTestModeIndex;
                    }
                } else if (this.mTestLoadSteps == 100) {
                    this.changeGameState(1);
                    if (bSoundFlag) {
                        Game.mPauseEventScheduled = true;
                        bSoundFlag = false;
                    }
                }
                this.mTestLoadSteps += 10;
                break;
            }
            case 4: {
                if (formTitleSTE != null) {
                    GameEngine.scrollTextEngine(n, formTitleSTE, true);
                }
                this.mStatisticsTimer += n;
                if (!popupStatisticsTestShowed) {
                    GameEngine.createTextBox(166, 167, null, false);
                    popupStatisticsTestShowed = true;
                }
                if (!mExitStatistics) break;
                formTitleSTE = null;
                this.changeGameState(1);
                return 2;
            }
            case 5: {
                if (formTitleSTE != null) {
                    GameEngine.scrollTextEngine(n, formTitleSTE, true);
                }
                if (scrollTextSTE != null) {
                    GameEngine.scrollTextEngine(n, scrollTextSTE, true);
                }
                if (formCathegoryTitleSTE != null) {
                    GameEngine.scrollTextEngine(n, formCathegoryTitleSTE, true);
                }
                if (!popupStatisticsPracticeShowed) {
                    GameEngine.createTextBox(168, 169, null, false);
                    popupStatisticsPracticeShowed = true;
                }
                if (!mExitStatistics) break;
                this.changeGameState(1);
                scrollTextSTE = null;
                formTitleSTE = null;
                formCathegoryTitleSTE = null;
                mIconMiniGames = null;
                return 2;
            }
        }
        return 0;
    }

    public void doDraw(Graphics graphics) {
        int n = mGameState;
        if (n == 2) {
            n = this.mLastGameState;
        }
        switch (n) {
            case 1: {
                if (mCurrentMiniGame == null) break;
                try {
                    mCurrentMiniGame.draw(graphics);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 3: {
                DCPack.drawLoadingScreen(graphics, null, this.mTestLoadSteps, 35);
                break;
            }
            case 4: {
                int n2;
                int n3;
                int n4;
                int n5;
                int[] nArray;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10 = this.mCanvasY;
                int n11 = Toolkit.getScreenWidth() / this.mBackground.getWidth();
                int n12 = Toolkit.getScreenHeight() / this.mBackground.getHeight();
                for (n9 = 0; n9 <= n11; ++n9) {
                    for (n8 = 0; n8 <= n12; ++n8) {
                        this.mBackground.draw(graphics, n9 * this.mBackground.getWidth(), n8 * this.mBackground.getHeight());
                    }
                }
                this.mNoteBook.draw(graphics, this.mNoteBookX, this.mNoteBookY);
                if (this.mCanvasY > this.gameFont.getHeight() + 12) {
                    n11 = this.mCanvasY - this.gameFont.getHeight() + 1;
                    this.gameFont.drawString(graphics, mGeneralStr[STR_TEST_STATISTICS_HELP_TITLE], this.mCanvasX + (this.mCanvasWidth >> 1), n11 + 0, 17);
                }
                n11 = GameEngine.getLastTest();
                if (formTitleSTE == null) {
                    formTitleSTE = new int[6];
                    GameEngine.formTitleSTE[0] = this.mCanvasWidth;
                    GameEngine.formTitleSTE[1] = this.gameFont.stringWidth(mGeneralStr[STR_STAT_TEST_AVERAGE_TITLE]);
                }
                if (formTitleSTE[1] > formTitleSTE[0]) {
                    graphics.setClip(this.mCanvasX, 0, this.mCanvasWidth, this.mCanvasHeight);
                    this.gameFont.drawString(graphics, mGeneralStr[STR_STAT_TEST_AVERAGE_TITLE], formTitleSTE[3] + this.mCanvasX, n10, 20);
                } else {
                    this.gameFont.drawString(graphics, mGeneralStr[STR_STAT_TEST_AVERAGE_TITLE], this.mCanvasX + (this.mCanvasWidth >> 1), n10 + 0, 17);
                }
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                this.gameFont.drawString(graphics, mGeneralStr[STR_STAT_TEST_AVERAGE_VALUE], this.mCanvasX + (this.mCanvasWidth >> 1), (n10 += this.gameFont.getHeight()) + 0, 17);
                n12 = 2;
                n9 = -1 + this.mCanvasHeight - ((n10 += this.gameFont.getHeight() + 6) - this.mCanvasY) - n12 - 6 - this.gameFont.getHeight();
                n9 -= mIconCategories[0].getHeight();
                n8 = Math.max(this.mCanvasWidth >> 4, MenuObject.smScrollLeftAnimations.getWidth() + 2);
                if (GameEngine.getLastTest() > 0) {
                    this.mPointArrowX = this.mCanvasX + (MenuObject.smScrollArrowLeftSpace >> 1);
                    this.mPointArrowX1 = this.mCanvasX + this.mCanvasWidth - (MenuObject.smScrollArrowRightSpace >> 1);
                    this.mPointArrowY = n10 + (n9 >> 1) + 6;
                    MenuObject.smScrollLeftAnimations.draw(graphics, this.mPointArrowX, this.mPointArrowY);
                    MenuObject.smScrollRightAnimations.draw(graphics, this.mPointArrowX1, this.mPointArrowY);
                }
                graphics.setClip(this.mCanvasX, this.mCanvasY, this.mCanvasWidth, this.mCanvasHeight);
                graphics.setColor(0x808080);
                graphics.fillRect(this.mCanvasX + n8, n10, n12, n9);
                graphics.fillRect(this.mCanvasX + n8, n10 + n9, this.mCanvasWidth - (n8 << 1), n12);
                int n13 = this.mCanvasWidth - (n8 << 1) - (n12 << 1);
                if (n11 > 0) {
                    n7 = this.fakeSin[(this.mStatisticsTimer >> 6) % this.fakeSin.length];
                    n7 >>= 1;
                    n7 = n7 + (n7 << 8) + (n7 << 16);
                    graphics.setColor(0x606060 + n7);
                    graphics.drawLine(this.mCanvasX + n8 + n12 + this.mStatisticsSelectionTest * (n13 / 4), n10 + n9, this.mCanvasX + n8 + n12 + this.mStatisticsSelectionTest * (n13 / 4), n10);
                }
                n7 = 0;
                for (n6 = 0; n6 < 4; ++n6) {
                    graphics.setColor(MiniGame.categoryColors[n6]);
                    nArray = mCurrentMiniGameTestScoresPer[n6];
                    for (n5 = 0; n5 < 4; ++n5) {
                        n4 = n5 * (n13 / 4);
                        n3 = nArray[n5];
                        if (n3 > 100) {
                            n3 = 100;
                        }
                        n3 = n3 * n9 / 100;
                        int n14 = n10 + n9 - n3;
                        int n15 = (n5 + 1) * (n13 / 4);
                        int n16 = nArray[n5 + 1];
                        if (n16 > 100) {
                            n16 = 100;
                        }
                        n16 = n16 * n9 / 100;
                        int n17 = n10 + n9 - n16;
                        if (nArray[n5 + 1] == -1) continue;
                        graphics.drawLine(this.mCanvasX + n8 + n12 + n4, n14, this.mCanvasX + n8 + n12 + n15, n17);
                    }
                }
                for (n6 = 0; n6 < 4; ++n6) {
                    graphics.setColor(MiniGame.categoryColors[n6]);
                    nArray = mCurrentMiniGameTestScoresPer[n6];
                    n5 = nArray[this.mStatisticsSelectionTest];
                    if (n5 > 100) {
                        n5 = 100;
                    }
                    n5 = n5 * n9 / 100;
                    n4 = n10 + n9 - n5;
                    n3 = 7;
                    graphics.fillArc(this.mCanvasX + n8 + n12 + this.mStatisticsSelectionTest * (n13 / 4) - (n3 >> 1), n4 - (n3 >> 1), n3, n3, 0, 360);
                }
                n10 += n9 + 6 + n12;
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                n6 = mIconCategories[0].getWidth();
                for (n2 = 0; n2 < 4; ++n2) {
                    graphics.setColor(MiniGame.categoryColors[n2]);
                    n5 = this.mCanvasX + (this.mCanvasWidth - (n6 + 1 << 2) >> 1);
                    graphics.fillRect(n5 + (n6 + 1) * n2, n10, n6, this.gameFont.getHeight() + 1);
                    this.gameFont.drawString(graphics, mGeneralStr[STR_STAT_TEST_SCORES_PER_FIRST + n2], n5 + (n6 + 1) * n2 + (n6 >> 1), n10 + 1, 17);
                }
                n10 += this.gameFont.getHeight() + 3;
                n2 = mIconCategories[0].getWidth() + 1;
                n5 = this.mCanvasX + (this.mCanvasWidth - (n2 << 2) >> 1) + mIconCategories[0].getPivotX();
                n10 += mIconCategories[0].getHeight() >> 1;
                for (n4 = 0; n4 < 4; ++n4) {
                    mIconCategories[n4].draw(graphics, n5 + n2 * n4, n10);
                }
                break;
            }
            case 5: {
                int n18;
                int n19;
                int n20;
                int n21;
                int n22 = -1;
                int n23 = -1;
                if (mShowPopup && mPopupWait <= 0) {
                    if (MenuObject.smScrollUpAnimations.getCurrentAnimationIndex() != 0) {
                        n22 = MenuObject.smScrollUpAnimations.getCurrentAnimationIndex();
                        MenuObject.smScrollUpAnimations.setAnimation(0, 0, true);
                    }
                    if (MenuObject.smScrollDownAnimations.getCurrentAnimationIndex() != 0) {
                        n23 = MenuObject.smScrollDownAnimations.getCurrentAnimationIndex();
                        MenuObject.smScrollDownAnimations.setAnimation(0, 0, true);
                    }
                }
                int n24 = this.mCanvasY;
                int n25 = Toolkit.getScreenWidth() / this.mBackground.getWidth();
                int n26 = Toolkit.getScreenHeight() / this.mBackground.getHeight();
                for (n21 = 0; n21 <= n25; ++n21) {
                    for (n20 = 0; n20 <= n26; ++n20) {
                        this.mBackground.draw(graphics, n21 * this.mBackground.getWidth(), n20 * this.mBackground.getHeight());
                    }
                }
                this.mNoteBook.draw(graphics, this.mNoteBookX, this.mNoteBookY);
                if (this.mCanvasY > this.gameFont.getHeight() + 12) {
                    n25 = this.mCanvasY - this.gameFont.getHeight() + 1;
                    this.gameFont.drawString(graphics, mGeneralStr[STR_PRACTICE_STATISTICS_HELP_TITLE], this.mCanvasX + (this.mCanvasWidth >> 1), n25 + 0, 17);
                }
                this.gameFont.drawString(graphics, mGeneralStr[0], this.mCanvasX + 6, n24, 20);
                n24 += this.gameFont.getHeight() + 6;
                n24 = this.drawTestIconList(graphics, this.mStatisticsSelection, n24);
                n25 = 2;
                n26 = this.mCanvasHeight - ((n24 += this.gameFont.getHeight()) - this.mCanvasY) - n25 - 6 - this.gameFont.getHeight();
                n24 -= this.gameFont.getHeight();
                n21 = this.mCanvasWidth >> 4;
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                n20 = this.mCanvasWidth - (n21 << 1) - (n25 << 1);
                int n27 = 6 + this.mCanvasX + n21 + n25;
                int n28 = this.mStatisticsSelection * 6 + this.mStatisticsSubSelection;
                int n29 = n24 + (MenuObject.smScrollUpAnimations.getHeight() >> 1);
                if (mIconMiniGames != null) {
                    this.mPointArrowX = this.mCanvasX + (mIconMiniGames[n28].getWidth() + MenuObject.smScrollUpAnimations.getWidth() >> 1);
                    this.mPointArrowY1 = n29;
                    MenuObject.smScrollUpAnimations.draw(graphics, this.mPointArrowX, this.mPointArrowY1);
                    mIconMiniGames[n28].draw(graphics, n27 + (mIconMiniGames[n28].getPivotX() >> 1), n29 += (MenuObject.smScrollUpAnimations.getHeight() >> 1) + (mIconMiniGames[n28].getHeight() >> 1) + 6);
                    n27 += 6;
                    this.mPointArrowY2 = n29 += (mIconMiniGames[n28].getHeight() >> 1) + (MenuObject.smScrollDownAnimations.getHeight() >> 1) + 6;
                    MenuObject.smScrollDownAnimations.draw(graphics, this.mPointArrowX, this.mPointArrowY2);
                }
                n27 += mIconCategories[0].getWidth();
                n20 -= mIconCategories[0].getWidth();
                if (n22 != -1) {
                    MenuObject.smScrollUpAnimations.setAnimation(n22, 0, true);
                }
                if (n23 != -1) {
                    MenuObject.smScrollDownAnimations.setAnimation(n23, 0, true);
                }
                n24 += this.gameFont.getHeight();
                if (formTitleSTE == null) {
                    formTitleSTE = new int[6];
                }
                GameEngine.formTitleSTE[0] = n20;
                GameEngine.formTitleSTE[1] = this.gameFont.stringWidth(mGeneralStr[1]);
                graphics.setClip(n27, 0, n20, Toolkit.getScreenHeight());
                this.gameFont.drawString(graphics, mGeneralStr[1], formTitleSTE[3] + n27, n24 - this.gameFont.getHeight(), 20);
                graphics.setClip(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                n29 = (n20 - 42) / 6;
                graphics.setColor(0x808080);
                graphics.fillRect(n27 - n21 - n25, n24, n25, n26);
                graphics.fillRect(n27 - n21 - n25, n24 + n26, n20 + n21, n25);
                for (n19 = 0; n19 < 6; ++n19) {
                    if (n19 == this.mStatisticsSubSelection) {
                        graphics.setColor(MiniGame.categoryColors[this.mStatisticsSelection]);
                    } else {
                        graphics.setColor(0xA0A0A0);
                    }
                    n18 = mCurrentMiniGameScoresMax[this.mStatisticsSelection][n19];
                    if (n18 > 100) {
                        n18 = 100;
                    }
                    if ((n18 = n18 * n26 / 100) == 0 && mCurrentMiniGameScoresMax[this.mStatisticsSelection][n19] > 0) {
                        n18 = 1;
                    }
                    graphics.fillRect(n27 + (6 + n29) * n19, n24 + n26 - n18, n29, n18);
                }
                n19 = 2 + this.mStatisticsSubSelection;
                n18 = this.gameFont.stringWidth(mGeneralStr[n19]);
                if (n18 > n20) {
                    if (scrollTextSTE == null) {
                        scrollTextSTE = new int[6];
                    }
                    GameEngine.scrollTextSTE[0] = n20;
                    GameEngine.scrollTextSTE[1] = n18;
                    graphics.setClip(n27, 0, n20, Toolkit.getScreenHeight());
                    this.gameFont.drawString(graphics, mGeneralStr[n19], scrollTextSTE[3] + n27, n24 + n26 + n25 + 3, 20);
                    break;
                }
                this.gameFont.drawString(graphics, mGeneralStr[n19], n27 + (n20 - n21 - n25 >> 1), n24 + n26 + n25 + 3, 17);
            }
        }
        if (mTextBox != null && mShowPopup && mPopupWait <= 0) {
            mTextBox.doDraw(graphics, 6, 6);
        }
    }

    private int drawTestIconList(Graphics graphics, int n, int n2) {
        boolean bl = true;
        int n3 = mIconCategories[0].getWidth() + 1;
        int n4 = bl ? this.mCanvasX + (this.mCanvasWidth >> 1) : this.mCanvasX + (this.mCanvasWidth - (n3 << 2) >> 1) + mIconCategories[0].getPivotX();
        n2 += mIconCategories[0].getHeight() >> 1;
        if (bl) {
            mIconCategories[n].draw(graphics, n4, n2);
            this.mCategorieSelection.draw(graphics, n4, n2);
            this.mPointArrowX1 = n4 - (this.mCategorieSelection.getWidth() >> 1) - (MenuObject.smScrollLeftAnimations.getWidth() >> 1) - 6;
            this.mPointArrowX2 = n4 + (this.mCategorieSelection.getWidth() >> 1) + (MenuObject.smScrollRightAnimations.getWidth() >> 1) + 6;
            this.mPointArrowY = n2;
            MenuObject.smScrollLeftAnimations.draw(graphics, this.mPointArrowX1, n2);
            MenuObject.smScrollRightAnimations.draw(graphics, this.mPointArrowX2, n2);
        } else {
            for (int i = 0; i < 4; ++i) {
                mIconCategories[i].draw(graphics, n4 + n3 * i, n2);
            }
            this.mPointArrowX1 = n4 - (mIconCategories[0].getWidth() >> 1) - (MenuObject.smScrollLeftAnimations.getWidth() >> 1) - 6;
            this.mPointArrowX2 = n4 + n3 * 3 + (mIconCategories[0].getWidth() >> 1) + (MenuObject.smScrollRightAnimations.getWidth() >> 1) + 6;
            this.mPointArrowY = n2;
            this.mCategorieSelection.draw(graphics, n4 + n3 * n, n2);
            MenuObject.smScrollLeftAnimations.draw(graphics, this.mPointArrowX1, n2);
            MenuObject.smScrollRightAnimations.draw(graphics, this.mPointArrowX2, n2);
        }
        return n2 + (mIconCategories[0].getHeight() >> 1) + 6;
    }

    public static int getLastTest() {
        int n;
        int n2 = 0;
        boolean bl = false;
        int[] nArray = mCurrentMiniGameTestScoresPer[0];
        while (!bl && n2 < nArray.length) {
            if (nArray[n2] == -1) {
                bl = true;
                continue;
            }
            ++n2;
        }
        --n2;
        boolean bl2 = true;
        for (n = 0; n < mCurrentMiniGameTestScoresPer.length; ++n) {
            if (mCurrentMiniGameTestScoresPer[n][n2] != -1) continue;
            bl2 = false;
        }
        if (!bl2) {
            for (n = 0; n < mCurrentMiniGameTestScoresPer.length; ++n) {
                GameEngine.mCurrentMiniGameTestScoresPer[n][n2] = -1;
            }
            --n2;
        }
        return n2;
    }

    public void updateStatisticsFields() {
        int n;
        int n2 = 0;
        for (n = 0; n < mCurrentMiniGameTestScoresPer.length; ++n) {
            n2 += mCurrentMiniGameTestScoresPer[n][this.mStatisticsSelectionTest];
        }
        GameEngine.mGeneralStr[GameEngine.STR_STAT_TEST_AVERAGE_VALUE] = (n2 /= 4) + "%";
        for (n = 0; n < 4; ++n) {
            String string = "" + mCurrentMiniGameTestScoresPer[n][this.mStatisticsSelectionTest];
            GameEngine.mGeneralStr[GameEngine.STR_STAT_TEST_SCORES_PER_FIRST + n] = string = string + "%";
        }
    }

    public static void createTextBox(int n, int n2, String string, boolean bl) {
        int n3 = Toolkit.getScreenWidth();
        int n4 = Toolkit.getScreenHeight() * 60 / 100;
        mTextBox = new MenuObject();
        mTextBox.setScreen(1, 2, 0);
        mTextBox.configSpeechBubble(true, true, true);
        mTextBox.setStyle(5);
        String string2 = Toolkit.getText(n2);
        if (string != null) {
            string2 = Toolkit.replaceParameters(string2, new String[]{string});
        }
        mTextBox.setItem(0, 1, string2, null, 0);
        n4 = mTextBox.getPreferredHeight(n3, n4);
        mTextBox.setSize(n3, n4);
        mShowPopup = true;
        mPopupWait = bl ? 500 : 0;
        mUpdateSoftKeys = true;
    }

    private void destroyTextBox() {
        this.updateSoftKeys();
        if (mTextBox != null) {
            mTextBox.destroyItem(0);
            mTextBox = null;
        }
    }

    public void keyEventOccurred(int n, int n2) {
        if (MiniGame.bKeyEventFlag) {
            return;
        }
        if (n2 == 3) {
            this.mPressedSK = n;
            if (mGameState != 3) {
                if (mShowPopup && mPopupWait <= 0) {
                    mTextBox.keyEventOccurred(n, n2);
                } else if (mCurrentMiniGame != null) {
                    mCurrentMiniGame.keyEvent(n, n2);
                } else {
                    mExitStatistics = true;
                }
            }
        } else if (n2 == 0 || n2 == 1) {
            int n3 = Toolkit.getToolkitGameAction(n);
            if (mGameState == 3) {
                return;
            }
            int n4 = 0;
            switch (n3) {
                case 52: {
                    n4 = 1;
                    break;
                }
                case 54: {
                    n4 = 2;
                    break;
                }
                case 50: {
                    n4 = 4;
                    break;
                }
                case 56: {
                    n4 = 8;
                    break;
                }
                case 53: {
                    n4 = 16;
                }
            }
            if (n2 == 0) {
                this.mKeys |= n4;
                if (mShowPopup && mPopupWait <= 0) {
                    mTextBox.keyEventOccurred(n, n2);
                } else if (mCurrentMiniGame != null) {
                    mCurrentMiniGame.keyEvent(n, n2);
                } else if (mShowingStatistics) {
                    if ((n4 & 1) != 0) {
                        --this.mStatisticsSelectionTest;
                        if (this.mStatisticsSelectionTest < 0) {
                            this.mStatisticsSelectionTest = 0;
                        }
                        this.mStatisticsSelection = (this.mStatisticsSelection + 3) % 4;
                        this.mStatisticsSubSelection = 0;
                        if (mGameState == 5) {
                            while (!GameEngine.miniGameQuerys(this.mStatisticsSubSelection + this.mStatisticsSelection * 6, 2)) {
                                ++this.mStatisticsSubSelection;
                            }
                            formTitleSTE = null;
                        }
                        this.updateStatisticsFields();
                    }
                    if ((n4 & 2) != 0) {
                        int n5 = GameEngine.getLastTest();
                        ++this.mStatisticsSelectionTest;
                        if (this.mStatisticsSelectionTest > n5) {
                            this.mStatisticsSelectionTest = n5;
                        }
                        ++this.mStatisticsSelection;
                        this.mStatisticsSelection %= 4;
                        this.mStatisticsSubSelection = 0;
                        if (mGameState == 5) {
                            while (!GameEngine.miniGameQuerys(this.mStatisticsSubSelection + this.mStatisticsSelection * 6, 2)) {
                                ++this.mStatisticsSubSelection;
                            }
                            formTitleSTE = null;
                        }
                        this.updateStatisticsFields();
                    }
                    if (mGameState == 5 && (n4 & 4) != 0) {
                        do {
                            this.mStatisticsSubSelection = (this.mStatisticsSubSelection + 5) % 6;
                        } while (!GameEngine.miniGameQuerys(this.mStatisticsSubSelection + this.mStatisticsSelection * 6, 2));
                        formTitleSTE = null;
                    }
                    if (mGameState == 5 && (n4 & 8) != 0) {
                        do {
                            ++this.mStatisticsSubSelection;
                            this.mStatisticsSubSelection %= 6;
                        } while (!GameEngine.miniGameQuerys(this.mStatisticsSubSelection + this.mStatisticsSelection * 6, 2));
                        formTitleSTE = null;
                    }
                    if (mGameState == 5) {
                        this.statsPracticeUpdate();
                    }
                }
            } else {
                this.mKeys &= ~n4;
                if (mShowPopup && mPopupWait <= 0) {
                    mTextBox.keyEventOccurred(n, n2);
                } else if (mCurrentMiniGame != null) {
                    mCurrentMiniGame.keyEvent(n, n2);
                }
            }
        }
    }

    public void pointerEventOccurred(int n, int n2, int n3) {
        if (mTextBox != null) {
            mTextBox.pointerEventOccurred(n, n2, n3);
        }
        if (mCurrentMiniGame != null) {
            mCurrentMiniGame.pointerEventOccurred(n, n2, n3);
        } else {
            int n4;
            int n5;
            if (mGameState == 4 && n3 == 0 && this.mPointArrowX > 0 && this.mPointArrowY > 0) {
                n5 = this.mPointArrowX - this.mPointPivotX1;
                n4 = this.mPointArrowY - this.mPointPivotY1;
                if (n > n5 && n <= n5 + this.mPointArrowW && n2 > n4 && n2 <= n4 + this.mPointArrowH) {
                    this.keyEventOccurred(52, 0);
                }
                if (n > (n5 = this.mPointArrowX1 - this.mPointPivotX1) && n <= n5 + this.mPointArrowW && n2 > n4 && n2 <= n4 + this.mPointArrowH) {
                    this.keyEventOccurred(54, 0);
                }
            }
            if (mGameState == 5 && n3 == 0) {
                n5 = this.mPointArrowX1 - this.mPointPivotX1;
                n4 = this.mPointArrowY - this.mPointPivotY1;
                if (n > n5 && n <= n5 + this.mPointArrowW && n2 > n4 && n2 <= n4 + this.mPointArrowH) {
                    this.keyEventOccurred(52, 0);
                }
                if (n > (n5 = this.mPointArrowX2 - this.mPointPivotX1) && n <= n5 + this.mPointArrowW && n2 > n4 && n2 <= n4 + this.mPointArrowH) {
                    this.keyEventOccurred(54, 0);
                }
                n5 = this.mPointArrowX - this.mPointPivotX1;
                n4 = this.mPointArrowY1 - this.mPointPivotY2;
                if (n > n5 && n <= n5 + this.mPointArrowW1 && n2 > n4 && n2 <= n4 + this.mPointArrowH) {
                    this.keyEventOccurred(50, 0);
                }
                n4 = this.mPointArrowY2 - this.mPointPivotY1;
                if (n > n5 && n <= n5 + this.mPointArrowW1 && n2 > n4 && n2 <= n4 + this.mPointArrowH) {
                    this.keyEventOccurred(56, 0);
                }
            }
        }
    }

    public void screenSizeChanged() {
        if (mCurrentMiniGame != null) {
            mCurrentMiniGame.screenSizeChanged();
        }
        if (mTextBox != null) {
            int n = Toolkit.getScreenWidth();
            int n2 = Toolkit.getScreenHeight() * 60 / 100;
            n2 = mTextBox.getPreferredHeight(n, n2);
            mTextBox.setSize(n, n2);
        }
    }

    public void continueGame() {
        this.resetKeys();
        mUpdateSoftKeys = true;
    }

    public void playGame() {
        mUpdateSoftKeys = false;
        this.destroyTextBox();
    }

    private void resetKeys() {
        this.mPressedSK = -1;
        this.mKeys = 0;
    }

    private void updateSoftKeys() {
        switch (mGameState) {
            case 1: {
                if (mCurrentMiniGame == null) break;
                mCurrentMiniGame.updateSoftkeys(true);
                break;
            }
            case 2: {
                Toolkit.removeAllSoftKeys();
                if (!mShowPopup) break;
                if (mPopupWait <= 0) {
                    mTextBox.setSoftkey(15, 0);
                    mTextBox.setVisible();
                    break;
                }
                Toolkit.setSoftKey(9, 0);
                break;
            }
            case 4: 
            case 5: {
                Toolkit.removeAllSoftKeys();
                Toolkit.setSoftKey(5, 0);
                break;
            }
            case 3: {
                Toolkit.removeAllSoftKeys();
                break;
            }
        }
    }

    public void trigon_init() {
        byte[] byArray = Toolkit.getResourceBytes(65550);
        sintable = new short[64];
        costable = new short[64];
        tantable = new short[64];
        for (int i = 0; i < 64; ++i) {
            GameEngine.sintable[i] = (short)((byArray[i * 2] & 0xFF) << 8 | byArray[i * 2 + 1] & 0xFF);
            GameEngine.costable[i] = (short)((byArray[128 + i * 2] & 0xFF) << 8 | byArray[i * 2 + 129] & 0xFF);
            GameEngine.tantable[i] = (short)((byArray[i * 2 + 256] & 0xFF) << 8 | byArray[i * 2 + 257] & 0xFF);
        }
    }

    static int trigon_sin(int n) {
        short s = ((n &= 0xFF) & 0x40) == 0 ? sintable[n & 0x3F] : sintable[63 - (n & 0x3F)];
        if (n >= 128) {
            s = -s;
        }
        return s;
    }

    static int trigon_cos(int n) {
        short s = ((n &= 0xFF) & 0x40) == 0 ? costable[n & 0x3F] : costable[63 - (n & 0x3F)];
        if (n >= 64 && n < 192) {
            s = -s;
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    static int trigon_atan(int n, int n2) {
        void var2_4;
        int n3;
        int s = 99999;
        if (n2 != 0) {
            n3 = (n << 10) / n2;
        }
        if (n3 < 0) {
            var2_4 = -n3;
        }
        int n4 = 0;
        int n5 = 32;
        int n6 = 63;
        while (n4 < n6 - 1) {
            if (var2_4 > tantable[n5]) {
                n4 = n5;
            } else {
                if (var2_4 >= tantable[n5]) break;
                n6 = n5;
            }
            n5 = n4 + n6 >> 1;
        }
        if (n >= 0) {
            if (n2 >= 0) {
                return n5;
            }
            return 128 - n5;
        }
        if (n2 < 0) {
            return 128 + n5;
        }
        return 256 - n5 & 0xFF;
    }

    public static boolean scrollTextEngine(int n, int[] nArray, boolean bl) {
        if (nArray == null) {
            return false;
        }
        if (nArray[0] < nArray[1]) {
            if (nArray[4] > 0) {
                nArray[4] = nArray[4] - n;
                return false;
            }
            if (nArray[2] == 0) {
                nArray[2] = -1;
            }
            nArray[5] = nArray[5] + nArray[2] * n * 27;
            nArray[3] = nArray[5] >> 10;
            if (nArray[3] >= 0 && nArray[2] == 1) {
                nArray[2] = -1;
                nArray[4] = 2000;
            } else if (Math.abs(nArray[3]) >= nArray[1] - nArray[0] && nArray[2] == -1) {
                nArray[2] = 1;
                nArray[4] = 2000;
            }
            return true;
        }
        nArray[3] = nArray[5] >> 10;
        nArray[3] = bl ? (nArray[0] - nArray[1]) / 2 : 0;
        return false;
    }

    public static boolean scrollTextEngineCicle(int n, int[] nArray, boolean bl) {
        if (nArray == null) {
            return false;
        }
        if (nArray[0] < nArray[1]) {
            if (nArray[4] > 0) {
                nArray[4] = nArray[4] - n;
                return false;
            }
            nArray[5] = nArray[5] + nArray[2] * n * 27;
            if (nArray[5] >> 10 == 0 && nArray[2] != -1) {
                nArray[2] = -1;
                nArray[4] = 2000;
            } else if (nArray[5] >> 10 <= -nArray[1]) {
                nArray[5] = nArray[5] + (nArray[1] << 10);
            }
            nArray[3] = nArray[5] >> 10;
            return true;
        }
        nArray[3] = nArray[5] >> 10;
        nArray[3] = bl ? (nArray[0] - nArray[1]) / 2 : 0;
        return false;
    }

    private void statsPracticeUpdate() {
        int[] nArray = new int[]{62, 63, 64, 65};
        GameEngine.mGeneralStr[0] = Toolkit.getText(nArray[this.mStatisticsSelection]);
        GameEngine.mGeneralStr[GameEngine.STR_PRACTICE_STATISTICS_HELP_TITLE] = Toolkit.getText(56);
        int n = this.mStatisticsSelection * 6 + this.mStatisticsSubSelection;
        GameEngine.mGeneralStr[1] = Toolkit.getText(MINIGAME_NAMES[n]);
        for (int i = 0; i < 6; ++i) {
            int n2 = 2 + i;
            if (i == this.mStatisticsSubSelection) {
                int n3;
                int n4 = 0;
                for (n3 = 0; n3 < mCurrentMiniGameScoresPer[this.mStatisticsSelection][i].length && mCurrentMiniGameScoresPer[this.mStatisticsSelection][i][n3] != -1; ++n3) {
                    ++n4;
                }
                --n4;
                GameEngine.mGeneralStr[n2] = Toolkit.getText(429) + ": " + mCurrentMiniGameScoresMax[this.mStatisticsSelection][i] + "%";
                if (mCurrentMiniGameScoresPer[this.mStatisticsSelection][i][--n3] == -1) {
                    --n4;
                }
                if (!mMiniGameUnlocked[n]) {
                    GameEngine.mGeneralStr[n2] = Toolkit.getText(427);
                    continue;
                }
                if (n4 != 0) continue;
                GameEngine.mGeneralStr[n2] = Toolkit.getText(428);
                continue;
            }
            GameEngine.mGeneralStr[n2] = "";
        }
        scrollTextSTE = null;
        formCathegoryTitleSTE = null;
    }

    static {
        mMiniGameUnlocked = new boolean[]{true, false, false, false, false, false, true, false, false, false, false, false, true, false, false, false, false, false, true, false, false, false, false, false};
        mMiniGameMedals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mFirstTimeStupidTest = true;
        mFirstTimeTestMode = true;
        mTestModeIndex = 0;
        mTestModeMaxScore = 0;
        mTestModeMaxScoreStr = "0%";
        mHighScoresPlayerPos = 15;
        mHighScores = new int[]{95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25};
        mHighScoresStr = new String[]{"95%", "90%", "85%", "80%", "75%", "70%", "65%", "60%", "55%", "50%", "45%", "40%", "35%", "30%", "25%"};
        mHighScoresIndexStr = new String[]{"1. ", "2. ", "3. ", "4. ", "5. ", "6. ", "7. ", "8. ", "9. ", "10. ", "11. ", "12. ", "13. ", "14. ", "15. ", "16. "};
        mIconCategories = new SpriteObject[4];
        achievementDone = new boolean[30];
        MINIGAME_NAMES = new int[]{66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 57};
        MINIGAME_ICONS = new int[]{262173, 196713, 196689, 196697, 262160, 196711, 196695, 262147, 196705, 262162, 196715, 262167, 196699, 262151, 262149, 196721, 262178, 262155, 196673, 262153, 262158, 196665, 196701, 131082, 131189};
        ACHIEVEMENTS_NAMES = new int[]{305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334};
        MINIINSTRUCTIONS_ID = new int[]{131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 156};
        INSTRUCTIONS_ID = new int[]{107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 155};
        TITLES_ID = new int[]{66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89};
        mCurrentMiniGameScoresPer = new int[4][6][5];
        mCurrentMiniGameScoresMax = new int[4][6];
        mCurrentMiniGameTestScoresPer = new int[4][5];
        STR_STAT_TEST_AVERAGE_TITLE = 0;
        STR_STAT_TEST_AVERAGE_VALUE = 1;
        STR_STAT_TEST_SCORES_PER_FIRST = 2;
        STR_TEST_STATISTICS_HELP_TITLE = 6;
        STR_STAT_TEST_COUNT = 7;
        STR_PRACTICE_STATISTICS_HELP_TITLE = 8;
    }
}

