/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageFont {
    public static final int BORDER_DISABLED = -1;
    private Image mFontImage;
    private Font mSystemFont;
    private int mSystemFontColor;
    private int mSystemFontBorderColor;
    private boolean mEnableSystemBorders;
    private int mCharacterSpacing;
    private byte mFontAscent;
    private byte mFontDescent;
    private byte[] mCharacterXs;
    private short[] mCharacterYs;
    private byte[] mCharacterWidths;
    private byte[] mCharacterHeights;
    private byte[] mCharacterAscents;
    private static final int CHARACTER_NOT_FOUND = -1;
    private static final int SYSTEM_FONT_BORDER_WIDTH = 1;
    private int[] mHashTableEntries;

    public ImageFont(Image image, DataInputStream dataInputStream, Font font, int n, int n2) throws IOException {
        if (image != null) {
            int n3;
            this.mFontImage = image;
            int n4 = dataInputStream.readShort();
            this.mCharacterSpacing = dataInputStream.readByte();
            this.mFontAscent = dataInputStream.readByte();
            this.mFontDescent = dataInputStream.readByte();
            for (n3 = 1; n3 < n4 * 4 / 3; n3 <<= 1) {
            }
            this.hashTableCreate(n3);
            this.mCharacterXs = new byte[n4];
            this.mCharacterYs = new short[n4];
            this.mCharacterWidths = new byte[n4];
            this.mCharacterHeights = new byte[n4];
            this.mCharacterAscents = new byte[n4];
            while (n4 > 0) {
                int n5 = dataInputStream.read();
                char c = dataInputStream.readChar();
                while (n5-- > 0) {
                    this.mCharacterXs[--n4] = dataInputStream.readByte();
                    this.mCharacterYs[n4] = dataInputStream.readShort();
                    this.mCharacterWidths[n4] = dataInputStream.readByte();
                    this.mCharacterHeights[n4] = dataInputStream.readByte();
                    this.mCharacterAscents[n4] = dataInputStream.readByte();
                    this.hashTablePut(c, (short)n4);
                    c = (char)(c + '\u0001');
                }
            }
        } else {
            this.mSystemFont = font;
            this.mSystemFontColor = n;
            this.mSystemFontBorderColor = n2;
            this.mEnableSystemBorders = n2 != -1;
        }
    }

    private int getCharIndex(char c) {
        int n = this.hashTableGet(c);
        if (n == -1) {
            n = this.hashTableGet(' ');
        }
        return n;
    }

    public final int stringWidth(String string) {
        if (this.mFontImage != null) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n2 = this.getCharIndex(c);
                n += this.mCharacterWidths[n2] + this.mCharacterSpacing;
            }
            if (this.mCharacterSpacing < 0) {
                n -= this.mCharacterSpacing;
            }
            return n;
        }
        return this.mSystemFont.stringWidth(string) + (this.mEnableSystemBorders ? 2 : 0);
    }

    public int charWidth(char c) {
        if (this.mFontImage != null) {
            int n = this.getCharIndex(c);
            return this.mCharacterWidths[n] + this.mCharacterSpacing;
        }
        return this.mSystemFont.charWidth(c);
    }

    public int getEmptyStringWidth() {
        if (this.mFontImage != null) {
            return 0;
        }
        return this.mEnableSystemBorders ? 2 : 0;
    }

    public final int getHeight() {
        if (this.mFontImage != null) {
            return this.mFontAscent + this.mFontDescent;
        }
        return this.mSystemFont.getHeight() + (this.mEnableSystemBorders ? 2 : 0);
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        if (this.mFontImage != null) {
            if ((n3 & 1) != 0) {
                n -= this.stringWidth(string) >> 1;
            } else if ((n3 & 8) != 0) {
                n -= this.stringWidth(string);
            }
            if ((n3 & 0x10) != 0) {
                n2 += this.mFontAscent;
            } else if ((n3 & 0x20) != 0) {
                n2 -= this.mFontDescent;
            }
            if ((n3 & 2) != 0) {
                return;
            }
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n8 = this.getCharIndex(c);
                byte by = this.mCharacterWidths[n8];
                if (c != ' ') {
                    byte by2 = this.mCharacterAscents[n8];
                    byte by3 = this.mCharacterHeights[n8];
                    int n9 = n4 + n6;
                    int n10 = n5 + n7;
                    int n11 = Math.max(n4, n);
                    int n12 = Math.max(n5, n2 - by2);
                    int n13 = Math.max(n11, Math.min(n9, n + by));
                    int n14 = Math.max(n12, Math.min(n10, n2 - by2 + by3));
                    this.setGameClip(graphics, n11, n12, n13 - n11, n14 - n12);
                    graphics.drawImage(this.mFontImage, n - (this.mCharacterXs[n8] & 0xFF), n2 - this.mCharacterYs[n8] - by2, 20);
                }
                n += by + this.mCharacterSpacing;
            }
            this.setGameClip(graphics, n4, n5, n6, n7);
        } else {
            graphics.setFont(this.mSystemFont);
            int n15 = graphics.getColor();
            if (this.mEnableSystemBorders) {
                if ((n3 & 4) != 0) {
                    ++n;
                } else if ((n3 & 8) != 0) {
                    --n;
                }
                if ((n3 & 0x10) != 0) {
                    ++n2;
                } else if ((n3 & 0x20) != 0) {
                    --n2;
                }
                graphics.setColor(this.mSystemFontBorderColor);
                graphics.drawString(string, n, n2 - 1, n3);
                graphics.drawString(string, n - 1, n2, n3);
                graphics.drawString(string, n + 1, n2, n3);
                graphics.drawString(string, n, n2 + 1, n3);
            }
            graphics.setColor(this.mSystemFontColor);
            graphics.drawString(string, n, n2, n3);
            graphics.setColor(n15);
        }
    }

    public void drawChar(Graphics graphics, char c, int n, int n2, int n3) {
        if (this.mFontImage != null) {
            if ((n3 & 1) != 0) {
                n -= this.charWidth(c) >> 1;
            } else if ((n3 & 8) != 0) {
                n -= this.charWidth(c);
            }
            if ((n3 & 0x10) != 0) {
                n2 += this.mFontAscent;
            } else if ((n3 & 0x20) != 0) {
                n2 -= this.mFontDescent;
            }
            if ((n3 & 2) != 0) {
                return;
            }
            int n4 = graphics.getClipX();
            int n5 = graphics.getClipY();
            int n6 = graphics.getClipWidth();
            int n7 = graphics.getClipHeight();
            int n8 = this.getCharIndex(c);
            byte by = this.mCharacterWidths[n8];
            if (c != ' ') {
                byte by2 = this.mCharacterAscents[n8];
                byte by3 = this.mCharacterHeights[n8];
                int n9 = n4 + n6;
                int n10 = n5 + n7;
                int n11 = Math.max(n4, n);
                int n12 = Math.max(n5, n2 - by2);
                int n13 = Math.max(n11, Math.min(n9, n + by));
                int n14 = Math.max(n12, Math.min(n10, n2 - by2 + by3));
                this.setGameClip(graphics, n11, n12, n13 - n11, n14 - n12);
                graphics.drawImage(this.mFontImage, n - (this.mCharacterXs[n8] & 0xFF), n2 - this.mCharacterYs[n8] - by2, 20);
            }
            this.setGameClip(graphics, n4, n5, n6, n7);
        } else {
            graphics.setFont(this.mSystemFont);
            int n15 = graphics.getColor();
            if (this.mEnableSystemBorders) {
                if ((n3 & 4) != 0) {
                    ++n;
                } else if ((n3 & 8) != 0) {
                    --n;
                }
                if ((n3 & 0x10) != 0) {
                    ++n2;
                } else if ((n3 & 0x20) != 0) {
                    --n2;
                }
                graphics.setColor(this.mSystemFontBorderColor);
                graphics.drawChar(c, n, n2 - 1, n3);
                graphics.drawChar(c, n - 1, n2, n3);
                graphics.drawChar(c, n + 1, n2, n3);
                graphics.drawChar(c, n, n2 + 1, n3);
            }
            graphics.setColor(this.mSystemFontColor);
            graphics.drawChar(c, n, n2, n3);
            graphics.setColor(n15);
        }
    }

    private void hashTableCreate(int n) {
        this.mHashTableEntries = new int[n];
    }

    private void hashTablePut(char c, short s) {
        int n = this.hashTableHashCode(c);
        for (int i = 0; i < this.mHashTableEntries.length; ++i) {
            int n2 = this.mHashTableEntries[n & this.mHashTableEntries.length - 1];
            if (n2 == 0) {
                this.mHashTableEntries[n & this.mHashTableEntries.length - 1] = c << 16 | s & 0xFFFF;
                break;
            }
            ++n;
        }
    }

    private int hashTableGet(char c) {
        int n;
        int n2 = this.hashTableHashCode(c);
        for (int i = 0; i < this.mHashTableEntries.length && (n = this.mHashTableEntries[n2 & this.mHashTableEntries.length - 1]) != 0; ++i) {
            if (n >>> 16 == c) {
                return n & 0xFFFF;
            }
            ++n2;
        }
        return -1;
    }

    private int hashTableHashCode(char c) {
        return (c + 4660) * (c + 17185);
    }

    private void setGameClip(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n2 + n4 >= Toolkit.getScreenHeight()) {
            n4 = Toolkit.getScreenHeight() - n2;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n + n3 >= Toolkit.getScreenWidth()) {
            n3 = Toolkit.getScreenWidth() - n;
        }
        graphics.setClip(n, n2, n3, n4);
    }
}

