/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DCPack
extends DChocMIDlet
implements ApplicationControl {
    private static final boolean DEBUG_FLOW = false;
    private static final int NO_STATE_CHANGE = -1;
    private boolean mInitialized;
    private FlowHandler mFlowHandler;
    private int mFlowBinaryRid;
    private int[] mEventTargets;
    private int[] mStateOffsets;
    private int[] mStateGroups;
    private int mCurrentState = -1;
    private int mNextState = -1;
    private MenuObject mCurrentMenu;
    private int[] mCurrentGameScreen;
    private int[] mCurrentBranch;
    private MenuObject[] mLoadedMenus;
    private MenuObject[] mSubMenus;
    private int[][] mMenuSoftkeyEvents;
    private int[][] mLoadedGameScreens;
    private int[][] mLoadedBranches;
    private int mMenuScreenStartIndex;
    private int mMenuScreenCount;
    private int mGameScreenStartIndex;
    private int mGameScreenCount;
    private int mBranchStartIndex;
    private int mBranchCount;
    private boolean mGoingForward;
    private boolean mStoreStateToHistory;
    private int[] mStateHistory;
    private int mStateHistoryPointer;
    private Image mPreviewImage;
    private boolean mLoading;
    private static boolean keyAfterLoadingPressed;
    public static boolean mLoadingFinished;
    public static boolean loadingQuizActive;
    private ImageFont mTextImageFont;
    private ImageFont mSelectionImageFont;
    private static ImageFont mTitleBarImageFont;
    private int mMaxLoadingCount;
    private int mLoadingCounter;
    public static int mLoadingTimer;
    private int mStateGroupLoadingCount;
    private int mStateLoadingCount;
    private int[] mMenusToLoad;
    final int MIN_DELTA_TIME;
    final int MAX_DELTA_TIME;
    final int MIN_MEASUREMENTS;
    final int MAX_MEASUREMENTS;
    int mDeltaTimeCount;
    int mAverageDeltaTime;
    private static final int INITIALIZE_GRAPHICS = 0;
    private static final int INITIALIZE_SOFT_KEYS = 1;
    private static final int INITIALIZE_FONTS = 2;
    private static final int INITIALIZE_SCROLL_ARROWS = 3;
    private static final int INITIALIZE_FLOW = 4;
    private static final int INITIALIZE_GAME = 5;
    private static final int INITIALIZATION_STEPS = 6;
    static final int[] smQuizWords;
    static String[] smQuizWord;
    static String[] smMessedWord;
    static int[] smQuizOrder;
    static int lastRndWord;

    public DCPack() {
        this.MIN_DELTA_TIME = 16;
        this.MAX_DELTA_TIME = 200;
        this.MIN_MEASUREMENTS = 25;
        this.MAX_MEASUREMENTS = 65000;
    }

    public void logicUpdate(int n) {
        try {
            int[] nArray;
            int n2;
            int n3;
            int n4;
            if (!this.mInitialized) {
                this.initialize();
                return;
            }
            if (this.mCurrentState != 35) {
                DChocMIDlet.skipTimer();
            }
            if (this.mDeltaTimeCount < 65000 && n > 16 && n < 200) {
                this.mAverageDeltaTime += n;
                ++this.mDeltaTimeCount;
            } else if (n > 200) {
                n = 200;
                if (this.mDeltaTimeCount > 25 && this.mDeltaTimeCount > 5) {
                    n = this.mAverageDeltaTime / this.mDeltaTimeCount;
                }
                if (n > 200) {
                    n = 200;
                }
            }
            while (this.mNextState != -1) {
                int n5;
                if (!this.mLoading) {
                    int n6;
                    n4 = this.mCurrentState != -1 ? this.mStateGroups[this.mCurrentState] : -1;
                    n5 = this.mStateGroups[this.mNextState];
                    if (this.mCurrentState != -1) {
                        if (n4 != -1) {
                            if (n4 != n5) {
                                if (this.mNextState == 35 && this.mCurrentState != 21) {
                                    DCPack.initLoadingQuiz();
                                }
                                if (!this.mFlowHandler.isChildGroup(n4, n5)) {
                                    this.mFlowHandler.unloadStateGroup(n4, n5);
                                    for (n6 = 0; n6 < this.mStateGroups.length; ++n6) {
                                        if (this.mStateGroups[n6] != n4 || !this.isMenuState(n6) || this.mLoadedMenus[n3 = n6 - this.mMenuScreenStartIndex] == null) continue;
                                        this.mLoadedMenus[n3] = null;
                                    }
                                }
                            }
                        } else if (this.isMenuState(this.mCurrentState) && this.mLoadedMenus[n6 = this.mCurrentState - this.mMenuScreenStartIndex] != null) {
                            this.mLoadedMenus[n6] = null;
                        }
                        this.mFlowHandler.unloadState(this.mCurrentState, this.mNextState);
                        this.deactivateState();
                    }
                    this.mMaxLoadingCount = 0;
                    this.mStateGroupLoadingCount = 0;
                    if (n5 != -1 && n5 != n4) {
                        if (!this.mFlowHandler.isChildGroup(n5, n4)) {
                            this.mStateGroupLoadingCount = this.mFlowHandler.getStateGroupLoadingCount(n5);
                        }
                        n6 = 0;
                        for (n3 = 0; n3 < this.mStateGroups.length; ++n3) {
                            if (this.mStateGroups[n3] != n5 || !this.isMenuState(n3) || this.mLoadedMenus[n3 - this.mMenuScreenStartIndex] != null || n3 != this.mNextState && !this.mFlowHandler.shouldStoreStateToHistory(n3)) continue;
                            ++n6;
                        }
                        this.mMenusToLoad = new int[n6];
                        n3 = 0;
                        for (n2 = 0; n2 < this.mStateGroups.length; ++n2) {
                            if (this.mStateGroups[n2] != n5 || !this.isMenuState(n2) || this.mLoadedMenus[n2 - this.mMenuScreenStartIndex] != null || n2 != this.mNextState && !this.mFlowHandler.shouldStoreStateToHistory(n2)) continue;
                            this.mMenusToLoad[n3++] = n2;
                        }
                    } else {
                        n6 = this.mNextState;
                        this.mMenusToLoad = this.isMenuState(n6) && this.mLoadedMenus[n6 - this.mMenuScreenStartIndex] == null ? new int[]{n6} : new int[0];
                    }
                    this.mStateLoadingCount = this.mFlowHandler.getStateLoadingCount(this.mNextState);
                    this.mMaxLoadingCount = this.mStateGroupLoadingCount + this.mStateLoadingCount + this.mMenusToLoad.length;
                    if (this.mMaxLoadingCount > 0) {
                        this.mLoadingCounter = 0;
                        mLoadingTimer = 0;
                        this.mLoading = true;
                        Toolkit.removeAllSoftKeys();
                        Game.stopMusic();
                        return;
                    }
                } else {
                    if (this.mLoadingCounter < this.mMaxLoadingCount) {
                        mLoadingTimer += n;
                        if (MenuObject.mGears != null) {
                            MenuObject.mGears.logicUpdate(n);
                        }
                        if (this.mLoadingCounter < this.mStateGroupLoadingCount) {
                            n4 = this.mLoadingCounter;
                            n5 = this.mStateGroups[this.mNextState];
                            if (n5 == 5) {
                                if (this.mLoadedMenus[15] == null) {
                                    this.loadMenu(15);
                                    this.loadMenu(18);
                                    this.loadMenu(17);
                                    this.loadMenu(16);
                                    this.mFlowHandler.getSubMenu(this.mLoadedMenus);
                                }
                            } else if (n5 == 2) {
                                this.mFlowHandler.removeSubMenus(this.mLoadedMenus);
                            }
                            this.mFlowHandler.loadStateGroup(n5, n4);
                        } else if (this.mLoadingCounter < this.mStateLoadingCount) {
                            n4 = this.mLoadingCounter - this.mStateGroupLoadingCount;
                            this.mFlowHandler.loadState(this.mNextState, n4);
                        } else {
                            n4 = this.mLoadingCounter - this.mStateGroupLoadingCount - this.mStateLoadingCount;
                            if (n4 > -1) {
                                n5 = this.mMenusToLoad[n4];
                                this.loadMenu(n5);
                            }
                        }
                        ++this.mLoadingCounter;
                        return;
                    }
                    if (!mLoadingFinished) {
                        if (loadingQuizActive) {
                            Toolkit.setSoftKey(15, 0);
                        }
                        mLoadingFinished = true;
                    }
                    mLoadingTimer += n;
                    if (loadingQuizActive && !keyAfterLoadingPressed) {
                        return;
                    }
                    loadingQuizActive = false;
                    mLoadingFinished = false;
                    keyAfterLoadingPressed = false;
                    this.mLoading = false;
                }
                n4 = this.mCurrentState;
                this.mCurrentState = this.mNextState;
                this.mNextState = -1;
                n5 = this.mStateHistoryPointer;
                while (--n5 >= 0) {
                    if (this.mStateHistory[n5] != this.mCurrentState) continue;
                    this.mStateHistoryPointer = n5;
                    break;
                }
                this.activateState(this.mCurrentState);
                this.mFlowHandler.switchState(n4, this.mCurrentState, this.mCurrentMenu);
                if (this.mCurrentBranch == null) continue;
                this.processBranch(this.mCurrentState);
            }
            n4 = this.mFlowHandler.logicUpdate(this.mCurrentState, n);
            this.processEvent(n4);
            if (this.mCurrentMenu != null && (nArray = this.mCurrentMenu.logicUpdate(n)) != null) {
                if (nArray[0] == 1) {
                    this.processEvent(nArray[1]);
                } else if (nArray[0] == 0) {
                    int[] nArray2 = this.mMenuSoftkeyEvents[this.mCurrentState - this.mMenuScreenStartIndex];
                    if (nArray2 != null) {
                        for (n3 = 0; n3 < nArray2.length; ++n3) {
                            if (nArray2[n3++] != nArray[1]) continue;
                            n2 = nArray2[n3];
                            this.processEvent(n2);
                        }
                    }
                    this.processSoftkeyEvent(nArray[1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initialize() {
        if (!this.mLoading) {
            this.mMaxLoadingCount = 6;
            this.mLoadingCounter = 0;
            this.mLoading = true;
            return;
        }
        if (this.mLoadingCounter < this.mMaxLoadingCount) {
            switch (this.mLoadingCounter) {
                case 0: {
                    this.initializeGraphics();
                    break;
                }
                case 1: {
                    this.initializeSoftkeys();
                    break;
                }
                case 2: {
                    this.initializeFonts();
                    break;
                }
                case 3: {
                    this.initializeScrollArrows();
                    break;
                }
                case 4: {
                    this.initializeFlow(65549, new Game(this, mTitleBarImageFont, this.mTextImageFont, this.mSelectionImageFont));
                    break;
                }
            }
            ++this.mLoadingCounter;
        } else {
            this.mInitialized = true;
            this.mLoading = false;
        }
    }

    private void initializeGraphics() {
        SpriteObject.initialize();
    }

    private void initializeScrollArrows() {
        short[][] sArray = SpriteObject.loadAnimations(new int[]{917541, 917538, 917539});
        short[][] sArray2 = SpriteObject.loadAnimations(new int[]{917537, 917535, 917536});
        MenuObject.setScrollArrowsDvc(new SpriteObject(sArray, true), new SpriteObject(sArray2, true));
        short[][] sArray3 = SpriteObject.loadAnimations(new int[]{917534, 917532});
        short[][] sArray4 = SpriteObject.loadAnimations(new int[]{917531, 917530});
        MenuObject.setHorizontalScrollArrows(new SpriteObject(sArray3, true), new SpriteObject(sArray4, true));
    }

    private void initializeFonts() {
        try {
            Image image = null;
            Image image2 = null;
            Image image3 = null;
            Font font = Font.getFont((int)32, (int)0, (int)8);
            Font font2 = Font.getFont((int)32, (int)1, (int)8);
            Font font3 = Font.getFont((int)32, (int)1, (int)0);
            image = Toolkit.getImage(65541);
            image2 = Toolkit.getImage(65539);
            image3 = Toolkit.getImage(65537);
            this.mTextImageFont = new ImageFont(image, Toolkit.getResourceStream(65542), font, 0, -1);
            this.mSelectionImageFont = new ImageFont(image2, Toolkit.getResourceStream(65540), font2, 0xFFFFFF, 0);
            mTitleBarImageFont = new ImageFont(image3, Toolkit.getResourceStream(65538), font3, 0xFFFF00, 0);
            MenuObject.setDefaultImageFonts(mTitleBarImageFont, this.mTextImageFont, this.mSelectionImageFont);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void doDraw(Graphics graphics) {
        try {
            if (this.mLoading && this.mMaxLoadingCount > 1) {
                DCPack.drawLoadingScreen(graphics, null, this.mLoadingCounter * 100 / this.mMaxLoadingCount, this.mCurrentState);
                return;
            }
            this.mFlowHandler.doDraw(this.mCurrentState, graphics);
            if (this.mCurrentMenu != null) {
                this.mFlowHandler.drawMenu(this.mCurrentState, graphics, this.mCurrentMenu);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyEventOccurred(int n, int n2) {
        if (this.mLoading) {
            if (mLoadingFinished) {
                int n3;
                if (n2 == 3) {
                    if (n > 0 && Toolkit.getSoftKeyType(n) == 0) {
                        keyAfterLoadingPressed = true;
                        Toolkit.removeAllSoftKeys();
                    }
                } else if (n2 == 0 && (n3 = Toolkit.getToolkitGameAction(n)) == 53) {
                    keyAfterLoadingPressed = true;
                    Toolkit.removeAllSoftKeys();
                }
            }
            return;
        }
        if (this.mCurrentMenu != null) {
            this.mCurrentMenu.keyEventOccurred(n, n2);
        }
        if (this.mFlowHandler != null) {
            this.mFlowHandler.keyEventOccurred(this.mCurrentState, n, n2);
        }
    }

    public void pointerEventOccurred(int n, int n2, int n3) {
        if (this.mLoading) {
            return;
        }
        if (this.mCurrentMenu != null) {
            this.mCurrentMenu.pointerEventOccurred(n, n2, n3);
        }
        if (this.mFlowHandler != null) {
            this.mFlowHandler.pointerEventOccurred(this.mCurrentState, n, n2, n3);
        }
    }

    public void appEventOccurred(int n) {
        if (this.mFlowHandler == null) {
            return;
        }
        if (n == 0) {
            this.mFlowHandler.pauseGame();
        } else if (n == 1) {
            this.mFlowHandler.pauseGame();
        } else if (n == 5) {
            this.mFlowHandler.licenseManagerActivated();
        }
    }

    private void initializeSoftkeys() {
        byte[] byArray = Toolkit.getResourceBytes(917567);
        int n = 1;
        for (int i = byArray[0]; i > 0; --i) {
            byte by = byArray[n++];
            int n2 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
            int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
            byte by2 = byArray[n++];
            if (n2 == -1) continue;
            Image image = null;
            if (n3 != -1 && (image = SpriteObject.getImage(n3, 0, 1)) == null) {
                image = Toolkit.getImage(n3);
            }
            Toolkit.createSoftKey(by, n2, image, by2);
        }
    }

    private void initializeFlow(int n, FlowHandler flowHandler) {
        int n2;
        int n3;
        this.mFlowBinaryRid = n;
        this.mFlowHandler = flowHandler;
        byte[] byArray = Toolkit.getResourceBytes(n);
        int n4 = byArray[0] & 0xFF;
        int n5 = 1;
        this.mEventTargets = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.mEventTargets[n3] = byArray[n5++] << 8 | byArray[n5++] & 0xFF;
        }
        n3 = byArray[n5++] & 0xFF;
        this.mMenuScreenStartIndex = 0;
        this.mMenuScreenCount = byArray[n5++] & 0xFF;
        this.mGameScreenStartIndex = this.mMenuScreenStartIndex + this.mMenuScreenCount;
        this.mGameScreenCount = byArray[n5++] & 0xFF;
        this.mBranchStartIndex = this.mGameScreenStartIndex + this.mGameScreenCount;
        this.mBranchCount = byArray[n5++] & 0xFF;
        int n6 = this.mMenuScreenCount + this.mGameScreenCount + this.mBranchCount;
        this.mStateGroups = new int[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            this.mStateGroups[n2] = byArray[n5++];
        }
        this.mStateOffsets = new int[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            this.mStateOffsets[n2] = byArray[n5++] << 8 | byArray[n5++] & 0xFF;
        }
        this.mNextState = byArray[n5++] & 0xFF;
        this.mLoadedMenus = new MenuObject[this.mMenuScreenCount];
        this.mMenuSoftkeyEvents = new int[this.mMenuScreenCount][];
        this.mLoadedGameScreens = new int[this.mGameScreenCount][];
        this.mLoadedBranches = new int[this.mMenuScreenCount][];
        n2 = this.mMenuScreenCount;
        int n7 = 0;
        while (n7 < this.mGameScreenCount) {
            this.loadGameScreen(n2);
            ++n7;
            ++n2;
        }
        n7 = 0;
        while (n7 < this.mBranchCount) {
            this.loadBranch(n2);
            ++n7;
            ++n2;
        }
        this.mStateHistory = new int[this.mMenuScreenCount + this.mBranchCount + this.mGameScreenCount];
        this.mStateHistoryPointer = 0;
        this.mStoreStateToHistory = false;
    }

    private void deactivateState() {
        this.mCurrentMenu = null;
        this.mCurrentGameScreen = null;
        this.mCurrentBranch = null;
        Toolkit.removeAllSoftKeys();
    }

    private void activateState(int n) {
        if (n >= 0 && n < this.mMenuScreenCount + this.mBranchCount + this.mGameScreenCount) {
            if (n < this.mMenuScreenCount) {
                this.activateMenuScreen(n);
            } else if (n < this.mMenuScreenCount + this.mGameScreenCount) {
                this.activateGameScreen(n);
            } else if (n < this.mMenuScreenCount + this.mGameScreenCount + this.mBranchCount) {
                this.activateBranch(n);
            }
        }
    }

    private boolean isMenuState(int n) {
        return (n -= this.mMenuScreenStartIndex) >= 0 && n < this.mMenuScreenCount;
    }

    private void activateMenuScreen(int n) {
        this.mCurrentMenu = this.mLoadedMenus[n - this.mMenuScreenStartIndex];
        if (this.mGoingForward) {
            this.mCurrentMenu.setSelectedItem(0);
        }
        this.mFlowHandler.processMenu(n, this.mCurrentMenu, 2);
        this.mCurrentMenu.setVisible();
        this.mFlowHandler.processMenu(n, this.mCurrentMenu, 3);
        this.mStoreStateToHistory = this.mFlowHandler.shouldStoreStateToHistory(n);
    }

    private void activateGameScreen(int n) {
        if (this.mLoadedGameScreens[n - this.mGameScreenStartIndex] == null) {
            this.loadGameScreen(n);
        }
        this.mCurrentGameScreen = this.mLoadedGameScreens[n - this.mGameScreenStartIndex];
        this.mStoreStateToHistory = this.mFlowHandler.shouldStoreStateToHistory(n);
    }

    private void activateBranch(int n) {
        if (this.mLoadedBranches[n - this.mBranchStartIndex] == null) {
            this.loadBranch(n);
        }
        this.mCurrentBranch = this.mLoadedBranches[n - this.mBranchStartIndex];
        this.mStoreStateToHistory = false;
    }

    private void processBranch(int n) {
        if (this.mFlowHandler.evaluateBranchCondition(n)) {
            this.processEvent(this.mCurrentBranch[0]);
        } else {
            this.processEvent(this.mCurrentBranch[1]);
        }
    }

    private void loadMenu(int n) {
        int n2;
        int n3;
        byte[] byArray = Toolkit.getResourceBytes(this.mFlowBinaryRid);
        int n4 = this.mStateOffsets[n - this.mMenuScreenStartIndex];
        MenuObject menuObject = new MenuObject();
        this.mFlowHandler.processMenu(n, menuObject, 0);
        Vector<int[]> vector = new Vector<int[]>();
        int n5 = byArray[n4++];
        Image[][] imageArrayArray = new Image[1][];
        SpriteObject[] spriteObjectArray = new SpriteObject[1];
        boolean[] blArray = new boolean[1];
        byte by = byArray[n4++];
        byte by2 = byArray[n4++];
        this.mFlowHandler.menuSetScreen(n, menuObject, by, n5, by2);
        byte by3 = byArray[n4++];
        this.mFlowHandler.menuSetStyle(n, menuObject, by3);
        boolean bl = false;
        int n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF);
        String string = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
        blArray[0] = bl;
        n4 = DCPack.loadImagesOrAnimations(byArray, n4, 1, imageArrayArray, spriteObjectArray, blArray);
        Image image = imageArrayArray[0] == null ? null : imageArrayArray[0][0];
        SpriteObject spriteObject = spriteObjectArray[0];
        bl = blArray[0];
        by2 = byArray[n4++];
        if (bl) {
            if (string != null || spriteObject != null) {
                this.mFlowHandler.menuSetTitleBarDvc(n, menuObject, string, spriteObject, by2);
            }
        } else if (string != null || image != null) {
            this.mFlowHandler.menuSetTitleBar(n, menuObject, string, image, by2);
        }
        int n7 = byArray[n4++];
        if ((n3 = byArray[n4++] & 0xFF) != 255) {
            vector.addElement(new int[]{n7, n3});
        }
        this.mFlowHandler.menuSetSoftkey(n, menuObject, n7, 0);
        int n8 = byArray[n4++];
        int n9 = byArray[n4++] & 0xFF;
        if (n9 != 255) {
            vector.addElement(new int[]{n8, n9});
        }
        this.mFlowHandler.menuSetSoftkey(n, menuObject, n8, 1);
        block7: for (int i = 0; i < n5; ++i) {
            bl = false;
            n2 = byArray[n4++];
            switch (n2) {
                case 0: {
                    n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF);
                    string = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
                    blArray[0] = bl;
                    n4 = DCPack.loadImagesOrAnimations(byArray, n4, 3, imageArrayArray, spriteObjectArray, blArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    bl = blArray[0];
                    int n10 = byArray[n4++] & 0xFF;
                    if (n10 == 255) {
                        n10 = -1;
                    }
                    if (bl) {
                        this.mFlowHandler.menuSetItemDvc(n, menuObject, i, n2, string, spriteObject, n10);
                        continue block7;
                    }
                    this.mFlowHandler.menuSetItem(n, menuObject, i, n2, string, imageArray, n10);
                    continue block7;
                }
                case 1: {
                    int n10;
                    n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF & 0xFF);
                    string = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
                    blArray[0] = bl;
                    n4 = DCPack.loadImagesOrAnimations(byArray, n4, 4, imageArrayArray, spriteObjectArray, blArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    bl = blArray[0];
                    int n11 = byArray[n4++] & 0xFF;
                    String[] stringArray = new String[n11];
                    for (int j = 0; j < n11; ++j) {
                        n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF & 0xFF);
                        stringArray[j] = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
                    }
                    blArray[0] = bl;
                    n4 = DCPack.loadImagesOrAnimations(byArray, n4, n11, imageArrayArray, spriteObjectArray, blArray);
                    Image[] imageArray2 = imageArrayArray[0];
                    SpriteObject spriteObject2 = spriteObjectArray[0];
                    bl = blArray[0];
                    if ((n10 = byArray[n4++] & 0xFF) == 255) {
                        n10 = -1;
                    }
                    if (bl) {
                        this.mFlowHandler.menuSetSwitchItemDvc(n, menuObject, i, string, spriteObject, stringArray, spriteObject2, n10);
                        continue block7;
                    }
                    this.mFlowHandler.menuSetSwitchItem(n, menuObject, i, string, imageArray, stringArray, imageArray2, n10);
                    continue block7;
                }
                case 2: {
                    n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF & 0xFF);
                    string = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
                    blArray[0] = bl;
                    n4 = DCPack.loadImagesOrAnimations(byArray, n4, 4, imageArrayArray, spriteObjectArray, blArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    bl = blArray[0];
                    int n12 = byArray[n4++] & 0xFF;
                    int n13 = byArray[n4++] & 0xFF;
                    int n10 = byArray[n4++] & 0xFF;
                    if (n10 == 255) {
                        n10 = -1;
                    }
                    if (bl) {
                        this.mFlowHandler.menuSetSliderItemDvc(n, menuObject, i, string, spriteObject, n12, n13, n10);
                        continue block7;
                    }
                    this.mFlowHandler.menuSetSliderItem(n, menuObject, i, string, imageArray, n12, n13, n10);
                    continue block7;
                }
                case 3: {
                    int n14 = byArray[n4++] & 0xFF;
                    n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF);
                    String string2 = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
                    n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF);
                    String string3 = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
                    blArray[0] = bl;
                    n4 = DCPack.loadImagesOrAnimations(byArray, n4, 3, imageArrayArray, spriteObjectArray, blArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    bl = blArray[0];
                    int n15 = byArray[n4++] & 0xFF;
                    int n10 = byArray[n4++] & 0xFF;
                    if (n10 == 255) {
                        n10 = -1;
                    }
                    if (bl) {
                        this.mFlowHandler.menuSetInputItemDvc(n, menuObject, i, n14, string2, string3, spriteObject, n15, n10);
                        continue block7;
                    }
                    this.mFlowHandler.menuSetInputItem(n, menuObject, i, n14, string2, string3, imageArray, n15, n10);
                    continue block7;
                }
                case 4: {
                    n6 = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | ((byArray[n4++] & 0xFF) << 8) + (byArray[n4++] & 0xFF);
                    string = this.mFlowHandler.processText(n, n6, Toolkit.getText(n6));
                    blArray[0] = bl;
                    n4 = DCPack.loadImagesOrAnimations(byArray, n4, 1, imageArrayArray, spriteObjectArray, blArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    bl = blArray[0];
                    if (bl) {
                        this.mFlowHandler.menuSetItemDvc(n, menuObject, i, 1, string, spriteObject, -1);
                        continue block7;
                    }
                    this.mFlowHandler.menuSetItem(n, menuObject, i, 1, string, imageArray, -1);
                }
            }
        }
        this.mFlowHandler.processMenu(n, menuObject, 1);
        menuObject.setState(n);
        this.mFlowHandler.menuSetSize(n, menuObject);
        menuObject.setSelectedItem(0);
        this.mLoadedMenus[n - this.mMenuScreenStartIndex] = menuObject;
        int[] nArray = null;
        if (vector.size() > 0) {
            nArray = new int[vector.size() * 2];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                int[] nArray2 = (int[])vector.elementAt(n2);
                nArray[n2 * 2] = nArray2[0];
                nArray[n2 * 2 + 1] = nArray2[1];
            }
        }
        this.mMenuSoftkeyEvents[n - this.mMenuScreenStartIndex] = nArray;
    }

    private static int loadImagesOrAnimations(byte[] byArray, int n, int n2, Image[][] imageArray, SpriteObject[] spriteObjectArray, boolean[] blArray) {
        int n3;
        imageArray[0] = null;
        spriteObjectArray[0] = null;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
            nArray2[n3] = byArray[n++];
            blArray[0] = blArray[0] | (nArray2[n3] == 2 || nArray2[n3] == 3);
        }
        if (blArray[0]) {
            short[][] sArrayArray = new short[n2][];
            for (int i = 0; i < n2; ++i) {
                sArrayArray[i] = SpriteObject.loadAnimation(nArray[i]);
            }
            spriteObjectArray[0] = new SpriteObject(sArrayArray, true);
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                Object object = nArray2[n3] == 0 ? Toolkit.getImage(nArray[n3]) : (nArray2[n3] == 1 ? SpriteObject.getImage(nArray[n3], 0, 1) : null);
                if (object == null) continue;
                if (imageArray[0] == null) {
                    imageArray[0] = new Image[n2];
                }
                imageArray[0][n3] = object;
            }
        }
        return n;
    }

    private void loadGameScreen(int n) {
        byte[] byArray = Toolkit.getResourceBytes(this.mFlowBinaryRid);
        int n2 = this.mStateOffsets[this.mMenuScreenCount + (n - this.mGameScreenStartIndex)];
        int n3 = byArray[n2++] & 0xFF;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = byArray[n2++] & 0xFF;
            if (nArray[i] != 255) continue;
            nArray[i] = -1;
        }
        this.mLoadedGameScreens[n - this.mGameScreenStartIndex] = nArray;
    }

    private void loadBranch(int n) {
        byte[] byArray = Toolkit.getResourceBytes(this.mFlowBinaryRid);
        int n2 = this.mStateOffsets[this.mMenuScreenCount + this.mGameScreenCount + (n - this.mBranchStartIndex)];
        int[] nArray = new int[]{byArray[n2++] & 0xFF, byArray[n2++] & 0xFF};
        if (nArray[0] == 255) {
            nArray[0] = -1;
        }
        if (nArray[1] == 255) {
            nArray[1] = -1;
        }
        this.mLoadedBranches[n - this.mBranchStartIndex] = nArray;
    }

    private void processEvent(int n) {
        if (n != -1) {
            if (n == -1000) {
                this.mNextState = 26;
            } else if (n == -2) {
                if (this.mCurrentGameScreen != null && this.mCurrentGameScreen.length > 0) {
                    this.processEvent(this.mCurrentGameScreen[0]);
                }
            } else if (n == -3) {
                this.mGoingForward = false;
                this.mNextState = this.mCurrentState == 14 ? 12 : this.mStateHistory[--this.mStateHistoryPointer];
            } else if (n >= 0) {
                int n2 = this.mEventTargets[n];
                if (n2 != -1) {
                    this.mGoingForward = true;
                    this.mNextState = n2;
                    if (this.mCurrentState == 19) {
                        this.mNextState = 14;
                    } else if (this.mCurrentState == 14) {
                        this.mNextState = 39;
                        this.mFlowHandler.setLastMenu();
                    } else if (this.mCurrentState == 43 || this.mCurrentState == 41 || this.mCurrentState == 42) {
                        this.mNextState = 14;
                    }
                    if (this.mStoreStateToHistory) {
                        this.mStateHistory[this.mStateHistoryPointer++] = this.mCurrentState;
                    }
                }
                if (n == 1) {
                    MenuObject.mTitleSprite = null;
                    this.mFlowHandler.removeSubMenus(this.mLoadedMenus);
                }
                this.mFlowHandler.eventOccurred(this.mCurrentState, n);
            }
        }
    }

    private void processSoftkeyEvent(int n) {
        if (n == 5 || n == 34) {
            this.processEvent(-3);
        }
    }

    public IMenu getNewMenuObject() {
        return new MenuObject();
    }

    public String[][] getHighscoreTables() {
        return new String[][]{{Toolkit.getText(60)}};
    }

    public String getFormattedScore(int n, int n2, int n3) {
        return "" + n3;
    }

    public void prefetchState(int n) {
        if (n >= 0 && n < this.mMenuScreenCount + this.mBranchCount + this.mGameScreenCount) {
            if (n < this.mMenuScreenCount) {
                this.loadMenu(n);
                if (n == 14) {
                    this.loadMenu(15);
                    this.loadMenu(18);
                    this.loadMenu(17);
                    this.loadMenu(16);
                    this.mFlowHandler.getSubMenu(this.mLoadedMenus);
                    this.mFlowHandler.setCategoryMenu(this.mLoadedMenus[n], n);
                }
            } else if (n < this.mMenuScreenCount + this.mGameScreenCount) {
                this.loadGameScreen(n);
            } else if (n < this.mMenuScreenCount + this.mGameScreenCount + this.mBranchCount) {
                this.loadBranch(n);
            }
        }
    }

    public void removeFromStateCache(int n) {
        if (n >= 0 && n < this.mMenuScreenCount + this.mBranchCount + this.mGameScreenCount) {
            if (n < this.mMenuScreenCount) {
                this.mLoadedMenus[n - this.mMenuScreenStartIndex] = null;
            } else if (n < this.mMenuScreenCount + this.mGameScreenCount || n < this.mMenuScreenCount + this.mGameScreenCount + this.mBranchCount) {
                // empty if block
            }
        }
    }

    public void clearMenuCache() {
        for (int i = 0; i < this.mLoadedMenus.length; ++i) {
            this.mLoadedMenus[i] = null;
        }
    }

    public void setLanguage(int n) {
        if (this.mInitialized) {
            this.clearMenuCache();
        }
        Toolkit.setSelectedLanguage(n);
        this.initializeSoftkeys();
    }

    public static void initLoadingQuiz() {
        int n;
        loadingQuizActive = true;
        int n2 = lastRndWord;
        while (n2 == lastRndWord) {
            n2 = MiniGame.rnd(smQuizWords.length);
        }
        lastRndWord = n2;
        String string = Toolkit.getText(smQuizWords[n2]);
        int n3 = string.length();
        smMessedWord = new String[n3];
        smQuizWord = new String[n3];
        smQuizOrder = new int[n3];
        for (n = 0; n < n3; ++n) {
            DCPack.smQuizOrder[n] = -1;
        }
        n = 0;
        while (n < n3) {
            char c = string.charAt(n);
            int n4 = MiniGame.rnd(n3);
            while (n == 0 && n4 == n || smQuizOrder[n4] != -1) {
                n4 = (n4 + 1) % n3;
            }
            DCPack.smMessedWord[n4] = "" + c;
            DCPack.smQuizWord[n] = smMessedWord[n4];
            DCPack.smQuizOrder[n4] = n++;
        }
    }

    public static void drawLoadingScreen(Graphics graphics, String[] stringArray, int n, int n2) {
        if (n2 == 8 || n2 == 36 || n2 == 37) {
            return;
        }
        if (n > 100) {
            n = 100;
        }
        if (n2 > -1 && n2 != 8 && n2 != 7 && n2 != 37 && n2 != 36) {
            if (loadingQuizActive) {
                int n3;
                int n4;
                int n5;
                MenuObject.mCoverElements.setAnimationFrame(0);
                MenuObject.drawBackground(graphics);
                graphics.drawImage(MenuObject.mTitleSprite, Toolkit.getScreenWidth() - MenuObject.mTitleSprite.getWidth() >> 1, 3, 20);
                if (keyAfterLoadingPressed) {
                    return;
                }
                int n6 = mLoadingTimer / 500;
                int n7 = smQuizWord.length;
                if (n6 > n7) {
                    n6 = n7;
                }
                int n8 = Toolkit.getScreenWidth() * 7 / (n7 * 8);
                int n9 = Toolkit.getScreenWidth() - (n7 - 1) * n8 >> 1;
                for (n5 = 0; n5 < n7; ++n5) {
                    n4 = n9 + n5 * n8;
                    mTitleBarImageFont.drawString(graphics, smMessedWord[n5], n4, 1 * Toolkit.getScreenHeight() / 2, 17);
                    MenuObject.smDefaultTextImageFont.drawString(graphics, "-", n4, 2 * Toolkit.getScreenHeight() / 3 + (mTitleBarImageFont.getHeight() >> 1), 17);
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = smQuizOrder[n5];
                    n3 = n9 + n4 * n8;
                    MenuObject.smDefaultTextImageFont.drawString(graphics, smQuizWord[n4], n3, 2 * Toolkit.getScreenHeight() / 3, 17);
                }
                if (!mLoadingFinished && (n5 = n / 10) > -1) {
                    MenuObject.mLoadingBarSprites.setAnimationFrame(0);
                    n4 = MenuObject.mLoadingBarSprites.getPivotX() + 6;
                    n3 = Toolkit.getScreenHeight() - MenuObject.mLoadingBarSprites.getHeight() - 6;
                    MenuObject.smDefaultSelectionImageFont.drawString(graphics, Toolkit.getText(433), n4, n3, 0);
                    for (int i = 0; i < 10; ++i) {
                        if (i < n5) {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(3);
                            MenuObject.mLoadingBarSprites.draw(graphics, n4, n3);
                        }
                        if (i == 0) {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(0);
                        } else if (i == 9) {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(2);
                            n4 += MenuObject.mLoadingBarSprites.getPivotX();
                        } else {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(1);
                        }
                        MenuObject.mLoadingBarSprites.draw(graphics, n4, n3);
                        n4 += MenuObject.mLoadingBarSprites.getWidth() - MenuObject.mLoadingBarSprites.getPivotX();
                    }
                }
            } else {
                MenuObject.mCoverElements.setAnimationFrame(0);
                MenuObject.drawBackground(graphics);
                graphics.drawImage(MenuObject.mTitleSprite, Toolkit.getScreenWidth() - MenuObject.mTitleSprite.getWidth() >> 1, 3, 20);
                MenuObject.mGears.draw(graphics, Toolkit.getScreenWidth() - (MenuObject.mGears.getWidth() - MenuObject.mGears.getPivotX()), Toolkit.getScreenHeight() - (MenuObject.mGears.getHeight() - MenuObject.mGears.getPivotY()));
                int n10 = n / 10;
                if (n10 > -1) {
                    MenuObject.mLoadingBarSprites.setAnimationFrame(0);
                    int n11 = MenuObject.mLoadingBarSprites.getPivotX() + 6;
                    int n12 = Toolkit.getScreenHeight() - MenuObject.mLoadingBarSprites.getHeight() - 6;
                    MenuObject.smDefaultSelectionImageFont.drawString(graphics, Toolkit.getText(433), n11, n12, 0);
                    for (int i = 0; i < 10; ++i) {
                        if (i < n10) {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(3);
                            MenuObject.mLoadingBarSprites.draw(graphics, n11, n12);
                        }
                        if (i == 0) {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(0);
                        } else if (i == 9) {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(2);
                            n11 += MenuObject.mLoadingBarSprites.getPivotX();
                        } else {
                            MenuObject.mLoadingBarSprites.setAnimationFrame(1);
                        }
                        MenuObject.mLoadingBarSprites.draw(graphics, n11, n12);
                        n11 += MenuObject.mLoadingBarSprites.getWidth() - MenuObject.mLoadingBarSprites.getPivotX();
                    }
                }
            }
        } else {
            int n13 = 0xFFFFFF;
            if (n2 > -1 && n2 != 8 && n2 != 7 && n2 != 37 && n2 != 36) {
                MenuObject.drawBackground(graphics);
                graphics.drawImage(MenuObject.mTitleSprite, Toolkit.getScreenWidth() - MenuObject.mTitleSprite.getWidth() >> 1, 3, 20);
            } else {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                n13 = 0xCC6600;
            }
            int n14 = Toolkit.getScreenHeight() >> 6;
            int n15 = Toolkit.getScreenWidth() >> 1;
            int n16 = n14 < 2 ? 2 : n14;
            int n17 = Toolkit.getScreenWidth() - n15 >> 1;
            int n18 = Toolkit.getScreenHeight() - n16 >> 1;
            int n19 = (n15 - 1) * n / 100;
            if (MenuObject.mTitleSprite != null && n18 < MenuObject.mTitleSprite.getHeight()) {
                n18 = MenuObject.mTitleSprite.getHeight() + 6;
            }
            graphics.setColor(0);
            graphics.drawRect(n17, n18, n15, n16);
            graphics.setColor(n13);
            graphics.fillRect(n17 + 1, n18 + 1, n19, n16 - 1);
        }
    }

    static {
        smQuizWords = new int[]{404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423};
        lastRndWord = -1;
    }
}

