/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniFrogs
extends MiniGame {
    private static final int MAX_FROGS = 12;
    private static final int FROG_WAIT = 500;
    private static final int FROG_LEFT = 0;
    private static final int FROG_RIGHT = 1;
    private int[] mFrogs = new int[12];
    private int mFrogIndex;
    private int mFrogActualIndex;
    private int mShowFrogIndex;
    private int mShowFrogTick;
    private boolean mFrogCorrect;
    private boolean mCreateParticle;
    private static final int FROG_SPR_LEFT = 0;
    private static final int FROG_SPR_RIGHT = 1;

    public MiniFrogs(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(786443), false);
        this.initialize(n, n2);
        this.createButtons(SpriteObject.loadAnimations(new int[]{196622, 131195, 196609}), SpriteObject.loadAnimations(new int[]{131190, 131192, 131193}));
        this.mSpritesPool = new SpriteObject[2];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(131191), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(196618), true);
        this.initFrogs();
    }

    private void initFrogs() {
        this.mFrogIndex = 0;
        this.mFrogCorrect = true;
        for (int i = 0; i < 12; ++i) {
            this.mFrogs[i] = 0;
            if (!this.rndBin()) continue;
            this.mFrogs[i] = 1;
        }
    }

    protected void initNextQuestion() {
        this.mCreateParticle = false;
        this.mShowFrogIndex = 0;
        this.mFrogActualIndex = 0;
        this.mShowFrogTick = 500 - 50 * this.mFrogIndex;
    }

    protected void updateGame(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        this.mSpritesPool[1].logicUpdate(n);
    }

    protected boolean updateWatch(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        this.mSpritesPool[1].logicUpdate(n);
        this.mShowFrogTick -= n;
        if (this.mShowFrogTick <= 0) {
            ++this.mShowFrogIndex;
            this.mShowFrogTick = 500 - 50 * this.mFrogIndex;
            if (this.mShowFrogIndex > this.mFrogIndex + 1) {
                ++this.mFrogIndex;
                return true;
            }
        }
        return false;
    }

    protected void drawGame(Graphics graphics) {
        int n;
        int n2 = this.mSpritesPool[0].getWidth() + 6;
        int n3 = this.mSpritesPool[0].getHeight();
        int n4 = n = this.mCanvasX + (this.mCanvasWidth - n2 * 4) / 2 + this.mSpritesPool[0].getPivotX() + 0;
        int n5 = this.mCanvasY + this.mSpritesPool[0].getPivotY() + 6;
        switch (this.mState[this.mGameMode]) {
            case 3: {
                if (this.mShowFrogIndex > 0) {
                    for (int i = 0; i < this.mShowFrogIndex; ++i) {
                        this.mSpritesPool[this.mFrogs[i]].draw(graphics, n4, n5);
                        if ((n4 += n2) < n + n2 * 4) continue;
                        n5 += n3;
                        n4 = n;
                    }
                }
                this.mHudConfirmationPosX = -100;
                this.mHudConfirmationPosY = -100;
                this.mDrawButtons = false;
                this.mDrawWatchIcon = true;
                break;
            }
            case 4: 
            case 5: {
                if (this.mFrogActualIndex - 1 > -1) {
                    for (int i = 0; i <= this.mFrogActualIndex - 1; ++i) {
                        this.mSpritesPool[this.mFrogs[i]].draw(graphics, n4, n5);
                        if (this.mHudConfirmationTicks > 0 && this.mFrogActualIndex - 1 == i) {
                            this.mSpritesPool[this.mFrogs[i]].draw(graphics, n4, n5);
                            this.mHudConfirmationPosX = n4;
                            this.mHudConfirmationPosY = n5;
                            if (this.mCreateParticle) {
                                this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                                this.mCreateParticle = false;
                            }
                        }
                        if ((n4 += n2) < n + n2 * 4) continue;
                        n5 += n3;
                        n4 = n;
                    }
                }
                this.mDrawButtons = true;
            }
        }
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                this.pressButton(0, this.mFrogs[this.mFrogActualIndex] == 0, true);
                this.mHudConfirmationTicks = 500;
                if (this.mFrogs[this.mFrogActualIndex] == 0) {
                    ++this.mFrogActualIndex;
                    this.mCreateParticle = true;
                    if (this.mFrogIndex > this.mFrogActualIndex) {
                        return 2;
                    }
                    return 0;
                }
                this.mFrogCorrect = false;
                ++this.mFrogActualIndex;
                return 1;
            }
            if (n2 == 54 || n == 54) {
                this.pressButton(1, this.mFrogs[this.mFrogActualIndex] == 1, true);
                this.mHudConfirmationTicks = 500;
                if (this.mFrogs[this.mFrogActualIndex] == 1) {
                    ++this.mFrogActualIndex;
                    this.mCreateParticle = true;
                    if (this.mFrogIndex > this.mFrogActualIndex) {
                        return 2;
                    }
                    return 0;
                }
                this.mFrogCorrect = false;
                ++this.mFrogActualIndex;
                return 1;
            }
        }
        return 3;
    }

    protected boolean checkAnswer(int n) {
        this.mSpritesPool[0].logicUpdate(n);
        this.mSpritesPool[1].logicUpdate(n);
        if (this.mTicks[this.mGameMode] >= 500) {
            if (!this.mFrogCorrect || this.mFrogIndex >= 12) {
                this.initFrogs();
            }
            return true;
        }
        return false;
    }
}

