/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MiniSpider
extends MiniGame {
    public static final int MAX_VERTICAL_PATH = 4;
    public static final int MAX_HORIZONTAL_PATH = 4;
    public static final int TILE_SIZE = 6;
    public static final int SPRITE_SPIDER = 0;
    public static final int SPRITE_WEB = 1;
    public static final int SPRITE_ARROW_LEFT = 2;
    public static final int SPRITE_ARROW_RIGHT = 3;
    public static final int CELL_EMPTY = 0;
    public static final int CELL_VERTICAL_WALL = 1;
    public static final int CELL_VERTICAL_WALL_RED = 2;
    public static final int CELL_HORIZONTAL_WALL = 3;
    public static final int CELL_HORIZONTAL_WALL_RED = 4;
    private int mExitGate;
    private int[] mMaze;
    private int mMazeWidth;
    private int mMazeHeight;
    private int mPathSeparation;
    private int mMazeX;
    private int mMazeY;
    private int mMazeTilesWidth;
    private int mMazeTilesHeight;
    private int mSpiderTilesHeight;
    private int mExitTilesHeight;
    private int mTicks;
    private int mMoveIndex;
    private int mMoveDirection;
    private int mPlayerX;
    private int mPlayerY;
    private boolean mUseLeftGate;
    private boolean mShowQuestionCheck;
    private boolean mDrawArrows;

    public MiniSpider(int n, int n2) {
        this.mBackground = new SpriteObject(SpriteObject.loadAnimation(655446), false);
        this.initialize(n, n2);
        this.mSpritesPool = new SpriteObject[4];
        this.mSpritesPool[0] = new SpriteObject(SpriteObject.loadAnimation(196627), true);
        this.mSpritesPool[1] = new SpriteObject(SpriteObject.loadAnimation(196624), false);
        this.mSpritesPool[2] = new SpriteObject(SpriteObject.loadAnimation(196629), true);
        this.mSpritesPool[3] = new SpriteObject(SpriteObject.loadAnimation(196631), true);
        this.mMazeTilesWidth = 7;
        this.mSpiderTilesHeight = this.mSpritesPool[0].getHeight() / 6;
        this.mExitTilesHeight = (this.mSpritesPool[1].getHeight() << 1) / 6;
        this.mMazeTilesHeight = this.mCanvasHeight / 6 - this.mExitTilesHeight;
        this.mMaze = new int[this.mMazeTilesWidth * this.mMazeTilesHeight];
        this.mPathSeparation = this.mCanvasWidth / 4;
        this.mMazeWidth = 3 * this.mPathSeparation;
        this.mMazeHeight = this.mMazeTilesHeight * 6;
        this.mMazeX = this.mCanvasWidth - this.mMazeWidth >> 1;
        this.mMazeY = this.mCanvasHeight - this.mMazeHeight >> 1;
    }

    protected void initNextQuestion() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n6 = 1;
        this.mTicks = 0;
        do {
            if (this.mDifficulty > 2 && (n6 = this.mDifficulty / 2) > 4) {
                n6 = 4;
            }
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = 0;
                nArray[n] = 50;
            }
            for (n = 0; n < this.mMaze.length; n += this.mMazeTilesWidth) {
                for (n2 = n; n2 < n + this.mMazeTilesWidth; n2 += 2) {
                    if (n2 % this.mMazeTilesWidth != 0 && n2 % this.mMazeTilesWidth != this.mMazeTilesWidth - 1 && n2 <= 1 + this.mSpiderTilesHeight * this.mMazeTilesWidth) continue;
                    this.mMaze[n2] = 1;
                }
            }
            this.mMaze[1] = 3;
            this.mMaze[this.mMazeTilesWidth - 2] = 3;
            for (n = 1 + this.mSpiderTilesHeight * this.mMazeTilesWidth; n < this.mMaze.length; n += this.mMazeTilesWidth) {
                for (n2 = n; n2 < n + this.mMazeTilesWidth - 1; n2 += 2) {
                    this.mMaze[n2] = 0;
                    n4 = n2 % this.mMazeTilesWidth / 2;
                    if (MiniSpider.rnd(100) < nArray[n4]) {
                        if (n2 % this.mMazeTilesWidth == 1) {
                            this.mMaze[n2] = 3;
                        } else if (this.mMaze[n2 - 2] != 3) {
                            this.mMaze[n2] = 3;
                        }
                        if (this.mMaze[n2] != 0) {
                            int n7 = n2 % this.mMazeTilesWidth / 2;
                            nArray2[n7] = nArray2[n7] + 1;
                            if (nArray2[n4] >= n6) {
                                nArray[n4] = 0;
                            } else if (nArray[n4] > 50) {
                                nArray[n4] = 40;
                            } else {
                                int n8 = n4;
                                nArray[n8] = nArray[n8] - 10;
                                if (nArray[n4] < 10) {
                                    nArray[n4] = 10;
                                }
                            }
                        }
                    }
                    if (nArray2[n4] != 0) continue;
                    int n9 = n4;
                    nArray[n9] = nArray[n9] + 40;
                }
            }
            n3 = 0;
            for (n = 0; n < this.mMaze.length; ++n) {
                int n10 = n + 1;
                if (this.mMaze[n] < 0) {
                    n10 = 100;
                }
                n3 += (Math.abs(this.mMaze[n]) + 1) * n10;
            }
        } while (this.isPreviouslyAnswered(n3) && ++n5 < 500);
        this.mLastQuestions[this.mLastQuestionsIndex] = n3;
        this.mLastQuestionsIndex = (this.mLastQuestionsIndex + 1) % this.mLastQuestions.length;
        this.mUseLeftGate = this.rndBin();
        if (this.mUseLeftGate) {
            this.mMoveIndex = 1;
            this.mMoveDirection = 1;
        } else {
            this.mMoveIndex = this.mMazeTilesWidth - 2;
            this.mMoveDirection = 2;
        }
        while (!this.checkPath(false)) {
        }
        this.mExitGate = this.mMoveIndex % this.mMazeTilesWidth / 2;
        this.mMoveIndex = 1 + (this.mMazeTilesWidth >> 1);
        this.mMoveDirection = 0;
        this.mPlayerX = 0;
        this.mPlayerY = 0;
        this.mShowQuestionCheck = false;
        this.mDrawArrows = true;
    }

    protected void updateGame(int n) {
        if (this.mDrawArrows) {
            this.mSpritesPool[2].logicUpdate(n);
            this.mSpritesPool[3].logicUpdate(n);
        }
        this.mSpritesPool[0].logicUpdate(n);
    }

    protected void drawGame(Graphics graphics) {
        int n = 0;
        int n2 = this.mCanvasX + this.mMazeX;
        int n3 = this.mCanvasY + this.mMazeY - 6;
        graphics.setColor(0);
        block4: for (n = 0; n < this.mMaze.length; ++n) {
            if (this.mMaze[n] % 2 == 0) {
                graphics.setColor(0xFF0000);
            } else {
                graphics.setColor(0);
            }
            if (n % this.mMazeTilesWidth == 0) {
                n3 += 6;
                n2 = this.mCanvasX + this.mMazeX;
            }
            if (n == this.mMoveIndex) {
                this.mPlayerX = n2;
                this.mPlayerY = n3;
                if (this.mMoveIndex == 4) {
                    this.mPlayerX -= this.mSpritesPool[0].getPivotX();
                }
            }
            switch (this.mMaze[n]) {
                case 1: 
                case 2: {
                    graphics.drawLine(n2, n3, n2, n3 + 6);
                    continue block4;
                }
                case 3: 
                case 4: {
                    graphics.drawLine(n2, n3, n2 + this.mPathSeparation, n3);
                    n2 += this.mPathSeparation;
                    continue block4;
                }
                default: {
                    if (n % this.mMazeTilesWidth % 2 == 0) continue block4;
                    n2 += this.mPathSeparation;
                }
            }
        }
        if (this.mDrawArrows) {
            this.mSpritesPool[2].draw(graphics, this.mPlayerX - this.mSpritesPool[0].getPivotX() - 12, this.mPlayerY);
            this.mSpritesPool[3].draw(graphics, this.mPlayerX + this.mSpritesPool[0].getPivotX() + 12, this.mPlayerY);
        }
        this.mSpritesPool[1].draw(graphics, this.mCanvasX + this.mMazeX + this.mExitGate * this.mPathSeparation, this.mCanvasY + this.mMazeY + this.mMazeTilesHeight * 6 + this.mSpritesPool[1].getPivotY());
        this.mSpritesPool[0].draw(graphics, this.mPlayerX, this.mPlayerY);
    }

    protected void pointerEventOccurred(int n, int n2, int n3) {
        if (n3 == 0 && this.mDrawArrows) {
            int n4 = this.mSpritesPool[3].getHeight();
            int n5 = this.mSpritesPool[3].getWidth();
            int n6 = this.mPlayerX - this.mSpritesPool[0].getPivotX() - 6 - n5;
            int n7 = this.mPlayerX + this.mSpritesPool[0].getPivotX() + 6;
            int n8 = this.mPlayerY - n5;
            if (n > n6 && n < n6 + n5 && n2 > n8 && n2 < n8 + n4) {
                this.keyEvent(52, 0);
            }
            if (n > n7 && n < n7 + n5 && n2 > n8 && n2 < n8 + n4) {
                this.keyEvent(54, 0);
            }
        }
    }

    protected int isCorrectAnswer(int n) {
        if (n != 0) {
            int n2 = Toolkit.getToolkitGameAction(n);
            if (n2 == 52 || n == 52) {
                this.mMoveIndex = 1;
                this.mMoveDirection = 1;
                this.mDrawArrows = false;
                this.mShowQuestionCheck = true;
                this.mMaze[this.mMoveIndex] = 4;
                if (this.mUseLeftGate) {
                    return 0;
                }
                return 1;
            }
            if (n2 == 54 || n == 54) {
                this.mMoveIndex = this.mMazeTilesWidth - 2;
                this.mMoveDirection = 2;
                this.mDrawArrows = false;
                this.mShowQuestionCheck = true;
                this.mMaze[this.mMoveIndex] = 4;
                if (!this.mUseLeftGate) {
                    return 0;
                }
                return 1;
            }
        }
        return 3;
    }

    protected boolean checkAnswer(int n) {
        while (this.mProcessedTime < this.mElapsedTime) {
            ++this.mTicks;
            if (this.mTicks % 2 == 0 && this.checkPath(true)) {
                this.mHudConfirmationPosX = this.mPlayerX;
                this.mHudConfirmationPosY = this.mPlayerY;
                if (this.mShowQuestionCheck) {
                    this.mHudConfirmationTicks = 500;
                    this.mShowQuestionCheck = false;
                    this.registerParticle(this.mHudConfirmationPosX, this.mHudConfirmationPosY);
                }
                return this.mHudConfirmationTicks <= 0;
            }
            this.mProcessedTime += 50;
        }
        this.mSpritesPool[0].logicUpdate(n);
        return false;
    }

    private boolean moveLeft(boolean bl) {
        if (this.mMoveIndex % this.mMazeTilesWidth != 0 && this.mMaze[this.mMoveIndex - 1] == 3) {
            --this.mMoveIndex;
            if (bl) {
                this.mMaze[this.mMoveIndex] = 4;
            }
            this.mMoveDirection = 1;
            return true;
        }
        return false;
    }

    private boolean moveRight(boolean bl) {
        if (this.mMoveIndex % this.mMazeTilesWidth != this.mMazeTilesWidth - 1 && this.mMaze[this.mMoveIndex + 1] == 3) {
            ++this.mMoveIndex;
            if (bl) {
                this.mMaze[this.mMoveIndex] = 4;
            }
            this.mMoveDirection = 2;
            return true;
        }
        return false;
    }

    private boolean checkPath(boolean bl) {
        switch (this.mMaze[this.mMoveIndex]) {
            case 1: 
            case 2: {
                if (this.mMoveIndex + this.mMazeTilesWidth < this.mMaze.length) {
                    this.mMoveIndex += this.mMazeTilesWidth;
                    if (this.moveLeft(bl) || this.moveRight(bl) || !bl) break;
                    this.mMaze[this.mMoveIndex] = 2;
                    break;
                }
                return true;
            }
            case 3: 
            case 4: {
                if (this.mMoveDirection == 1) {
                    --this.mMoveIndex;
                } else if (this.mMoveDirection == 2) {
                    ++this.mMoveIndex;
                }
                if (!bl) break;
                this.mMaze[this.mMoveIndex] = 2;
            }
        }
        return false;
    }
}

